/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.ui.freemarker;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.core.io.DefaultResourceLoader;
import com.bmc.thirdparty.org.springframework.core.io.Resource;
import com.bmc.thirdparty.org.springframework.core.io.ResourceLoader;
import com.bmc.thirdparty.org.springframework.core.io.support.PropertiesLoaderUtils;
import com.bmc.thirdparty.org.springframework.ui.freemarker.SpringTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModelEx;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class FreeMarkerConfigurationFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Resource configLocation;
    private Properties freemarkerSettings;
    private Map freemarkerVariables;
    private String defaultEncoding;
    private final List templateLoaders = new ArrayList();
    private String[] templateLoaderPaths;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private boolean preferFileSystemAccess = true;

    public void setConfigLocation(Resource resource) {
        this.configLocation = resource;
    }

    public void setFreemarkerSettings(Properties settings) {
        this.freemarkerSettings = settings;
    }

    public void setFreemarkerVariables(Map variables) {
        this.freemarkerVariables = variables;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public void setTemplateLoaders(TemplateLoader[] templateLoaders) {
        if (templateLoaders != null) {
            this.templateLoaders.addAll(Arrays.asList(templateLoaders));
        }
    }

    public void setTemplateLoaderPath(String templateLoaderPath) {
        this.templateLoaderPaths = new String[]{templateLoaderPath};
    }

    public void setTemplateLoaderPaths(String[] templateLoaderPaths) {
        this.templateLoaderPaths = templateLoaderPaths;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setPreferFileSystemAccess(boolean preferFileSystemAccess) {
        this.preferFileSystemAccess = preferFileSystemAccess;
    }

    protected boolean isPreferFileSystemAccess() {
        return this.preferFileSystemAccess;
    }

    public Configuration createConfiguration() throws IOException, TemplateException {
        Configuration config = this.newConfiguration();
        Properties props = new Properties();
        if (this.configLocation != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Loading FreeMarker config from [" + this.configLocation + "]");
            }
            PropertiesLoaderUtils.fillProperties(props, this.configLocation);
        }
        if (this.freemarkerSettings != null) {
            props.putAll((Map<?, ?>)this.freemarkerSettings);
        }
        if (!props.isEmpty()) {
            config.setSettings(props);
        }
        if (this.freemarkerVariables != null && this.freemarkerVariables.size() > 0) {
            config.setAllSharedVariables((TemplateHashModelEx)new SimpleHash(this.freemarkerVariables));
        }
        if (this.defaultEncoding != null) {
            config.setDefaultEncoding(this.defaultEncoding);
        }
        if (this.templateLoaderPaths != null) {
            for (int i2 = 0; i2 < this.templateLoaderPaths.length; ++i2) {
                this.templateLoaders.add(this.getTemplateLoaderForPath(this.templateLoaderPaths[i2]));
            }
        }
        this.postProcessTemplateLoaders(this.templateLoaders);
        TemplateLoader loader = this.getAggregateTemplateLoader(this.templateLoaders);
        if (loader != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Setting TemplateLoader on Configuration to [" + loader + "]");
            }
            config.setTemplateLoader(loader);
        }
        this.postProcessConfiguration(config);
        return config;
    }

    protected Configuration newConfiguration() throws IOException, TemplateException {
        return new Configuration();
    }

    protected TemplateLoader getTemplateLoaderForPath(String templateLoaderPath) {
        if (this.isPreferFileSystemAccess()) {
            try {
                Resource path = this.getResourceLoader().getResource(templateLoaderPath);
                File file = path.getFile();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Template loader path [" + path + "] resolved to file [" + file.getAbsolutePath() + "]");
                }
                return new FileTemplateLoader(file);
            }
            catch (IOException ex) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Cannot resolve template loader path [" + templateLoaderPath + "] to java.io.File: using SpringTemplateLoader", ex);
                }
                return new SpringTemplateLoader(this.getResourceLoader(), templateLoaderPath);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("File system access not preferred: using SpringTemplateLoader");
        }
        return new SpringTemplateLoader(this.getResourceLoader(), templateLoaderPath);
    }

    protected void postProcessTemplateLoaders(List templateLoaders) {
    }

    protected TemplateLoader getAggregateTemplateLoader(List templateLoaders) {
        int loaderCount = templateLoaders.size();
        switch (loaderCount) {
            case 0: {
                this.logger.info("No FreeMarker TemplateLoaders specified");
                return null;
            }
            case 1: {
                return (TemplateLoader)templateLoaders.get(0);
            }
        }
        TemplateLoader[] loaders = templateLoaders.toArray(new TemplateLoader[loaderCount]);
        return new MultiTemplateLoader(loaders);
    }

    protected void postProcessConfiguration(Configuration config) throws IOException, TemplateException {
    }
}

