/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.scheduling.concurrent;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.DisposableBean;
import com.bmc.thirdparty.org.springframework.beans.factory.FactoryBean;
import com.bmc.thirdparty.org.springframework.beans.factory.InitializingBean;
import com.bmc.thirdparty.org.springframework.scheduling.concurrent.ScheduledExecutorTask;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;

public class ScheduledExecutorFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ScheduledExecutorTask[] scheduledExecutorTasks;
    private int poolSize = 1;
    private ThreadFactory threadFactory = Executors.defaultThreadFactory();
    private RejectedExecutionHandler rejectedExecutionHandler = new ThreadPoolExecutor.AbortPolicy();
    private ScheduledExecutorService executor;

    public void setScheduledExecutorTasks(ScheduledExecutorTask[] scheduledExecutorTasks) {
        this.scheduledExecutorTasks = scheduledExecutorTasks;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory != null ? threadFactory : Executors.defaultThreadFactory();
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.rejectedExecutionHandler = rejectedExecutionHandler != null ? rejectedExecutionHandler : new ThreadPoolExecutor.AbortPolicy();
    }

    public void afterPropertiesSet() {
        Assert.isTrue(this.poolSize > 0, "The [poolSize] property cannot be set to a value less than 0 (zero).");
        Assert.notEmpty(this.scheduledExecutorTasks, "At least one [ScheduledExecutorTask] must be provided via the [scheduledExecutorTasks] property");
        this.logger.info("Initializing SchedulerExecutorService");
        this.executor = this.createExecutor(this.poolSize, this.threadFactory, this.rejectedExecutionHandler);
        this.registerAllScheduledExecutorTasks();
    }

    protected ScheduledExecutorService createExecutor(int poolSize, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        return new ScheduledThreadPoolExecutor(poolSize, threadFactory, rejectedExecutionHandler);
    }

    public Object getObject() {
        return this.executor;
    }

    public Class getObjectType() {
        return ScheduledExecutorService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        this.logger.info("Shutting down ScheduledExecutorService");
        this.executor.shutdown();
    }

    private void registerAllScheduledExecutorTasks() {
        for (int i2 = 0; i2 < this.scheduledExecutorTasks.length; ++i2) {
            ScheduledExecutorTask scheduledTask = this.scheduledExecutorTasks[i2];
            if (scheduledTask.isOneTimeTask()) {
                this.executor.schedule(scheduledTask.getRunnable(), scheduledTask.getDelay(), scheduledTask.getTimeUnit());
                continue;
            }
            if (scheduledTask.isFixedRate()) {
                this.executor.scheduleAtFixedRate(scheduledTask.getRunnable(), scheduledTask.getDelay(), scheduledTask.getPeriod(), scheduledTask.getTimeUnit());
                continue;
            }
            this.executor.scheduleWithFixedDelay(scheduledTask.getRunnable(), scheduledTask.getDelay(), scheduledTask.getPeriod(), scheduledTask.getTimeUnit());
        }
    }
}

