/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.beans.factory.parsing;

import com.bmc.thirdparty.org.springframework.beans.MutablePropertyValues;
import com.bmc.thirdparty.org.springframework.beans.PropertyValue;
import com.bmc.thirdparty.org.springframework.beans.factory.config.BeanDefinition;
import com.bmc.thirdparty.org.springframework.beans.factory.config.BeanDefinitionHolder;
import com.bmc.thirdparty.org.springframework.beans.factory.config.BeanReference;
import com.bmc.thirdparty.org.springframework.beans.factory.parsing.AbstractComponentDefinition;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.util.ArrayList;

public class BeanComponentDefinition
extends AbstractComponentDefinition {
    private final BeanDefinition beanDefinition;
    private final String beanName;
    private final String description;
    private BeanDefinition[] innerBeanDefinitions;
    private BeanReference[] beanReferences;

    public BeanComponentDefinition(BeanDefinition beanDefinition, String beanName) {
        Assert.notNull(beanDefinition, "BeanDefinition must not be null");
        Assert.notNull(beanName, "Bean name must not be null");
        this.beanDefinition = beanDefinition;
        this.beanName = beanName;
        this.description = this.buildDescription(this.beanDefinition);
        this.findInnerBeanDefinitionsAndBeanReferences();
    }

    public BeanComponentDefinition(BeanDefinitionHolder holder) {
        this(holder.getBeanDefinition(), holder.getBeanName());
    }

    private String buildDescription(BeanDefinition beanDefinition) {
        StringBuffer sb = new StringBuffer();
        sb.append("Bean '").append(this.getName()).append("'");
        String beanType = beanDefinition.getBeanClassName();
        if (beanType != null) {
            sb.append(" of type [" + beanType + "]");
        }
        return sb.toString();
    }

    private void findInnerBeanDefinitionsAndBeanReferences() {
        ArrayList<Object> innerBeans = new ArrayList<Object>();
        ArrayList<Object> references = new ArrayList<Object>();
        MutablePropertyValues propertyValues = this.beanDefinition.getPropertyValues();
        for (int i2 = 0; i2 < propertyValues.getPropertyValues().length; ++i2) {
            PropertyValue propertyValue = propertyValues.getPropertyValues()[i2];
            Object value = propertyValue.getValue();
            if (value instanceof BeanDefinitionHolder) {
                innerBeans.add(((BeanDefinitionHolder)value).getBeanDefinition());
                continue;
            }
            if (value instanceof BeanDefinition) {
                innerBeans.add(value);
                continue;
            }
            if (!(value instanceof BeanReference)) continue;
            references.add(value);
        }
        this.innerBeanDefinitions = innerBeans.toArray(new BeanDefinition[innerBeans.size()]);
        this.beanReferences = references.toArray(new BeanReference[references.size()]);
    }

    public String getName() {
        return this.beanName;
    }

    public String getDescription() {
        return this.description;
    }

    public BeanDefinition[] getBeanDefinitions() {
        return new BeanDefinition[]{this.beanDefinition};
    }

    public BeanDefinition[] getInnerBeanDefinitions() {
        return this.innerBeanDefinitions;
    }

    public BeanReference[] getBeanReferences() {
        return this.beanReferences;
    }

    public Object getSource() {
        return this.beanDefinition.getSource();
    }
}

