/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.beans.factory.annotation;

import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.beans.PropertyValues;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanInitializationException;
import com.bmc.thirdparty.org.springframework.beans.factory.annotation.Required;
import com.bmc.thirdparty.org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import com.bmc.thirdparty.org.springframework.core.annotation.AnnotationUtils;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredAnnotationBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter {
    private Class<? extends Annotation> requiredAnnotationType = Required.class;

    public void setRequiredAnnotationType(Class<? extends Annotation> requiredAnnotationType) {
        Assert.notNull(requiredAnnotationType, "requiredAnnotationType must not be null");
        this.requiredAnnotationType = requiredAnnotationType;
    }

    protected Class<? extends Annotation> getRequiredAnnotationType() {
        return this.requiredAnnotationType;
    }

    @Override
    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        ArrayList<String> invalidProperties = new ArrayList<String>();
        for (PropertyDescriptor pd : pds) {
            if (!this.isRequiredProperty(pd) || pvs.contains(pd.getName())) continue;
            invalidProperties.add(pd.getName());
        }
        if (!invalidProperties.isEmpty()) {
            throw new BeanInitializationException(this.buildExceptionMessage(invalidProperties, beanName));
        }
        return pvs;
    }

    protected boolean isRequiredProperty(PropertyDescriptor propertyDescriptor) {
        Method setter = propertyDescriptor.getWriteMethod();
        return setter != null && AnnotationUtils.getAnnotation(setter, this.getRequiredAnnotationType()) != null;
    }

    private String buildExceptionMessage(List<String> invalidProperties, String beanName) {
        StringBuilder sb = new StringBuilder();
        int size = invalidProperties.size();
        sb.append(size == 1 ? "Property" : "Properties");
        for (int i2 = 0; i2 < size; ++i2) {
            String propertyName = invalidProperties.get(i2);
            if (i2 > 0) {
                if (i2 == size - 1) {
                    sb.append(" and");
                } else {
                    sb.append(",");
                }
            }
            sb.append(" '");
            sb.append(propertyName);
            sb.append('\'');
        }
        sb.append(size == 1 ? " is required" : " are required");
        sb.append(" for bean '");
        sb.append(beanName);
        sb.append("'");
        return sb.toString();
    }
}

