/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.common;

import com.bmc.arsys.utils.CatalogReader;
import java.util.Locale;

public class AppException
extends Exception {
    private static final long serialVersionUID = -8130109398650244204L;
    private static final String WHITE_SPACE = " ";
    private static final String OPENING_BRACE = "(";
    private static final String CLOSING_BRACE = "):";
    private int messageId;
    private String defaultMessage;
    private Object[] args;
    private String appendMessage;
    private String messageSet;
    private boolean isNonLocalizedMessage = false;

    public AppException(int n, String string) {
        this.messageId = n;
        this.defaultMessage = string;
    }

    public AppException(String string, int n, String string2) {
        this.messageSet = string;
        this.messageId = n;
        this.defaultMessage = string2;
    }

    public AppException() {
        this.isNonLocalizedMessage = true;
    }

    public AppException(String string) {
        super(string);
        this.isNonLocalizedMessage = true;
    }

    public AppException(Exception exception) {
        super(exception);
        this.isNonLocalizedMessage = true;
    }

    public AppException(String string, Throwable throwable) {
        super(string, throwable);
        this.isNonLocalizedMessage = true;
    }

    public AppException(int n, String string, Object[] objectArray) {
        this.messageId = n;
        this.defaultMessage = string;
        this.args = objectArray;
    }

    public AppException(String string, int n, String string2, Object[] objectArray) {
        this.messageSet = string;
        this.messageId = n;
        this.defaultMessage = string2;
        this.args = objectArray;
    }

    public AppException(int n, String string, Object[] objectArray, String string2) {
        this(n, string, objectArray);
        this.appendMessage = string2;
    }

    public AppException(String string, int n, String string2, Object[] objectArray, String string3) {
        this(string, n, string2, objectArray);
        this.appendMessage = string3;
    }

    public AppException(int n, String string, String string2) {
        this(n, string);
        this.appendMessage = string2;
    }

    public AppException(String string, int n, String string2, String string3) {
        this(string, n, string2);
        this.appendMessage = string3;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public String getMessageSet() {
        return this.messageSet;
    }

    @Override
    public String getMessage() {
        if (this.isNonLocalizedMessage) {
            return super.getMessage();
        }
        CatalogReader catalogReader = CatalogReader.getInstance();
        String string = this.messageSet != null ? catalogReader.getMessage(this.messageSet, this.messageId, this.args, this.defaultMessage, Locale.getDefault()) : catalogReader.getMessage(this.messageId, this.args, this.defaultMessage, Locale.getDefault());
        if (this.appendMessage != null) {
            string = string + WHITE_SPACE + this.appendMessage;
        }
        return OPENING_BRACE + this.messageId + CLOSING_BRACE + WHITE_SPACE + string;
    }
}

