/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.test.dsig.TestUtils;
import junit.framework.TestCase;
import org.jcp.xml.dsig.internal.dom.XMLDSigRI;

public class ManifestTest
extends TestCase {
    private XMLSignatureFactory fac;
    private static Reference VALID_REF = new TestUtils.MyOwnDOMReference("ref#1", true);
    private static Reference INVALID_REF = new TestUtils.MyOwnDOMReference("ref#2", false);

    public ManifestTest() {
        super("ManifestTest");
    }

    public ManifestTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        this.fac = XMLSignatureFactory.getInstance("DOM", new XMLDSigRI());
    }

    public void tearDown() {
    }

    public void testConstructor() throws Exception {
        Manifest manifest = null;
        String string = "manifest_id";
        Vector<Object> vector = new Vector<Object>();
        vector.add(VALID_REF);
        vector.add(INVALID_REF);
        for (int i = 0; i < 3; ++i) {
            String string2 = null;
            switch (i) {
                case 0: {
                    manifest = this.fac.newManifest(vector);
                    break;
                }
                case 1: {
                    manifest = this.fac.newManifest(vector, null);
                    break;
                }
                case 2: {
                    manifest = this.fac.newManifest(vector, string);
                    string2 = string;
                }
            }
            ManifestTest.assertNotNull(manifest);
            ManifestTest.assertTrue((boolean)Arrays.equals(manifest.getReferences().toArray(), vector.toArray()));
            ManifestTest.assertEquals((String)manifest.getId(), (String)string2);
        }
        try {
            manifest = this.fac.newManifest(null);
            ManifestTest.fail((String)"Should throw a NPE for null references");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            ManifestTest.fail((String)("Should throw a NPE instead of " + exception + " for null references"));
        }
        try {
            manifest = this.fac.newManifest(null, string);
            ManifestTest.fail((String)"Should throw a NPE for null references");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            ManifestTest.fail((String)("Should throw a NPE instead of " + exception + " for null references"));
        }
        vector.clear();
        try {
            manifest = this.fac.newManifest(vector);
            ManifestTest.fail((String)"Should throw a IAE for empty references");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            ManifestTest.fail((String)("Should throw a IAE instead of " + exception + " for empty references"));
        }
        try {
            manifest = this.fac.newManifest(vector, string);
            ManifestTest.fail((String)"Should throw a IAE for empty references");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            ManifestTest.fail((String)("Should throw a IAE instead of " + exception + " for empty references"));
        }
        vector.add("references");
        try {
            manifest = this.fac.newManifest(vector);
            ManifestTest.fail((String)"Should throw a CCE for references containing non-Reference objects");
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {
            ManifestTest.fail((String)("Should throw a CCE instead of " + exception + " for references containing non-Reference objects"));
        }
        try {
            manifest = this.fac.newManifest(vector, string);
            ManifestTest.fail((String)"Should throw a CCE for references containing non-Reference objects");
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {
            ManifestTest.fail((String)("Should throw a CCE instead of " + exception + " for references containing non-Reference objects"));
        }
    }

    public void testisFeatureSupported() throws Exception {
        Vector<Reference> vector = new Vector<Reference>();
        vector.add(VALID_REF);
        Manifest manifest = this.fac.newManifest(vector);
        try {
            manifest.isFeatureSupported(null);
            ManifestTest.fail((String)"Should raise a NPE for null feature");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ManifestTest.assertTrue((!manifest.isFeatureSupported("not supported") ? 1 : 0) != 0);
    }

    public void testgetReferences() throws Exception {
        Vector<Reference> vector = new Vector<Reference>();
        vector.add(VALID_REF);
        Manifest manifest = this.fac.newManifest(vector);
        List<Reference> list = manifest.getReferences();
        try {
            list.add(INVALID_REF);
            ManifestTest.fail((String)"Should not be able to modify the references directly");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            ListIterator<Reference> listIterator = list.listIterator();
            listIterator.add(INVALID_REF);
            ManifestTest.fail((String)"Should not be able to modify the references indirectly");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

