/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.annotation;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.aspectj.lang.reflect.PerClauseKind;
import org.springframework.aop.Advisor;
import org.springframework.aop.aspectj.InstantiationModelAwarePointcutAdvisor;
import org.springframework.aop.aspectj.annotation.AspectJAdvisorFactory;
import org.springframework.aop.aspectj.annotation.AspectMetadata;
import org.springframework.aop.aspectj.annotation.BeanFactoryAspectInstanceFactory;
import org.springframework.aop.aspectj.annotation.PrototypeAspectInstanceFactory;
import org.springframework.aop.aspectj.annotation.ReflectiveAspectJAdvisorFactory;
import org.springframework.aop.aspectj.autoproxy.AspectJInvocationContextExposingAdvisorAutoProxyCreator;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationAwareAspectJAutoProxyCreator
extends AspectJInvocationContextExposingAdvisorAutoProxyCreator {
    private static final String ORDER_PROPERTY = "order";
    private AspectJAdvisorFactory aspectJAdvisorFactory = new ReflectiveAspectJAdvisorFactory();
    private List<Pattern> includePatterns;

    @Override
    protected boolean isInfrastructureClass(Class beanClass) {
        return super.isInfrastructureClass(beanClass) || this.aspectJAdvisorFactory.isAspect(beanClass);
    }

    public void setAspectJAdvisorFactory(AspectJAdvisorFactory aspectJAdvisorFactory) {
        Assert.notNull(this.aspectJAdvisorFactory, "AspectJAdvisorFactory must not be null");
        this.aspectJAdvisorFactory = aspectJAdvisorFactory;
    }

    public void setIncludePatterns(List<String> patterns) {
        this.includePatterns = new ArrayList<Pattern>(patterns.size());
        for (String patternText : patterns) {
            this.includePatterns.add(Pattern.compile(patternText));
        }
    }

    private boolean isIncluded(String beanName) {
        if (this.includePatterns == null) {
            return true;
        }
        for (Pattern pattern : this.includePatterns) {
            if (!pattern.matcher(beanName).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected List findCandidateAdvisors() {
        LinkedList<Advisor> advisors = new LinkedList<Advisor>();
        advisors.addAll(super.findCandidateAdvisors());
        ListableBeanFactory lbf = (ListableBeanFactory)this.getBeanFactory();
        advisors.addAll(this.createAspectJAdvisors(this.aspectJAdvisorFactory, lbf));
        return advisors;
    }

    public List<Advisor> createAspectJAdvisors(AspectJAdvisorFactory aspectJAdvisorFactory, ListableBeanFactory beanFactory) throws BeansException, IllegalStateException {
        String[] beanNames;
        LinkedList<Advisor> advisors = new LinkedList<Advisor>();
        for (String beanName : beanNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors(beanFactory, Object.class, true, false)) {
            Class beanType;
            if (!this.isIncluded(beanName) || (beanType = beanFactory.getType(beanName)) == null || !aspectJAdvisorFactory.isAspect(beanType)) continue;
            AspectMetadata amd = new AspectMetadata(beanType, beanName);
            BeanFactoryAspectInstanceFactory factory = null;
            if (amd.getAjType().getPerClause().getKind() == PerClauseKind.SINGLETON) {
                factory = new BeanFactoryAspectInstanceFactory(beanFactory, beanName);
            } else {
                if (beanFactory.isSingleton(beanName)) {
                    throw new IllegalArgumentException("Bean with name '" + beanName + "' is a singleton, but aspect instantiation model is not singleton");
                }
                factory = new PrototypeAspectInstanceFactory(beanFactory, beanName);
            }
            List<Advisor> classAdvisors = aspectJAdvisorFactory.getAdvisors(factory);
            this.setAdvisorOrderIfNecessary(classAdvisors, beanFactory, beanName);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found " + classAdvisors.size() + " AspectJ advice methods in bean with name '" + beanName + "'"));
            }
            advisors.addAll(classAdvisors);
        }
        return advisors;
    }

    private void setAdvisorOrderIfNecessary(List<Advisor> advisors, BeanFactory beanFactory, String beanName) {
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            Object beanInstance;
            ConfigurableListableBeanFactory lbf = (ConfigurableListableBeanFactory)beanFactory;
            if (lbf.containsBeanDefinition(beanName)) {
                Object value;
                BeanDefinition bd = lbf.getBeanDefinition(beanName);
                MutablePropertyValues mpvs = bd.getPropertyValues();
                if (mpvs.contains(ORDER_PROPERTY) && (value = mpvs.getPropertyValue(ORDER_PROPERTY).getValue()) != null) {
                    try {
                        int order = Integer.parseInt(value.toString());
                        this.applyOrderToAdvisors(advisors, order);
                    }
                    catch (NumberFormatException ex) {}
                }
            } else if (beanFactory.isSingleton(beanName) && (beanInstance = beanFactory.getBean(beanName)) instanceof Ordered) {
                int order = ((Ordered)beanInstance).getOrder();
                this.applyOrderToAdvisors(advisors, order);
            }
        }
    }

    private void applyOrderToAdvisors(List<Advisor> advisors, int order) {
        for (Advisor advisor : advisors) {
            if (!(advisor instanceof InstantiationModelAwarePointcutAdvisor)) continue;
            ((InstantiationModelAwarePointcutAdvisor)advisor).setOrder(order);
        }
    }
}

