/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.orm.jpa;

import com.bmc.thirdparty.org.aopalliance.intercept.MethodInterceptor;
import com.bmc.thirdparty.org.aopalliance.intercept.MethodInvocation;
import com.bmc.thirdparty.org.springframework.orm.jpa.EntityManagerHolder;
import com.bmc.thirdparty.org.springframework.orm.jpa.JpaAccessor;
import com.bmc.thirdparty.org.springframework.transaction.support.TransactionSynchronizationManager;
import javax.persistence.EntityManager;

public class JpaInterceptor
extends JpaAccessor
implements MethodInterceptor {
    private boolean exceptionConversionEnabled = true;

    public void setExceptionConversionEnabled(boolean exceptionConversionEnabled) {
        this.exceptionConversionEnabled = exceptionConversionEnabled;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        EntityManager em = this.getTransactionalEntityManager();
        boolean isNewEm = false;
        if (em == null) {
            this.logger.debug("Creating new EntityManager for JpaInterceptor invocation");
            em = this.createEntityManager();
            isNewEm = true;
            TransactionSynchronizationManager.bindResource(this.getEntityManagerFactory(), new EntityManagerHolder(em));
        }
        try {
            Object retVal = methodInvocation.proceed();
            this.flushIfNecessary(em, !isNewEm);
            Object object = retVal;
            return object;
        }
        catch (RuntimeException rawException) {
            if (this.exceptionConversionEnabled) {
                throw this.translateIfNecessary(rawException);
            }
            throw rawException;
        }
        finally {
            if (isNewEm) {
                TransactionSynchronizationManager.unbindResource(this.getEntityManagerFactory());
                this.logger.debug("Closing new EntityManager after JpaInterceptor invocation");
                em.close();
            }
        }
    }
}

