/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.CurrencyValue;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.apiext.data.ARImportException;
import com.bmc.arsys.apiext.data.BaseObject;
import com.bmc.arsys.apiext.data.Converter;
import com.bmc.arsys.apiext.data.DataOptions;
import com.bmc.arsys.apiext.data.FieldInformation;
import com.bmc.arsys.apiext.data.FormInformation;
import com.bmc.arsys.apiext.data.IParser;
import com.bmc.arsys.apiext.data.ImportErrors;
import com.bmc.arsys.apiext.data.ImportOptions;
import com.bmc.arsys.apiext.data.KeywordExpander;
import com.bmc.arsys.apiext.data.Mapping;
import com.bmc.arsys.apiext.data.MappingOptions;
import com.bmc.arsys.apiext.data.RecordResult;
import com.bmc.arsys.apiext.data.ThreadLocalStorage;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class EntryFactory
extends BaseObject {
    private ImportOptions bs = null;
    private FormInformation bu = null;
    private FormInformation bv = null;
    private Converter bt = null;
    private KeywordExpander bx = null;
    private IParser bw = null;
    public static final String dollar = "$";
    public static final char currencySeparator = '\u0004';

    public EntryFactory(IParser iParser, ImportOptions importOptions, String string, String string2, Converter converter, KeywordExpander keywordExpander) throws ARImportException {
        this.bw = iParser;
        this.bs = importOptions;
        this.bu = importOptions.getFileForms().get(string);
        this.bv = importOptions.getServerForms().get(string2);
        if (this.bu == null || this.bv == null) {
            throw new ARImportException(ImportErrors.FORMS_NOT_FOUND.toDefMsg());
        }
        this.bt = converter;
        this.bx = keywordExpander;
    }

    public EntryFactory(IParser iParser, ImportOptions importOptions, String string, String string2) throws ARImportException {
        this(iParser, importOptions, string2, string2, new Converter(importOptions), new KeywordExpander(importOptions));
    }

    public EntryFactory(IParser iParser, ImportOptions importOptions, FormInformation formInformation, FormInformation formInformation2) throws ARImportException {
        this.bw = iParser;
        this.bs = importOptions;
        this.bu = formInformation;
        this.bv = formInformation2;
        if (formInformation == null || formInformation2 == null) {
            throw new ARImportException(ImportErrors.FORMS_NOT_FOUND.toDefMsg());
        }
        this.bt = new Converter(importOptions);
        this.bx = new KeywordExpander(importOptions);
    }

    public ImportOptions getOptions() {
        return this.bs;
    }

    public void setOptions(ImportOptions importOptions) {
        this.bs = importOptions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Entry createEntry(List<String> list, String string) throws ARImportException, NullPointerException, ARException, Exception {
        Object object;
        FieldInformation fieldInformation;
        Object object2;
        Logger logger = ThreadLocalStorage.getLogger();
        Entry entry = new Entry();
        int n = this.bs.getDataOptions().getSuppressDefaults();
        MappingOptions mappingOptions = this.bs.getMappingOptions(this.bu.getName(), this.bv.getName());
        if (mappingOptions == null) {
            mappingOptions = this.bs.getMappingOptions("ARImport_Data_Holder", this.bv.getName());
        }
        if (mappingOptions == null) {
            throw new NullPointerException(ImportErrors.MAP_INFO_NULL.toDefMsg());
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)MessageFormat.format(ImportErrors.CREATE_ENTRY.toDefMsg(), list));
        }
        this.applyMappings(mappingOptions, this.bu, this.bv, list);
        for (Integer n2 : mappingOptions.getMappings().keySet()) {
            Value value;
            Object object3;
            try {
                object2 = mappingOptions.getMappings().get(n2);
                fieldInformation = this.bv.getFields().get(n2);
                if (fieldInformation == null || fieldInformation.getDataType() == null) continue;
                if (((Mapping)object2).getType() == Mapping.Type.CONSTANT) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)MessageFormat.format(ImportErrors.SET_VALUE_FOR_CONSTANT.toDefMsg(), String.valueOf(fieldInformation.getFieldId()), object2));
                    }
                    entry.put(Integer.valueOf(fieldInformation.getFieldId()), new Value(((Mapping)object2).getConstant()));
                    continue;
                }
                if (((Mapping)object2).getType() == Mapping.Type.COMPOUND) {
                    Value value2 = this.bt.convertToARValue(fieldInformation, ((Mapping)object2).getCompoundValue());
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)MessageFormat.format(ImportErrors.SET_VALUE_FOR_FIELD.toDefMsg(), String.valueOf(fieldInformation.getFieldId()), value2, object2));
                    }
                    entry.put(Integer.valueOf(fieldInformation.getFieldId()), value2);
                    continue;
                }
                if (((Mapping)object2).getType() == Mapping.Type.KEYWORD) {
                    Value value3 = this.bt.getKeywordValue(fieldInformation, (Mapping)object2);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)MessageFormat.format(ImportErrors.SET_VALUE_FOR_FIELD.toDefMsg(), String.valueOf(fieldInformation.getFieldId()), value3, object2));
                    }
                    entry.put(Integer.valueOf(fieldInformation.getFieldId()), value3);
                    continue;
                }
                int n3 = ((Mapping)object2).getTokenIndex();
                if (n3 <= -1 || n3 > list.size() - 1) continue;
                object3 = list.get(n3);
                value = this.bt.convertToARValue(fieldInformation, (String)object3);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)MessageFormat.format(ImportErrors.SET_VALUE_FOR_FIELD.toDefMsg(), String.valueOf(fieldInformation.getFieldId()), value, object2));
                }
                entry.put(Integer.valueOf(fieldInformation.getFieldId()), value);
            }
            catch (Exception exception) {
                fieldInformation = this.bv.getFields().get(n2);
                int n4 = fieldInformation.getFieldId();
                this.applyFallbackMappings(mappingOptions, this.bu, this.bv, list, n4);
                if (!mappingOptions.getFallbacks().keySet().contains(n4)) {
                    throw exception;
                }
                object3 = mappingOptions.getFallbacks().get(n4);
                if (object3 == null) continue;
                if (((Mapping)object3).getType() == Mapping.Type.CONSTANT) {
                    entry.put(Integer.valueOf(n4), new Value(((Mapping)object3).getConstant()));
                    continue;
                }
                if (((Mapping)object3).getType() == Mapping.Type.COMPOUND) {
                    value = this.bt.convertToARValue(fieldInformation, ((Mapping)object3).getCompoundValue());
                    entry.put(Integer.valueOf(n4), value);
                    continue;
                }
                if (((Mapping)object3).getType() == Mapping.Type.KEYWORD) {
                    value = this.bt.getKeywordValue(fieldInformation, (Mapping)object3);
                    entry.put(Integer.valueOf(n4), value);
                    continue;
                }
                int n5 = ((Mapping)object3).getTokenIndex();
                if (n5 <= -1 || n5 > list.size() - 1) continue;
                String string2 = list.get(n5);
                Value value4 = this.bt.convertToARValue(fieldInformation, string2);
                entry.put(Integer.valueOf(n4), value4);
            }
        }
        if (!(n != 2 && n != 3 || this.bs.getDataOptions().getDuplicateIdHandling().equals((Object)DataOptions.DuplicateHandling.DUP_MERGE))) {
            object = this.bv.getFields().values();
            Set set = entry.keySet();
            object2 = object.iterator();
            while (object2.hasNext()) {
                fieldInformation = (FieldInformation)object2.next();
                if (fieldInformation.getDefaultValue().getValue() == null || set.contains(fieldInformation.getFieldId())) continue;
                entry.put(Integer.valueOf(fieldInformation.getFieldId()), new Value());
            }
        }
        if (entry.isEmpty()) {
            if (this.bs.getDataOptions().getBadRecordHandling().equals((Object)DataOptions.BadRecords.SKIP)) {
                logger.info((Object)MessageFormat.format(ImportErrors.UNABLE_TO_DETERMINE_FIELD_VALUE_FOR_RECORD.toDefMsg(), list.size(), this.bv.getFields().size(), System.getProperty("line.separator"), string));
            }
        } else if (this.bv.getFormType() == 1 && this.bs.getDataOptions().isDisableRequired()) {
            for (Integer n6 : this.getTargetForm().getFields().keySet()) {
                if (n6 <= 8 || entry.containsKey((Object)n6) || (object2 = this.getTargetForm().getFields().get(n6)) == null || ((FieldInformation)object2).getFieldOption() != 1 || this.bs.getDataOptions().getDuplicateIdHandling().getMergeOption() == 4 || ((FieldInformation)object2).getDefaultValue().getValue() != null) continue;
                entry.put(n6, new Value());
            }
        }
        if (this.bs.getFileForms().get(this.bu.getName()).getFields().size() > list.size()) {
            if (!this.bs.getDataOptions().isAllowTooFew()) {
                object = MessageFormat.format(ImportErrors.TOO_FEW_FIELDS.toDefMsg(), list.size(), this.bs.getFileForms().get(this.bu.getName()).getFields().size());
                if (this.bs.getDataOptions().getBadRecordHandling() != DataOptions.BadRecords.ALERTUSER) {
                    logger.info((Object)ImportErrors.SKIP_RECORD.toDefMsg());
                    logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), object, System.getProperty("line.separator"), string));
                    this.getOptions().getResults().addError(this.bv.getName(), new RecordResult(this.bu.getName(), this.bv.getName(), RecordResult.Status.ERROR, this.getOptions().getResults().getRecordCount(this.bv.getName()), (String)object, null));
                    return null;
                }
                if (this.bs.getUserAlertListener() != null) {
                    int n7 = this.bs.getUserAlertListener().handleUserAlert(this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), string, (String)object);
                    switch (n7) {
                        case 0: {
                            logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), object, System.getProperty("line.separator"), string));
                            logger.info((Object)ImportErrors.STOP_ON_FIRST_FAILURE_BY_USER.toDefMsg());
                            if (this.a() == null) break;
                            this.a().setAbort(true);
                            break;
                        }
                        case 2: {
                            logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), object, System.getProperty("line.separator"), string));
                            logger.info((Object)ImportErrors.STOP_ON_FIRST_FAILURE_BY_USER_COPY_REST.toDefMsg());
                            if (this.a() == null) break;
                            this.a().setAbort(true);
                            this.a().setCopyToLog(true);
                            break;
                        }
                        default: {
                            logger.info((Object)ImportErrors.SKIP_RECORD_INSTRUCTED_BY_USER.toDefMsg());
                            logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), object, System.getProperty("line.separator"), string));
                        }
                    }
                    this.getOptions().getResults().addError(this.bv.getName(), new RecordResult(this.bu.getName(), this.bv.getName(), RecordResult.Status.ERROR, this.getOptions().getResults().getRecordCount(this.bv.getName()), (String)object, null));
                    return null;
                }
            } else {
                object = MessageFormat.format(ImportErrors.TOO_FEW_FIELDS_FOUND.toDefMsg(), list.size(), this.bs.getFileForms().get(this.bu.getName()).getFields().size(), System.getProperty("line.separator"), string);
                logger.warn(object);
                this.getOptions().getResults().addWarning(this.bv.getName(), new RecordResult(this.bu.getName(), this.bv.getName(), RecordResult.Status.WARN, this.getOptions().getResults().getRecordCount(this.bv.getName()), (String)object, null));
            }
        } else if (this.bs.getFileForms().get(this.bu.getName()).getFields().size() < list.size()) {
            if (!this.bs.getDataOptions().isAllowTooMany()) {
                object = MessageFormat.format(ImportErrors.TOO_MANY_FIELDS.toDefMsg(), list.size(), this.bs.getFileForms().get(this.bu.getName()).getFields().size());
                if (this.bs.getDataOptions().getBadRecordHandling() != DataOptions.BadRecords.ALERTUSER) {
                    logger.info((Object)ImportErrors.SKIP_RECORD.toDefMsg());
                    logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), object, System.getProperty("line.separator"), string));
                    this.getOptions().getResults().addError(this.bv.getName(), new RecordResult(this.bu.getName(), this.bv.getName(), RecordResult.Status.ERROR, this.getOptions().getResults().getRecordCount(this.bv.getName()), (String)object, null));
                    return null;
                }
                if (this.bs.getUserAlertListener() != null) {
                    int n8 = this.bs.getUserAlertListener().handleUserAlert(this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), string, (String)object);
                    switch (n8) {
                        case 0: {
                            logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), object, System.getProperty("line.separator"), string));
                            logger.info((Object)ImportErrors.STOP_ON_FIRST_FAILURE_BY_USER.toDefMsg());
                            if (this.a() == null) break;
                            this.a().setAbort(true);
                            break;
                        }
                        case 2: {
                            logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), object, System.getProperty("line.separator"), string));
                            logger.info((Object)ImportErrors.STOP_ON_FIRST_FAILURE_BY_USER_COPY_REST.toDefMsg());
                            if (this.a() == null) break;
                            this.a().setAbort(true);
                            this.a().setCopyToLog(true);
                            break;
                        }
                        default: {
                            logger.info((Object)ImportErrors.SKIP_RECORD_INSTRUCTED_BY_USER.toDefMsg());
                            logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), object, System.getProperty("line.separator"), string));
                        }
                    }
                    this.getOptions().getResults().addError(this.bv.getName(), new RecordResult(this.bu.getName(), this.bv.getName(), RecordResult.Status.ERROR, this.getOptions().getResults().getRecordCount(this.bv.getName()), (String)object, null));
                    return null;
                }
            } else {
                object = MessageFormat.format(ImportErrors.TOO_MANY_FIELDS_FOUND.toDefMsg(), list.size(), this.bs.getFileForms().get(this.bu.getName()).getFields().size(), System.getProperty("line.separator"), string);
                logger.warn(object);
                this.getOptions().getResults().addWarning(this.bv.getName(), new RecordResult(this.bu.getName(), this.bv.getName(), RecordResult.Status.WARN, this.getOptions().getResults().getRecordCount(this.bv.getName()), (String)object, null));
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)MessageFormat.format(ImportErrors.NEW_ENTRY.toDefMsg(), entry));
        }
        return entry;
    }

    public void applyMappings(MappingOptions mappingOptions, FormInformation formInformation, FormInformation formInformation2, List<String> list) throws ARException {
        int n = this.bs.getDataOptions().getSuppressDefaults();
        for (Integer n2 : mappingOptions.getMappings().keySet()) {
            Mapping mapping = mappingOptions.getMappings().get(n2);
            FieldInformation fieldInformation = formInformation2.getFields().get(n2);
            if (mapping.getType() == Mapping.Type.COMPOUND) {
                String string = this.bx.expandAllKeywords(mapping.getCompound(), formInformation2, fieldInformation);
                if (string != null) {
                    string = this.a(string, formInformation, formInformation2, list);
                }
                mapping.setCompoundValue(string);
                continue;
            }
            int n3 = mapping.getTokenIndex();
            if (n3 <= -1 || n3 > list.size() - 1) continue;
            String string = list.get(n3);
            if (n != 0 && n != 3 || string != null && string.length() != 0 || fieldInformation == null || fieldInformation.getDefaultValue() == null || fieldInformation.getDefaultValue().getDataType().equals((Object)DataType.NULL)) continue;
            string = fieldInformation.getDataType() == DataType.CURRENCY ? this.a(fieldInformation.getDefaultValue()) : fieldInformation.getDefaultValue().getValue().toString();
            string = this.bx.expandAllKeywords(string, formInformation2, fieldInformation);
            list.set(n3, string);
        }
    }

    private String a(Value value) {
        CurrencyValue currencyValue = (CurrencyValue)value.getValue();
        String string = currencyValue.getValueString() + Character.toString('\u0004') + currencyValue.getCurrencyCode() + Character.toString('\u0004') + currencyValue.getConversionDate().getValue() + Character.toString('\u0004');
        return string;
    }

    protected String getFieldValue(FormInformation formInformation, String string, List<String> list) {
        int n = -1;
        for (FieldInformation fieldInformation : formInformation.getFields().values()) {
            if (!fieldInformation.getName().equals(string)) continue;
            n = fieldInformation.getFieldId();
            break;
        }
        return this.getFieldValue(formInformation, n, list);
    }

    protected String getFieldValue(FormInformation formInformation, int n, List<String> list) {
        int n2 = -1;
        if (formInformation.getFields().containsKey(n)) {
            n2 = formInformation.getFields().get(n).getTokenIndex();
        }
        return list.get(n2);
    }

    private String a(String string, FormInformation formInformation, FormInformation formInformation2, List<String> list) {
        for (FieldInformation fieldInformation : formInformation.getFields().values()) {
            String string2 = dollar + fieldInformation.getFieldId() + dollar;
            String string3 = null;
            try {
                if (fieldInformation.getTokenIndex() < list.size()) {
                    string3 = list.get(fieldInformation.getTokenIndex());
                }
            }
            catch (Exception exception) {
                string3 = null;
            }
            if (null != string3) {
                string = string.replace(string2, string3);
                continue;
            }
            string = string.replace(string2, "");
        }
        return string;
    }

    public FormInformation getSourceForm() {
        return this.bu;
    }

    public void setSourceForm(FormInformation formInformation) {
        this.bu = formInformation;
    }

    public FormInformation getTargetForm() {
        return this.bv;
    }

    public void setTargetForm(FormInformation formInformation) {
        this.bv = formInformation;
    }

    private IParser a() {
        return this.bw;
    }

    protected void setLastId(String string) {
        if (this.bx != null) {
            this.bx.setLastId(string);
        }
    }

    public void applyFallbackMappings(MappingOptions mappingOptions, FormInformation formInformation, FormInformation formInformation2, List<String> list, Integer n) throws ARException {
        Mapping mapping = mappingOptions.getFallbacks().get(n);
        if (mapping != null && mapping.getType() == Mapping.Type.COMPOUND) {
            FieldInformation fieldInformation = formInformation2.getFields().get(n);
            if (fieldInformation == null) {
                throw new NullPointerException("Field id " + n + "does not exist on schema: " + formInformation2.getName());
            }
            String string = this.bx.expandAllKeywords(mapping.getCompound(), formInformation2, fieldInformation);
            if (string != null) {
                string = this.a(string, formInformation, formInformation2, list);
            }
            mapping.setCompoundValue(string);
        }
    }
}

