/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.server;

import java.io.IOException;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.XdrEncodingStream;
import org.acplt.oncrpc.server.OncRpcServerCallMessage;
import org.acplt.oncrpc.server.OncRpcServerReplyMessage;
import org.acplt.oncrpc.server.OncRpcServerTransport;

public class OncRpcCallInformation {
    public OncRpcServerCallMessage callMessage = new OncRpcServerCallMessage();
    public InetAddress peerAddress = null;
    public int peerPort = 0;
    protected OncRpcServerTransport transport;

    protected OncRpcCallInformation(OncRpcServerTransport oncRpcServerTransport) {
        this.transport = oncRpcServerTransport;
    }

    public void retrieveCall(XdrAble xdrAble) throws OncRpcException, IOException {
        this.transport.retrieveCall(xdrAble);
    }

    public XdrDecodingStream getXdrDecodingStream() {
        return this.transport.getXdrDecodingStream();
    }

    public void endDecoding() throws OncRpcException, IOException {
        this.transport.endDecoding();
    }

    public void beginEncoding(OncRpcServerReplyMessage oncRpcServerReplyMessage) throws OncRpcException, IOException {
        this.transport.beginEncoding(this, oncRpcServerReplyMessage);
    }

    public void beginEncoding() throws OncRpcException, IOException {
        this.transport.beginEncoding(this, new OncRpcServerReplyMessage(this.callMessage, 0, 0, 0, 0, 0, 0));
    }

    public XdrEncodingStream getXdrEncodingStream() {
        return this.transport.getXdrEncodingStream();
    }

    public void endEncoding() throws OncRpcException, IOException {
        this.transport.endEncoding();
    }

    public void reply(OncRpcServerReplyMessage oncRpcServerReplyMessage, XdrAble xdrAble) throws OncRpcException, IOException {
        this.transport.reply(this, oncRpcServerReplyMessage, xdrAble);
    }

    public void reply(XdrAble xdrAble) throws OncRpcException, IOException {
        this.reply(new OncRpcServerReplyMessage(this.callMessage, 0, 0, 0, 0, 0, 0), xdrAble);
    }

    public void failArgumentGarbage() throws OncRpcException, IOException {
        this.reply(new OncRpcServerReplyMessage(this.callMessage, 0, 4, 0, 0, 0, 0), null);
    }

    public void failProcedureUnavailable() throws OncRpcException, IOException {
        this.reply(new OncRpcServerReplyMessage(this.callMessage, 0, 3, 0, 0, 0, 0), null);
    }

    public void failProgramUnavailable() throws OncRpcException, IOException {
        this.reply(new OncRpcServerReplyMessage(this.callMessage, 0, 1, 0, 0, 0, 0), null);
    }

    public void failProgramMismatch(int n, int n2) throws OncRpcException, IOException {
        this.reply(new OncRpcServerReplyMessage(this.callMessage, 0, 2, 0, n, n2, 0), null);
    }

    public void failSystemError() throws OncRpcException, IOException {
        this.reply(new OncRpcServerReplyMessage(this.callMessage, 0, 5, 0, 0, 0, 0), null);
    }

    public void failOncRpcVersionMismatch() throws OncRpcException, IOException {
        this.reply(new OncRpcServerReplyMessage(this.callMessage, 1, 0, 0, 2, 2, 0), null);
    }

    public void failAuthenticationFailed(int n) throws OncRpcException, IOException {
        this.reply(new OncRpcServerReplyMessage(this.callMessage, 1, 0, 1, 0, 0, n), null);
    }
}

