/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.scripting.support;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.aop.TargetSource;
import com.bmc.thirdparty.org.springframework.aop.framework.ProxyFactory;
import com.bmc.thirdparty.org.springframework.aop.support.DelegatingIntroductionInterceptor;
import com.bmc.thirdparty.org.springframework.beans.BeanUtils;
import com.bmc.thirdparty.org.springframework.beans.PropertyValue;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanDefinitionStoreException;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanFactoryAware;
import com.bmc.thirdparty.org.springframework.beans.factory.DisposableBean;
import com.bmc.thirdparty.org.springframework.beans.factory.config.BeanDefinition;
import com.bmc.thirdparty.org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import com.bmc.thirdparty.org.springframework.beans.factory.support.AbstractBeanFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.support.DefaultListableBeanFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.support.RootBeanDefinition;
import com.bmc.thirdparty.org.springframework.context.ResourceLoaderAware;
import com.bmc.thirdparty.org.springframework.core.Conventions;
import com.bmc.thirdparty.org.springframework.core.io.DefaultResourceLoader;
import com.bmc.thirdparty.org.springframework.core.io.ResourceLoader;
import com.bmc.thirdparty.org.springframework.scripting.ScriptFactory;
import com.bmc.thirdparty.org.springframework.scripting.ScriptSource;
import com.bmc.thirdparty.org.springframework.scripting.support.RefreshableScriptTargetSource;
import com.bmc.thirdparty.org.springframework.scripting.support.ResourceScriptSource;
import com.bmc.thirdparty.org.springframework.scripting.support.StaticScriptSource;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import com.bmc.thirdparty.org.springframework.util.ObjectUtils;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import net.sf.cglib.asm.Type;
import net.sf.cglib.core.Signature;
import net.sf.cglib.proxy.InterfaceMaker;

public class ScriptFactoryPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements BeanFactoryAware,
ResourceLoaderAware,
DisposableBean {
    public static final String INLINE_SCRIPT_PREFIX = "inline:";
    public static final String REFRESH_CHECK_DELAY_ATTRIBUTE = Conventions.getQualifiedAttributeName(class$org$springframework$scripting$support$ScriptFactoryPostProcessor == null ? (class$org$springframework$scripting$support$ScriptFactoryPostProcessor = ScriptFactoryPostProcessor.class$("com.bmc.thirdparty.org.springframework.scripting.support.ScriptFactoryPostProcessor")) : class$org$springframework$scripting$support$ScriptFactoryPostProcessor, "refreshCheckDelay");
    private static final String SCRIPT_FACTORY_NAME_PREFIX = "scriptFactory.";
    private static final String SCRIPTED_OBJECT_NAME_PREFIX = "scriptedObject.";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private long defaultRefreshCheckDelay = -1L;
    private AbstractBeanFactory beanFactory;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private DefaultListableBeanFactory scriptBeanFactory = new DefaultListableBeanFactory();
    static /* synthetic */ Class class$org$springframework$scripting$support$ScriptFactoryPostProcessor;
    static /* synthetic */ Class class$org$springframework$scripting$ScriptFactory;
    static /* synthetic */ Class class$org$springframework$aop$TargetSource;

    public void setDefaultRefreshCheckDelay(long defaultRefreshCheckDelay) {
        this.defaultRefreshCheckDelay = defaultRefreshCheckDelay;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (!(beanFactory instanceof AbstractBeanFactory)) {
            throw new IllegalStateException("ScriptFactoryPostProcessor must run in AbstractBeanFactory, not in " + beanFactory);
        }
        this.beanFactory = (AbstractBeanFactory)beanFactory;
        this.scriptBeanFactory.setParentBeanFactory(this.beanFactory);
        this.scriptBeanFactory.copyConfigurationFrom(this.beanFactory);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Object postProcessBeforeInstantiation(Class beanClass, String beanName) {
        if (!(class$org$springframework$scripting$ScriptFactory == null ? (class$org$springframework$scripting$ScriptFactory = ScriptFactoryPostProcessor.class$("com.bmc.thirdparty.org.springframework.scripting.ScriptFactory")) : class$org$springframework$scripting$ScriptFactory).isAssignableFrom(beanClass)) {
            return null;
        }
        String scriptedObjectBeanName = SCRIPTED_OBJECT_NAME_PREFIX + beanName;
        if (!this.scriptBeanFactory.containsBeanDefinition(scriptedObjectBeanName)) {
            RootBeanDefinition bd = this.beanFactory.getMergedBeanDefinition(beanName);
            String scriptFactoryBeanName = SCRIPT_FACTORY_NAME_PREFIX + beanName;
            this.scriptBeanFactory.registerBeanDefinition(scriptFactoryBeanName, this.createScriptFactoryBeanDefinition(bd));
            ScriptFactory scriptFactory = (ScriptFactory)this.scriptBeanFactory.getBean(scriptFactoryBeanName, class$org$springframework$scripting$ScriptFactory == null ? (class$org$springframework$scripting$ScriptFactory = ScriptFactoryPostProcessor.class$("com.bmc.thirdparty.org.springframework.scripting.ScriptFactory")) : class$org$springframework$scripting$ScriptFactory);
            ScriptSource scriptSource = this.convertToScriptSource(scriptFactory.getScriptSourceLocator(), this.resourceLoader);
            Object[] interfaces = scriptFactory.getScriptInterfaces();
            if (scriptFactory.requiresConfigInterface() && !bd.getPropertyValues().isEmpty()) {
                PropertyValue[] pvs = bd.getPropertyValues().getPropertyValues();
                Class configInterface = this.createConfigInterface(pvs, (Class[])interfaces);
                interfaces = (Class[])ObjectUtils.addObjectToArray(interfaces, configInterface);
            }
            RootBeanDefinition objectBd = this.createScriptedObjectBeanDefinition(bd, scriptFactoryBeanName, scriptSource, (Class[])interfaces);
            long refreshCheckDelay = this.resolveRefreshCheckDelay(bd);
            if (refreshCheckDelay >= 0L) {
                objectBd.setSingleton(false);
            }
            this.scriptBeanFactory.registerBeanDefinition(scriptedObjectBeanName, objectBd);
            if (refreshCheckDelay >= 0L) {
                RefreshableScriptTargetSource ts = new RefreshableScriptTargetSource(this.scriptBeanFactory, scriptedObjectBeanName, scriptSource);
                ts.setRefreshCheckDelay(refreshCheckDelay);
                return this.createRefreshableProxy(ts, (Class[])interfaces);
            }
        }
        return this.scriptBeanFactory.getBean(scriptedObjectBeanName);
    }

    protected long resolveRefreshCheckDelay(BeanDefinition bd) {
        long refreshCheckDelay = this.defaultRefreshCheckDelay;
        Object attributeValue = bd.getAttribute(REFRESH_CHECK_DELAY_ATTRIBUTE);
        if (attributeValue instanceof Number) {
            refreshCheckDelay = ((Number)attributeValue).longValue();
        } else if (attributeValue instanceof String) {
            refreshCheckDelay = Long.parseLong((String)attributeValue);
        } else if (attributeValue != null) {
            throw new BeanDefinitionStoreException("Invalid refresh check delay attribute [" + REFRESH_CHECK_DELAY_ATTRIBUTE + "] with value [" + attributeValue + "]: needs to be of type Number or String");
        }
        return refreshCheckDelay;
    }

    protected RootBeanDefinition createScriptFactoryBeanDefinition(RootBeanDefinition bd) {
        RootBeanDefinition scriptBd = new RootBeanDefinition(bd.getBeanClass());
        scriptBd.getConstructorArgumentValues().addArgumentValues(bd.getConstructorArgumentValues());
        return scriptBd;
    }

    protected ScriptSource convertToScriptSource(String scriptSourceLocator, ResourceLoader resourceLoader) {
        if (scriptSourceLocator.startsWith(INLINE_SCRIPT_PREFIX)) {
            return new StaticScriptSource(scriptSourceLocator.substring(INLINE_SCRIPT_PREFIX.length()));
        }
        return new ResourceScriptSource(resourceLoader.getResource(scriptSourceLocator));
    }

    protected Class createConfigInterface(PropertyValue[] pvs, Class[] interfaces) {
        Assert.notEmpty(pvs, "Property values must not be empty");
        InterfaceMaker maker = new InterfaceMaker();
        for (int i2 = 0; i2 < pvs.length; ++i2) {
            String propertyName = pvs[i2].getName();
            Class propertyType = BeanUtils.findPropertyType(propertyName, interfaces);
            String setterName = "set" + StringUtils.capitalize(propertyName);
            Signature signature = new Signature(setterName, Type.VOID_TYPE, new Type[]{Type.getType((Class)propertyType)});
            maker.add(signature, new Type[0]);
        }
        return maker.create();
    }

    protected RootBeanDefinition createScriptedObjectBeanDefinition(RootBeanDefinition bd, String scriptFactoryBeanName, ScriptSource scriptSource, Class[] interfaces) {
        RootBeanDefinition objectBd = new RootBeanDefinition(bd);
        objectBd.setBeanClass(null);
        objectBd.setFactoryBeanName(scriptFactoryBeanName);
        objectBd.setFactoryMethodName("getScriptedObject");
        objectBd.getConstructorArgumentValues().clear();
        objectBd.getConstructorArgumentValues().addIndexedArgumentValue(0, scriptSource);
        objectBd.getConstructorArgumentValues().addIndexedArgumentValue(1, interfaces);
        return objectBd;
    }

    protected Object createRefreshableProxy(TargetSource ts, Class[] interfaces) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTargetSource(ts);
        if (interfaces == null) {
            interfaces = ClassUtils.getAllInterfacesForClass(ts.getTargetClass());
        }
        proxyFactory.setInterfaces(interfaces);
        DelegatingIntroductionInterceptor introduction = new DelegatingIntroductionInterceptor(ts);
        introduction.suppressInterface(class$org$springframework$aop$TargetSource == null ? (class$org$springframework$aop$TargetSource = ScriptFactoryPostProcessor.class$("com.bmc.thirdparty.org.springframework.aop.TargetSource")) : class$org$springframework$aop$TargetSource);
        proxyFactory.addAdvice(introduction);
        return proxyFactory.getProxy();
    }

    public void destroy() {
        this.scriptBeanFactory.destroySingletons();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

