/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jms.listener.serversession;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.core.task.TaskExecutor;
import com.bmc.thirdparty.org.springframework.jms.listener.serversession.ListenerSessionManager;
import com.bmc.thirdparty.org.springframework.jms.listener.serversession.ServerSessionFactory;
import com.bmc.thirdparty.org.springframework.jms.support.JmsUtils;
import com.bmc.thirdparty.org.springframework.scheduling.timer.TimerTaskExecutor;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.Session;

public abstract class AbstractPoolingServerSessionFactory
implements ServerSessionFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private TaskExecutor taskExecutor;
    private int maxSize;

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    protected TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    protected final ServerSession createServerSession(ListenerSessionManager sessionManager) throws JMSException {
        return new PoolableServerSession(sessionManager);
    }

    protected final void destroyServerSession(ServerSession serverSession) {
        if (serverSession != null) {
            ((PoolableServerSession)serverSession).close();
        }
    }

    protected abstract void serverSessionFinished(ServerSession var1, ListenerSessionManager var2);

    private class PoolableServerSession
    implements ServerSession {
        private final ListenerSessionManager sessionManager;
        private final Session session;
        private TaskExecutor taskExecutor;
        private TimerTaskExecutor internalExecutor;

        public PoolableServerSession(ListenerSessionManager sessionManager) throws JMSException {
            this.sessionManager = sessionManager;
            this.session = sessionManager.createListenerSession();
            this.taskExecutor = AbstractPoolingServerSessionFactory.this.getTaskExecutor();
            if (this.taskExecutor == null) {
                this.internalExecutor = new TimerTaskExecutor();
                this.internalExecutor.afterPropertiesSet();
                this.taskExecutor = this.internalExecutor;
            }
        }

        public Session getSession() {
            return this.session;
        }

        public void start() {
            this.taskExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        PoolableServerSession.this.sessionManager.executeListenerSession(PoolableServerSession.this.session);
                    }
                    finally {
                        AbstractPoolingServerSessionFactory.this.serverSessionFinished(PoolableServerSession.this, PoolableServerSession.this.sessionManager);
                    }
                }
            });
        }

        public void close() {
            if (this.internalExecutor != null) {
                this.internalExecutor.destroy();
            }
            JmsUtils.closeSession(this.session);
        }
    }
}

