/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jdbc.support.nativejdbc;

import com.bmc.thirdparty.org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractorAdapter;
import com.bmc.thirdparty.org.springframework.util.ReflectionUtils;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class JBossNativeJdbcExtractor
extends NativeJdbcExtractorAdapter {
    private static final String WRAPPED_CONNECTION_NAME = "org.jboss.resource.adapter.jdbc.WrappedConnection";
    private static final String WRAPPED_STATEMENT_NAME = "org.jboss.resource.adapter.jdbc.WrappedStatement";
    private static final String WRAPPED_RESULT_SET_NAME = "org.jboss.resource.adapter.jdbc.WrappedResultSet";
    private Class wrappedConnectionClass;
    private Class wrappedStatementClass;
    private Class wrappedResultSetClass;
    private Method getUnderlyingConnectionMethod;
    private Method getUnderlyingStatementMethod;
    private Method getUnderlyingResultSetMethod;

    public JBossNativeJdbcExtractor() {
        try {
            this.wrappedConnectionClass = this.getClass().getClassLoader().loadClass(WRAPPED_CONNECTION_NAME);
            this.wrappedStatementClass = this.getClass().getClassLoader().loadClass(WRAPPED_STATEMENT_NAME);
            this.wrappedResultSetClass = this.getClass().getClassLoader().loadClass(WRAPPED_RESULT_SET_NAME);
            this.getUnderlyingConnectionMethod = this.wrappedConnectionClass.getMethod("getUnderlyingConnection", null);
            this.getUnderlyingStatementMethod = this.wrappedStatementClass.getMethod("getUnderlyingStatement", null);
            this.getUnderlyingResultSetMethod = this.wrappedResultSetClass.getMethod("getUnderlyingResultSet", null);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not initialize JBossNativeJdbcExtractor because JBoss API classes are not available: " + ex);
        }
    }

    protected Connection doGetNativeConnection(Connection con) throws SQLException {
        if (this.wrappedConnectionClass.isAssignableFrom(con.getClass())) {
            return (Connection)ReflectionUtils.invokeMethod(this.getUnderlyingConnectionMethod, con);
        }
        return con;
    }

    public Statement getNativeStatement(Statement stmt) throws SQLException {
        if (this.wrappedStatementClass.isAssignableFrom(stmt.getClass())) {
            return (Statement)ReflectionUtils.invokeMethod(this.getUnderlyingStatementMethod, stmt);
        }
        return stmt;
    }

    public PreparedStatement getNativePreparedStatement(PreparedStatement ps) throws SQLException {
        return (PreparedStatement)this.getNativeStatement(ps);
    }

    public CallableStatement getNativeCallableStatement(CallableStatement cs) throws SQLException {
        return (CallableStatement)this.getNativeStatement(cs);
    }

    public ResultSet getNativeResultSet(ResultSet rs) throws SQLException {
        if (this.wrappedResultSetClass.isAssignableFrom(rs.getClass())) {
            return (ResultSet)ReflectionUtils.invokeMethod(this.getUnderlyingResultSetMethod, rs);
        }
        return rs;
    }
}

