/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.AlertMessageCriteria;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.arsys.arcompress.ARDecompressor;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.zip.DataFormatException;

public class AlertMessageInfo
implements Serializable {
    private static final long serialVersionUID = 1538327159080758632L;
    private Timestamp timestamp;
    private int sourceType;
    private int priority;
    private String alertText;
    private String sourceTag;
    private String serverName;
    private String serverAddr;
    private String formName;
    private String objectId;
    private String user;
    public static final int AR_ALERT_MSG_TOTAL_LEN = 1;
    public static final int AR_ALERT_MSG_SERVER_VERSION = 2;
    public static final int AR_ALERT_MSG_TIMESTAMP = 3;
    public static final int AR_ALERT_MSG_TYPE_CODE = 4;
    public static final int AR_ALERT_MSG_PRIORITY = 5;
    public static final int AR_ALERT_MSG_TEXT_LEN = 6;
    public static final int AR_ALERT_MSG_TEXT = 7;
    public static final int AR_ALERT_MSG_SOURCE_LEN = 8;
    public static final int AR_ALERT_MSG_SOURCE = 9;
    public static final int AR_ALERT_MSG_SOURCE_SERVER_LEN = 10;
    public static final int AR_ALERT_MSG_SOURCE_SERVER = 11;
    public static final int AR_ALERT_MSG_SOURCE_FORM_LEN = 12;
    public static final int AR_ALERT_MSG_SOURCE_FORM = 13;
    public static final int AR_ALERT_MSG_SOURCE_OBJECT_LEN = 14;
    public static final int AR_ALERT_MSG_SOURCE_OBJECT = 15;
    public static final int AR_ALERT_MSG_SOURCE_SVR_ADDR_LEN = 16;
    public static final int AR_ALERT_MSG_SOURCE_SVR_ADDR = 17;
    public static final int AR_ALERT_MSG_ITEM_COUNT = 17;
    public static final int AR_ALERT_MSG_ITEM_COUNT_V1 = 15;
    public static final int AR_ALERT_MSG_PROTOCOL_VERSION = 2;
    public static final int AR_ALERT_SOURCE_GP = 1;
    public static final int AR_ALERT_SOURCE_AR = 2;
    public static final int AR_ALERT_SOURCE_FIRST = 3;
    public static final int AR_ALERT_SOURCE_CHECK = 4;
    public static final int AR_ALERT_SOURCE_FB = 5;
    public static final String AR_ALERT_ACK = "ack";
    public static final String AR_ALERT_MSG_SEPARATOR = "\\";

    public AlertMessageInfo() {
    }

    public AlertMessageInfo(Timestamp timestamp, int n2, int n3, String string, String string2, String string3, String string4, String string5) {
        this.sourceType = n2;
        this.priority = n3;
        this.alertText = string;
        this.sourceTag = string2;
        this.serverName = string3;
        this.formName = string4;
        this.objectId = string5;
        try {
            this.timestamp = timestamp != null ? (Timestamp)timestamp.clone() : null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Clone not supported");
        }
    }

    public AlertMessageInfo(Timestamp timestamp, int n2, int n3, String string, String string2, String string3, String string4, String string5, String string6) {
        this.sourceType = n2;
        this.priority = n3;
        this.alertText = string;
        this.sourceTag = string2;
        this.serverName = string3;
        this.serverAddr = string4;
        this.formName = string5;
        this.objectId = string6;
        try {
            this.timestamp = timestamp != null ? (Timestamp)timestamp.clone() : null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Clone not supported");
        }
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public int getSourceType() {
        return this.sourceType;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getAlertText() {
        return this.alertText;
    }

    public String getSourceTag() {
        return this.sourceTag;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    public String getFormName() {
        return this.formName;
    }

    public String getObjectId() {
        return this.objectId;
    }

    void fromVariant(Object[] objectArray, ARServerUser aRServerUser) {
        if (objectArray == null) {
            return;
        }
        this.timestamp = new Timestamp(ConversionUtil.getLongValue(ARTypeMgr.GetAt((Object)objectArray, 4)));
        this.sourceType = ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)objectArray, 5));
        this.priority = ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)objectArray, 6));
        this.alertText = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)objectArray, 7));
        this.sourceTag = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)objectArray, 8));
        this.serverName = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)objectArray, 9));
        this.serverAddr = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)objectArray, 10));
        this.formName = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)objectArray, 11));
        this.objectId = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)objectArray, 12));
        this.user = aRServerUser.getUser();
    }

    static AlertMessageInfo createInstance(Object[] objectArray, ARServerUser aRServerUser) {
        if (objectArray == null) {
            return null;
        }
        AlertMessageInfo alertMessageInfo = new AlertMessageInfo();
        if (objectArray.length == 14 && objectArray[0] != null) {
            alertMessageInfo.fromVariant(objectArray, aRServerUser);
        }
        return alertMessageInfo;
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Timestamp", this.timestamp).append("Source Type", this.sourceType).append("Priority", this.priority).append("Alert Text", this.alertText).append("Source Tag", this.sourceTag).append("Server Name", this.serverName).append("Server Addr", this.serverAddr).append("Form Name", this.formName).append("Object Id", this.objectId).append("User", this.user).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.timestamp).append(this.sourceType).append(this.priority).append(this.alertText).append(this.sourceTag).append(this.serverName).append(this.serverAddr).append(this.formName).append(this.objectId).append(this.user).toHashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof AlertMessageInfo)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        AlertMessageInfo alertMessageInfo = (AlertMessageInfo)object;
        return new EqualsBuilder().append(this.timestamp, alertMessageInfo.timestamp).append(this.sourceType, alertMessageInfo.sourceType).append(this.priority, alertMessageInfo.priority).append(this.alertText, alertMessageInfo.alertText).append(this.sourceTag, alertMessageInfo.sourceTag).append(this.serverName, alertMessageInfo.serverName).append(this.serverAddr, alertMessageInfo.serverAddr).append(this.formName, alertMessageInfo.formName).append(this.objectId, alertMessageInfo.objectId).append(this.user, alertMessageInfo.user).isEquals();
    }

    public static AlertMessageInfo DecodeAlertMessage(AlertMessageCriteria alertMessageCriteria, Object object, int n2) throws ARException {
        Object object2;
        int n3;
        if (object == null || n2 < 8) {
            throw new ARException(2, 3317, "");
        }
        AlertMessageInfo alertMessageInfo = new AlertMessageInfo();
        byte[] byArray = (byte[])object;
        int n4 = -1;
        String string = new String(byArray);
        String string2 = string.substring(0, 4);
        if (string2.equalsIgnoreCase("2059")) {
            try {
                n3 = 4;
                n4 = byArray[n3++] & 0xFF;
                n4 = n4 << 8 | byArray[n3++] & 0xFF;
                n4 = n4 << 8 | byArray[n3++] & 0xFF;
                n4 = n4 << 8 | byArray[n3++] & 0xFF;
                if (n4 != n2) {
                    throw new ARException(2, 3317, "");
                }
                object2 = new ARDecompressor();
                ((ARDecompressor)object2).setInput(byArray, 8, n2 - 8);
                byte[] byArray2 = ((ARDecompressor)object2).inflate();
                string = new String(byArray2).trim();
            }
            catch (DataFormatException dataFormatException) {
                throw new ARException(2, 9004, dataFormatException.getLocalizedMessage());
            }
        }
        n3 = 0;
        object2 = string;
        while (((String)object2).indexOf(AR_ALERT_MSG_SEPARATOR, 0) != -1) {
            ++n3;
            object2 = ((String)object2).substring(((String)object2).indexOf(AR_ALERT_MSG_SEPARATOR, 0) + 1);
        }
        int n5 = 0;
        int n6 = string.indexOf(AR_ALERT_MSG_SEPARATOR, 0) + 1;
        int n7 = Integer.parseInt(string.substring(n6, n6 + 1));
        switch (n7) {
            case 1: {
                if (n3 < 15) {
                    throw new ARException(2, 3317, "");
                }
                n5 = 15;
                break;
            }
            case 2: {
                if (n3 < 17) {
                    throw new ARException(2, 3317, "");
                }
                n5 = 17;
                break;
            }
            default: {
                throw new ARException(2, 3317, "");
            }
        }
        int n8 = -1;
        String string3 = string;
        block21: for (int i2 = 1; string3.length() != 0 && i2 <= n5; ++i2) {
            if (string3.indexOf(AR_ALERT_MSG_SEPARATOR, 0) == -1) {
                throw new ARException(2, 3317, "");
            }
            String string4 = null;
            if (n8 != -1) {
                if (!AR_ALERT_MSG_SEPARATOR.equals(String.valueOf(string3.charAt(n8)))) {
                    throw new ARException(2, 3317, "");
                }
                string4 = string3.substring(0, n8);
                string3 = string3.substring(n8 + 1);
                n8 = -1;
            } else {
                string4 = string3.substring(0, string3.indexOf(AR_ALERT_MSG_SEPARATOR, 0));
                string3 = string3.substring(string3.indexOf(AR_ALERT_MSG_SEPARATOR, 0) + 1);
            }
            switch (i2) {
                case 1: {
                    if (Integer.parseInt(string4) == string.length()) continue block21;
                    throw new ARException(2, 3317, "");
                }
                case 2: {
                    n7 = Integer.parseInt(string4);
                    continue block21;
                }
                case 3: {
                    alertMessageInfo.timestamp = new Timestamp(Long.valueOf(string4));
                    continue block21;
                }
                case 4: {
                    alertMessageInfo.sourceType = Integer.parseInt(string4);
                    continue block21;
                }
                case 5: {
                    alertMessageInfo.priority = Integer.parseInt(string4);
                    continue block21;
                }
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: {
                    n8 = Integer.parseInt(string4);
                    continue block21;
                }
                case 7: {
                    alertMessageInfo.alertText = string4;
                    continue block21;
                }
                case 9: {
                    alertMessageInfo.sourceTag = string4;
                    continue block21;
                }
                case 11: {
                    alertMessageInfo.serverName = string4;
                    continue block21;
                }
                case 13: {
                    alertMessageInfo.formName = string4;
                    continue block21;
                }
                case 15: {
                    alertMessageInfo.objectId = string4;
                    continue block21;
                }
                case 17: {
                    alertMessageInfo.serverAddr = string4;
                    continue block21;
                }
            }
        }
        return alertMessageInfo;
    }
}

