/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.NoSuchElementException;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcPortmapClient;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.XdrEncodingStream;
import org.acplt.oncrpc.server.OncRpcCallInformation;
import org.acplt.oncrpc.server.OncRpcDispatchable;
import org.acplt.oncrpc.server.OncRpcServerReplyMessage;
import org.acplt.oncrpc.server.OncRpcServerTransport;
import org.acplt.oncrpc.server.OncRpcServerTransportRegistrationInfo;
import org.acplt.oncrpc.server.OncRpcTcpConnectionServerTransport;

public class OncRpcTcpServerTransport
extends OncRpcServerTransport {
    private ServerSocket socket;
    private int bufferSize;
    private TransportList openTransports = new TransportList();
    protected int transmissionTimeout = 30000;
    private String characterEncoding = null;

    public OncRpcTcpServerTransport(OncRpcDispatchable oncRpcDispatchable, int n, int n2, int n3, int n4) throws OncRpcException, IOException {
        this(oncRpcDispatchable, n, new OncRpcServerTransportRegistrationInfo[]{new OncRpcServerTransportRegistrationInfo(n2, n3)}, n4);
    }

    public OncRpcTcpServerTransport(OncRpcDispatchable oncRpcDispatchable, int n, OncRpcServerTransportRegistrationInfo[] oncRpcServerTransportRegistrationInfoArray, int n2) throws OncRpcException, IOException {
        this(oncRpcDispatchable, null, n, oncRpcServerTransportRegistrationInfoArray, n2);
    }

    public OncRpcTcpServerTransport(OncRpcDispatchable oncRpcDispatchable, InetAddress inetAddress, int n, OncRpcServerTransportRegistrationInfo[] oncRpcServerTransportRegistrationInfoArray, int n2) throws OncRpcException, IOException {
        super(oncRpcDispatchable, n, oncRpcServerTransportRegistrationInfoArray);
        if (n2 < 1024) {
            n2 = 1024;
        }
        this.bufferSize = n2;
        this.socket = new ServerSocket(n, 0, inetAddress);
        if (n == 0) {
            this.port = this.socket.getLocalPort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object;
        if (this.socket != null) {
            object = this.socket;
            this.socket = null;
            try {
                ((ServerSocket)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = this.openTransports;
        synchronized (object) {
            while (this.openTransports.size() > 0) {
                OncRpcTcpConnectionServerTransport oncRpcTcpConnectionServerTransport = (OncRpcTcpConnectionServerTransport)this.openTransports.removeFirst();
                oncRpcTcpConnectionServerTransport.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTransport(OncRpcTcpConnectionServerTransport oncRpcTcpConnectionServerTransport) {
        TransportList transportList = this.openTransports;
        synchronized (transportList) {
            this.openTransports.remove(oncRpcTcpConnectionServerTransport);
        }
    }

    @Override
    public void register() throws OncRpcException {
        try {
            OncRpcPortmapClient oncRpcPortmapClient = new OncRpcPortmapClient(InetAddress.getByName("127.0.0.1"));
            int n = this.info.length;
            for (int i = 0; i < n; ++i) {
                if (oncRpcPortmapClient.setPort(this.info[i].program, this.info[i].version, 6, this.port)) continue;
                throw new OncRpcException(45);
            }
        }
        catch (IOException iOException) {
            throw new OncRpcException(16);
        }
    }

    @Override
    public void retrieveCall(XdrAble xdrAble) throws OncRpcException, IOException {
        throw new Error("OncRpcTcpServerTransport.retrieveCall() is abstract and can not be called.");
    }

    @Override
    protected XdrDecodingStream getXdrDecodingStream() {
        throw new Error("OncRpcTcpServerTransport.getXdrDecodingStream() is abstract and can not be called.");
    }

    @Override
    protected void endDecoding() throws OncRpcException, IOException {
        throw new Error("OncRpcTcpServerTransport.endDecoding() is abstract and can not be called.");
    }

    @Override
    protected XdrEncodingStream getXdrEncodingStream() {
        throw new Error("OncRpcTcpServerTransport.getXdrEncodingStream() is abstract and can not be called.");
    }

    @Override
    protected void beginEncoding(OncRpcCallInformation oncRpcCallInformation, OncRpcServerReplyMessage oncRpcServerReplyMessage) throws OncRpcException, IOException {
        throw new Error("OncRpcTcpServerTransport.beginEncoding() is abstract and can not be called.");
    }

    @Override
    protected void endEncoding() throws OncRpcException, IOException {
        throw new Error("OncRpcTcpServerTransport.endEncoding() is abstract and can not be called.");
    }

    @Override
    protected void reply(OncRpcCallInformation oncRpcCallInformation, OncRpcServerReplyMessage oncRpcServerReplyMessage, XdrAble xdrAble) throws OncRpcException, IOException {
        throw new Error("OncRpcTcpServerTransport.reply() is abstract and can not be called.");
    }

    @Override
    public void listen() {
        Thread thread = new Thread("TCP server transport listener thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                while (true) {
                    try {
                        ServerSocket serverSocket;
                        while ((serverSocket = OncRpcTcpServerTransport.this.socket) != null) {
                            Socket socket = serverSocket.accept();
                            OncRpcTcpConnectionServerTransport oncRpcTcpConnectionServerTransport = new OncRpcTcpConnectionServerTransport(OncRpcTcpServerTransport.this.dispatcher, socket, OncRpcTcpServerTransport.this.info, OncRpcTcpServerTransport.this.bufferSize, OncRpcTcpServerTransport.this, OncRpcTcpServerTransport.this.transmissionTimeout);
                            TransportList transportList = OncRpcTcpServerTransport.this.openTransports;
                            synchronized (transportList) {
                                OncRpcTcpServerTransport.this.openTransports.add(oncRpcTcpConnectionServerTransport);
                            }
                            oncRpcTcpConnectionServerTransport.listen();
                        }
                        return;
                    }
                    catch (OncRpcException oncRpcException) {
                        continue;
                    }
                    catch (IOException iOException) {
                        if (OncRpcTcpServerTransport.this.socket == null) return;
                        continue;
                    }
                    break;
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public void setTransmissionTimeout(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("transmission timeout must be > 0");
        }
        this.transmissionTimeout = n;
    }

    public int getTransmissionTimeout() {
        return this.transmissionTimeout;
    }

    @Override
    public void setCharacterEncoding(String string) {
        this.characterEncoding = string;
    }

    @Override
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    protected OncRpcTcpConnectionServerTransport getTCPConnectionServerTransport(Socket socket, int n) throws IOException, OncRpcException {
        return new OncRpcTcpConnectionServerTransport(this.dispatcher, socket, this.info, n, this, this.transmissionTimeout);
    }

    private class TransportList {
        private Node head = new Node(null);
        private int size = 0;

        public TransportList() {
            this.head.next = this.head;
            this.head.prev = this.head;
        }

        public void add(Object object) {
            Node node = new Node(object);
            node.next = this.head.next;
            this.head.next = node;
            node.prev = this.head;
            node.next.prev = node;
            ++this.size;
        }

        public boolean remove(Object object) {
            Node node = this.head.next;
            while (node != this.head) {
                if (node.item == object) {
                    node.prev.next = node.next;
                    node.next.prev = node.prev;
                    --this.size;
                    return true;
                }
                node = node.next;
            }
            return false;
        }

        public Object removeFirst() {
            if (this.size == 0) {
                throw new NoSuchElementException();
            }
            Node node = this.head.next;
            this.head.next = node.next;
            node.next.prev = this.head;
            --this.size;
            return node.item;
        }

        public int size() {
            return this.size;
        }

        private class Node {
            Node next;
            Node prev;
            Object item;

            public Node(Object object) {
                this.item = object;
            }
        }
    }
}

