/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.demo.javadriver;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.Action;
import com.bmc.arsys.api.ActiveLinkAction;
import com.bmc.arsys.api.ActiveLinkGuide;
import com.bmc.arsys.api.AlertMessageCriteria;
import com.bmc.arsys.api.ApplicationContainer;
import com.bmc.arsys.api.ArchiveInfo;
import com.bmc.arsys.api.ArithOpAssignInfo;
import com.bmc.arsys.api.ArithmeticOperationInfo;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.AssignFieldInfo;
import com.bmc.arsys.api.AssignFilterApiInfo;
import com.bmc.arsys.api.AssignInfo;
import com.bmc.arsys.api.AssignSQLInfo;
import com.bmc.arsys.api.AttachmentField;
import com.bmc.arsys.api.AttachmentFieldLimit;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.AuditInfo;
import com.bmc.arsys.api.ByteListValue;
import com.bmc.arsys.api.COMMethodInfo;
import com.bmc.arsys.api.COMMethodParmInfo;
import com.bmc.arsys.api.COMValueInfo;
import com.bmc.arsys.api.CallGuideAction;
import com.bmc.arsys.api.ChangeFieldAction;
import com.bmc.arsys.api.CharacterField;
import com.bmc.arsys.api.CharacterFieldLimit;
import com.bmc.arsys.api.CloseWindowAction;
import com.bmc.arsys.api.ColumnField;
import com.bmc.arsys.api.ColumnFieldLimit;
import com.bmc.arsys.api.CommitChangesAction;
import com.bmc.arsys.api.Container;
import com.bmc.arsys.api.ContainerOwner;
import com.bmc.arsys.api.ContainerType;
import com.bmc.arsys.api.CoordinateInfo;
import com.bmc.arsys.api.CurrencyDetail;
import com.bmc.arsys.api.CurrencyField;
import com.bmc.arsys.api.CurrencyFieldLimit;
import com.bmc.arsys.api.CurrencyPartInfo;
import com.bmc.arsys.api.CurrencyValue;
import com.bmc.arsys.api.DDEAction;
import com.bmc.arsys.api.DataDictionaryMenu;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DateInfo;
import com.bmc.arsys.api.DateOnlyField;
import com.bmc.arsys.api.DateTimeField;
import com.bmc.arsys.api.DayInfo;
import com.bmc.arsys.api.DecimalField;
import com.bmc.arsys.api.DecimalFieldLimit;
import com.bmc.arsys.api.DiaryField;
import com.bmc.arsys.api.DiaryFieldLimit;
import com.bmc.arsys.api.DiaryItem;
import com.bmc.arsys.api.DiaryListValue;
import com.bmc.arsys.api.DirectSqlAction;
import com.bmc.arsys.api.DisplayField;
import com.bmc.arsys.api.DisplayFieldLimit;
import com.bmc.arsys.api.DisplayInstanceMap;
import com.bmc.arsys.api.DisplayOnlyForm;
import com.bmc.arsys.api.DisplayPropertyMap;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryKey;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.EnumItem;
import com.bmc.arsys.api.EscalationInterval;
import com.bmc.arsys.api.EscalationTime;
import com.bmc.arsys.api.EscalationTimeCriteria;
import com.bmc.arsys.api.ExitGuideAction;
import com.bmc.arsys.api.ExternalReference;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.FieldAssignInfo;
import com.bmc.arsys.api.FieldDataDictionaryMenu;
import com.bmc.arsys.api.FieldLimit;
import com.bmc.arsys.api.FieldMapping;
import com.bmc.arsys.api.FileMenu;
import com.bmc.arsys.api.FilterAction;
import com.bmc.arsys.api.FilterGuide;
import com.bmc.arsys.api.FilterMessageAction;
import com.bmc.arsys.api.Form;
import com.bmc.arsys.api.FormDataDictionaryMenu;
import com.bmc.arsys.api.FormType;
import com.bmc.arsys.api.FunctionAssignInfo;
import com.bmc.arsys.api.GotoAction;
import com.bmc.arsys.api.GotoGuideLabelAction;
import com.bmc.arsys.api.IQuerySource;
import com.bmc.arsys.api.ImageData;
import com.bmc.arsys.api.IndexInfo;
import com.bmc.arsys.api.IntegerField;
import com.bmc.arsys.api.IntegerFieldLimit;
import com.bmc.arsys.api.JoinFieldMapping;
import com.bmc.arsys.api.JoinForm;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.api.ListMenu;
import com.bmc.arsys.api.LocalizedRequestInfo;
import com.bmc.arsys.api.LocalizedValueCriteria;
import com.bmc.arsys.api.LogAction;
import com.bmc.arsys.api.Menu;
import com.bmc.arsys.api.MenuItem;
import com.bmc.arsys.api.MessageAction;
import com.bmc.arsys.api.NotifyAction;
import com.bmc.arsys.api.ObjectPropertyMap;
import com.bmc.arsys.api.OleAutomationAction;
import com.bmc.arsys.api.OpenWindowAction;
import com.bmc.arsys.api.OperandType;
import com.bmc.arsys.api.PackingList;
import com.bmc.arsys.api.PermissionInfo;
import com.bmc.arsys.api.PropInfo;
import com.bmc.arsys.api.PushFieldsAction;
import com.bmc.arsys.api.PushFieldsInfo;
import com.bmc.arsys.api.QualifierFromFieldInfo;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.QueryFormField;
import com.bmc.arsys.api.QueryInfo;
import com.bmc.arsys.api.QueryMenu;
import com.bmc.arsys.api.QuerySourceForm;
import com.bmc.arsys.api.RealField;
import com.bmc.arsys.api.RealFieldLimit;
import com.bmc.arsys.api.RecursiveQuery;
import com.bmc.arsys.api.Reference;
import com.bmc.arsys.api.ReferenceType;
import com.bmc.arsys.api.RegularFieldMapping;
import com.bmc.arsys.api.RegularForm;
import com.bmc.arsys.api.RegularQuery;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.RunMacroAction;
import com.bmc.arsys.api.RunProcessAction;
import com.bmc.arsys.api.SelectionField;
import com.bmc.arsys.api.SelectionFieldLimit;
import com.bmc.arsys.api.ServerInfo;
import com.bmc.arsys.api.ServerInfoMap;
import com.bmc.arsys.api.SetFieldsAction;
import com.bmc.arsys.api.SetFieldsFromFilterAPI;
import com.bmc.arsys.api.SetFieldsFromSQL;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.SqlMenu;
import com.bmc.arsys.api.StatusHistoryItem;
import com.bmc.arsys.api.StatusHistoryValue;
import com.bmc.arsys.api.StatusHistoryValueIndicator;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.StructItemInfo;
import com.bmc.arsys.api.SupportFileKey;
import com.bmc.arsys.api.TableField;
import com.bmc.arsys.api.TableFieldLimit;
import com.bmc.arsys.api.Time;
import com.bmc.arsys.api.TimeOnlyField;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.ValueSetQuery;
import com.bmc.arsys.api.VendorFieldMapping;
import com.bmc.arsys.api.VendorForm;
import com.bmc.arsys.api.ViewDisplayPropertyMap;
import com.bmc.arsys.api.ViewField;
import com.bmc.arsys.api.ViewFieldLimit;
import com.bmc.arsys.api.ViewFieldMapping;
import com.bmc.arsys.api.ViewForm;
import com.bmc.arsys.api.ViewKey;
import com.bmc.arsys.api.WaitAction;
import com.bmc.arsys.api.WebService;
import com.bmc.arsys.api.WfdBreakpoint;
import com.bmc.arsys.api.WorkflowLockInfo;
import com.bmc.arsys.demo.javadriver.JavaDriver;
import com.bmc.arsys.demo.javadriver.LocaleCharSet;
import com.bmc.arsys.demo.javadriver.OutputWriter;
import com.bmc.arsys.demo.javadriver.ThreadControlBlock;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.List;
import java.util.Stack;
import java.util.TreeMap;

public class InputReader {
    static Stack<Object> inputSources = new Stack();
    static BufferedReader currentInputSource = new BufferedReader(new InputStreamReader(System.in));
    static boolean nullPromptOption = false;

    public static void setNullPromptOption(boolean bl) {
        nullPromptOption = bl;
    }

    public static boolean getNullPromptOption() {
        return nullPromptOption;
    }

    public static void getInputLine() throws IOException {
        String string = null;
        ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
        BufferedReader bufferedReader = threadControlBlock.getCurrentInputFile();
        string = bufferedReader.readLine();
        if (string == null) {
            if (threadControlBlock.isCurrentInputSourceStdInput()) {
                JavaDriver.outputWriter.driverPrintError("\n*** EOF on input file; exiting ***\n");
                System.exit(1);
            }
            threadControlBlock.closeCurrentInputFile();
            InputReader.getInputLine();
            return;
        }
        threadControlBlock.addToCurrentInputFilePosition(string.length());
        PrintWriter printWriter = threadControlBlock.getRecordFile();
        if (printWriter != null && !string.equals("srec")) {
            printWriter.write(string);
            printWriter.write("\n");
        }
        int n = 0;
        for (n = string.length() - 1; n >= 0 && string.charAt(n) == ' ' && string.charAt(n) == '\t' && string.charAt(n) == '\n'; --n) {
        }
        threadControlBlock.setBuffer(string.substring(0, n + 1));
        if (string.length() >= 1 && string.charAt(0) == '#' && threadControlBlock.processCommentLine(string) && !threadControlBlock.getIsStdOut()) {
            JavaDriver.outputWriter.printResult(string + "\n");
        }
    }

    public static boolean getBoolean(String string, boolean bl) throws IOException {
        if (!InputReader.getNullPromptOption()) {
            return bl;
        }
        return InputReader.getBooleanForChangingInfo(string, bl);
    }

    public static boolean getBooleanForChangingInfo(String string, boolean bl) throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt(string);
        boolean bl2 = bl;
        InputReader.getInputLine();
        ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
        String string2 = threadControlBlock.getBuffer();
        if (string2.length() != 0) {
            bl2 = string2.equals("t") || string2.equals("true") || string2.equals("T");
        }
        return bl2;
    }

    public static int getInt(int n) throws IOException {
        InputReader.getInputLine();
        ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
        String string = threadControlBlock.getBuffer();
        int n2 = n;
        if (string.length() != 0) {
            try {
                Integer n3 = new Integer(string);
                n2 = n3;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    public static int getInt(String string, int n) throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt(string);
        return InputReader.getInt(n);
    }

    public static long getLong(String string, long l) throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt(string);
        long l2 = l;
        InputReader.getInputLine();
        ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
        String string2 = threadControlBlock.getBuffer();
        if (string2.length() != 0) {
            try {
                Long l3 = new Long(string2);
                l2 = l3;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l2;
    }

    public static double getDouble(String string, double d) throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt(string);
        double d2 = d;
        InputReader.getInputLine();
        ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
        String string2 = threadControlBlock.getBuffer();
        if (string2.length() != 0) {
            try {
                Double d3 = new Double(string2);
                d2 = d3;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d2;
    }

    public static char getChar(String string, char c) throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt(string);
        char c2 = c;
        InputReader.getInputLine();
        ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
        String string2 = threadControlBlock.getBuffer();
        if (string2.length() != 0) {
            c2 = string2.charAt(0);
        }
        return c2;
    }

    public static String getString(String string, String string2) throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt(string);
        InputReader.getInputLine();
        ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
        String string3 = threadControlBlock.getBuffer();
        if (string3 == null || string3.length() == 0) {
            return string2;
        }
        ARServerUser aRServerUser = threadControlBlock.getContext();
        if (aRServerUser != null) {
            if (string3.equals("$USER$") && aRServerUser.getUser() != null) {
                threadControlBlock.setBuffer(aRServerUser.getUser());
            }
            if (string3.equals("$SERVER$")) {
                threadControlBlock.setBuffer(aRServerUser.getServer());
            }
            if (string3.equals("$FIRST_LIST_ID$")) {
                threadControlBlock.setBuffer(threadControlBlock.getFirstListId());
            }
            if (string3.equals("$SECOND_LIST_ID$")) {
                threadControlBlock.setBuffer(threadControlBlock.getSecondListId());
            }
            if (string3.equals("$LAST_LIST_ID$")) {
                threadControlBlock.setBuffer(threadControlBlock.getLastListId());
            }
        }
        if ((string3 = threadControlBlock.getBuffer()) == null || string3.length() == 0) {
            return string2;
        }
        return string3;
    }

    public static Time getTimeOfDay(String string, Time time) throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt(string + "(" + time.getValue() + "): ");
        Time time2 = new Time(time.getValue());
        InputReader.getInputLine();
        ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
        String string2 = threadControlBlock.getBuffer();
        if (string2.length() != 0) {
            Long l = new Long(string2);
            time2.setValue(l);
        }
        return time2;
    }

    public static Timestamp getTimestamp(String string, Timestamp timestamp) throws IOException {
        if (InputReader.getBoolean("Null Timestamp (F): ", false)) {
            return null;
        }
        String string2 = InputReader.getString(string, "");
        Timestamp timestamp2 = new Timestamp(timestamp.getValue());
        if (string2.length() != 0) {
            Long l = new Long(string2);
            timestamp2.setValue(l);
        }
        return timestamp2;
    }

    public static Timestamp[] getTimestampArray() throws IOException {
        Timestamp[] timestampArray = null;
        int n = InputReader.getInt("Number of Timestamps (0): ", 0);
        if (n != 0) {
            timestampArray = new Timestamp[n];
            for (int i = 0; i < n; ++i) {
                timestampArray[i] = InputReader.getTimestamp("   Timestamp: (0)", new Timestamp(0L));
            }
        }
        return timestampArray;
    }

    public static List<Timestamp> getTimestampList() throws IOException {
        Timestamp[] timestampArray = InputReader.getTimestampArray();
        return new ArrayList<Timestamp>(Arrays.asList(timestampArray));
    }

    public static int[] getInternalIDList() throws IOException {
        int[] nArray = null;
        int n = InputReader.getInt("  Number of ids( 0 ): ", 0);
        if (n != 0) {
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = InputReader.getInt("    Id  " + i + " ( 1 ): ", 1);
            }
        }
        return nArray;
    }

    public static List<Integer> getInternalIDArrayList() throws IOException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = InputReader.getInt("  Number of ids( 0 ): ", 0);
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                arrayList.add(InputReader.getInt("    Id  " + i + " ( 1 ): ", 1));
            }
        }
        return arrayList;
    }

    public static List<Integer> getIntegerList() throws IOException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = InputReader.getInt("  Number of ids( 0 ): ", 0);
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                arrayList.add(new Integer(InputReader.getInt("    Id  " + i + " ( 1 ): ", 1)));
            }
        }
        return arrayList;
    }

    public static FormType[] getFormTypeList() throws IOException {
        FormType[] formTypeArray = null;
        int n = InputReader.getInt("  Number of  Values( 0 ): ", 0);
        if (n != 0) {
            formTypeArray = new FormType[n];
            for (int i = 0; i < n; ++i) {
                formTypeArray[i] = InputReader.getFormType();
            }
        }
        return formTypeArray;
    }

    public static String[] getStringArray(String string, String string2) throws IOException {
        int n;
        String[] stringArray = null;
        if (string2 == null || string2.length() == 0) {
            string2 = "item";
        }
        if ((n = InputReader.getInt(string + "Number of " + string2 + "s (0): ", 0)) != 0) {
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = InputReader.getString(string + string2 + "(" + i + "): ", "");
            }
        }
        return stringArray;
    }

    public static List<String> getStringList(String string, String string2) throws IOException {
        String[] stringArray = InputReader.getStringArray(string, string2);
        if (stringArray != null) {
            return new ArrayList<String>(Arrays.asList(stringArray));
        }
        return null;
    }

    public static String[] getApplicationKeyList(String string) throws IOException {
        String[] stringArray = null;
        int n = InputReader.getInt(string + "Number of application keys (0): ", 0);
        if (n != 0) {
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = InputReader.getString(string + "Name " + "(" + i + "): ", "");
            }
        }
        return stringArray;
    }

    public static void getARServerUser() throws IOException {
        String string;
        JavaDriver.outputWriter.driverPrintPrompt("Control record:\n");
        ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
        ARServerUser aRServerUser = threadControlBlock.getContext();
        String string2 = null;
        string2 = aRServerUser.getAuthentication() != null ? InputReader.getString("   Authentication String (" + aRServerUser.getAuthentication() + "): ", aRServerUser.getAuthentication()) : InputReader.getString("   Authentication String (): ", "");
        aRServerUser.setAuthentication(string2);
        String string3 = null;
        string3 = aRServerUser.getUser() != null && aRServerUser.getUser() != null ? InputReader.getString("   User name (" + aRServerUser.getUser() + "): ", aRServerUser.getUser()) : InputReader.getString("   User name (): ", "");
        aRServerUser.setUser(string3);
        String string4 = null;
        string4 = aRServerUser.getPassword() != null && aRServerUser.getPassword() != null ? InputReader.getString("   Password (" + aRServerUser.getPassword() + "): ", aRServerUser.getPassword()) : InputReader.getString("   Password(): ", "");
        aRServerUser.setPassword(string4);
        String string5 = null;
        LocaleCharSet localeCharSet = new LocaleCharSet();
        if (aRServerUser.getLocale() != null) {
            localeCharSet.setLocale(aRServerUser.getLocale());
            string = localeCharSet.toString();
            string5 = InputReader.getString("   Locale (" + string + "): ", string);
        } else {
            string5 = InputReader.getString("   Locale : ", "");
        }
        localeCharSet.parseLocaleAndCharSet(string5);
        aRServerUser.setLocale(localeCharSet.getLocale());
        string = null;
        string = aRServerUser.getTimeZone() != null ? InputReader.getString("   TimeZone (" + aRServerUser.getTimeZone() + "): ", aRServerUser.getTimeZone()) : InputReader.getString("   TimeZone () : ", "");
        aRServerUser.setTimeZone(string);
        String string6 = null;
        string6 = aRServerUser.getServer() != null ? InputReader.getString("   Server (" + aRServerUser.getServer() + "): ", aRServerUser.getServer()) : InputReader.getString("   Server () : ", "");
        aRServerUser.setServer(string6);
    }

    public static FilterMessageAction getFilterStatusInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("Status Info:\n");
        if (InputReader.getBoolean("Null Filter Status Info (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt("   Note, Warning, or Error (0, 1, 2) (2) : ", 2);
        int n2 = InputReader.getInt("   Message number (0): ", 0);
        String string = InputReader.getString("   Message Text():  ", "");
        return new FilterMessageAction(n, n2, string);
    }

    public static MessageAction getMessageInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("Message Info:\n");
        if (InputReader.getBoolean("Null Message Info (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt("   Note, Warning, Error, Prompt, Accessible hint or Tooltip (0, 1, 2, 5, 6, 7)(2) : ", 2);
        int n2 = InputReader.getInt("   Message number (10000): ", 10000);
        String string = InputReader.getString("   Message Text():  ", "");
        boolean bl = InputReader.getBooleanForChangingInfo("   Use Prompting Pane? (T): ", true);
        return new MessageAction(n, n2, string, bl);
    }

    public static List<CoordinateInfo> getCoordinateInfoList() throws IOException {
        ArrayList<CoordinateInfo> arrayList = null;
        int n = InputReader.getInt("Number of Items in the List (0): ", 0);
        if (n != 0) {
            arrayList = new ArrayList<CoordinateInfo>(n);
            for (int i = 0; i < n; ++i) {
                int n2 = InputReader.getInt("x (" + i + "): ", 0);
                int n3 = InputReader.getInt("y (" + i + "): ", 0);
                arrayList.add(new CoordinateInfo(n2, n3));
            }
        }
        return arrayList;
    }

    public static ByteListValue getByteListInfo() throws IOException {
        if (InputReader.getBoolean("Null ByteListInfo (F): ", false)) {
            return null;
        }
        byte[] byArray = null;
        int n = InputReader.getInt("Byte List Type (0): ", 0);
        int n2 = InputReader.getInt("Number of Items in the List (0): ", 0);
        if (n2 != 0) {
            byArray = new byte[n2];
            for (int i = 0; i < n2; ++i) {
                byArray[i] = (byte)InputReader.getChar("Byte (" + i + "): ", '0');
            }
        }
        return new ByteListValue(n, byArray);
    }

    public static AttachmentValue getAttachmentInfo() throws IOException {
        if (InputReader.getBoolean("Null AttachmentInfo (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("Attachment Name(): ", "");
        int n = InputReader.getInt("Choose:\n   1 - prompt for filename,\n   2 - prompt for string\n   default (1): ", 1);
        if (n < 1 || n > 2) {
            JavaDriver.outputWriter.driverPrintWarning("   ERROR: choice outside range 1-4; defaulting to prompt for filename(1)");
            n = 1;
        }
        if (n == 1) {
            File file;
            String string2 = null;
            if (!InputReader.getBoolean("Null FileName? (F):", false)) {
                string2 = InputReader.getString("File Name ():", "");
            }
            if ((file = new File(string2)).exists() && file.canRead()) {
                return new AttachmentValue(string, string2);
            }
            JavaDriver.outputWriter.driverPrintError("  ERROR: failed to open file\n");
            return null;
        }
        String string3 = InputReader.getString("Enter String(): ", "");
        return new AttachmentValue(string, string3.getBytes());
    }

    public static Value getValue() throws IOException, ARException {
        return InputReader.getValue("");
    }

    public static Value getValue(String string) throws IOException, ARException {
        if (InputReader.getBoolean(string + "Null Value (F): ", false)) {
            return null;
        }
        int n = string == "" ? InputReader.getInt("Datatype Null/Key/Int/Real/Char/DiaryList/Enum/Time/Bitmask/Byte\n    Decimal/attach/currency/date/timeofday/join/trim/control/Table/Column/ulong/coords/view/display (0 - 14, 30-34, 40-43) (0): ", 0) : InputReader.getInt(string + "Datatype Null/Key/Int/Real/Char/DiaryList/Enum/Time/Bitmask/Byte/Decimal/attach/currency/date/timeofday/join/trim/control/Table/Column/ulong/coords/view/display (0 - 14, 30-34, 40-43) (0): ", 0);
        Value value = InputReader.getValue(n, string);
        return value;
    }

    public static Value getValue(int n) throws IOException, ARException {
        return InputReader.getValue(n, "");
    }

    public static Value getValue(int n, String string) throws IOException, ARException {
        Value value = null;
        switch (n) {
            case 0: {
                value = new Value();
                break;
            }
            case 1: {
                int n2 = InputReader.getInt(string + "Keyword Code (0): ", 0);
                value = new Value(Keyword.toKeyword(n2));
                break;
            }
            case 2: {
                int n3 = InputReader.getInt(string + "Integer Value (0): ", 0);
                value = new Value(n3);
                break;
            }
            case 3: {
                double d = InputReader.getDouble(string + "Real Value (0.0): ", 0.0);
                value = new Value(d);
                break;
            }
            case 4: {
                String string2 = InputReader.getString(string + "Char Value (): ", "");
                value = new Value(string2);
                break;
            }
            case 5: {
                String string3 = InputReader.getString(string + "DiaryList Value (): ", "");
                DiaryListValue diaryListValue = new DiaryListValue();
                diaryListValue.setAppendedText(string3);
                value = new Value(diaryListValue);
                break;
            }
            case 6: {
                int n4 = InputReader.getInt(string + "Enum Value( 0 ): ", 0);
                value = new Value((Object)n4, DataType.ENUM);
                break;
            }
            case 7: {
                Timestamp timestamp = InputReader.getTimestamp(string + "Time Value (0):", new Timestamp(0L));
                value = new Value(timestamp);
                break;
            }
            case 14: {
                Time time = InputReader.getTimeOfDay(string + "Time Of Day Value(0):", new Time(0L));
                value = new Value(time);
                break;
            }
            case 8: {
                long l = InputReader.getLong("indent + Bitmask Value (0): ", 0L);
                value = new Value(l, DataType.BITMASK);
                break;
            }
            case 9: {
                ByteListValue byteListValue = InputReader.getByteListInfo();
                value = new Value(byteListValue);
                break;
            }
            case 30: {
                value = new Value(null, DataType.JOIN);
                break;
            }
            case 31: {
                value = new Value(null, DataType.TRIM);
                break;
            }
            case 32: {
                value = new Value(null, DataType.CONTROL);
                break;
            }
            case 35: {
                value = new Value(null, DataType.PAGE);
                break;
            }
            case 36: {
                value = new Value(null, DataType.PAGE_HOLDER);
                break;
            }
            case 37: {
                value = new Value(null, DataType.ATTACHMENT_POOL);
                break;
            }
            case 40: {
                long l = InputReader.getLong("indent + Ulong Value (0): ", 0L);
                value = new Value(l, DataType.ULONG);
                break;
            }
            case 41: {
                List<CoordinateInfo> list = InputReader.getCoordinateInfoList();
                value = new Value(list);
                break;
            }
            case 11: {
                AttachmentValue attachmentValue = InputReader.getAttachmentInfo();
                value = new Value(attachmentValue);
                break;
            }
            case 10: {
                String string4 = InputReader.getString(string + "Decimal Value ():", "");
                InputReader.checkDecimalFormat(string4);
                BigDecimal bigDecimal = new BigDecimal(string4);
                value = new Value(bigDecimal);
                break;
            }
            case 12: {
                String string5 = InputReader.getString(string + "Value (0.0):", "");
                InputReader.checkDecimalFormat(string5);
                String string6 = InputReader.getString(string + "CurrencyCode (USD):", "USD");
                Timestamp timestamp = InputReader.getTimestamp(string + "Conversion Date (0):", new Timestamp(0L));
                CurrencyValue currencyValue = new CurrencyValue(string5, string6, timestamp, null);
                value = new Value(currencyValue);
                break;
            }
            case 42: {
                String string7 = InputReader.getString(string + "View Value (): ", "");
                value = new Value(string7, DataType.VIEW);
                break;
            }
            case 43: {
                String string8 = InputReader.getString(string + "Display Value (): ", "");
                value = new Value(string8, DataType.DISPLAY);
                break;
            }
            case 13: {
                String string9 = InputReader.getString(string + "Date Value ()[YYYY-MM-DD]: ", "");
                value = new Value(new DateInfo(DateInfo.dateToJulianDate("yyyy-MM-dd", string9)), DataType.DATE);
                break;
            }
        }
        return value;
    }

    public static List<Value> getValueList() throws IOException, ARException {
        ArrayList<Value> arrayList = null;
        int n = InputReader.getInt("   Number of values (0): ", 0);
        if (n != 0) {
            arrayList = new ArrayList<Value>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(InputReader.getValue());
            }
        }
        return arrayList;
    }

    public static EntryListFieldInfo getEntryListFieldInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   Entry list field Info\n");
        if (InputReader.getBoolean("Null EntryListFieldInfo (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt("      Field id (0): ", 0);
        int n2 = InputReader.getInt("      Column width (20): ", 20);
        String string = InputReader.getString("      Separator(  ): ", "  ");
        return new EntryListFieldInfo(n, n2, string);
    }

    public static List<EntryListFieldInfo> getEntryListFieldInfoList() throws IOException {
        ArrayList<EntryListFieldInfo> arrayList = null;
        int n = InputReader.getInt("Number of  query list fields (0): ", 0);
        if (n != 0) {
            arrayList = new ArrayList<EntryListFieldInfo>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(InputReader.getEntryListFieldInfo());
            }
        }
        return arrayList;
    }

    public static StatusHistoryValueIndicator getStatusHistoryValue() throws IOException {
        if (InputReader.getBoolean("Null StatusHistoryValue (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt("Enumerated value index (0): ", 0);
        int n2 = InputReader.getInt("User or Time field (1 or 2) (2): ", 2);
        boolean bl = true;
        if (n2 == 2) {
            bl = false;
        }
        return new StatusHistoryValueIndicator(bl, n);
    }

    public static CurrencyPartInfo getCurrencyPartInfo() throws IOException {
        int n = InputReader.getInt("Currency Field Id (0): ", 0);
        int n2 = InputReader.getInt("Currency Part - Field,Value,Type,Date,Functional (0-4) (0): ", 0);
        String string = null;
        if (n2 == 4) {
            string = InputReader.getString("Functional currency code:", "");
        }
        return new CurrencyPartInfo(n, n2, string);
    }

    public static ArithmeticOrRelationalOperand getArithmeticOrRelationalOperand(List<IQuerySource> list, String string) throws IOException, ARException {
        if (InputReader.getBoolean("Null ArithmeticOrRelationalOperand (F): ", false)) {
            return null;
        }
        OperandType operandType = null;
        boolean bl = list != null && list.size() > 0;
        int n = !bl ? InputReader.getInt("Fld,Value,Arith,Stat-Hist,Val-Set,Currency,Fld-Tran,Fld-DB,L-Var,\nQuery,Currency-Tran,Currency-DB,Currency-Current,Fld-Current (1-6,50-56,99): ", 0) : InputReader.getInt("Fld,Value,Arith,Stat-Hist,Val-Set,Currency,Val-Set Query,Fld-Tran,Fld-DB,L-Var,Query,Currency-Tran,Currency-DB,Currency-Current,Fld-Current (1-7,50-56,99): ", 0);
        ArithmeticOrRelationalOperand arithmeticOrRelationalOperand = null;
        operandType = OperandType.getOperandType(n);
        switch (n) {
            case 1: 
            case 50: 
            case 51: 
            case 99: {
                if (bl) {
                    arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(InputReader.getQueryFormField(list, string));
                    break;
                }
                int n2 = InputReader.getInt(string + "Field id (0): ", 0);
                arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(operandType, n2);
                break;
            }
            case 2: {
                Value value = InputReader.getValue(string);
                arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(value);
                break;
            }
            case 3: {
                ArithmeticOperationInfo arithmeticOperationInfo = InputReader.getArithmeticOperationInfo(string);
                arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(arithmeticOperationInfo);
                break;
            }
            case 4: {
                StatusHistoryValueIndicator statusHistoryValueIndicator = InputReader.getStatusHistoryValue();
                arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(statusHistoryValueIndicator);
                break;
            }
            case 5: {
                List<Value> list2 = InputReader.getValueList();
                arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(list2);
                break;
            }
            case 6: 
            case 54: 
            case 55: 
            case 56: {
                CurrencyPartInfo currencyPartInfo = InputReader.getCurrencyPartInfo();
                arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(operandType, currencyPartInfo);
                break;
            }
            case 52: {
                int n3 = InputReader.getInt("Local Variable number (0 to 10) (0): ", 0);
                arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(n3);
                break;
            }
            case 53: {
                QueryInfo queryInfo = InputReader.getQueryInfo();
                arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(queryInfo);
                break;
            }
            case 7: {
                ValueSetQuery valueSetQuery = InputReader.getValueSetQuery(string + "      ");
                arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(valueSetQuery);
                break;
            }
            default: {
                JavaDriver.outputWriter.driverPrintWarning(string + "Invalid operation..");
            }
        }
        return arithmeticOrRelationalOperand;
    }

    public static ArithmeticOperationInfo getArithmeticOperationInfo(String string) throws IOException, ARException {
        return InputReader.getArithmeticOperationInfo(null, string);
    }

    public static ArithmeticOperationInfo getArithmeticOperationInfo(List<IQuerySource> list, String string) throws IOException, ARException {
        if (InputReader.getBoolean(string + "Null ArithmeticOperationInfo (F): ", false)) {
            return null;
        }
        ArithmeticOrRelationalOperand arithmeticOrRelationalOperand = null;
        ArithmeticOrRelationalOperand arithmeticOrRelationalOperand2 = null;
        int n = InputReader.getInt(string + "Arithmetic op code -- +, -, *, /, %, unary - (1 - 6): ", 1);
        if (n != 6) {
            JavaDriver.outputWriter.driverPrintPrompt(string + "Left Operand - ");
            arithmeticOrRelationalOperand = InputReader.getArithmeticOrRelationalOperand(list, string);
        }
        JavaDriver.outputWriter.driverPrintPrompt(string + "Right Operand - ");
        arithmeticOrRelationalOperand2 = InputReader.getArithmeticOrRelationalOperand(list, string);
        return new ArithmeticOperationInfo(n, arithmeticOrRelationalOperand, arithmeticOrRelationalOperand2);
    }

    public static RelationalOperationInfo getRelationalOperationInfo() throws IOException, ARException {
        return InputReader.getRelationalOperationInfo("");
    }

    public static RelationalOperationInfo getRelationalOperationInfo(String string) throws IOException, ARException {
        return InputReader.getRelationalOperationInfo(null, string);
    }

    public static RelationalOperationInfo getRelationalOperationInfo(List<IQuerySource> list, String string) throws IOException, ARException {
        if (InputReader.getBoolean(string + "Null RelationalOperationInfo (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt(string + "Relational op code - EQ, GT, GE, LT, LE, NE, LIKE, IN, NOT IN  (1 - 9): ", 1);
        JavaDriver.outputWriter.driverPrintPrompt(string + "Left operand - ");
        ArithmeticOrRelationalOperand arithmeticOrRelationalOperand = InputReader.getArithmeticOrRelationalOperand(list, string);
        JavaDriver.outputWriter.driverPrintPrompt(string + "Right operand - ");
        ArithmeticOrRelationalOperand arithmeticOrRelationalOperand2 = InputReader.getArithmeticOrRelationalOperand(list, string);
        return new RelationalOperationInfo(n, arithmeticOrRelationalOperand, arithmeticOrRelationalOperand2);
    }

    public static QualifierInfo getQualifierInfo() throws IOException, ARException {
        return InputReader.getQualifierInfo(null, "Qualifier Info", "");
    }

    public static QualifierInfo getQualifierInfo(List<IQuerySource> list, String string, String string2) throws IOException, ARException {
        JavaDriver.outputWriter.driverPrintPrompt(string2 + string + ": \n");
        if (InputReader.getBoolean(string2 + "Null " + string + " (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt(string2 + "None, And, Or, Not, Relop or FromField (0, 1, 2, 3, 4, 5) (0): ", 0);
        QualifierInfo qualifierInfo = null;
        QualifierInfo qualifierInfo2 = null;
        QualifierInfo qualifierInfo3 = null;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                qualifierInfo = InputReader.getQualifierInfo(list, string, string2);
                JavaDriver.outputWriter.driverPrintPrompt(string2 + "AND\n");
                qualifierInfo2 = InputReader.getQualifierInfo(list, string, string2);
                qualifierInfo3 = new QualifierInfo(1, qualifierInfo, qualifierInfo2);
                break;
            }
            case 2: {
                qualifierInfo = InputReader.getQualifierInfo(list, string, string2);
                JavaDriver.outputWriter.driverPrintPrompt(string2 + "OR\n");
                qualifierInfo2 = InputReader.getQualifierInfo(list, string, string2);
                qualifierInfo3 = new QualifierInfo(2, qualifierInfo, qualifierInfo2);
                break;
            }
            case 3: {
                qualifierInfo = InputReader.getQualifierInfo(list, string, string2);
                qualifierInfo3 = new QualifierInfo(3, qualifierInfo, null);
                break;
            }
            case 4: {
                RelationalOperationInfo relationalOperationInfo = InputReader.getRelationalOperationInfo(list, string2);
                qualifierInfo3 = new QualifierInfo(relationalOperationInfo);
                break;
            }
            case 5: {
                int n2 = InputReader.getInt("Field id (1):", 1);
                QualifierFromFieldInfo qualifierFromFieldInfo = new QualifierFromFieldInfo(n2);
                qualifierInfo3 = new QualifierInfo(qualifierFromFieldInfo);
                break;
            }
        }
        return qualifierInfo3;
    }

    public static QualifierInfo[] getQualifierInfoList() throws IOException, ARException {
        QualifierInfo[] qualifierInfoArray = null;
        int n = InputReader.getInt("  Number of  qualifierInfo objects(0): ", 0);
        if (n != 0) {
            qualifierInfoArray = new QualifierInfo[n];
            for (int i = 0; i < n; ++i) {
                qualifierInfoArray[i] = InputReader.getQualifierInfo();
            }
        }
        return qualifierInfoArray;
    }

    public static SortInfo getSortInfo() throws IOException {
        return InputReader.getSortInfoWithSources(null);
    }

    public static List<SortInfo> getSortInfoList() throws IOException {
        return InputReader.getSortInfoListWithSources(null);
    }

    public static List<SortInfo> getSortInfoListWithSources(List<IQuerySource> list) throws IOException {
        ArrayList<SortInfo> arrayList = null;
        int n = InputReader.getInt("Number of sort fields (0): ", 0);
        if (n != 0) {
            arrayList = new ArrayList<SortInfo>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(InputReader.getSortInfoWithSources(list));
            }
        }
        return arrayList;
    }

    public static SortInfo getSortInfoWithSources(List<IQuerySource> list) throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   Sort list entry\n");
        if (InputReader.getBoolean("Null SortInfo (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt("      Internal id of field to sort on (0): ", 0);
        int n2 = InputReader.getInt("      Ascending or Descending (1 or 2) (1): ", 1);
        if (list != null && list.size() > 0) {
            int n3 = InputReader.getInt("      Field source (" + InputReader.getQuerySourcesPrompt(list) + ") (0): ", 0);
            return new SortInfo(n, list.get(n3), n2);
        }
        return new SortInfo(n, n2);
    }

    public static IndexInfo getIndexInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   Index list entry\n");
        if (InputReader.getBoolean("Null IndexInfo (F): ", false)) {
            return null;
        }
        List<Integer> list = InputReader.getIntegerList();
        boolean bl = InputReader.getBooleanForChangingInfo("      Unique index (F): ", false);
        String string = InputReader.getString("Name", "");
        return new IndexInfo(list, bl, string);
    }

    public static List<IndexInfo> getIndexInfoList() throws IOException {
        ArrayList<IndexInfo> arrayList = null;
        int n = InputReader.getInt("Number of indexes (0): ", 0);
        if (n != 0) {
            arrayList = new ArrayList<IndexInfo>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(InputReader.getIndexInfo());
            }
        }
        return arrayList;
    }

    public static ArchiveInfo getArchiveInfo() throws IOException, ARException {
        int n;
        ArchiveInfo archiveInfo = new ArchiveInfo();
        int n2 = InputReader.getInt("Enable (0): ", 0);
        int n3 = InputReader.getInt("Archive Type (0-None, 1-form, 2-delete, 3-form&delete): ", 0);
        String string = null;
        if (n3 == 1 || n3 == 3) {
            string = InputReader.getString("Archive Form Name ():", "");
        }
        QualifierInfo qualifierInfo = InputReader.getQualifierInfo();
        archiveInfo.setEnable(n2 != 0);
        archiveInfo.setArchiveType(n3);
        archiveInfo.setQualifier(qualifierInfo);
        archiveInfo.setArchiveDest(string);
        BitSet bitSet = new BitSet(32);
        BitSet bitSet2 = new BitSet(7);
        BitSet bitSet3 = new BitSet(24);
        int n4 = 0;
        if (InputReader.getBooleanForChangingInfo("Do you want to archive now <F>", false)) {
            n = InputReader.getInt("Enter secs from now: (>= 0) (0): ", 0);
            Calendar calendar = Calendar.getInstance();
            calendar.add(13, n);
            int n5 = calendar.get(5);
            int n6 = calendar.get(7);
            int n7 = calendar.get(11);
            bitSet.set(n5 - 1);
            bitSet2.set(n6 - 1);
            if (n7 > 0) {
                --n7;
            }
            bitSet3.set(n7);
            n4 = calendar.get(12);
        } else {
            int n8;
            int n9 = InputReader.getInt("how many days to set in day/month format? (> 0) (1): ", 1);
            for (n = 0; n < n9; ++n) {
                n8 = InputReader.getInt("date of the day, 0 to 30 for month/day (0): ", 0);
                bitSet.set(n8);
            }
            n9 = InputReader.getInt("how many days to set in day/week format? (> 0) (1): ", 1);
            for (n = 0; n < n9; ++n) {
                n8 = InputReader.getInt("date of the day, 0 to 6 for sunday to saturday (0): ", 0);
                bitSet2.set(n8);
            }
            n9 = InputReader.getInt("how many hour to set in a day? (> 0) (1): ", 1);
            for (n = 0; n < n9; ++n) {
                n8 = InputReader.getInt("hour of the day, 0 to 23 for 24 hours of a day (0): ", 0);
                bitSet3.set(n8);
            }
            n4 = InputReader.getInt("set minute of the hour ? (0-59) (0): ", 0);
        }
        EscalationTime escalationTime = new EscalationTime(bitSet, bitSet2, bitSet3, n4);
        archiveInfo.setArchiveTmInfo(escalationTime);
        return archiveInfo;
    }

    public static AuditInfo getAuditInfo() throws IOException, ARException {
        AuditInfo auditInfo = new AuditInfo();
        int n = InputReader.getInt("Audit Style (0-None, 1-Copy, 2-Log): ", 1);
        if (n == 0) {
            return null;
        }
        if (n == 1 || n == 2) {
            auditInfo.setAuditStyle(n);
            String string = InputReader.getString("Audit Form Name ():", "");
            auditInfo.setAuditForm(string);
        }
        boolean bl = InputReader.getBoolean("Enable Audit (F): ", false);
        auditInfo.setEnable(bl);
        QualifierInfo qualifierInfo = InputReader.getQualifierInfo();
        auditInfo.setQualifier(qualifierInfo);
        return auditInfo;
    }

    public static Form getForm() throws IOException, ARException {
        int n = InputReader.getInt("Form Type (1): ", 1);
        switch (n) {
            case 1: {
                return new RegularForm();
            }
            case 4: {
                return new DisplayOnlyForm();
            }
            case 2: {
                return InputReader.getJoinForm();
            }
            case 3: {
                return InputReader.getViewForm();
            }
            case 5: {
                return InputReader.getVendorForm();
            }
        }
        return new RegularForm();
    }

    public static Container getContainer() throws IOException {
        int n = InputReader.getInt("Container Type (1): ", 1);
        switch (n) {
            case 1: {
                return new ActiveLinkGuide();
            }
            case 3: {
                return new PackingList();
            }
            case 4: {
                return new FilterGuide();
            }
            case 5: {
                return new WebService();
            }
        }
        return new ApplicationContainer();
    }

    public static Field getField() throws IOException {
        int n = InputReader.getInt("Field Datatype (2): ", 2);
        switch (n) {
            case 2: {
                return new IntegerField();
            }
            case 3: {
                return new RealField();
            }
            case 5: {
                return new DiaryField();
            }
            case 6: {
                return new SelectionField();
            }
            case 7: {
                return new DateTimeField();
            }
            case 10: {
                return new DecimalField();
            }
            case 11: {
                return new AttachmentField();
            }
            case 12: {
                return new CurrencyField();
            }
            case 13: {
                return new DateOnlyField();
            }
            case 14: {
                return new TimeOnlyField();
            }
            case 33: {
                return new TableField();
            }
            case 34: {
                return new ColumnField();
            }
            case 42: {
                return new ViewField();
            }
            case 43: {
                return new DisplayField();
            }
        }
        return new CharacterField();
    }

    public static FieldMapping getFieldMappingInfo() throws IOException {
        int n = InputReader.getInt("Field Mapping Type (1): ", 1);
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return new RegularFieldMapping();
            }
            case 2: {
                int n2 = InputReader.getInt("   form index (0): ", 0);
                int n3 = InputReader.getInt("   real Id (0): ", 0);
                return new JoinFieldMapping(n2, n3);
            }
            case 3: {
                return new ViewFieldMapping(InputReader.getString("Field Name", ""));
            }
            case 4: {
                return new VendorFieldMapping(InputReader.getString("Field Name", ""));
            }
        }
        return null;
    }

    public static PropInfo getPropInfo() throws IOException, ARException {
        if (InputReader.getBoolean("Null PropInfo (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt("Prop Tag - ( 0-500 ): ", 0);
        Value value = InputReader.getValue();
        return new PropInfo(n, value);
    }

    public static PropInfo[] getPropInfoList() throws IOException, ARException {
        PropInfo[] propInfoArray = null;
        int n = InputReader.getInt("Number of Properties (0): ", 0);
        if (n != 0) {
            propInfoArray = new PropInfo[n];
            for (int i = 0; i < n; ++i) {
                propInfoArray[i] = InputReader.getPropInfo();
            }
        }
        return propInfoArray;
    }

    public static DisplayPropertyMap getDisplayPropertyMap() throws IOException, ARException {
        DisplayPropertyMap displayPropertyMap = null;
        int n = InputReader.getInt("Number of Properties (0): ", 0);
        if (n != 0) {
            displayPropertyMap = new DisplayPropertyMap();
            for (int i = 0; i < n; ++i) {
                PropInfo propInfo = InputReader.getPropInfo();
                displayPropertyMap.put(propInfo.getPropertyTag(), propInfo.getPropertyValue());
            }
        }
        return displayPropertyMap;
    }

    public static ViewDisplayPropertyMap getViewDisplayPropertyMap() throws IOException, ARException {
        ViewDisplayPropertyMap viewDisplayPropertyMap = null;
        int n = InputReader.getInt("Number of Properties (0): ", 0);
        if (n != 0) {
            viewDisplayPropertyMap = new ViewDisplayPropertyMap();
            for (int i = 0; i < n; ++i) {
                PropInfo propInfo = InputReader.getPropInfo();
                viewDisplayPropertyMap.put(propInfo.getPropertyTag(), propInfo.getPropertyValue());
            }
        }
        return viewDisplayPropertyMap;
    }

    public static ObjectPropertyMap getObjectPropertyMap() throws IOException, ARException {
        ObjectPropertyMap objectPropertyMap = null;
        int n = InputReader.getInt("Number of Properties (0): ", 0);
        if (n != 0) {
            objectPropertyMap = new ObjectPropertyMap();
            for (int i = 0; i < n; ++i) {
                PropInfo propInfo = InputReader.getPropInfo();
                objectPropertyMap.put(propInfo.getPropertyTag(), propInfo.getPropertyValue());
            }
        }
        return objectPropertyMap;
    }

    public static DisplayInstanceMap getDisplayInstanceMap() throws IOException, ARException {
        DisplayInstanceMap displayInstanceMap = new DisplayInstanceMap();
        JavaDriver.outputWriter.driverPrintPrompt("getting the Common Properties for this field\n");
        int n = InputReader.getInt("Number of display Instances (0): ", 0);
        for (int i = 0; i < n; ++i) {
            int n2 = InputReader.getInt(" VUI id ( 0 ): ", 0);
            DisplayPropertyMap displayPropertyMap = InputReader.getDisplayPropertyMap();
            displayInstanceMap.put(n2, displayPropertyMap);
        }
        return displayInstanceMap;
    }

    public static AssignFieldInfo getAssignFieldInfo() throws IOException, ARException {
        if (InputReader.getBoolean("Null AssignFieldInfo (F): ", false)) {
            return null;
        }
        Serializable serializable = null;
        int n = InputReader.getInt("Field, status history, currency field (1, 4, 6) (1): ", 1);
        if (n == 1) {
            serializable = new Integer(InputReader.getInt("Field id (0): ", 0));
        } else if (n == 4) {
            serializable = InputReader.getStatusHistoryValue();
        } else if (n == 6) {
            serializable = InputReader.getCurrencyPartInfo();
        }
        QualifierInfo qualifierInfo = InputReader.getQualifierInfo();
        return new AssignFieldInfo(null, null, qualifierInfo, n, serializable, 0, 0);
    }

    public static DDEAction getDDEInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   Active Link DDE Info:\n");
        if (InputReader.getBoolean("Null DDEInfo (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("      Service name (): ", "");
        String string2 = InputReader.getString("      Topic (): ", "");
        int n = InputReader.getInt("      Action (execute, poke, request) (1-3) (1): ", 1);
        String string3 = InputReader.getString("      Path To Program (): ", "");
        String string4 = null;
        string4 = n != 3 ? InputReader.getString("      Command (): ", "") : null;
        String string5 = null;
        string5 = InputReader.getBooleanForChangingInfo("      Set an item string? (F): ", false) ? InputReader.getString("      Item text (): ", "") : null;
        return new DDEAction(string, string2, string5, n, string3, string4);
    }

    public static OleAutomationAction getAutomationInfo() throws IOException, ARException {
        JavaDriver.outputWriter.driverPrintPrompt("   Active Link Automation Info:\n");
        if (InputReader.getBoolean("Null AutomationInfo (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("      Auto Server name (): ", "");
        boolean bl = InputReader.getBooleanForChangingInfo("      Showing Automation Server? (T): ", true);
        String string2 = InputReader.getString("      Class  Id (): ", "");
        String string3 = InputReader.getString("      Automation Action (): ", "");
        List<COMMethodInfo> list = InputReader.getCOMMethodInfoList();
        return new OleAutomationAction(string, string2, string3, bl, list);
    }

    public static COMValueInfo getCOMValueInfo() throws IOException, ARException {
        if (InputReader.getBoolean("Null COMValueInfo (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt("      Transient Id (1): ", 1);
        String string = InputReader.getString("      Value IId (used for method only)(): ", "");
        int n2 = InputReader.getInt("      COM [Method( null -0, fieldId - 1)/Parm( null -0, value - 2)] Type (0): ", 0);
        int n3 = 0;
        Value value = null;
        switch (n2) {
            case 1: {
                n3 = InputReader.getInt("      FieldId (1): ", 1);
                break;
            }
            case 2: {
                value = InputReader.getValue();
                break;
            }
        }
        return new COMValueInfo(string, n, n2, n3, value);
    }

    public static COMMethodParmInfo getCOMMethodParmInfo() throws IOException, ARException {
        if (InputReader.getBoolean("Null COMMethodParmInfo (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("      Parameter Name (): ", "");
        int n = InputReader.getInt("      COM Parameter Type (VT_EMPTY/VT_NULL/VT_I2/VT_I4/VT_R4/VT_R8/VT_CY/VT_DATE/VT_BSTR/VT_DISPATCH/VT_ERROR/VT_BOOL/VT_VIANT/VT_UNKNOWN/VT_WBSTR) (0-14) (VT_I1/VT_UI1/VT_UI2/VT_UI4/VT_I8/VT_UI8/VT_INT/VT_UINT/VT_VOID/VT_HRESULT/VT_PTR) (16-26) (VT_LPSTR/VT_LPWSTR) (30-31) (VT_BLOB_OBJECT -- 70) (0): ", 0);
        COMValueInfo cOMValueInfo = InputReader.getCOMValueInfo();
        return new COMMethodParmInfo(string, n, cOMValueInfo);
    }

    public static List<COMMethodParmInfo> getCOMMethodParmInfoList() throws IOException, ARException {
        ArrayList<COMMethodParmInfo> arrayList = null;
        int n = InputReader.getInt("      Number of Parameters (0): ", 0);
        if (n != 0) {
            arrayList = new ArrayList<COMMethodParmInfo>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(InputReader.getCOMMethodParmInfo());
            }
        }
        return arrayList;
    }

    public static COMMethodInfo getCOMMethodInfo() throws IOException, ARException {
        if (InputReader.getBoolean("Null COMMethodInfo (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("      Method Name (): ", "");
        String string2 = InputReader.getString("      Method Interface Id (): ", "");
        int n = InputReader.getInt("      COM Method Type (VT_EMPTY/VT_NULL/VT_I2/VT_I4/VT_R4/VT_R8/VT_CY/VT_DATE/VT_BSTR/VT_DISPATCH/VT_ERROR/VT_BOOL/VT_VIANT/VT_UNKNOWN/VT_WBSTR) (0-14) (VT_I1/VT_UI1/VT_UI2/VT_UI4/VT_I8/VT_UI8/VT_INT/VT_UINT/VT_VOID/VT_HRESULT/VT_PTR) (16-26) (VT_LPSTR/VT_LPWSTR) (30-31) (VT_BLOB_OBJECT -- 70) (0): ", 0);
        COMValueInfo cOMValueInfo = InputReader.getCOMValueInfo();
        List<COMMethodParmInfo> list = InputReader.getCOMMethodParmInfoList();
        return new COMMethodInfo(string, string2, n, cOMValueInfo, list);
    }

    public static List<COMMethodInfo> getCOMMethodInfoList() throws IOException, ARException {
        ArrayList<COMMethodInfo> arrayList = null;
        int n = InputReader.getInt("      Number of Methods (1): ", 1);
        if (n != 0) {
            arrayList = new ArrayList<COMMethodInfo>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(InputReader.getCOMMethodInfo());
            }
        }
        return arrayList;
    }

    public static OpenWindowAction getOpenWindowAction() throws IOException, ARException {
        JavaDriver.outputWriter.driverPrintPrompt("   Active Link Open Dialog Info:\n");
        if (InputReader.getBoolean("Null OpenDlgInfo (F): ", false)) {
            return null;
        }
        OpenWindowAction openWindowAction = new OpenWindowAction();
        String string = InputReader.getString("Server Name ():", "");
        openWindowAction.setServerName(string);
        String string2 = InputReader.getString("Form name (): ", "");
        openWindowAction.setFormName(string2);
        String string3 = InputReader.getString("Vui Label (): ", "");
        openWindowAction.setVuiLabel(string3);
        boolean bl = InputReader.getBooleanForChangingInfo("Close Box? (T): ", true);
        openWindowAction.setCloseBox(bl);
        List<FieldAssignInfo> list = InputReader.getFieldAssignInfoList();
        openWindowAction.setInputValueFieldPairs(list);
        List<FieldAssignInfo> list2 = InputReader.getFieldAssignInfoList();
        openWindowAction.setOutputValueFieldPairs(list2);
        int n = InputReader.getInt("Window Mode( 0-20)(0):", 0);
        openWindowAction.setWindowMode(n);
        String string4 = InputReader.getString("Target Location ():", "");
        openWindowAction.setTargetLocation(string4);
        QualifierInfo qualifierInfo = InputReader.getQualifierInfo();
        openWindowAction.setQuery(qualifierInfo);
        boolean bl2 = InputReader.getBooleanForChangingInfo("   No Match Continue?(F):", false);
        openWindowAction.setNoMatchContinue(bl2);
        boolean bl3 = InputReader.getBooleanForChangingInfo("Suppress Empty List ? (F):", false);
        openWindowAction.setSuppressEmptyLst(bl3);
        MessageAction messageAction = InputReader.getMessageInfo();
        openWindowAction.setMsg(messageAction);
        int n2 = InputReader.getInt("Polling interval (0):", 0);
        openWindowAction.setPollinginterval(n2);
        openWindowAction.setReportInfo(new OpenWindowAction.ReportInfo());
        List<SortInfo> list3 = InputReader.getSortInfoList();
        openWindowAction.setSortOrderList(list3);
        return openWindowAction;
    }

    public static CloseWindowAction getCloseWindowInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   Active Link Close Window Info :\n");
        if (InputReader.getBoolean("Null CloseWindowInfo (F): ", false)) {
            return null;
        }
        boolean bl = InputReader.getBooleanForChangingInfo("Close All? (t): ", true);
        return new CloseWindowAction(bl);
    }

    public static CallGuideAction getCallGuideInfo() throws IOException, ARException {
        JavaDriver.outputWriter.driverPrintPrompt("   Active Link Call Guide Info:\n");
        if (InputReader.getBoolean("Null CallGuideInfo (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("      Server Name: ", "");
        String string2 = InputReader.getString("      Guide Name: ", "");
        int n = InputReader.getInt("      Guide Mode: (0): ", 0);
        int n2 = InputReader.getInt("      Guide Table Id (0): ", 0);
        List<FieldAssignInfo> list = InputReader.getFieldAssignInfoList();
        List<FieldAssignInfo> list2 = InputReader.getFieldAssignInfoList();
        String string3 = InputReader.getString("      Sample Server Name: ", "");
        String string4 = InputReader.getString("      Sample Guide Name: ", "");
        return new CallGuideAction(string, string2, n, n2, list, list2, string3, string4);
    }

    public static ExitGuideAction getExitGuideInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   Active Link Exit Guide Info:\n");
        if (InputReader.getBoolean("Null ExitGuideInfo (F): ", false)) {
            return null;
        }
        boolean bl = InputReader.getBooleanForChangingInfo("      Close All? (T): ", true);
        return new ExitGuideAction(bl);
    }

    public static GotoGuideLabelAction getGotoGuideLabelInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   Active Link Goto Guide Label Info:\n");
        if (InputReader.getBoolean("Null GotoGuideLabelInfo (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("      Label (): ", "");
        return new GotoGuideLabelAction(string);
    }

    public static WaitAction getWaitInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintHeader("   Active Link Wait Info:");
        if (InputReader.getBoolean("Null WaitInfo (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("      Continue Button Title ( Continue ): ", "Continue");
        return new WaitAction(string);
    }

    public static AssignSQLInfo getAssignSQLInfo() throws IOException {
        if (InputReader.getBoolean("Null AssignSQLInfo (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("Server name (): ", "");
        String string2 = InputReader.getString("SQL command (): ", "");
        int n = InputReader.getInt("Index of returned value to select (1): ", 1);
        int n2 = InputReader.getInt("No match action -- error, null (1, 2) (2): ", 2);
        int n3 = InputReader.getInt("Multi match action -- error, null, first, picklist (1, 2, 3, 4) (4): ", 4);
        return new AssignSQLInfo(string, string2, n, n2, n3);
    }

    public static AssignFilterApiInfo getAssignFilterApiInfo() throws IOException, ARException {
        int n;
        if (InputReader.getBoolean("Null AssignFilterApiInfo (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("      Service Name: ", "");
        JavaDriver.outputWriter.driverPrintPrompt("      Input Value List:\n");
        ArrayList<AssignInfo> arrayList = null;
        int n2 = InputReader.getInt("      Number of Assignments (0): ", 0);
        if (n2 > 0) {
            arrayList = new ArrayList<AssignInfo>(n2);
            for (n = 0; n < n2; ++n) {
                arrayList.add(InputReader.getAssignInfo());
            }
        }
        n = InputReader.getInt("      Index of the value field (1): ", 1);
        return new AssignFilterApiInfo(string, arrayList, n);
    }

    public static AssignInfo getAssignInfo() throws IOException, ARException {
        if (InputReader.getBoolean("Null AssignInfo (F): ", false)) {
            return null;
        }
        AssignInfo assignInfo = new AssignInfo();
        int n = InputReader.getInt("Assign type:  None, Value, Field, Process, Arith, Function, DDE, SQL, Filter API(0 - 8): ", 0);
        assignInfo.setAssignType(n);
        switch (n) {
            case 1: {
                Value value = InputReader.getValue();
                assignInfo.setValue(value);
                break;
            }
            case 2: {
                AssignFieldInfo assignFieldInfo = InputReader.getAssignFieldInfo();
                assignInfo.setField(assignFieldInfo);
                break;
            }
            case 3: {
                String string = InputReader.getString("Process to run (): ", "");
                assignInfo.setProcess(string);
                break;
            }
            case 4: {
                ArithOpAssignInfo arithOpAssignInfo = InputReader.getArithOpAssignInfo();
                assignInfo.setArithOp(arithOpAssignInfo);
                break;
            }
            case 5: {
                FunctionAssignInfo functionAssignInfo = InputReader.getFunctionAssignInfo();
                assignInfo.setFunction(functionAssignInfo);
                break;
            }
            case 6: {
                DDEAction dDEAction = InputReader.getDDEInfo();
                assignInfo.setDde(dDEAction);
                break;
            }
            case 7: {
                AssignSQLInfo assignSQLInfo = InputReader.getAssignSQLInfo();
                assignInfo.setSql(assignSQLInfo);
                break;
            }
            case 8: {
                assignInfo.setFilterApi(InputReader.getAssignFilterApiInfo());
                break;
            }
        }
        return assignInfo;
    }

    public static ArithOpAssignInfo getArithOpAssignInfo() throws IOException, ARException {
        if (InputReader.getBoolean("Null ArithOpAssignInfo (F): ", false)) {
            return null;
        }
        AssignInfo assignInfo = null;
        AssignInfo assignInfo2 = null;
        int n = InputReader.getInt("Arithmetic op code(+): +, -, *, /, %, unary - (1 - 6): ", 1);
        if (n != 6) {
            JavaDriver.outputWriter.driverPrintPrompt("Left Operand - ");
            assignInfo = InputReader.getAssignInfo();
        }
        JavaDriver.outputWriter.driverPrintPrompt("Right Operand - ");
        assignInfo2 = InputReader.getAssignInfo();
        ArithOpAssignInfo arithOpAssignInfo = new ArithOpAssignInfo();
        arithOpAssignInfo.setOperation(n);
        arithOpAssignInfo.setOperandLeft(assignInfo);
        arithOpAssignInfo.setOperandRight(assignInfo2);
        return arithOpAssignInfo;
    }

    public static FunctionAssignInfo getFunctionAssignInfo() throws IOException, ARException {
        if (InputReader.getBoolean("Null FunctionAssignInfo (F): ", false)) {
            return null;
        }
        FunctionAssignInfo functionAssignInfo = new FunctionAssignInfo();
        int n = InputReader.getInt("Function code -- (1 - 50): ", 1);
        functionAssignInfo.setFunctionCode(n);
        int n2 = InputReader.getInt("Number of parameters (0): ", 0);
        if (n2 != 0) {
            ArrayList<AssignInfo> arrayList = new ArrayList<AssignInfo>(n2);
            for (int i = 0; i < n2; ++i) {
                JavaDriver.outputWriter.driverPrintPrompt("Parameter[" + i + "] - ");
                arrayList.add(InputReader.getAssignInfo());
            }
            functionAssignInfo.setParameterList(arrayList);
        }
        return functionAssignInfo;
    }

    public static FieldAssignInfo getFieldAssignInfo() throws IOException, ARException {
        if (InputReader.getBoolean("Null FieldAssignInfo (F): ", false)) {
            return null;
        }
        FieldAssignInfo fieldAssignInfo = new FieldAssignInfo();
        int n = InputReader.getInt("Field id (0): ", 0);
        fieldAssignInfo.setFieldId(n);
        AssignInfo assignInfo = InputReader.getAssignInfo();
        fieldAssignInfo.setAssignment(assignInfo);
        return fieldAssignInfo;
    }

    public static List<FieldAssignInfo> getFieldAssignInfoList() throws IOException, ARException {
        int n = InputReader.getInt("   Number of field/assign pairs (0): ", 0);
        ArrayList<FieldAssignInfo> arrayList = null;
        if (n != 0) {
            arrayList = new ArrayList<FieldAssignInfo>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(InputReader.getFieldAssignInfo());
            }
        }
        return arrayList;
    }

    public static SetFieldsAction getSetFieldsActionInfo(boolean bl) throws IOException, ARException {
        List<FieldAssignInfo> list = InputReader.getFieldAssignInfoList();
        String string = new String(InputReader.getString("   Sample Server Name : ", ""));
        String string2 = InputReader.getString("   Sample Form Name: ", "");
        SetFieldsAction setFieldsAction = null;
        for (FieldAssignInfo fieldAssignInfo : list) {
            AssignInfo assignInfo = fieldAssignInfo.getAssignment();
            switch (assignInfo.getAssignType()) {
                case 8: {
                    setFieldsAction = new SetFieldsFromFilterAPI("", "", list);
                    break;
                }
                case 7: {
                    setFieldsAction = new SetFieldsFromSQL("", "", list);
                    break;
                }
            }
            if (setFieldsAction == null) continue;
            setFieldsAction.setSampleServer(string);
            setFieldsAction.setSampleForm(string2);
            break;
        }
        return setFieldsAction;
    }

    public static PushFieldsAction getPushFieldsAction() throws IOException, ARException {
        String string = InputReader.getString("   Server Name for Push Fields : ", "@");
        String string2 = InputReader.getString("   Form Name for the push fields : ", "");
        int n = InputReader.getInt("No match action -- error, null, no action, submit (1-4) (2): ", 2);
        int n2 = InputReader.getInt("Multi match action -- error, null, first, picklist, mod all, no action, submit (1-7) (4): ", 4);
        List<PushFieldsInfo> list = InputReader.getPushFieldsInfoList();
        PushFieldsAction pushFieldsAction = new PushFieldsAction();
        pushFieldsAction.setPushFieldsList(list);
        pushFieldsAction.setNoMatchOption(n);
        pushFieldsAction.setMultiMatchOption(n2);
        pushFieldsAction.setPushToServer(string);
        pushFieldsAction.setPushToForm(string2);
        return pushFieldsAction;
    }

    public static List<PushFieldsInfo> getPushFieldsInfoList() throws IOException, ARException {
        int n = InputReader.getInt("   Number of field/assign pairs (0): ", 0);
        ArrayList<PushFieldsInfo> arrayList = null;
        if (n != 0) {
            arrayList = new ArrayList<PushFieldsInfo>(n);
            for (int i = 0; i < n; ++i) {
                PushFieldsInfo pushFieldsInfo = new PushFieldsInfo();
                pushFieldsInfo.setField(InputReader.getAssignFieldInfo());
                pushFieldsInfo.setAssignment(InputReader.getAssignInfo());
                arrayList.add(pushFieldsInfo);
            }
        }
        return arrayList;
    }

    public static DirectSqlAction getSQLInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("Action Direct SQL:\n");
        if (InputReader.getBoolean("Null SQLInfo (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("      Server (): ", "");
        String string2 = InputReader.getString("      SQL command (): ", "");
        return new DirectSqlAction(string, string2);
    }

    public static GotoAction getGotoActionInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   Goto Action Info:\n");
        if (InputReader.getBoolean("Null GotoActionInfo (F): ", false)) {
            return null;
        }
        int n = 0;
        int n2 = InputReader.getInt("      Field, Value, Forward, Backup (1-4): ", 1);
        switch (n2) {
            case 1: {
                n = InputReader.getInt("      FieldId (0): ", 0);
                break;
            }
            case 2: {
                n = InputReader.getInt("      Execution Order (0): ", 0);
                break;
            }
            case 3: {
                n = InputReader.getInt("    Execution Order Advance By(1): ", 1);
                break;
            }
            case 4: {
                n = InputReader.getInt("      Execution Order Backup By (0): ", 1);
                break;
            }
        }
        return new GotoAction(n2, n);
    }

    public static FilterAction getFilterActionInfo() throws IOException, ARException {
        JavaDriver.outputWriter.driverPrintHeader("Filter Action Info:");
        if (InputReader.getBoolean("Null FilterActionInfo (F): ", false)) {
            return null;
        }
        Action action = null;
        int n = InputReader.getInt("   Notify, Message, Log, Fields, Process, Push, SQL, Goto Action, Call Guide, Exit Guide, Goto Guide Label(1-11): ", 0);
        switch (n) {
            case 1: {
                NotifyAction notifyAction = InputReader.getNotifyActionInfo();
                action = notifyAction;
                break;
            }
            case 2: {
                FilterMessageAction filterMessageAction = InputReader.getFilterStatusInfo();
                action = filterMessageAction;
                break;
            }
            case 3: {
                String string = InputReader.getString("  Log File name(): ", "");
                action = new LogAction(string);
                break;
            }
            case 4: {
                SetFieldsAction setFieldsAction = InputReader.getSetFieldsActionInfo(false);
                action = setFieldsAction;
                break;
            }
            case 5: {
                String string = InputReader.getString("    Process ():", "");
                action = new RunProcessAction(string);
                break;
            }
            case 6: {
                PushFieldsAction pushFieldsAction = InputReader.getPushFieldsAction();
                action = pushFieldsAction;
                break;
            }
            case 7: {
                DirectSqlAction directSqlAction = InputReader.getSQLInfo();
                action = directSqlAction;
                break;
            }
            case 8: {
                GotoAction gotoAction = InputReader.getGotoActionInfo();
                action = gotoAction;
                break;
            }
            case 9: {
                action = InputReader.getCallGuideInfo();
                break;
            }
            case 10: {
                action = InputReader.getExitGuideInfo();
                break;
            }
            case 11: {
                action = InputReader.getGotoGuideLabelInfo();
                break;
            }
        }
        return action;
    }

    public static List<FilterAction> getFilterActionInfoList(boolean bl) throws IOException, ARException {
        int n = 0;
        n = bl ? InputReader.getInt("Number of actions for the filter (1): ", 1) : InputReader.getInt("Number of elses for the filter (0): ", 0);
        ArrayList<FilterAction> arrayList = null;
        if (n != 0) {
            arrayList = new ArrayList<FilterAction>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(InputReader.getFilterActionInfo());
            }
        }
        return arrayList;
    }

    public static RunMacroAction getActiveLinkMacroInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   Active Link Macro Info:\n");
        if (InputReader.getBoolean("Null ActiveLinkMacroInfo (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("      Macro name (): ", "");
        String string2 = InputReader.getString("      Macro text(): ", "");
        TreeMap<String, String> treeMap = null;
        int n = InputReader.getInt("      Number of macro parms (0): ", 0);
        if (n != 0) {
            treeMap = new TreeMap<String, String>();
            String string3 = null;
            String string4 = null;
            for (int i = 0; i < n; ++i) {
                string3 = InputReader.getString("         Parm Name (): ", "");
                string4 = InputReader.getString("         Parm Value (): ", "");
                treeMap.put(string3, string4);
            }
        }
        return new RunMacroAction(string, string2, treeMap);
    }

    public static ChangeFieldAction getFieldCharacteristicsInfo() throws IOException, ARException {
        JavaDriver.outputWriter.driverPrintPrompt("   Active Link Field Characteristics:\n");
        int n = InputReader.getInt("      Option (bitmask - 1 field reference) (0): ", 0);
        if (InputReader.getBoolean("Null ChangeFieldAction (F): ", false)) {
            return null;
        }
        int n2 = InputReader.getInt("      Field Id (0): ", 0);
        String string = null;
        if (InputReader.getBooleanForChangingInfo("      Change menu? (F): ", false)) {
            string = InputReader.getString("      Char menu (): ", "");
        }
        DisplayPropertyMap displayPropertyMap = null;
        if (InputReader.getBooleanForChangingInfo("      Change display Properties? (F): ", false)) {
            displayPropertyMap = InputReader.getDisplayPropertyMap();
        }
        int n3 = 0;
        if (InputReader.getBooleanForChangingInfo("      Change focus to this field? (F): ", false)) {
            n3 = 1;
        }
        int n4 = InputReader.getInt("      Access option (unchanged, read-only, read/write, disable) (0-3) (0): ", 0);
        return new ChangeFieldAction(n, n2, string, displayPropertyMap, n3, n4);
    }

    public static ActiveLinkAction getActiveLinkActionInfo() throws IOException, ARException {
        JavaDriver.outputWriter.driverPrintPrompt("Active Link Action Info:\n");
        if (InputReader.getBoolean("Null ActiveLinkActionInfo (F): ", false)) {
            return null;
        }
        Action action = null;
        int n = InputReader.getInt(" Macro, Fields, Process, Message, Field Characteristics, DDE, Push, SQL, Automation, Open Dialog, Commit Changes, Close Window, Call Guide, Exit Guide, Goto Guide, Wait, Goto Action(1-17): ", 1);
        switch (n) {
            case 1: {
                RunMacroAction runMacroAction;
                action = runMacroAction = InputReader.getActiveLinkMacroInfo();
                break;
            }
            case 2: {
                SetFieldsAction setFieldsAction = InputReader.getSetFieldsActionInfo(true);
                action = setFieldsAction;
                break;
            }
            case 3: {
                String string = InputReader.getString("   Command string (): ", "");
                action = new RunProcessAction(string);
                break;
            }
            case 4: {
                MessageAction messageAction = InputReader.getMessageInfo();
                action = messageAction;
                break;
            }
            case 5: {
                ChangeFieldAction changeFieldAction = InputReader.getFieldCharacteristicsInfo();
                action = changeFieldAction;
                break;
            }
            case 6: {
                DDEAction dDEAction = InputReader.getDDEInfo();
                action = dDEAction;
                break;
            }
            case 7: {
                PushFieldsAction pushFieldsAction = InputReader.getPushFieldsAction();
                action = pushFieldsAction;
                break;
            }
            case 8: {
                DirectSqlAction directSqlAction = InputReader.getSQLInfo();
                action = directSqlAction;
                break;
            }
            case 9: {
                OleAutomationAction oleAutomationAction = InputReader.getAutomationInfo();
                action = oleAutomationAction;
                break;
            }
            case 10: {
                OpenWindowAction openWindowAction = InputReader.getOpenWindowAction();
                action = openWindowAction;
                break;
            }
            case 11: {
                CommitChangesAction commitChangesAction = InputReader.getCommitChangesInfo();
                action = commitChangesAction;
                break;
            }
            case 12: {
                CloseWindowAction closeWindowAction = InputReader.getCloseWindowInfo();
                action = closeWindowAction;
                break;
            }
            case 13: {
                CallGuideAction callGuideAction = InputReader.getCallGuideInfo();
                action = callGuideAction;
                break;
            }
            case 14: {
                ExitGuideAction exitGuideAction = InputReader.getExitGuideInfo();
                action = exitGuideAction;
                break;
            }
            case 15: {
                GotoGuideLabelAction gotoGuideLabelAction = InputReader.getGotoGuideLabelInfo();
                action = gotoGuideLabelAction;
                break;
            }
            case 16: {
                WaitAction waitAction = InputReader.getWaitInfo();
                action = waitAction;
                break;
            }
            case 17: {
                GotoAction gotoAction = InputReader.getGotoActionInfo();
                action = gotoAction;
                break;
            }
        }
        return action;
    }

    public static List<ActiveLinkAction> getActiveLinkActionInfoList(boolean bl) throws IOException, ARException {
        int n = 0;
        n = bl ? InputReader.getInt("Number of actions for the active link (1): ", 1) : InputReader.getInt("Number of elses for the active link (0): ", 0);
        ArrayList<ActiveLinkAction> arrayList = null;
        if (n != 0) {
            arrayList = new ArrayList<ActiveLinkAction>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(i, InputReader.getActiveLinkActionInfo());
            }
        }
        return arrayList;
    }

    public static PermissionInfo getPermissionInfo(boolean bl) throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   Permission Info:\n");
        if (InputReader.getBoolean("Null PermissionInfo (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt("      Group id (3): ", 0);
        int n2 = 0;
        n2 = bl ? InputReader.getInt("      None, View, or Change (0, 1, 2): ", 0) : InputReader.getInt("      None, Visible, or Hidden(0, 1, 2): ", 0);
        return new PermissionInfo(n, n2);
    }

    public static List<PermissionInfo> getPermissionInfoList(boolean bl) throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("Permission List:\n");
        int n = InputReader.getInt("   Number of permission defns (0): ", 0);
        ArrayList<PermissionInfo> arrayList = null;
        if (n != 0) {
            arrayList = new ArrayList<PermissionInfo>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(InputReader.getPermissionInfo(bl));
            }
        }
        return arrayList;
    }

    public static IntegerFieldLimit getIntegerLimitInfo() throws IOException {
        if (InputReader.getBoolean("Null Form List Criteria (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt("   Integer range low (0): ", 0);
        int n2 = InputReader.getInt("   Integer range high (5000): ", 5000);
        return new IntegerFieldLimit(n, n2);
    }

    public static RealFieldLimit getRealLimitInfo() throws IOException {
        if (InputReader.getBoolean("Null RealLimitInfo (F): ", false)) {
            return null;
        }
        double d = InputReader.getDouble("   Real range low (0): ", 0.0);
        double d2 = InputReader.getDouble("   Real range high (5000): ", 5000.0);
        int n = InputReader.getInt("   Precision (-1 is no precision) (-1): ", -1);
        return new RealFieldLimit(d, d2, n);
    }

    public static CharacterFieldLimit getCharLimitInfo() throws IOException {
        if (InputReader.getBoolean("Null CharLimitInfo (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt("   Length Units - Byte or Character (0 or 1) (0): ", 0);
        int n2 = InputReader.getInt("   Storage Option for CLOB - Default, In-Row or Out-of-Row (0, 1 or 2) (0): ", 0);
        int n3 = InputReader.getInt("   Maximum length (128): ", 128);
        int n4 = InputReader.getInt("   Menu style - Append or Overwrite (1 or 2) (1): ", 1);
        int n5 = InputReader.getInt("   Match operation - Anywhere, Leading match, or Equal (1 - 3) (1): ", 1);
        String string = InputReader.getString("\tCharacter menu(): ", "");
        String string2 = InputReader.getString("   Pattern (): ", "");
        int n6 = InputReader.getInt("   FullText Options(0): ", 0);
        return new CharacterFieldLimit(n3, n4, n5, string, string2, n6, n, n2);
    }

    public static DiaryFieldLimit getDiaryLimitInfo() throws IOException {
        if (InputReader.getBoolean("Null DiaryLimitInfo (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt("   FullText Options(0): ", 0);
        return new DiaryFieldLimit(n);
    }

    public static EnumItem getEnumItem() throws IOException {
        if (InputReader.getBoolean("Null EnumItem (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("   Item Name : ", "");
        int n = InputReader.getInt("   Item Number (0): ", 0);
        return new EnumItem(string, n);
    }

    public static List<EnumItem> getEnumItemList() throws IOException {
        ArrayList<EnumItem> arrayList = null;
        int n = InputReader.getInt("   Number of enum items (0): ", 0);
        if (n != 0) {
            arrayList = new ArrayList<EnumItem>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(InputReader.getEnumItem());
            }
        }
        return arrayList;
    }

    public static SelectionFieldLimit getEnumLimitInfo() throws IOException {
        if (InputReader.getBoolean("Null EnumLimitInfo (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt("Enum List Style (1): ", 1);
        switch (n) {
            case 1: {
                return new SelectionFieldLimit(InputReader.getStringArray("", "Selection Field Enum Item"));
            }
            case 2: {
                return new SelectionFieldLimit(InputReader.getEnumItemList());
            }
        }
        return null;
    }

    public static AttachmentFieldLimit getAttachmentLimitInfo() throws IOException {
        if (InputReader.getBoolean("Null AttachmentLimitInfo (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt("   maxSize(0): ", 0);
        int n2 = 1;
        int n3 = InputReader.getInt("   FullText Options(0): ", 0);
        return new AttachmentFieldLimit(n, n2, n3);
    }

    public static TableFieldLimit getTableLimitInfo() throws IOException, ARException {
        if (InputReader.getBoolean("Null TableLimitInfo (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("   form name: ", "");
        String string2 = InputReader.getString("   server name: ", "");
        QualifierInfo qualifierInfo = InputReader.getQualifierInfo();
        int n = InputReader.getInt("  Max rows to retrieve (10): ", 10);
        int n2 = 0;
        String string3 = InputReader.getString("   sample form name: ", "");
        String string4 = InputReader.getString("   sample server name: ", "");
        return new TableFieldLimit(n2, qualifierInfo, n, string, string2, string3, string4);
    }

    public static ColumnFieldLimit getColumnLimitInfo() throws IOException {
        if (InputReader.getBoolean("Null ColumnLimitInfo (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt("   Parent Table field Id (0): ", 0);
        int n2 = InputReader.getInt("   Data field Id (0): ", 0);
        int n3 = InputReader.getInt("   Data Source(0): ", 0);
        int n4 = InputReader.getInt("   Length to display(10) : ", 10);
        return new ColumnFieldLimit(n, n2, n3, n4);
    }

    public static DecimalFieldLimit getDecimalLimitInfo() throws IOException {
        if (InputReader.getBoolean("Null DecimalLimitInfo (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("   Decimal range low (0.0): ", "0.0");
        String string2 = InputReader.getString("   Decimal range high (5000.0): ", "5000.0");
        int n = InputReader.getInt("   Precision (0): ", 0);
        return new DecimalFieldLimit(string, string2, n);
    }

    public static List<CurrencyDetail> getCurrencyDetail(String string, int n) throws IOException {
        ArrayList<CurrencyDetail> arrayList = null;
        int n2 = InputReader.getInt(string + "(" + n + "):", n);
        if (n2 > 0) {
            arrayList = new ArrayList<CurrencyDetail>(n2);
        }
        for (int i = 0; i < n2; ++i) {
            String string2 = InputReader.getString("   Currency Code (USD): ", "USD");
            int n3 = InputReader.getInt("   Precision (0): ", 0);
            arrayList.add(new CurrencyDetail(string2, n3));
        }
        return arrayList;
    }

    public static CurrencyFieldLimit getCurrencyLimitInfo() throws IOException {
        String string = InputReader.getString("   Currency range low (0.0): ", "0.0");
        String string2 = InputReader.getString("   Currency range high (5000.0): ", "5000.0");
        int n = InputReader.getInt("   Precision (0): ", 0);
        List<CurrencyDetail> list = InputReader.getCurrencyDetail("    Number of functional Currencies", 1);
        List<CurrencyDetail> list2 = InputReader.getCurrencyDetail("   Number of Allowable Currencies", 1);
        return new CurrencyFieldLimit(string, string2, n, list, list2);
    }

    public static ViewFieldLimit getViewLimits() throws IOException {
        if (InputReader.getBoolean("Null ViewLimits (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt("   Maximum length (128): ", 128);
        return new ViewFieldLimit(n);
    }

    public static DisplayFieldLimit getDisplayLimits() throws IOException {
        if (InputReader.getBoolean("Null DisplayLimits (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt("   Length Units - Byte or Character (0 or 1) (0): ", 0);
        int n2 = InputReader.getInt("   Maximum length (128): ", 128);
        return new DisplayFieldLimit(n2, n);
    }

    public static MenuItem getCharMenuItemInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("Char Menu Item Info:\n");
        if (InputReader.getBoolean("Null CharMenuItemInfo (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("    Menu Label: ", "");
        int n = InputReader.getInt("    Menu type - Value Or Menu (1, 2) (1):", 1);
        MenuItem menuItem = null;
        switch (n) {
            case 1: {
                String string2 = InputReader.getString("    Char menu text(): ", "");
                menuItem = new MenuItem(string, string2);
                break;
            }
            case 2: {
                List<MenuItem> list = InputReader.getCharMenuItemInfoList();
                menuItem = new MenuItem(string, list);
                break;
            }
        }
        return menuItem;
    }

    public static ListMenu getCharMenuListInfo() throws IOException {
        if (InputReader.getBoolean("Null CharMenuListInfo (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt("   Number of char menu items (0): ", 0);
        ArrayList<MenuItem> arrayList = null;
        if (n != 0) {
            arrayList = new ArrayList<MenuItem>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(InputReader.getCharMenuItemInfo());
            }
        }
        return new ListMenu(arrayList);
    }

    public static QueryMenu getCharMenuQueryInfo() throws IOException, ARException {
        JavaDriver.outputWriter.driverPrintPrompt("    Char Menu Query Info:\n");
        if (InputReader.getBoolean("Null CharMenuQueryInfo (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("    Form Name (): ", "");
        String string2 = InputReader.getString("      Server (): ", "");
        QualifierInfo qualifierInfo = InputReader.getQualifierInfo();
        int n = InputReader.getInt("      Id of the label field (0): ", 0);
        int n2 = InputReader.getInt("      Id of the value field (0): ", 0);
        boolean bl = InputReader.getBooleanForChangingInfo("      Sort the label field (T): ", true);
        String string3 = InputReader.getString("    Sample Form Name (): ", "");
        String string4 = InputReader.getString("      Sample Server (): ", "");
        return new QueryMenu(string, string2, qualifierInfo, n, n2, bl, string3, string4);
    }

    public static FileMenu getCharMenuFileInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintHeader("Char Menu FILE INFO:");
        if (InputReader.getBoolean("Null CharMenuFileInfo (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt("       File location  Server or Client (1 or 2) (1): ", 1);
        String string = InputReader.getString("      File Name():", "");
        return new FileMenu(n, string);
    }

    public static SqlMenu getCharMenuSQLInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("Char Menu SQL INFO:\n");
        if (InputReader.getBoolean("Null CharMenuSQLInfo (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("      Server (): ", "");
        String string2 = InputReader.getString("      SQL command (): ", "");
        int n = InputReader.getInt("      Index of the label field (1): ", 1);
        int n2 = InputReader.getInt("      Index of the value field (1): ", 1);
        return new SqlMenu(string, string2, n, n2);
    }

    public static List<MenuItem> getCharMenuItemInfoList() throws IOException {
        int n = InputReader.getInt("   Number of char menu items (0): ", 0);
        ArrayList<MenuItem> arrayList = null;
        if (n > 0) {
            arrayList = new ArrayList<MenuItem>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(InputReader.getCharMenuItemInfo());
            }
        }
        return arrayList;
    }

    public static DataDictionaryMenu getCharMenuDDInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   Char Menu Data-Dictionary info:\n");
        if (InputReader.getBoolean("Null CharMenuDDInfo (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("      Server name (): ", "");
        int n = InputReader.getInt("      Name type (0 - 2) (0): ", 0);
        int n2 = InputReader.getInt("      Value format (1 - 11) (2): ", 2);
        int n3 = InputReader.getInt("      Struct type ( 1(form) - 2(field) ) (1): ", 1);
        DataDictionaryMenu dataDictionaryMenu = null;
        switch (n3) {
            case 1: {
                JavaDriver.outputWriter.driverPrintPrompt("      Data-Dictionary Form Info :\n");
                int n4 = InputReader.getInt("        Type of form (all,regular,join,view,uplink,downlink,dialog,vendor) (0-6,8) (0): ", 0);
                boolean bl = InputReader.getBooleanForChangingInfo("        Include hidden forms (T): ", true);
                dataDictionaryMenu = new FormDataDictionaryMenu(string, n, n2, n4, bl);
                break;
            }
            case 2: {
                JavaDriver.outputWriter.driverPrintPrompt("        Data-Dictionary Field Info :\n");
                int n5 = InputReader.getInt("        Field Type - data, trim, control, page, pholder, table,\n  column, attach, attachpool  (1, 2, 4, 8, 16, 32, 64, 128, 256) (129): ", 129);
                String string2 = InputReader.getString("        Form name (): ", "");
                dataDictionaryMenu = new FieldDataDictionaryMenu(string, n, n2, n5, string2);
                break;
            }
        }
        return dataDictionaryMenu;
    }

    public static Menu getCharMenuSSInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("    Char Menu Server-Side info:\n");
        if (InputReader.getBoolean("Null CharMenuSSInfo (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("      Menu name (): ", "");
        SqlMenu sqlMenu = new SqlMenu(null, null, 0, 0);
        sqlMenu.setName(string);
        return sqlMenu;
    }

    public static Menu getMenu() throws IOException, ARException {
        JavaDriver.outputWriter.driverPrintPrompt("Char Menu Info:\n");
        int n = InputReader.getInt("    Menu type - None, List, Query, File, SQL, SS, DD (0 - 6) ( 1 ):", 1);
        Menu menu = null;
        switch (n) {
            case 1: {
                menu = InputReader.getCharMenuListInfo();
                break;
            }
            case 2: {
                menu = InputReader.getCharMenuQueryInfo();
                break;
            }
            case 3: {
                menu = InputReader.getCharMenuFileInfo();
                break;
            }
            case 4: {
                menu = InputReader.getCharMenuSQLInfo();
                break;
            }
            case 6: {
                menu = InputReader.getCharMenuDDInfo();
            }
            case 5: {
                menu = InputReader.getCharMenuSSInfo();
            }
        }
        return menu;
    }

    public static StructItemInfo getStructItemInfo() throws IOException {
        if (InputReader.getBoolean("Null StructItemInfo (F): ", false)) {
            return null;
        }
        int n = 0;
        InputReader.setNullPromptOption(true);
        int n2 = InputReader.getInt("   Form(full,defn,view,mail),Filter,ActLink,<7-obsolete>,CharMenu,\n    Escalation,Dist Map, Form(min view), Container, DistPool, VUI,\n   Field, Application, Image, VUI(locale based)(1-8, 9-15, 16-18): ", 0);
        String string = InputReader.getString("Structure name ", "");
        String[] stringArray = null;
        if (n2 == 14 || n2 == 4) {
            JavaDriver.outputWriter.driverPrintPrompt("   VUIs to select (supply VUI's DB name):\n");
            stringArray = InputReader.getStringArray("", "VUI DB Name");
        } else if (n2 == 15) {
            stringArray = InputReader.getStringArray("", "Field Name");
        } else if (n2 == 16) {
            if (InputReader.getBoolean("Integration Workflow Only (F): ", false)) {
                n |= 8;
                JavaDriver.outputWriter.driverPrintPrompt("   Applicaiotns to select:\n");
                stringArray = InputReader.getStringArray("", "Applications");
            } else {
                if (InputReader.getBoolean("Include Shared Workflow (F): ", false)) {
                    n |= 1;
                }
                if (InputReader.getBoolean("Include only Locale VUI and data T/F? (F): ", false)) {
                    n |= 0x14;
                    JavaDriver.outputWriter.driverPrintPrompt("   Locales to select:\n");
                    stringArray = InputReader.getStringArray("", "Locale");
                } else {
                    int n3 = InputReader.getInt("Locales to include: (0-All 1-Default only 2-Selected) (0):", 0);
                    if (n3 == 1) {
                        n |= 2;
                    } else if (n3 == 2) {
                        n |= 4;
                        JavaDriver.outputWriter.driverPrintPrompt("   Locales to select:\n");
                        stringArray = InputReader.getStringArray("", "Locale");
                    }
                }
            }
        }
        InputReader.setNullPromptOption(false);
        return new StructItemInfo(n2, string, stringArray, n);
    }

    public static List<StructItemInfo> getStructItemInfoList() throws IOException {
        int n = InputReader.getInt("   Format: AR_DEF, XML (1,2) (1): ", 1);
        JavaDriver.outputWriter.driverPrintPrompt("Struct ItemInfo List:\n");
        int n2 = InputReader.getInt("   Number of structure items (0): ", 0);
        ArrayList<StructItemInfo> arrayList = new ArrayList<StructItemInfo>();
        if (n2 != 0) {
            for (int i = 0; i < n2; ++i) {
                arrayList.add(InputReader.getStructItemInfo());
            }
        }
        if (n == 2) {
            for (StructItemInfo structItemInfo : arrayList) {
                structItemInfo.setType(structItemInfo.getType() | 0x40000000);
            }
        }
        return arrayList;
    }

    public static ServerInfo getServerInfo() throws IOException, ARException {
        if (InputReader.getBoolean("Null ServerInfo (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt("    Operation (1-351) (1):", 1);
        Value value = InputReader.getValue();
        return new ServerInfo(n, value);
    }

    public static ServerInfoMap getServerInfoMap() throws IOException, ARException {
        int n = InputReader.getInt("   Number of server info operations (0): ", 0);
        ServerInfoMap serverInfoMap = new ServerInfoMap();
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                int n2 = InputReader.getInt("    Operation (1-351) (1):", 1);
                Value value = InputReader.getValue();
                serverInfoMap.put(n2, value);
            }
        }
        return serverInfoMap;
    }

    public static List<Reference> getReferenceList() throws IOException, ARException {
        int n = InputReader.getInt("   Number of References (0): ", 0);
        ArrayList<Reference> arrayList = null;
        if (n != 0) {
            arrayList = new ArrayList<Reference>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(InputReader.getReference());
            }
        }
        return arrayList;
    }

    public static Reference getReference() throws IOException, ARException {
        if (InputReader.getBoolean("Null Reference (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("Reference Label ():", "");
        String string2 = InputReader.getString("Reference Description ():", "");
        ReferenceType referenceType = InputReader.getReferenceType();
        int n = InputReader.getInt("References Data Type AR, EXTERNAL (0, 1) (0):", 0);
        if (n == 0) {
            String string3 = InputReader.getString("ARS reference name", "");
            return new Reference(string, string2, referenceType, string3);
        }
        JavaDriver.outputWriter.driverPrintPrompt("   External reference access group ids: \n");
        List<Integer> list = InputReader.getIntegerList();
        JavaDriver.outputWriter.driverPrintPrompt("External Reference Value :\n");
        Value value = InputReader.getValue();
        return new ExternalReference(string, string2, referenceType, list, value);
    }

    public static ReferenceType getReferenceType() throws IOException {
        if (InputReader.getBoolean("Null ReferenceType (F): ", false)) {
            return null;
        }
        JavaDriver.outputWriter.driverPrintPrompt("   Reference type none, form, filter, esc,actlink,\n");
        int n = InputReader.getInt("      container,charmenu (0,2-7) (0): ", 0);
        return ReferenceType.toReferenceType(n);
    }

    public static List<ContainerOwner> getContainerOwnerList() throws IOException {
        if (InputReader.getBoolean("Null ContainerOwnerList (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt("Number of container owner objects (0): ", 0);
        ArrayList<ContainerOwner> arrayList = null;
        if (n != 0) {
            arrayList = new ArrayList<ContainerOwner>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(InputReader.getContainerOwner());
            }
        }
        return arrayList;
    }

    public static ContainerOwner getContainerOwner() throws IOException {
        if (InputReader.getBoolean("Null ContainerOwnerInfo (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt("Container owner type (unowned, all, owned) (0-2) (0): ", 0);
        if (n == 0 || n == 1) {
            return new ContainerOwner(n);
        }
        String string = InputReader.getString("Container Owner Name", "");
        return new ContainerOwner(n, string);
    }

    public static ContainerType getContainerType() throws IOException {
        if (InputReader.getBoolean("Null ContainerType (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt("Active Link Guide, Application, Packing List, Filter Guide, Web Service(1-5) (2): ", 2);
        switch (n) {
            case 1: {
                return ContainerType.GUIDE;
            }
            case 2: {
                return ContainerType.APPLICATION;
            }
            case 3: {
                return ContainerType.PACKINGLIST;
            }
            case 4: {
                return ContainerType.FILTERGUIDE;
            }
        }
        return null;
    }

    public static List<ContainerType> getContainerTypeList() throws IOException {
        int n = InputReader.getInt("Number of container types (0): ", 0);
        ArrayList<ContainerType> arrayList = null;
        if (n != 0) {
            arrayList = new ArrayList<ContainerType>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(InputReader.getContainerType());
            }
        }
        return arrayList;
    }

    public static LocalizedRequestInfo getLocalizedRequestInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   Localized Message Request Info:\n");
        if (InputReader.getBoolean("Null getLocalizedRequest Object? (F):", false)) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = InputReader.getInt(" Message Type:  System, Active Link, Filter, Active Link Help,\n   Form Help, Field Help, Container Desc., List Menu Defn,\n   External Report ,Container Label, Application Help, \n  Application About, Application Help Index   (0 - 13) (0): ", 0);
        String string = InputReader.getString("     name: ", "");
        switch (n4) {
            case 5: 
            case 8: {
                n = InputReader.getInt("Internal ID (0): ", 0);
                break;
            }
            case 1: 
            case 2: {
                n2 = InputReader.getInt("If/Else (0): ", 0);
                n3 = InputReader.getInt("Action (0): ", 0);
                break;
            }
        }
        return new LocalizedRequestInfo(string, n4, n2, n3, n);
    }

    public static LocalizedRequestInfo[] getLocalizedRequestInfoList() throws IOException {
        int n = InputReader.getInt("Number of localized value operations (0): ", 0);
        LocalizedRequestInfo[] localizedRequestInfoArray = null;
        if (n != 0) {
            localizedRequestInfoArray = new LocalizedRequestInfo[n];
            for (int i = 0; i < n; ++i) {
                localizedRequestInfoArray[i] = InputReader.getLocalizedRequestInfo();
            }
        }
        return localizedRequestInfoArray;
    }

    public static StatusHistoryItem getStatusHistoryItem() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   Status History Info:\n");
        String string = InputReader.getString("   User: ", "");
        Timestamp timestamp = new Timestamp(InputReader.getLong("   TimeStamp(0): ", 0L));
        return new StatusHistoryItem(string, timestamp);
    }

    public static StatusHistoryValue getStatusHistory() throws IOException {
        StatusHistoryValue statusHistoryValue = new StatusHistoryValue();
        int n = InputReader.getInt("Number of Status History Info Objects(0): ", 0);
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                statusHistoryValue.add(InputReader.getStatusHistoryItem());
            }
        }
        return statusHistoryValue;
    }

    public static DiaryItem getDiaryInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   DiaryList Info:\n");
        String string = InputReader.getString("   User: ", "");
        Timestamp timestamp = new Timestamp(InputReader.getLong("   TimeStamp: ", 0L));
        String string2 = InputReader.getString("     Text () ", "");
        return new DiaryItem(string, string2, timestamp);
    }

    public static DiaryListValue getDiaryInfoList() throws IOException {
        DiaryListValue diaryListValue = new DiaryListValue();
        int n = InputReader.getInt("Number of DiaryList Info Objects(0): ", 0);
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                diaryListValue.add(InputReader.getDiaryInfo());
            }
        }
        return diaryListValue;
    }

    public static EscalationTimeCriteria getEsclationTmInfo() throws IOException {
        if (InputReader.getBoolean("Null EsclationTmInfo (F): ", false)) {
            return null;
        }
        EscalationTimeCriteria escalationTimeCriteria = null;
        int n = InputReader.getInt("Escalation Time Format (1-interval /2) (1) :", 1);
        if (n == 1) {
            long l = InputReader.getLong("Escalation Interval ( >0 ) (300):", 300L);
            escalationTimeCriteria = new EscalationInterval(l);
        } else {
            DayInfo dayInfo = InputReader.getDayInfo();
            escalationTimeCriteria = new EscalationTime((int)dayInfo.getMonthday(), (int)dayInfo.getWeekday(), (int)dayInfo.getHourmask(), (int)dayInfo.getMinute());
        }
        return escalationTimeCriteria;
    }

    public static DayInfo getDayInfo() throws IOException {
        if (InputReader.getBoolean("Null DayInfo (F): ", false)) {
            return null;
        }
        long l = InputReader.getLong("Day (0):", 0L);
        long l2 = InputReader.getLong("HourMask (0):", 0L);
        long l3 = InputReader.getLong("Minutes (0):", 0L);
        long l4 = InputReader.getLong("Week day (0):", 0L);
        return new DayInfo(l, l4, l2, l3);
    }

    public static FieldLimit getFieldLimitInfo(int n) throws IOException, ARException {
        if (InputReader.getBoolean("Set to NO LIMITS? (F): ", false)) {
            return null;
        }
        switch (n) {
            case 2: {
                return InputReader.getIntegerLimitInfo();
            }
            case 3: {
                return InputReader.getRealLimitInfo();
            }
            case 4: {
                return InputReader.getCharLimitInfo();
            }
            case 5: {
                return InputReader.getDiaryLimitInfo();
            }
            case 7: {
                return null;
            }
            case 6: {
                return InputReader.getEnumLimitInfo();
            }
            case 8: {
                return InputReader.getEnumLimitInfo();
            }
            case 11: {
                return InputReader.getAttachmentLimitInfo();
            }
            case 10: {
                return InputReader.getDecimalLimitInfo();
            }
            case 12: {
                return InputReader.getCurrencyLimitInfo();
            }
            case 33: {
                return InputReader.getTableLimitInfo();
            }
            case 34: {
                return InputReader.getColumnLimitInfo();
            }
            case 42: {
                return InputReader.getViewLimits();
            }
            case 43: {
                return InputReader.getDisplayLimits();
            }
        }
        return null;
    }

    public static DataType getDataType() throws IOException {
        if (InputReader.getBoolean("Null Data Type (F): ", false)) {
            return null;
        }
        JavaDriver.outputWriter.driverPrintPrompt("Datatype Null/Key/Int/Real/Char/DiaryList/Enum/Time/Bitmask/Byte/Decimal\n");
        int n = InputReader.getInt("    attach/currency/date/timeofday/join/trim/control/table/column/ulong/coords/view/display (0 - 14, 30-34, 40-43) (2): ", 2);
        return DataType.toDataType(n);
    }

    public static FormType getFormType() throws IOException {
        if (InputReader.getBoolean("Null Form Type (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt("Type of form (all, regular, join, view, uplink, downlink, dialog, all_with_data, vendor) (0-8)(0):", 0);
        switch (n) {
            case 0: {
                return FormType.ALL;
            }
            case 1: {
                return FormType.REGULAR;
            }
            case 2: {
                return FormType.JOIN;
            }
            case 3: {
                return FormType.VIEW;
            }
            case 4: {
                return FormType.UPLINK;
            }
            case 5: {
                return FormType.DOWNLINK;
            }
            case 6: {
                return FormType.DIALOG;
            }
            case 8: {
                return FormType.VENDOR;
            }
            case 7: {
                return FormType.ALL_WITH_DATA;
            }
        }
        return null;
    }

    public static EntryKey getEntryKey() throws IOException {
        if (InputReader.getBoolean("Null Entry key (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("Form Name (): ", "");
        int n = InputReader.getInt("Number of Items in EntryId ? (1): ", 1);
        if (n <= 0) {
            return null;
        }
        String[] stringArray = new String[n];
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringArray[i] = InputReader.getString("String: ", "");
            stringBuilder.append(stringArray[i]);
            stringBuilder.append("|");
        }
        if (n == 1) {
            return new EntryKey(string, stringArray[0]);
        }
        String string2 = stringBuilder.toString();
        string2 = string2.substring(0, string2.length() - 1);
        return new EntryKey(string, string2);
    }

    public static ByteListValue[] getByteListInfoList() throws IOException {
        ByteListValue[] byteListValueArray = null;
        int n = InputReader.getInt("   Number of items (0): ", 0);
        if (n != 0) {
            byteListValueArray = new ByteListValue[n];
            for (int i = 0; i < n; ++i) {
                byteListValueArray[i] = InputReader.getByteListInfo();
            }
        }
        return byteListValueArray;
    }

    public static Entry getEntry() throws IOException, ARException {
        Entry entry = new Entry();
        int n = InputReader.getInt("  Number of Field/value pairs (0): ", 0);
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                int n2 = InputReader.getInt("Field id (0): ", 0);
                Value value = InputReader.getValue();
                entry.put(n2, value);
            }
        }
        return entry;
    }

    public static ViewKey getViewKey() throws IOException {
        if (InputReader.getBoolean("Null ViewKey (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("Form Name (): ", "");
        int n = InputReader.getInt("VUI id (1): ", 1);
        return new ViewKey(string, n);
    }

    public static int[] getIntArray() throws IOException {
        int[] nArray = null;
        int n = InputReader.getInt("   Number of field IDs (0): ", 0);
        if (n != 0) {
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = InputReader.getInt("Field id (0): ", 0);
            }
        }
        return nArray;
    }

    public static QueryInfo getQueryInfo() throws IOException, ARException {
        if (InputReader.getBoolean("Null QueryInfo (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("Form (): ", "");
        String string2 = InputReader.getString("Server (): ", "");
        QualifierInfo qualifierInfo = InputReader.getQualifierInfo();
        int n = InputReader.getInt("Field id (0): ", 0);
        int n2 = InputReader.getInt("Multi-Match code (error, first, set) (1, 2, 3) (1): ", 1);
        return new QueryInfo(string, string2, qualifierInfo, n, n2);
    }

    public static NotifyAction getNotifyActionInfo() throws IOException {
        if (InputReader.getBoolean("Null NotifyActionInfo (F): ", false)) {
            return null;
        }
        NotifyAction notifyAction = new NotifyAction();
        JavaDriver.outputWriter.driverPrintHeader("Filter Action Notify (): ");
        int n = InputReader.getInt("   Notifier, Email, Default, other, or XRef (1, 2, 3, 4-98, 99): ", 0);
        notifyAction.setNotifyMechanism(n);
        if (n == 99) {
            int n2 = InputReader.getInt("   Cross-reference field id: ", 0);
            notifyAction.setNotifyMechanismXRef(n2);
        }
        String string = InputReader.getString("   User name: ", "");
        notifyAction.setUser(string);
        String string2 = InputReader.getString("   Notify text (): ", "");
        notifyAction.setNotifyText(string2);
        int n3 = InputReader.getInt("   Notify priority (1 to 10) (1): ", 1);
        notifyAction.setNotifyPriority(n3);
        String string3 = InputReader.getString("   Notify subject (): ", "");
        notifyAction.setSubjectText(string3);
        boolean bl = InputReader.getBoolean("Is Advanced Notify Action (F): ", false);
        if (bl) {
            notifyAction.setFrom(InputReader.getString("   From user: ", ""));
            notifyAction.setReplyTo(InputReader.getString("   Reply To: ", ""));
            notifyAction.setCc(InputReader.getString("   Cc user: ", ""));
            notifyAction.setBcc(InputReader.getString("   Bcc user: ", ""));
            notifyAction.setOrganization(InputReader.getString("   Organization: ", ""));
            notifyAction.setMailboxName(InputReader.getString("   Mailbox name: ", ""));
            notifyAction.setHeaderTemplate(InputReader.getString("   Header template: ", ""));
            notifyAction.setFooterTemplate(InputReader.getString("   Footer template: ", ""));
            notifyAction.setContentTemplate(InputReader.getString("   Content template: ", ""));
        }
        int n4 = InputReader.getInt("   None, All, specific list, or changed (0, 1, 2, 3) (0): ", 0);
        notifyAction.setFieldIdListType(n4);
        if (n4 == 2) {
            List<Integer> list = InputReader.getIntegerList();
            notifyAction.setFieldIdList(list);
        }
        return notifyAction;
    }

    public static StatusInfo getStatusInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintHeader("Status Info:");
        if (InputReader.getBoolean("Null StatusInfo (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt("   Note, Warning, or Error (0, 1, 2) (2) : ", 2);
        long l = InputReader.getLong("   Message number (0): ", 0L);
        String string = InputReader.getString("   Message text (): ", "");
        String string2 = InputReader.getString("Appended Text():", "");
        return new StatusInfo(n, l, string, string2);
    }

    public static CommitChangesAction getCommitChangesInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintHeader("   Active Link Commit Changes Info :");
        if (InputReader.getBoolean("Null CommitChangesInfo (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("      Form Name (): ", "");
        return new CommitChangesAction(string);
    }

    public static String getFileContents(String string) throws IOException, FileNotFoundException {
        File file = new File(string);
        FileReader fileReader = new FileReader(file);
        long l = file.length();
        char[] cArray = new char[(int)l + 1];
        String string2 = null;
        if ((long)fileReader.read(cArray, 0, (int)l) != l) {
            fileReader.close();
            JavaDriver.outputWriter.driverPrintWarning("Not able to read the entire file..\n");
            throw new IOException("Not able to read the entire file..\n");
        }
        string2 = new String(cArray);
        fileReader.close();
        return string2;
    }

    public static String getFileContent(String string, String string2, int n, OutputWriter outputWriter) {
        String string3 = null;
        String string4 = null;
        for (int i = 0; i < n; ++i) {
            try {
                string3 = InputReader.getString(string, string2);
                string4 = InputReader.getFileContents(string3);
                continue;
            }
            catch (Throwable throwable) {
                outputWriter.printString(String.format("Could not read from given input file;%s\n", i + 1 < n ? String.format("Retry (%d)...", i + 1) : ""));
            }
        }
        return string4;
    }

    public static ReferenceType[] getReferenceTypeList() throws IOException {
        int n = InputReader.getInt("   Number of reference types (0): ", 0);
        ReferenceType[] referenceTypeArray = null;
        if (n != 0) {
            referenceTypeArray = new ReferenceType[n];
            for (int i = 0; i < n; ++i) {
                referenceTypeArray[i] = InputReader.getReferenceType();
            }
        }
        return referenceTypeArray;
    }

    public static SupportFileKey getSupportFileKey() throws IOException {
        if (InputReader.getBoolean("Null SupportFileKey? (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt("File type -- external report (1) (1):", 1);
        String string = InputReader.getString("Name of associated object: ", "");
        int n2 = InputReader.getInt("Supporting ID for object (0):", 0);
        int n3 = InputReader.getInt("ID for the file (1): ", 1);
        return new SupportFileKey(n, string, n2, n3);
    }

    public static LocalizedValueCriteria getLocalizedValueCriteria() throws IOException {
        if (InputReader.getBoolean("Null LocalizedValueCriteria? (F):", false)) {
            return null;
        }
        LocalizedValueCriteria localizedValueCriteria = new LocalizedValueCriteria();
        localizedValueCriteria.setRetrieveAll(false);
        if (InputReader.getBooleanForChangingInfo("get Localized Values? (T): ", true)) {
            localizedValueCriteria.setPropertiesToRetrieve(1 | localizedValueCriteria.getPropertiesToRetrieve());
        }
        if (InputReader.getBooleanForChangingInfo("get Timestamps? (T): ", true)) {
            localizedValueCriteria.setPropertiesToRetrieve(2 | localizedValueCriteria.getPropertiesToRetrieve());
        }
        return localizedValueCriteria;
    }

    public static AlertMessageCriteria getAlertMessageCriteria() throws IOException {
        AlertMessageCriteria alertMessageCriteria = new AlertMessageCriteria();
        alertMessageCriteria.setRetrieveAll(false);
        if (InputReader.getBoolean("get Timestamp? (T): ", true)) {
            alertMessageCriteria.setPropertiesToRetrieve(1 | alertMessageCriteria.getPropertiesToRetrieve());
        }
        if (InputReader.getBoolean("get sourceType? (T): ", true)) {
            alertMessageCriteria.setPropertiesToRetrieve(2 | alertMessageCriteria.getPropertiesToRetrieve());
        }
        if (InputReader.getBoolean("get priority? (T): ", true)) {
            alertMessageCriteria.setPropertiesToRetrieve(4 | alertMessageCriteria.getPropertiesToRetrieve());
        }
        if (InputReader.getBoolean("get alertText? (T): ", true)) {
            alertMessageCriteria.setPropertiesToRetrieve(8 | alertMessageCriteria.getPropertiesToRetrieve());
        }
        if (InputReader.getBoolean("get sourceTag? (T): ", true)) {
            alertMessageCriteria.setPropertiesToRetrieve(0x10 | alertMessageCriteria.getPropertiesToRetrieve());
        }
        if (InputReader.getBoolean("get serverName? (T): ", true)) {
            alertMessageCriteria.setPropertiesToRetrieve(0x20 | alertMessageCriteria.getPropertiesToRetrieve());
        }
        if (InputReader.getBoolean("get serverAddress? (T): ", true)) {
            alertMessageCriteria.setPropertiesToRetrieve(0x100 | alertMessageCriteria.getPropertiesToRetrieve());
        }
        if (InputReader.getBoolean("get formName? (T): ", true)) {
            alertMessageCriteria.setPropertiesToRetrieve(0x40 | alertMessageCriteria.getPropertiesToRetrieve());
        }
        if (InputReader.getBoolean("get objectId? (T): ", true)) {
            alertMessageCriteria.setPropertiesToRetrieve(0x80 | alertMessageCriteria.getPropertiesToRetrieve());
        }
        return alertMessageCriteria;
    }

    public static String getString(String string) throws IOException {
        return InputReader.getString(string, "");
    }

    public static JoinForm getJoinForm() throws IOException, ARException {
        if (InputReader.getBoolean("Null JoinForm (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("Join member A name");
        String string2 = InputReader.getString("Join member B name");
        QualifierInfo qualifierInfo = InputReader.getQualifierInfo();
        int n = InputReader.getInt("   Join option(0): ", 0);
        return new JoinForm(string, string2, qualifierInfo, n);
    }

    public static ViewForm getViewForm() throws IOException {
        if (InputReader.getBoolean("Null ViewForm (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("   View table name : ", "");
        String string2 = InputReader.getString("   Key Field ");
        return new ViewForm(string, string2);
    }

    public static VendorForm getVendorForm() throws IOException {
        if (InputReader.getBoolean("Null VendorForm (F): ", false)) {
            return null;
        }
        String string = InputReader.getString("   Vendor name ");
        String string2 = InputReader.getString("   Vendor table name : ", "");
        return new VendorForm(string, string2);
    }

    public static void openInputFile(String string) throws IOException {
        String string2 = null;
        string2 = string == null ? InputReader.getString("File name of input file ()", "") : string;
        if (string2 == null || string2.length() == 0) {
            JavaDriver.outputWriter.driverPrintWarning("****No filename specified so no change to input file\n");
        } else {
            ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
            try {
                threadControlBlock.setCurrentInputFile(string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                JavaDriver.outputWriter.printString("**** File error during open; no change to input file: " + string2 + "\n");
            }
        }
    }

    public static String[] getStringList() throws IOException {
        if (InputReader.getBoolean("Null String List (F): ", false)) {
            return null;
        }
        String[] stringArray = null;
        int n = InputReader.getInt("Number Of Entries (1):", 1);
        if (n > 0) {
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = InputReader.getString("", "");
            }
        }
        return stringArray;
    }

    public static WorkflowLockInfo getWorkflowLockInfo() throws IOException {
        if (InputReader.getBoolean("Null WorkflowLockInfo (F): ", false)) {
            return null;
        }
        int n = InputReader.getInt("   Lock type (0-None, 1-Read, 2-Hidden) (0): ", 0);
        String string = null;
        if (n > 0) {
            string = InputReader.getString("   Lock Key: ");
        }
        return new WorkflowLockInfo(n, string);
    }

    public static WfdBreakpoint WFDFillBreakPt(boolean bl) throws IOException {
        WfdBreakpoint wfdBreakpoint = new WfdBreakpoint();
        if (!bl) {
            wfdBreakpoint.id = InputReader.getInt("  BP location -\n  ID ? (0): ", 0);
        }
        wfdBreakpoint.filter = InputReader.getString("  Filter: ", "FilterName");
        wfdBreakpoint.schema = InputReader.getString("  Schema (*): ", "*");
        wfdBreakpoint.stage = 3 + InputReader.getInt("  Stage PreAPI/PreQual/Phase1/Phase2/Phase3/Escl/CMDB (0-5) (4): ", 1);
        wfdBreakpoint.elsePath = InputReader.getBoolean("  Else path? (F): ", false);
        wfdBreakpoint.actionNo = InputReader.getInt("  Action number (0): ", 0);
        wfdBreakpoint.disable = InputReader.getBoolean("  Disabled (F): ", false);
        wfdBreakpoint.passcount = InputReader.getInt("  Passcount ? (0): ", 0);
        wfdBreakpoint.bpQualifier = null;
        return wfdBreakpoint;
    }

    public static RegularQuery getRegularQuery() throws IOException, ARException {
        RegularQuery regularQuery = new RegularQuery();
        regularQuery.setFromSources(InputReader.getQuerySourceList(""));
        regularQuery.setFromFields(InputReader.getQueryFormFieldList(regularQuery.getFromSources(), ""));
        regularQuery.setQualifier(InputReader.getQualifierInfo(regularQuery.getFromSources(), "Qualifier Info", ""));
        regularQuery.setSortBy(InputReader.getSortInfoList());
        return regularQuery;
    }

    public static RecursiveQuery getRecursiveQuery() throws IOException, ARException {
        RecursiveQuery recursiveQuery = new RecursiveQuery();
        recursiveQuery.setFromSources(InputReader.getQuerySourceList(recursiveQuery, "      "));
        recursiveQuery.setFromFields(InputReader.getQueryFormFieldList(recursiveQuery.getFromSources(), "      "));
        recursiveQuery.setQualifier(InputReader.getQualifierInfo(recursiveQuery.getFromSources(), "Start qualifier", "      "));
        ArrayList<IQuerySource> arrayList = new ArrayList<IQuerySource>(recursiveQuery.getFromSources().size() + 1);
        arrayList.addAll(recursiveQuery.getFromSources());
        arrayList.add(recursiveQuery);
        recursiveQuery.setRecursionQualifier(InputReader.getQualifierInfo(arrayList, "Recursion qualifier", "      "));
        recursiveQuery.setLevelsToRetrieve(InputReader.getInt("      Levels to retrieve (0): ", 0));
        return recursiveQuery;
    }

    public static List<IQuerySource> getQuerySourceList(String string) throws IOException, ARException {
        return InputReader.getQuerySourceList(null, string);
    }

    public static List<IQuerySource> getQuerySourceList(RecursiveQuery recursiveQuery, String string) throws IOException, ARException {
        ArrayList<IQuerySource> arrayList = null;
        IQuerySource iQuerySource = null;
        int n = InputReader.getInt(string + "Number of query sources (0): ", 0);
        if (n > 0) {
            arrayList = new ArrayList<IQuerySource>(n);
            int n2 = 0;
            while (n2 < n) {
                iQuerySource = InputReader.getQuerySource(string, recursiveQuery, n2 == 0 ? null : arrayList);
                if (iQuerySource == null) continue;
                arrayList.add(iQuerySource);
                ++n2;
            }
        }
        return arrayList;
    }

    public static IQuerySource getQuerySource(String string, RecursiveQuery recursiveQuery, List<IQuerySource> list) throws IOException, ARException {
        JavaDriver.outputWriter.driverPrintPrompt(string + "    Query source: \n");
        IQuerySource iQuerySource = null;
        boolean bl = false;
        int n = recursiveQuery == null ? InputReader.getInt(string + "      Type: Form name, Nested, Recursive (0 - 2) (0): ", 0) : 0;
        if (n == 0) {
            iQuerySource = new QuerySourceForm(InputReader.getString(string + "      Form: ", ""));
            if (recursiveQuery != null && !bl && (bl = InputReader.getBoolean(string + "      Recurse on this form (T): ", true))) {
                recursiveQuery.setRecursiveForm((QuerySourceForm)iQuerySource);
            }
        } else if (n == 2) {
            iQuerySource = InputReader.getRecursiveQuery();
        } else {
            JavaDriver.outputWriter.driverPrintWarning("****This query type is not supported\n");
            return null;
        }
        if (iQuerySource != null && list != null && list.size() > 0) {
            ArrayList<IQuerySource> arrayList = new ArrayList<IQuerySource>(list.size() + 1);
            arrayList.addAll(list);
            arrayList.add(iQuerySource);
            iQuerySource.setJoinType(InputReader.getInt(string + "      Join type: Inner, Left, Right (0 - 2) (0): ", 0));
            iQuerySource.setJoinQualifier(InputReader.getQualifierInfo(arrayList, "Join qualifier", string + "      "));
            iQuerySource.setJoinedWith(InputReader.getSourceJoinedWith(list, string + "      "));
        }
        return iQuerySource;
    }

    public static IQuerySource getSourceJoinedWith(List<IQuerySource> list, String string) throws IOException {
        int n = InputReader.getInt(string + "Joined with (" + InputReader.getQuerySourcesPrompt(list) + ") (0): ", 0);
        return list.get(n);
    }

    public static List<QueryFormField> getQueryFormFieldList(List<IQuerySource> list, String string) throws IOException {
        ArrayList<QueryFormField> arrayList = null;
        int n = InputReader.getInt(string + "Number of query fields (0): ", 0);
        if (n > 0) {
            arrayList = new ArrayList<QueryFormField>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(InputReader.getQueryFormField(list, string));
            }
        }
        return arrayList;
    }

    public static QueryFormField getQueryFormField(List<IQuerySource> list, String string) throws IOException {
        QueryFormField queryFormField = new QueryFormField();
        JavaDriver.outputWriter.driverPrintPrompt(string + "    Query field: \n");
        queryFormField.setFieldId(InputReader.getInt(string + "      Field id (0): ", 0));
        int n = InputReader.getInt(string + "      Field source (" + InputReader.getQuerySourcesPrompt(list) + ") (0): ", 0);
        queryFormField.setSource(list.get(n));
        return queryFormField;
    }

    public static ValueSetQuery getValueSetQuery(String string) throws IOException, ARException {
        ArrayList<QueryFormField> arrayList = new ArrayList<QueryFormField>(1);
        ValueSetQuery valueSetQuery = new ValueSetQuery();
        valueSetQuery.setFromSources(InputReader.getQuerySourceList(string));
        arrayList.add(InputReader.getQueryFormField(valueSetQuery.getFromSources(), string));
        valueSetQuery.setFromFields(arrayList);
        valueSetQuery.setQualifier(InputReader.getQualifierInfo(valueSetQuery.getFromSources(), "Qualifier Info", string));
        return valueSetQuery;
    }

    private static String getQuerySourcesPrompt(List<IQuerySource> list) throws IOException {
        String string = "";
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof RecursiveQuery) {
                string = string + "Recursive query - " + i + ", ";
                continue;
            }
            if (!(list.get(i) instanceof QuerySourceForm)) continue;
            string = string + ((QuerySourceForm)list.get(i)).getName() + "(" + i + "), ";
        }
        if (string.endsWith(", ")) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    private static void checkDecimalFormat(String string) throws ARException {
        CurrencyValue.checkDecimalFormat(string);
    }

    public static ImageData getImageData() throws IOException {
        int n = InputReader.getInt("Choose:\n   1 - prompt for filename \n   2 - prompt for string\n default (1): ", 1);
        ImageData imageData = null;
        switch (n) {
            case 1: {
                String string = InputReader.getString("Image File name (): ", "");
                imageData = new ImageData(string);
                break;
            }
            case 2: {
                int n2 = InputReader.getInt("Number of Items in the List (0): ", 0);
                byte[] byArray = new byte[1024];
                char[] cArray = new char[n2];
                for (int i = 0; i < n2; ++i) {
                    cArray[i] = InputReader.getChar("Byte[" + i + "]", ' ');
                }
                byArray = cArray.toString().getBytes();
                imageData = new ImageData(byArray);
            }
        }
        return imageData;
    }

    public static String[] getObjectModificationLogLabelAndTaskName() throws IOException {
        String[] stringArray = new String[]{InputReader.getString("Object Modification Log Label (): ", "")};
        if (stringArray[0].length() == 0) {
            stringArray[0] = null;
        }
        return stringArray;
    }
}

