/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.text.SimpleDateFormat;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrEncodingStream;

public class XdrTcpEncodingStream
extends XdrEncodingStream {
    private static SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss.SSS");
    private static PrintWriter debugout = null;
    private Socket socket;
    OutputStream stream;
    private byte[] buffer;
    private int bufferIndex;
    private int bufferHighmark;
    private int bufferFragmentHeaderIndex;
    private static final byte[] paddingZeros = new byte[]{0, 0, 0, 0};

    public XdrTcpEncodingStream(Socket streamingSocket, int bufferSize) throws IOException {
        this.socket = streamingSocket;
        this.stream = this.socket.getOutputStream();
        if (bufferSize < 1024) {
            bufferSize = 1024;
        }
        if ((bufferSize & 3) != 0) {
            bufferSize = bufferSize + 4 & 0xFFFFFFFC;
        }
        this.buffer = new byte[bufferSize];
        this.bufferFragmentHeaderIndex = 0;
        this.bufferIndex = 4;
        this.bufferHighmark = bufferSize - 4;
    }

    protected XdrTcpEncodingStream(Socket streamingSocket, byte[] newBuffer) throws IOException {
        this.socket = streamingSocket;
        this.stream = this.socket.getOutputStream();
        this.buffer = newBuffer;
        this.bufferFragmentHeaderIndex = 0;
        this.bufferIndex = 4;
        this.bufferHighmark = newBuffer.length - 4;
    }

    public InetAddress getSenderAddress() {
        return this.socket.getInetAddress();
    }

    public int getSenderPort() {
        return this.socket.getPort();
    }

    @Override
    public void beginEncoding(InetAddress receiverAddress, int receiverPort) throws OncRpcException, IOException {
    }

    @Override
    public void endEncoding() throws OncRpcException, IOException {
        this.flush(true, false);
    }

    public void endEncoding(boolean flush) throws OncRpcException, IOException {
        this.flush(true, !flush);
    }

    private void flush(boolean lastFragment, boolean batch) throws OncRpcException, IOException {
        int fragmentLength = this.bufferIndex - this.bufferFragmentHeaderIndex - 4;
        if (lastFragment) {
            fragmentLength |= Integer.MIN_VALUE;
        }
        this.buffer[this.bufferFragmentHeaderIndex] = (byte)(fragmentLength >>> 24);
        this.buffer[this.bufferFragmentHeaderIndex + 1] = (byte)(fragmentLength >>> 16);
        this.buffer[this.bufferFragmentHeaderIndex + 2] = (byte)(fragmentLength >>> 8);
        this.buffer[this.bufferFragmentHeaderIndex + 3] = (byte)fragmentLength;
        if (debugout != null) {
            String msg = "flush: lastFragment=" + lastFragment + " batch=" + batch + " bufferIndex=" + this.bufferIndex + " bufferHighmark=" + this.bufferHighmark;
            msg = "/* " + formatter.format(System.currentTimeMillis()) + " */" + msg;
            debugout.println(msg);
        }
        if (!lastFragment || !batch || this.bufferIndex >= this.bufferHighmark) {
            this.streamFlush(lastFragment);
            this.bufferFragmentHeaderIndex = 0;
            this.bufferIndex = 4;
        } else {
            this.bufferFragmentHeaderIndex = this.bufferIndex;
            this.bufferIndex += 4;
        }
    }

    protected void streamFlush(boolean lastFragment) throws IOException {
        if (debugout != null) {
            String msg = "streamFlush, bytes=" + this.bufferIndex;
            msg = "/* " + formatter.format(System.currentTimeMillis()) + " */" + msg;
            debugout.println(msg);
        }
        this.stream.write(this.buffer, 0, this.bufferIndex);
        this.stream.flush();
    }

    @Override
    public void close() throws OncRpcException, IOException {
        this.buffer = null;
        this.socket = null;
    }

    @Override
    public void xdrEncodeInt(int value) throws OncRpcException, IOException {
        if (this.bufferIndex > this.bufferHighmark) {
            this.flush(false, false);
        }
        this.buffer[this.bufferIndex++] = (byte)(value >>> 24);
        this.buffer[this.bufferIndex++] = (byte)(value >>> 16);
        this.buffer[this.bufferIndex++] = (byte)(value >>> 8);
        this.buffer[this.bufferIndex++] = (byte)value;
    }

    @Override
    public void xdrEncodeOpaque(byte[] value, int offset, int length) throws OncRpcException, IOException {
        int padding = 4 - (length & 3) & 3;
        while (length > 0) {
            int toCopy = this.bufferHighmark - this.bufferIndex + 4;
            if (toCopy >= length) {
                System.arraycopy(value, offset, this.buffer, this.bufferIndex, length);
                this.bufferIndex += length;
                break;
            }
            System.arraycopy(value, offset, this.buffer, this.bufferIndex, toCopy);
            this.bufferIndex += toCopy;
            offset += toCopy;
            length -= toCopy;
            this.flush(false, false);
        }
        System.arraycopy(paddingZeros, 0, this.buffer, this.bufferIndex, padding);
        this.bufferIndex += padding;
    }

    protected byte[] getBuffer() {
        return this.buffer;
    }

    public int getBufferIndex() {
        return this.bufferIndex;
    }

    protected void setBufferIndex(int bufferIndex) {
        this.bufferIndex = bufferIndex;
    }

    protected void setBufferHighmark(int bufferHighmark) {
        this.bufferHighmark = bufferHighmark;
    }

    protected void replaceBuffer(byte[] newBuffer) {
        this.buffer = newBuffer;
    }

    protected byte[] getBufferArray() {
        return this.buffer;
    }
}

