/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrDecodingStream;

public class XdrBufferDecodingStream
extends XdrDecodingStream {
    private byte[] buffer;
    private int encodedLength;
    private int bufferIndex;
    private int bufferHighmark;

    public XdrBufferDecodingStream(byte[] buffer, int encodedLength) {
        this.setXdrData(buffer, encodedLength);
    }

    public XdrBufferDecodingStream(byte[] buffer) {
        this.setXdrData(buffer, buffer.length);
    }

    public void setXdrData(byte[] buffer, int encodedLength) {
        if (encodedLength < 0 || (encodedLength & 3) != 0) {
            throw new IllegalArgumentException("length of encoded data must be a multiple of four and must not be negative");
        }
        this.buffer = buffer;
        this.encodedLength = encodedLength;
        this.bufferIndex = 0;
        this.bufferHighmark = -4;
    }

    @Override
    public InetAddress getSenderAddress() {
        return null;
    }

    @Override
    public int getSenderPort() {
        return 0;
    }

    @Override
    public void beginDecoding() throws OncRpcException, IOException {
        this.bufferIndex = 0;
        this.bufferHighmark = this.encodedLength - 4;
    }

    @Override
    public void endDecoding() throws OncRpcException, IOException {
        this.bufferIndex = 0;
        this.bufferHighmark = -4;
    }

    @Override
    public void close() throws OncRpcException, IOException {
        this.buffer = null;
    }

    @Override
    public int xdrDecodeInt() throws OncRpcException, IOException {
        if (this.bufferIndex <= this.bufferHighmark) {
            int value = this.buffer[this.bufferIndex++];
            value = (value << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
            value = (value << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
            value = (value << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
            return value;
        }
        throw new OncRpcException(43);
    }

    @Override
    public byte[] xdrDecodeOpaque(int length) throws OncRpcException, IOException {
        int alignedLength = length;
        if ((alignedLength & 3) != 0) {
            alignedLength = (alignedLength & 0xFFFFFFFC) + 4;
        }
        byte[] bytes = new byte[length];
        if (length > 0) {
            if (this.bufferIndex <= this.bufferHighmark - alignedLength + 4) {
                System.arraycopy(this.buffer, this.bufferIndex, bytes, 0, length);
            } else {
                throw new OncRpcException(43);
            }
        }
        this.bufferIndex += alignedLength;
        return bytes;
    }

    @Override
    public void xdrDecodeOpaque(byte[] opaque, int offset, int length) throws OncRpcException, IOException {
        int alignedLength = length;
        if ((alignedLength & 3) != 0) {
            alignedLength = (alignedLength & 0xFFFFFFFC) + 4;
        }
        if (length > 0) {
            if (this.bufferIndex <= this.bufferHighmark - alignedLength + 4) {
                System.arraycopy(this.buffer, this.bufferIndex, opaque, offset, length);
            } else {
                throw new OncRpcException(43);
            }
        }
        this.bufferIndex += alignedLength;
    }
}

