/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.servlet.view;

import com.bmc.thirdparty.org.springframework.web.servlet.support.RequestContext;
import com.bmc.thirdparty.org.springframework.web.servlet.view.AbstractUrlBasedView;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class AbstractTemplateView
extends AbstractUrlBasedView {
    public static final String SPRING_MACRO_REQUEST_CONTEXT_ATTRIBUTE = "springMacroRequestContext";
    private static boolean responseGetContentTypeAvailable;
    private boolean exposeRequestAttributes = false;
    private boolean exposeSessionAttributes = false;
    private boolean exposeSpringMacroHelpers = false;
    private boolean allowRequestOverride = false;
    private boolean allowSessionOverride = false;
    static /* synthetic */ Class class$javax$servlet$ServletResponse;

    public void setExposeRequestAttributes(boolean exposeRequestAttributes) {
        this.exposeRequestAttributes = exposeRequestAttributes;
    }

    public void setExposeSessionAttributes(boolean exposeSessionAttributes) {
        this.exposeSessionAttributes = exposeSessionAttributes;
    }

    public void setAllowRequestOverride(boolean allowRequestOverride) {
        this.allowRequestOverride = allowRequestOverride;
    }

    public void setAllowSessionOverride(boolean allowSessionOverride) {
        this.allowSessionOverride = allowSessionOverride;
    }

    public void setExposeSpringMacroHelpers(boolean exposeSpringMacroHelpers) {
        this.exposeSpringMacroHelpers = exposeSpringMacroHelpers;
    }

    protected final void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session;
        if (this.exposeRequestAttributes) {
            Enumeration en = request.getAttributeNames();
            while (en.hasMoreElements()) {
                String attribute = (String)en.nextElement();
                if (model.containsKey(attribute) && !this.allowRequestOverride) {
                    throw new ServletException("Cannot expose request attribute '" + attribute + "' because of an existing model object of the same name");
                }
                Object attributeValue = request.getAttribute(attribute);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Exposing request attribute '" + attribute + "' with value [" + attributeValue + "] to model");
                }
                model.put(attribute, attributeValue);
            }
        }
        if (this.exposeSessionAttributes && (session = request.getSession(false)) != null) {
            Enumeration en = session.getAttributeNames();
            while (en.hasMoreElements()) {
                String attribute = (String)en.nextElement();
                if (model.containsKey(attribute) && !this.allowSessionOverride) {
                    throw new ServletException("Cannot expose session attribute '" + attribute + "' because of an existing model object of the same name");
                }
                Object attributeValue = session.getAttribute(attribute);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Exposing session attribute '" + attribute + "' with value [" + attributeValue + "] to model");
                }
                model.put(attribute, attributeValue);
            }
        }
        if (this.exposeSpringMacroHelpers) {
            if (model.containsKey(SPRING_MACRO_REQUEST_CONTEXT_ATTRIBUTE)) {
                throw new ServletException("Cannot expose bind macro helper 'springMacroRequestContext' because of an existing model object of the same name");
            }
            model.put(SPRING_MACRO_REQUEST_CONTEXT_ATTRIBUTE, new RequestContext(request, model));
        }
        this.applyContentType(response);
        this.renderMergedTemplateModel(model, request, response);
    }

    protected void applyContentType(HttpServletResponse response) {
        if (!responseGetContentTypeAvailable || response.getContentType() == null) {
            response.setContentType(this.getContentType());
        }
    }

    protected abstract void renderMergedTemplateModel(Map var1, HttpServletRequest var2, HttpServletResponse var3) throws Exception;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            (class$javax$servlet$ServletResponse == null ? (class$javax$servlet$ServletResponse = AbstractTemplateView.class$("javax.servlet.ServletResponse")) : class$javax$servlet$ServletResponse).getMethod("getContentType", new Class[0]);
            responseGetContentTypeAvailable = true;
        }
        catch (NoSuchMethodException ex) {
            responseGetContentTypeAvailable = false;
        }
    }
}

