/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.transaction.support;

import com.bmc.thirdparty.org.springframework.transaction.NestedTransactionNotSupportedException;
import com.bmc.thirdparty.org.springframework.transaction.SavepointManager;
import com.bmc.thirdparty.org.springframework.transaction.support.AbstractTransactionStatus;
import com.bmc.thirdparty.org.springframework.transaction.support.SmartTransactionObject;

public class DefaultTransactionStatus
extends AbstractTransactionStatus {
    private final Object transaction;
    private final boolean newTransaction;
    private final boolean newSynchronization;
    private final boolean readOnly;
    private final boolean debug;
    private final Object suspendedResources;

    public DefaultTransactionStatus(Object transaction, boolean newTransaction, boolean newSynchronization, boolean readOnly, boolean debug, Object suspendedResources) {
        this.transaction = transaction;
        this.newTransaction = newTransaction;
        this.newSynchronization = newSynchronization;
        this.readOnly = readOnly;
        this.debug = debug;
        this.suspendedResources = suspendedResources;
    }

    public Object getTransaction() {
        return this.transaction;
    }

    public boolean hasTransaction() {
        return this.transaction != null;
    }

    public boolean isNewTransaction() {
        return this.hasTransaction() && this.newTransaction;
    }

    public boolean isNewSynchronization() {
        return this.newSynchronization;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public Object getSuspendedResources() {
        return this.suspendedResources;
    }

    public boolean isGlobalRollbackOnly() {
        return this.transaction instanceof SmartTransactionObject && ((SmartTransactionObject)this.transaction).isRollbackOnly();
    }

    protected SavepointManager getSavepointManager() {
        if (!this.isTransactionSavepointManager()) {
            throw new NestedTransactionNotSupportedException("Transaction object [" + this.getTransaction() + "] does not support savepoints");
        }
        return (SavepointManager)this.getTransaction();
    }

    public boolean isTransactionSavepointManager() {
        return this.getTransaction() instanceof SavepointManager;
    }
}

