/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.ejb.access;

import com.bmc.thirdparty.org.aopalliance.intercept.MethodInterceptor;
import com.bmc.thirdparty.org.springframework.ejb.access.EjbAccessException;
import com.bmc.thirdparty.org.springframework.jndi.JndiObjectLocator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.NamingException;

public abstract class AbstractSlsbInvokerInterceptor
extends JndiObjectLocator
implements MethodInterceptor {
    private boolean lookupHomeOnStartup = true;
    private boolean cacheHome = true;
    private Object cachedHome;
    private Method createMethod;
    private final Object homeMonitor = new Object();

    public void setLookupHomeOnStartup(boolean lookupHomeOnStartup) {
        this.lookupHomeOnStartup = lookupHomeOnStartup;
    }

    public void setCacheHome(boolean cacheHome) {
        this.cacheHome = cacheHome;
    }

    public void afterPropertiesSet() throws NamingException {
        super.afterPropertiesSet();
        if (this.lookupHomeOnStartup) {
            this.refreshHome();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshHome() throws NamingException {
        Object object = this.homeMonitor;
        synchronized (object) {
            Object home = this.lookup();
            if (this.cacheHome) {
                this.cachedHome = home;
                this.createMethod = this.getCreateMethod(home);
            }
        }
    }

    protected Method getCreateMethod(Object home) throws EjbAccessException {
        try {
            return home.getClass().getMethod("create", null);
        }
        catch (NoSuchMethodException ex) {
            throw new EjbAccessException("EJB home [" + home + "] has no no-arg create() method");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getHome() throws NamingException {
        if (!this.cacheHome || this.lookupHomeOnStartup && !this.isHomeRefreshable()) {
            return this.cachedHome != null ? this.cachedHome : this.lookup();
        }
        Object object = this.homeMonitor;
        synchronized (object) {
            if (this.cachedHome == null) {
                this.cachedHome = this.lookup();
                this.createMethod = this.getCreateMethod(this.cachedHome);
            }
            return this.cachedHome;
        }
    }

    protected boolean isHomeRefreshable() {
        return false;
    }

    protected Object create() throws NamingException, InvocationTargetException {
        try {
            Object home = this.getHome();
            Method createMethodToUse = this.createMethod;
            if (createMethodToUse == null) {
                createMethodToUse = this.getCreateMethod(home);
            }
            return createMethodToUse.invoke(home, (Object[])null);
        }
        catch (IllegalAccessException ex) {
            throw new EjbAccessException("Could not access EJB home create() method", ex);
        }
    }
}

