/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.core.enums;

import com.bmc.thirdparty.org.springframework.core.enums.AbstractCachingLabeledEnumResolver;
import com.bmc.thirdparty.org.springframework.core.enums.LabeledEnum;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.TreeSet;

public class StaticLabeledEnumResolver
extends AbstractCachingLabeledEnumResolver {
    private static final StaticLabeledEnumResolver INSTANCE = new StaticLabeledEnumResolver();

    public static StaticLabeledEnumResolver instance() {
        return INSTANCE;
    }

    protected Set findLabeledEnums(Class type) {
        TreeSet<Object> typeEnums = new TreeSet<Object>();
        Field[] fields = type.getFields();
        for (int i2 = 0; i2 < fields.length; ++i2) {
            Field field = fields[i2];
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !type.isAssignableFrom(field.getType())) continue;
            try {
                Object value = field.get(null);
                Assert.isTrue(value instanceof LabeledEnum, "Field value must be a LabeledEnum instance");
                typeEnums.add(value);
                continue;
            }
            catch (IllegalAccessException e2) {
                this.logger.warn("Unable to access field value " + field, e2);
            }
        }
        return typeEnums;
    }
}

