/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.apache.commons.configuration;

import com.bmc.thirdparty.org.apache.commons.collections.Predicate;
import com.bmc.thirdparty.org.apache.commons.collections.iterators.FilterIterator;
import com.bmc.thirdparty.org.apache.commons.configuration.Configuration;
import com.bmc.thirdparty.org.apache.commons.configuration.ConversionException;
import com.bmc.thirdparty.org.apache.commons.configuration.PropertyConverter;
import com.bmc.thirdparty.org.apache.commons.configuration.SubsetConfiguration;
import com.bmc.thirdparty.org.apache.commons.configuration.event.EventSource;
import com.bmc.thirdparty.org.apache.commons.lang.BooleanUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;

public abstract class AbstractConfiguration
extends EventSource
implements Configuration {
    public static final int EVENT_ADD_PROPERTY = 1;
    public static final int EVENT_CLEAR_PROPERTY = 2;
    public static final int EVENT_SET_PROPERTY = 3;
    public static final int EVENT_CLEAR = 4;
    protected static final String START_TOKEN = "${";
    protected static final String END_TOKEN = "}";
    private static char defaultListDelimiter = (char)44;
    private char listDelimiter = defaultListDelimiter;
    private boolean delimiterParsingDisabled;
    private boolean throwExceptionOnMissing;

    public static void setDefaultListDelimiter(char delimiter) {
        defaultListDelimiter = delimiter;
    }

    public static void setDelimiter(char delimiter) {
        AbstractConfiguration.setDefaultListDelimiter(delimiter);
    }

    public static char getDefaultListDelimiter() {
        return defaultListDelimiter;
    }

    public static char getDelimiter() {
        return AbstractConfiguration.getDefaultListDelimiter();
    }

    public void setListDelimiter(char listDelimiter) {
        this.listDelimiter = listDelimiter;
    }

    public char getListDelimiter() {
        return this.listDelimiter;
    }

    public boolean isDelimiterParsingDisabled() {
        return this.delimiterParsingDisabled;
    }

    public void setDelimiterParsingDisabled(boolean delimiterParsingDisabled) {
        this.delimiterParsingDisabled = delimiterParsingDisabled;
    }

    public void setThrowExceptionOnMissing(boolean throwExceptionOnMissing) {
        this.throwExceptionOnMissing = throwExceptionOnMissing;
    }

    public boolean isThrowExceptionOnMissing() {
        return this.throwExceptionOnMissing;
    }

    public void addProperty(String key, Object value) {
        this.fireEvent(1, key, value, true);
        if (!this.isDelimiterParsingDisabled()) {
            Iterator it = PropertyConverter.toIterator(value, this.getListDelimiter());
            while (it.hasNext()) {
                this.addPropertyDirect(key, it.next());
            }
        } else {
            this.addPropertyDirect(key, value);
        }
        this.fireEvent(1, key, value, false);
    }

    protected abstract void addPropertyDirect(String var1, Object var2);

    protected String interpolate(String base) {
        Object result = this.interpolate((Object)base);
        return result == null ? null : result.toString();
    }

    protected Object interpolate(Object value) {
        return PropertyConverter.interpolate(value, this);
    }

    protected String interpolateHelper(String base, List priorVariables) {
        return base;
    }

    public Configuration subset(String prefix) {
        return new SubsetConfiguration(this, prefix, ".");
    }

    public abstract boolean isEmpty();

    public abstract boolean containsKey(String var1);

    public void setProperty(String key, Object value) {
        this.fireEvent(3, key, value, true);
        this.setDetailEvents(false);
        try {
            this.clearProperty(key);
            this.addProperty(key, value);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.setDetailEvents(true);
            throw throwable;
        }
        this.setDetailEvents(true);
        this.fireEvent(3, key, value, false);
    }

    public void clearProperty(String key) {
        this.fireEvent(2, key, null, true);
        this.clearPropertyDirect(key);
        this.fireEvent(2, key, null, false);
    }

    protected void clearPropertyDirect(String key) {
    }

    public void clear() {
        this.fireEvent(4, null, null, true);
        this.setDetailEvents(false);
        try {
            Iterator it = this.getKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                it.remove();
                if (!this.containsKey(key)) continue;
                this.clearProperty(key);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.setDetailEvents(true);
            throw throwable;
        }
        this.setDetailEvents(true);
        this.fireEvent(4, null, null, false);
    }

    public abstract Iterator getKeys();

    public Iterator getKeys(final String prefix) {
        return new FilterIterator(this.getKeys(), new Predicate(){

            public boolean evaluate(Object obj) {
                String key = (String)obj;
                return key.startsWith(prefix + ".") || key.equals(prefix);
            }
        });
    }

    public Properties getProperties(String key) {
        return this.getProperties(key, null);
    }

    public Properties getProperties(String key, Properties defaults) {
        String[] tokens = this.getStringArray(key);
        Properties props = defaults == null ? new Properties() : new Properties(defaults);
        int i2 = 0;
        while (i2 < tokens.length) {
            String token = tokens[i2];
            int equalSign = token.indexOf(61);
            if (equalSign <= 0) {
                if (tokens.length == 1 && "".equals(token)) break;
                throw new IllegalArgumentException('\'' + token + "' does not contain an equals sign");
            }
            String pkey = token.substring(0, equalSign).trim();
            String pvalue = token.substring(equalSign + 1).trim();
            props.put(pkey, pvalue);
            ++i2;
        }
        return props;
    }

    public boolean getBoolean(String key) {
        Boolean b2 = this.getBoolean(key, null);
        if (b2 != null) {
            return b2;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getBoolean(key, BooleanUtils.toBooleanObject(defaultValue));
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toBoolean(this.interpolate(value));
        }
        catch (ConversionException e2) {
            throw new ConversionException('\'' + key + "' doesn't map to a Boolean object", e2);
        }
    }

    public byte getByte(String key) {
        Byte b2 = this.getByte(key, null);
        if (b2 != null) {
            return b2;
        }
        throw new NoSuchElementException('\'' + key + " doesn't map to an existing object");
    }

    public byte getByte(String key, byte defaultValue) {
        return this.getByte(key, new Byte(defaultValue));
    }

    public Byte getByte(String key, Byte defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toByte(this.interpolate(value));
        }
        catch (ConversionException e2) {
            throw new ConversionException('\'' + key + "' doesn't map to a Byte object", e2);
        }
    }

    public double getDouble(String key) {
        Double d2 = this.getDouble(key, null);
        if (d2 != null) {
            return d2;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public double getDouble(String key, double defaultValue) {
        return this.getDouble(key, new Double(defaultValue));
    }

    public Double getDouble(String key, Double defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toDouble(this.interpolate(value));
        }
        catch (ConversionException e2) {
            throw new ConversionException('\'' + key + "' doesn't map to a Double object", e2);
        }
    }

    public float getFloat(String key) {
        Float f2 = this.getFloat(key, null);
        if (f2 != null) {
            return f2.floatValue();
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public float getFloat(String key, float defaultValue) {
        return this.getFloat(key, new Float(defaultValue)).floatValue();
    }

    public Float getFloat(String key, Float defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toFloat(this.interpolate(value));
        }
        catch (ConversionException e2) {
            throw new ConversionException('\'' + key + "' doesn't map to a Float object", e2);
        }
    }

    public int getInt(String key) {
        Integer i2 = this.getInteger(key, null);
        if (i2 != null) {
            return i2;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public int getInt(String key, int defaultValue) {
        Integer i2 = this.getInteger(key, null);
        if (i2 == null) {
            return defaultValue;
        }
        return i2;
    }

    public Integer getInteger(String key, Integer defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toInteger(this.interpolate(value));
        }
        catch (ConversionException e2) {
            throw new ConversionException('\'' + key + "' doesn't map to an Integer object", e2);
        }
    }

    public long getLong(String key) {
        Long l2 = this.getLong(key, null);
        if (l2 != null) {
            return l2;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public long getLong(String key, long defaultValue) {
        return this.getLong(key, new Long(defaultValue));
    }

    public Long getLong(String key, Long defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toLong(this.interpolate(value));
        }
        catch (ConversionException e2) {
            throw new ConversionException('\'' + key + "' doesn't map to a Long object", e2);
        }
    }

    public short getShort(String key) {
        Short s = this.getShort(key, null);
        if (s != null) {
            return s;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public short getShort(String key, short defaultValue) {
        return this.getShort(key, new Short(defaultValue));
    }

    public Short getShort(String key, Short defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toShort(this.interpolate(value));
        }
        catch (ConversionException e2) {
            throw new ConversionException('\'' + key + "' doesn't map to a Short object", e2);
        }
    }

    public BigDecimal getBigDecimal(String key) {
        BigDecimal number = this.getBigDecimal(key, null);
        if (number != null) {
            return number;
        }
        if (this.isThrowExceptionOnMissing()) {
            throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
        }
        return null;
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toBigDecimal(this.interpolate(value));
        }
        catch (ConversionException e2) {
            throw new ConversionException('\'' + key + "' doesn't map to a BigDecimal object", e2);
        }
    }

    public BigInteger getBigInteger(String key) {
        BigInteger number = this.getBigInteger(key, null);
        if (number != null) {
            return number;
        }
        if (this.isThrowExceptionOnMissing()) {
            throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
        }
        return null;
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toBigInteger(this.interpolate(value));
        }
        catch (ConversionException e2) {
            throw new ConversionException('\'' + key + "' doesn't map to a BigDecimal object", e2);
        }
    }

    public String getString(String key) {
        String s = this.getString(key, null);
        if (s != null) {
            return s;
        }
        if (this.isThrowExceptionOnMissing()) {
            throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
        }
        return null;
    }

    public String getString(String key, String defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value instanceof String) {
            return this.interpolate((String)value);
        }
        if (value == null) {
            return this.interpolate(defaultValue);
        }
        throw new ConversionException('\'' + key + "' doesn't map to a String object");
    }

    public String[] getStringArray(String key) {
        String[] array;
        Object value = this.getProperty(key);
        if (value instanceof String) {
            array = new String[]{this.interpolate((String)value)};
        } else if (value instanceof List) {
            List list = (List)value;
            array = new String[list.size()];
            int i2 = 0;
            while (i2 < array.length) {
                array[i2] = this.interpolate((String)list.get(i2));
                ++i2;
            }
        } else if (value == null) {
            array = new String[]{};
        } else {
            throw new ConversionException('\'' + key + "' doesn't map to a String/List object");
        }
        return array;
    }

    public List getList(String key) {
        return this.getList(key, new ArrayList());
    }

    public List getList(String key, List defaultValue) {
        List<Object> list;
        Object value = this.getProperty(key);
        if (value instanceof String) {
            list = new ArrayList<String>(1);
            list.add(this.interpolate((String)value));
        } else if (value instanceof List) {
            list = new ArrayList();
            List l2 = (List)value;
            Iterator it = l2.iterator();
            while (it.hasNext()) {
                list.add(this.interpolate(it.next()));
            }
        } else if (value == null) {
            list = defaultValue;
        } else {
            throw new ConversionException('\'' + key + "' doesn't map to a List object: " + value + ", a " + value.getClass().getName());
        }
        return list;
    }

    protected Object resolveContainerStore(String key) {
        Object value = this.getProperty(key);
        if (value != null) {
            if (value instanceof List) {
                List list = (List)value;
                value = list.isEmpty() ? null : list.get(0);
            } else if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                value = array.length == 0 ? null : array[0];
            } else if (value instanceof boolean[]) {
                boolean[] array = (boolean[])value;
                value = array.length == 0 ? null : (array[0] ? Boolean.TRUE : Boolean.FALSE);
            } else if (value instanceof byte[]) {
                byte[] array = (byte[])value;
                value = array.length == 0 ? null : new Byte(array[0]);
            } else if (value instanceof short[]) {
                short[] array = (short[])value;
                value = array.length == 0 ? null : new Short(array[0]);
            } else if (value instanceof int[]) {
                int[] array = (int[])value;
                value = array.length == 0 ? null : new Integer(array[0]);
            } else if (value instanceof long[]) {
                long[] array = (long[])value;
                value = array.length == 0 ? null : new Long(array[0]);
            } else if (value instanceof float[]) {
                float[] array = (float[])value;
                value = array.length == 0 ? null : new Float(array[0]);
            } else if (value instanceof double[]) {
                double[] array = (double[])value;
                value = array.length == 0 ? null : new Double(array[0]);
            }
        }
        return value;
    }

    public abstract Object getProperty(String var1);
}

