/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.common;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class DateTimeFormatConverter {
    private static final String FORMAT_SEPARATOR = "%";
    private static final String QUOTE = "'";
    private static final char QUOTE_CHAR = '\'';
    private static final char WIN_AM_PM_CHAR = 't';
    private static final char SIMPLE_DATE_FORMAT_AM_PM_CHAR = 'a';
    private static final String ALTERNATE_MODIFIER_1 = "O";
    private static final String ALTERNATE_MODIFIER_2 = "E";
    private static Map<String, String> conversionMap = new HashMap<String, String>();

    public static String convertFromStrftimeToSimpleDateFormat(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, FORMAT_SEPARATOR, true);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (FORMAT_SEPARATOR.equals(string2)) {
                if (!stringTokenizer.hasMoreElements()) continue;
                String string3 = stringTokenizer.nextToken();
                if (string3.startsWith(ALTERNATE_MODIFIER_1) || string3.startsWith(ALTERNATE_MODIFIER_2)) {
                    if (string3.length() > 1) {
                        string3 = string3.substring(1);
                    } else {
                        stringBuffer.append("'%" + string3 + QUOTE);
                        continue;
                    }
                }
                String string4 = null;
                String string5 = null;
                if (string3.length() > 1) {
                    string4 = string3.substring(0, 1);
                    string5 = string3.substring(1);
                } else {
                    string4 = string3;
                }
                String string6 = conversionMap.get(string4);
                if (string6 != null) {
                    stringBuffer.append(string6);
                } else {
                    stringBuffer.append("'%" + string4 + QUOTE);
                }
                if (string5 == null) continue;
                stringBuffer.append(QUOTE + string5 + QUOTE);
                continue;
            }
            stringBuffer.append(QUOTE + string2 + QUOTE);
        }
        return stringBuffer.toString();
    }

    public static String convertFromWinRegionalToSimapleDateFormat(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\'') {
                bl = !bl;
                stringBuffer.append(c);
                continue;
            }
            if (c == 't' && !bl) {
                stringBuffer.append('a');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String convertFromARDatexxxToSimpleDateFormat(String string) {
        return DateTimeFormatConverter.convertFromStrftimeToSimpleDateFormat(string);
    }

    public static String convertFromARDatexxxToSimpleDateFormatIfValid(String string) {
        String string2 = null;
        string2 = DateTimeFormatConverter.convertFromStrftimeToSimpleDateFormat(string);
        if (string2 != null && !DateTimeFormatConverter.isValidDateFormat(string2)) {
            string2 = null;
        }
        return string2;
    }

    public static boolean isValidDateFormat(String string) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
            simpleDateFormat.format(new Date());
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    static {
        conversionMap.put("a", "EEE");
        conversionMap.put("A", "EEEE");
        conversionMap.put("b", "MMM");
        conversionMap.put("B", "MMMM");
        conversionMap.put("c", "EEE MMM d HH:mm:ss yyyy");
        conversionMap.put("d", "dd");
        conversionMap.put("D", "MM/dd/yy");
        conversionMap.put("e", "dd");
        conversionMap.put("F", "yyyy-MM-dd");
        conversionMap.put("g", "yy");
        conversionMap.put("G", "yyyy");
        conversionMap.put("H", "HH");
        conversionMap.put("h", "MMM");
        conversionMap.put("I", "hh");
        conversionMap.put("j", "DDD");
        conversionMap.put("k", "HH");
        conversionMap.put("l", "hh");
        conversionMap.put("m", "MM");
        conversionMap.put("M", "mm");
        conversionMap.put("n", "\n");
        conversionMap.put("p", "a");
        conversionMap.put("P", "a");
        conversionMap.put("r", "hh:mm:ss a");
        conversionMap.put("R", "HH:mm");
        conversionMap.put("S", "ss");
        conversionMap.put("t", "\t");
        conversionMap.put("T", "HH:mm:ss");
        conversionMap.put("V", "ww");
        conversionMap.put("X", "HH:mm:ss");
        conversionMap.put("x", "MM/dd/yy");
        conversionMap.put("y", "yy");
        conversionMap.put("Y", "yyyy");
        conversionMap.put("Z", "z");
        conversionMap.put("z", "Z");
        conversionMap.put(FORMAT_SEPARATOR, FORMAT_SEPARATOR);
    }
}

