/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.wsdl;

import com.bmc.arsys.ws.mapping.ARSWebService;
import com.bmc.arsys.ws.util.ARWSException;
import com.bmc.arsys.ws.util.WsdlUtil;
import com.bmc.arsys.ws.wsdl.WsdlOperation;
import com.bmc.arsys.ws.wsdl.WsdlPortBindingOperation;
import com.bmc.arsys.ws.wsdl.XMLSchemaParser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPBinding;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlService {
    protected String serviceName = null;
    protected Service service = null;
    protected Map<String, WsdlPortBindingOperation> wsports = null;
    protected String description = null;

    public WsdlService(Service serv) {
        this.service = serv;
        this.serviceName = this.service.getQName().toString();
        this.wsports = new HashMap<String, WsdlPortBindingOperation>();
    }

    public WsdlService() {
        this.wsports = new HashMap<String, WsdlPortBindingOperation>();
    }

    protected Service getService() {
        return this.service;
    }

    protected void setService(Service serv) {
        this.service = serv;
        this.serviceName = this.service.getQName().toString();
    }

    protected Map getPorts() {
        return this.wsports;
    }

    protected void setPorts(HashMap<String, WsdlPortBindingOperation> pts) {
        this.wsports = pts;
    }

    protected void addPort(WsdlPortBindingOperation port) {
        if (this.wsports == null) {
            this.wsports = new HashMap<String, WsdlPortBindingOperation>();
        }
        this.wsports.put(port.getPortName(), port);
    }

    protected WsdlPortBindingOperation getPortByName(String portName) {
        if (portName == null || this.wsports == null) {
            return null;
        }
        return this.wsports.get(portName);
    }

    protected void parseServiceBinding() {
        Node node;
        Element docElement = this.service.getDocumentationElement();
        if (docElement != null && docElement.getLocalName().equals("documentation") && (node = docElement.getFirstChild()) != null && node.getNodeType() == 3) {
            this.description = node.getNodeValue();
        }
        Map ports = this.service.getPorts();
        Iterator j = ports.values().iterator();
        while (j.hasNext()) {
            SOAPBinding soapBinding = null;
            Port port = (Port)j.next();
            WsdlUtil.trace(" Port: " + port.getName());
            Binding binding = port.getBinding();
            WsdlUtil.trace(" Binding: " + binding.getQName());
            List extensibilityList = binding.getExtensibilityElements();
            for (Object obj : extensibilityList) {
                if (!(obj instanceof SOAPBinding)) continue;
                soapBinding = (SOAPBinding)obj;
                break;
            }
            if (soapBinding == null) continue;
            WsdlPortBindingOperation wsPort = new WsdlPortBindingOperation(this.service, port, binding, soapBinding);
            wsPort.parseOperations();
            this.addPort(wsPort);
        }
        if (this.wsports.isEmpty()) {
            throw new ARWSException("INVALID_WSDL", "Cannot find supported SOAP binding");
        }
    }

    public void createMappingDoc(Document mappingDom, String wsdlNamespace, XMLSchemaParser schemaParser, Definition def, StringBuffer warnings) {
        String serviceName = this.service.getQName().getLocalPart();
        String targetNamespace = "";
        Iterator<WsdlPortBindingOperation> iter = this.wsports.values().iterator();
        WsdlPortBindingOperation port2 = null;
        WsdlOperation firstOp = null;
        if (iter.hasNext()) {
            port2 = iter.next();
        }
        if (port2 != null) {
            firstOp = port2.operationsList.get(0);
        }
        if (firstOp != null && firstOp.getUseStyle().equals("encoded")) {
            targetNamespace = firstOp.getInputBody().getNamespaceURI();
        } else if (port2 != null && port2.getBinding() != null) {
            targetNamespace = port2.getBinding().getQName().getNamespaceURI();
        }
        if (targetNamespace == null || targetNamespace.length() == 0) {
            targetNamespace = wsdlNamespace;
        }
        ARSWebService ws = new ARSWebService(serviceName, targetNamespace, this.description);
        for (WsdlPortBindingOperation port2 : this.wsports.values()) {
            port2.createMappingDoc(ws, mappingDom, schemaParser, def, warnings);
        }
        ws.generateXML(mappingDom);
    }
}

