/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.mapping;

import com.bmc.arsys.ws.mapping.ARSPort;
import com.bmc.arsys.ws.util.ARWSException;
import com.bmc.arsys.ws.util.WsdlUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ARSWebService {
    protected LinkedList<ARSPort> portsList = new LinkedList();
    protected HashMap<String, ARSPort> ports = new HashMap();
    protected Element element;
    protected String name;
    protected String targetNamespace;
    protected String description = null;

    public String getName() {
        return this.name;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection getPorts() {
        return this.portsList;
    }

    public ARSWebService(String name, String targetNamespace, String description) {
        this.name = name;
        this.targetNamespace = targetNamespace;
        this.element = null;
        this.description = description;
    }

    public ARSWebService(Element elem) {
        this.element = elem;
        this.parseXML();
    }

    public ARSWebService(ARSWebService oldWs, String schemaUri, StringBuffer warnings) {
        Document doc = WsdlUtil.newDocument();
        doc.appendChild(doc.importNode(oldWs.element, true));
        this.element = doc.getDocumentElement();
        this.parseXML();
    }

    public void parseXML() {
        Element rootElement = this.element;
        if (!rootElement.getLocalName().equals("webservice")) {
            throw new ARWSException("OTHER_ERROR", "ERROR: root element in parseWebServiceInfo should be webservice");
        }
        this.name = rootElement.getAttribute("name");
        if (this.name == null) {
            throw new ARWSException("OTHER_ERROR", "ERROR: webservice should have a name attribute");
        }
        this.targetNamespace = rootElement.getAttribute("targetNamespace");
        this.description = rootElement.getAttribute("description");
        if (this.targetNamespace == null || this.targetNamespace.equals("")) {
            this.targetNamespace = "urn:" + this.name;
        }
        NodeList childNodes = rootElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Element elem;
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1 || !(elem = (Element)node).getLocalName().equals("port")) continue;
            ARSPort port = new ARSPort(elem, this.targetNamespace);
            this.addPort(port);
            if (this.targetNamespace != null) continue;
            this.targetNamespace = port.getTargetNamespace();
        }
    }

    public void addPort(ARSPort port) {
        if (!this.ports.containsKey(port.getName())) {
            this.ports.put(port.getName(), port);
            this.portsList.add(port);
        }
    }

    public Element getElement() {
        return this.element;
    }

    public void generateXML(Document doc) {
        Element serviceElem = doc.createElementNS(null, "webservice");
        serviceElem.setAttributeNS(null, "name", this.getName());
        serviceElem.setAttributeNS(null, "targetNamespace", this.getTargetNamespace());
        if (this.getDescription() != null) {
            serviceElem.setAttributeNS(null, "description", this.getDescription());
        }
        this.element = serviceElem;
        doc.getDocumentElement().appendChild(serviceElem);
        for (ARSPort port : this.getPorts()) {
            port.generateXML(doc, this.element);
        }
    }
}

