/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.plugins;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.StatisticsResultInfo;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.VendorForm;
import com.bmc.arsys.arrpc.ArEsArdbcCancelQuery4In;
import com.bmc.arsys.arrpc.ArEsArdbcCancelQuery4Out;
import com.bmc.arsys.arrpc.ArEsArdbcCommit4In;
import com.bmc.arsys.arrpc.ArEsArdbcCommit4Out;
import com.bmc.arsys.arrpc.ArEsArdbcCreate4In;
import com.bmc.arsys.arrpc.ArEsArdbcCreate4Out;
import com.bmc.arsys.arrpc.ArEsArdbcDelete4In;
import com.bmc.arsys.arrpc.ArEsArdbcDelete4Out;
import com.bmc.arsys.arrpc.ArEsArdbcGet4In;
import com.bmc.arsys.arrpc.ArEsArdbcGet4Out;
import com.bmc.arsys.arrpc.ArEsArdbcGetBlob4In;
import com.bmc.arsys.arrpc.ArEsArdbcGetBlob4Out;
import com.bmc.arsys.arrpc.ArEsArdbcGetEntryStatistics4In;
import com.bmc.arsys.arrpc.ArEsArdbcGetEntryStatistics4Out;
import com.bmc.arsys.arrpc.ArEsArdbcGetListForms4In;
import com.bmc.arsys.arrpc.ArEsArdbcGetListForms4Out;
import com.bmc.arsys.arrpc.ArEsArdbcGetMultipleFields4In;
import com.bmc.arsys.arrpc.ArEsArdbcGetMultipleFields4Out;
import com.bmc.arsys.arrpc.ArEsArdbcGlewf4In;
import com.bmc.arsys.arrpc.ArEsArdbcGlewf4Out;
import com.bmc.arsys.arrpc.ArEsArdbcRollback4In;
import com.bmc.arsys.arrpc.ArEsArdbcRollback4Out;
import com.bmc.arsys.arrpc.ArEsArdbcSet4In;
import com.bmc.arsys.arrpc.ArEsArdbcSet4Out;
import com.bmc.arsys.arrpc.ArEsControlStruct4;
import com.bmc.arsys.arrpc.ArStatusList6;
import com.bmc.arsys.arrpc.ArStatusStruct6;
import com.bmc.arsys.pluginsvr.ARPluginSvrThreadLocalStorageBlock;
import com.bmc.arsys.pluginsvr.mapping.ApiToRpcMapping;
import com.bmc.arsys.pluginsvr.mapping.ArdbcCancelIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcCancelOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcCommitIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcCommitOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcCreateIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcCreateOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcDeleteIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcDeleteOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetBlobIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetBlobOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetEntryStatisticsIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetEntryStatisticsOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetListFormsIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetListFormsOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetMultipleFieldsIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetMultipleFieldsOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGlewfOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGlwefIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcRollbackIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcRollbackOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcSetIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcSetOut;
import com.bmc.arsys.pluginsvr.plugins.ARDBCPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.arsys.pluginsvr.plugins.ARPluginRepository;
import com.bmc.arsys.pluginsvr.plugins.ARVendorField;
import com.bmc.arsys.pluginsvr.plugins.PluginEnvelope;
import com.bmc.arsys.utils.CatalogReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARDBCPluginRepository
extends ARPluginRepository {
    private static Logger LOGGER = Logger.getLogger(ARDBCPluginRepository.class);
    private ConcurrentHashMap<String, PluginEnvelope> mPlugins = new ConcurrentHashMap();

    protected ARDBCPluginRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void addPlugin(String pName, PluginEnvelope pEnvelope) throws ARException {
        assert (pName != null && pEnvelope != null && pEnvelope.mPlugin != null);
        this.mPlugins.put(pName, pEnvelope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ARDBCPluggable getARDBCPlugin(String pName) throws ARException {
        ARDBCPluggable plugin = null;
        PluginEnvelope envelope = this.mPlugins.get(pName);
        if (envelope != null) {
            plugin = (ARDBCPluggable)envelope.mPlugin;
        }
        if (plugin == null) {
            LOGGER.error((Object)CatalogReader.getInstance().getMessage(8755));
            throw new ARException(2, 8755, pName);
        }
        return plugin;
    }

    @Override
    PluginEnvelope getPlugin(String pName) {
        return this.mPlugins.get(pName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ARPluginInfo getARPluginInfo(String pName) throws ARException {
        ARPluginInfo data = null;
        PluginEnvelope envelope = this.mPlugins.get(pName);
        if (envelope != null) {
            data = envelope.mPluginInfo;
        }
        return data;
    }

    public ArEsArdbcCreate4Out ArdbcCreate(ArEsArdbcCreate4In arg1) {
        ArEsArdbcCreate4Out out = new ArEsArdbcCreate4Out();
        String pluginName = ApiToRpcMapping.getInstance().getEncodedString(arg1.getVendorName().value);
        LOGGER.trace((Object)("received createEntry() for plugin: " + pluginName));
        try {
            this.validateClient(arg1.getControl().getPassword());
            ARDBCPluggable plugin = this.getARDBCPlugin(pluginName);
            ArdbcCreateIn in = ApiToRpcMapping.getInstance().fromRPC(arg1, this.getARPluginInfo(pluginName));
            String key = plugin.createEntry(in.getContext(), in.getTableName(), in.getFieldsList(), in.getTransId(), in.getEntry());
            ArdbcCreateOut tempOut = new ArdbcCreateOut(key, (ArEsControlStruct4)arg1.getControl(), null);
            out = ApiToRpcMapping.getInstance().toRPC(tempOut);
        }
        catch (ARException e) {
            LOGGER.error((Object)("createEntry() FAILs in plugin: " + pluginName), (Throwable)e);
            out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(e.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)("createEntry() FAILs in plugin: " + pluginName), e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8753, CatalogReader.getInstance().getMessage(8753), pluginName + " " + e.getLocalizedMessage());
            out.setStatus(status);
        }
        return out;
    }

    public ArEsArdbcGet4Out ArdbcGet(ArEsArdbcGet4In arg1) {
        ArEsArdbcGet4Out out = new ArEsArdbcGet4Out();
        String pluginName = ApiToRpcMapping.getInstance().getEncodedString(arg1.getVendorName().value);
        LOGGER.trace((Object)("received getEntry() for plugin: " + pluginName));
        try {
            this.validateClient(arg1.getControl().getPassword());
            ARDBCPluggable plugin = this.getARDBCPlugin(pluginName);
            ArdbcGetIn in = ApiToRpcMapping.getInstance().fromRPC(arg1, this.getARPluginInfo(pluginName));
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("ENTRYID: ArdbcGet calling plug-in " + in.getContext().getPluginInfo().getName() + " plugin.getEntry() with EntryId: " + in.getEntryId()));
            }
            Entry entry = plugin.getEntry(in.getContext(), in.getTableName(), in.getFieldsList(), in.getTransId(), in.getEntryId(), in.getIdList());
            ArdbcGetOut tempOut = new ArdbcGetOut(entry, (ArEsControlStruct4)arg1.getControl(), null);
            out = ApiToRpcMapping.getInstance().toRPC(tempOut);
        }
        catch (ARException e) {
            LOGGER.error((Object)("getEntry() FAILs in plugin: " + pluginName), (Throwable)e);
            out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(e.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)("getEntry() FAILs in plugin: " + pluginName), e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8753, CatalogReader.getInstance().getMessage(8753), pluginName + " " + e.getLocalizedMessage());
            out.setStatus(status);
        }
        return out;
    }

    public ArEsArdbcSet4Out ArdbcSet(ArEsArdbcSet4In arg1) {
        ArEsArdbcSet4Out out = new ArEsArdbcSet4Out();
        String pluginName = ApiToRpcMapping.getInstance().getEncodedString(arg1.getVendorName().value);
        LOGGER.trace((Object)("received setEntry() for plugin: " + pluginName));
        try {
            this.validateClient(arg1.getControl().getPassword());
            ARDBCPluggable plugin = this.getARDBCPlugin(pluginName);
            ArdbcSetIn in = ApiToRpcMapping.getInstance().fromRPC(arg1, this.getARPluginInfo(pluginName));
            plugin.setEntry(in.getContext(), in.getTableName(), in.getFieldsList(), in.getTransId(), in.getEntryId(), in.getEntry(), in.getTimestamp());
            ArdbcSetOut tempOut = new ArdbcSetOut((ArEsControlStruct4)arg1.getControl(), null);
            out = ApiToRpcMapping.getInstance().toRPC(tempOut);
        }
        catch (ARException e) {
            LOGGER.error((Object)("setEntry() FAILs in plugin: " + pluginName), (Throwable)e);
            out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(e.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)("setEntry() FAILs in plugin: " + pluginName), e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8753, CatalogReader.getInstance().getMessage(8753), pluginName + " " + e.getLocalizedMessage());
            out.setStatus(status);
        }
        return out;
    }

    public ArEsArdbcDelete4Out ArdbcDelete(ArEsArdbcDelete4In arg1) {
        ArEsArdbcDelete4Out out = new ArEsArdbcDelete4Out();
        String pluginName = ApiToRpcMapping.getInstance().getEncodedString(arg1.getVendorName().value);
        LOGGER.trace((Object)("received deleteEntry() for plugin: " + pluginName));
        try {
            this.validateClient(arg1.getControl().getPassword());
            ARDBCPluggable plugin = this.getARDBCPlugin(pluginName);
            ArdbcDeleteIn in = ApiToRpcMapping.getInstance().fromRPC(arg1, this.getARPluginInfo(pluginName));
            plugin.deleteEntry(in.getContext(), in.getTableName(), in.getFieldsList(), in.getTransId(), in.getEntryId());
            ArdbcDeleteOut tempOut = new ArdbcDeleteOut((ArEsControlStruct4)arg1.getControl(), null);
            out = ApiToRpcMapping.getInstance().toRPC(tempOut);
        }
        catch (ARException e) {
            LOGGER.error((Object)("deleteEntry() FAILs in plugin: " + pluginName), (Throwable)e);
            out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(e.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)("deleteEntry() FAILs in plugin: " + pluginName), e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8753, CatalogReader.getInstance().getMessage(8753), pluginName + " " + e.getLocalizedMessage());
            out.setStatus(status);
        }
        return out;
    }

    public ArEsArdbcGetBlob4Out ArdbcGetBlob(ArEsArdbcGetBlob4In arg1) {
        ArEsArdbcGetBlob4Out out = new ArEsArdbcGetBlob4Out();
        String pluginName = ApiToRpcMapping.getInstance().getEncodedString(arg1.getVendorName().value);
        LOGGER.trace((Object)("received getBlob() for plugin: " + pluginName));
        try {
            this.validateClient(arg1.getControl().getPassword());
            ARDBCPluggable plugin = this.getARDBCPlugin(pluginName);
            ArdbcGetBlobIn in = ApiToRpcMapping.getInstance().fromRPC(arg1, this.getARPluginInfo(pluginName));
            AttachmentValue info = plugin.getBLOB(in.getContext(), in.getTableName(), in.getFieldsList(), in.getTransId(), in.getEntryId(), in.getFieldId());
            ArdbcGetBlobOut tempOut = new ArdbcGetBlobOut(info, (ArEsControlStruct4)arg1.getControl(), null);
            out = ApiToRpcMapping.getInstance().toRPC(tempOut);
        }
        catch (ARException e) {
            LOGGER.error((Object)("getBlob() FAILs in plugin: " + pluginName), (Throwable)e);
            out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(e.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)("getBlob() FAILs in plugin: " + pluginName), e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8753, CatalogReader.getInstance().getMessage(8753), pluginName + " " + e.getLocalizedMessage());
            out.setStatus(status);
        }
        return out;
    }

    public ArEsArdbcGlewf4Out ArdbcGlewf(ArEsArdbcGlewf4In arg1) {
        ArEsArdbcGlewf4Out out = new ArEsArdbcGlewf4Out();
        String pluginName = ApiToRpcMapping.getInstance().getEncodedString(arg1.getVendorName().value);
        LOGGER.trace((Object)("received getListEntryWithFields() for plugin: " + pluginName));
        try {
            this.validateClient(arg1.getControl().getPassword());
            ARDBCPluggable plugin = this.getARDBCPlugin(pluginName);
            ARPluginInfo info = this.getARPluginInfo(pluginName);
            ArdbcGlwefIn in = ApiToRpcMapping.getInstance().fromRPC(arg1, info, info.isJavaPlugin());
            List<Entry> entries = plugin.getListEntryWithFields(in.getContext(), in.getTableName(), in.getFieldsList(), in.getTransId(), in.getQualifier(), in.getSortList(), in.getGetListFields(), in.getStartAt(), in.getMaxRetrieve(), in.getNumMatches());
            ArdbcGlewfOut tempOut = new ArdbcGlewfOut((ArEsControlStruct4)arg1.getControl(), entries, in.getNumMatches(), null);
            out = ApiToRpcMapping.getInstance().toRPC(tempOut);
            if (LOGGER.isTraceEnabled() && entries != null && entries.size() > 0) {
                Iterator<Entry> itr = entries.iterator();
                int total = 10;
                int i = -1;
                String tmp = entries.size() > total ? "; first " + total + " of total " + entries.size() : "; ";
                LOGGER.trace((Object)("ENTRYID: after plugin.getListEntryWithFields() returned from plug-in " + pluginName + tmp + " List<Entry> "));
                while (itr.hasNext() && i++ < total) {
                    LOGGER.trace((Object)("ENTRYID: " + itr.next().getEntryId()));
                    int n = out.entryList.value[i].entryId.value.length;
                    for (int j = 0; j < n; ++j) {
                        String s = new String(out.entryList.value[i].entryId.value[j].value, ARPluginSvrThreadLocalStorageBlock.getTLB().getRemoteHostCharSet());
                        LOGGER.trace((Object)("ENTRYID: from rpc split entryId byte[] revert back to String: " + s));
                    }
                }
            }
        }
        catch (ARException e) {
            LOGGER.error((Object)("getListEntryWithFields() FAILs in plugin: " + pluginName), (Throwable)e);
            out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(e.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)("getListEntryWithFields() FAILs in plugin: " + pluginName), e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8753, CatalogReader.getInstance().getMessage(8753), pluginName + " " + e.getLocalizedMessage());
            out.setStatus(status);
        }
        return out;
    }

    public ArEsArdbcCommit4Out ArdbcCommit(ArEsArdbcCommit4In arg1) {
        ArEsArdbcCommit4Out out = new ArEsArdbcCommit4Out();
        String pluginName = ApiToRpcMapping.getInstance().getEncodedString(arg1.getVendorName().value);
        LOGGER.trace((Object)("received commit() for plugin: " + pluginName));
        try {
            this.validateClient(arg1.getControl().getPassword());
            ARDBCPluggable plugin = this.getARDBCPlugin(pluginName);
            ArdbcCommitIn in = ApiToRpcMapping.getInstance().fromRPC(arg1, this.getARPluginInfo(pluginName));
            LOGGER.trace((Object)("mapped fromRpc in, calling commit to plugin: " + pluginName));
            plugin.commit(in.getContext(), in.getTransId());
            LOGGER.trace((Object)("after commit returned from plugin: " + pluginName));
            ArdbcCommitOut tempOut = new ArdbcCommitOut((ArEsControlStruct4)arg1.getControl(), null);
            out = ApiToRpcMapping.getInstance().toRPC(tempOut);
            LOGGER.trace((Object)("after mapping toRpc out for ardbc commit from plugin: " + pluginName));
        }
        catch (ARException e) {
            LOGGER.error((Object)("commit() FAILs in plugin: " + pluginName), (Throwable)e);
            out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(e.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)"commit() FAILs in plugin: ", e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8753, CatalogReader.getInstance().getMessage(8753), pluginName + " " + e.getLocalizedMessage());
            out.setStatus(status);
        }
        return out;
    }

    public ArEsArdbcRollback4Out ArdbcRollback(ArEsArdbcRollback4In arg1) {
        ArEsArdbcRollback4Out out = new ArEsArdbcRollback4Out();
        String pluginName = ApiToRpcMapping.getInstance().getEncodedString(arg1.getVendorName().value);
        LOGGER.trace((Object)("received rollback() for plugin: " + pluginName));
        try {
            this.validateClient(arg1.getControl().getPassword());
            ARDBCPluggable plugin = this.getARDBCPlugin(pluginName);
            ArdbcRollbackIn in = ApiToRpcMapping.getInstance().fromRPC(arg1, this.getARPluginInfo(pluginName));
            plugin.rollback(in.getContext(), in.getTransId());
            ArdbcRollbackOut tempOut = new ArdbcRollbackOut((ArEsControlStruct4)arg1.getControl(), null);
            out = ApiToRpcMapping.getInstance().toRPC(tempOut);
        }
        catch (ARException e) {
            LOGGER.error((Object)("rollback() FAILs in plugin: " + pluginName), (Throwable)e);
            out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(e.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)("rollback() FAILs in plugin: " + pluginName), e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8753, CatalogReader.getInstance().getMessage(8753), pluginName + " " + e.getLocalizedMessage());
            out.setStatus(status);
        }
        return out;
    }

    public ArEsArdbcCancelQuery4Out ArdbcCancelQuery(ArEsArdbcCancelQuery4In arg1) {
        ArEsArdbcCancelQuery4Out out = new ArEsArdbcCancelQuery4Out();
        String pluginName = ApiToRpcMapping.getInstance().getEncodedString(arg1.getVendorName().value);
        LOGGER.trace((Object)("received cancelQuery() for plugin: " + pluginName));
        try {
            this.validateClient(arg1.getControl().getPassword());
            ARDBCPluggable plugin = this.getARDBCPlugin(pluginName);
            ArdbcCancelIn in = ApiToRpcMapping.getInstance().fromRPC(arg1, this.getARPluginInfo(pluginName));
            plugin.cancel(in.getContext(), in.getTransId());
            ArdbcCancelOut tempOut = new ArdbcCancelOut((ArEsControlStruct4)arg1.getControl(), null);
            out = ApiToRpcMapping.getInstance().toRPC(tempOut);
        }
        catch (ARException e) {
            LOGGER.error((Object)("cancelQuery() FAILs in plugin: " + pluginName), (Throwable)e);
            out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(e.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)("cancelQuery() FAILs in plugin: " + pluginName), e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8753, CatalogReader.getInstance().getMessage(8753), pluginName + " " + e.getLocalizedMessage());
            out.setStatus(status);
        }
        return out;
    }

    public ArEsArdbcGetListForms4Out ArdbcGetListForms(ArEsArdbcGetListForms4In arg1) {
        ArEsArdbcGetListForms4Out out = new ArEsArdbcGetListForms4Out();
        ArrayList<VendorForm> allforms = new ArrayList<VendorForm>();
        ArrayList<StatusInfo> allstatus = new ArrayList<StatusInfo>();
        Set keys = this.mPlugins.keySet();
        LOGGER.trace((Object)("received getListForms() for all " + keys.size() + " ardbc plugins on current java plugin server"));
        Iterator iter = keys.iterator();
        String pluginName = "";
        int pluginCnt = 0;
        while (iter.hasNext()) {
            pluginName = (String)iter.next();
            LOGGER.trace((Object)("call getListForms() for plugin " + ++pluginCnt + " " + pluginName));
            try {
                this.validateClient(arg1.getControl().getPassword());
                ARDBCPluggable plugin = this.getARDBCPlugin(pluginName);
                ArdbcGetListFormsIn in = ApiToRpcMapping.getInstance().fromRPC(arg1, this.getARPluginInfo(pluginName));
                List<VendorForm> forms = plugin.getListForms(in.getContext());
                if (forms != null) {
                    allforms.addAll(forms);
                    LOGGER.trace((Object)("Got number of forms: " + (forms != null ? forms.size() : 0) + " from plugin: " + pluginName));
                    if (forms.size() <= 0) continue;
                    LOGGER.trace((Object)("The first form in plug-in " + pluginName + " :"));
                    LOGGER.trace((Object)forms.get(0).toString());
                    continue;
                }
                LOGGER.trace((Object)("getListForms() does not get any form from plugin: " + pluginName));
            }
            catch (ARException e) {
                LOGGER.error((Object)("getListForms() FAILs in plugin: " + pluginName), (Throwable)e);
                allstatus.addAll(e.getLastStatus());
            }
            catch (Throwable e) {
                LOGGER.error((Object)("getListForms() FAILs in plugin: " + pluginName), e);
                StatusInfo status = new StatusInfo(2, 8753L, CatalogReader.getInstance().getMessage(8753), pluginName + " " + e.getLocalizedMessage());
                allstatus.add(status);
            }
        }
        LOGGER.trace((Object)("Converting to ArdbcGetListFormsOut for all " + pluginCnt + " plugins for getListForms() on current plug-in server"));
        ArdbcGetListFormsOut tempOut = new ArdbcGetListFormsOut((ArEsControlStruct4)arg1.getControl(), allforms, allstatus);
        try {
            out = ApiToRpcMapping.getInstance().toRPC(tempOut);
        }
        catch (ARException e) {
            LOGGER.error((Object)"Error occured during the getListForms() plugin call.", (Throwable)e);
            out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(e.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)("getListForms() FAILs in plugin: " + pluginName), e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8753, CatalogReader.getInstance().getMessage(8753), pluginName + " " + e.getLocalizedMessage());
            out.setStatus(status);
        }
        LOGGER.trace((Object)("Done getListForms() for all " + pluginCnt + " plugins on current plug-in server"));
        return out;
    }

    public ArEsArdbcGetMultipleFields4Out ArdbcGetMultipleFields(ArEsArdbcGetMultipleFields4In arg1) {
        ArEsArdbcGetMultipleFields4Out out = new ArEsArdbcGetMultipleFields4Out();
        String pluginName = ApiToRpcMapping.getInstance().getEncodedString(arg1.getVendorName().value);
        LOGGER.trace((Object)("received getMultipleFields() for plugin: " + pluginName));
        try {
            this.validateClient(arg1.getControl().getPassword());
            ARDBCPluggable plugin = this.getARDBCPlugin(pluginName);
            ArdbcGetMultipleFieldsIn in = ApiToRpcMapping.getInstance().fromRPC(arg1, this.getARPluginInfo(pluginName));
            List<ARVendorField> fields = plugin.getMultipleFields(in.getContext(), in.getSchema());
            LOGGER.trace((Object)("Got number of fields:" + (fields != null ? fields.size() : 0) + " from table:" + in.getSchema().getTableName()));
            ArdbcGetMultipleFieldsOut tempOut = new ArdbcGetMultipleFieldsOut((ArEsControlStruct4)arg1.getControl(), fields, null);
            out = ApiToRpcMapping.getInstance().toRPC(tempOut);
        }
        catch (ARException e) {
            LOGGER.error((Object)("getMultipleFields() FAILs in plugin: " + pluginName), (Throwable)e);
            out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(e.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)("getMultipleFields() FAILs in plugin: " + pluginName), e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8753, CatalogReader.getInstance().getMessage(8753), pluginName + " " + e.getLocalizedMessage());
            out.setStatus(status);
        }
        return out;
    }

    public ArEsArdbcGetEntryStatistics4Out ArdbcGetEntryStatistics(ArEsArdbcGetEntryStatistics4In arg1) {
        ArEsArdbcGetEntryStatistics4Out out = new ArEsArdbcGetEntryStatistics4Out();
        String pluginName = ApiToRpcMapping.getInstance().getEncodedString(arg1.getVendorName().value);
        LOGGER.trace((Object)("received getEntryStatistics() for plugin: " + pluginName));
        try {
            this.validateClient(arg1.getControl().getPassword());
            ARDBCPluggable plugin = this.getARDBCPlugin(pluginName);
            ARPluginInfo info = this.getARPluginInfo(pluginName);
            ArdbcGetEntryStatisticsIn in = ApiToRpcMapping.getInstance().fromRPC(arg1, info, info.isJavaPlugin());
            List<StatisticsResultInfo> stats = plugin.getEntryStatistics(in.getContext(), in.getTableName(), in.getFieldsList(), in.getTransId(), in.getQualifier(), in.getTarget(), in.getStatistic(), in.getGroupByList());
            ArdbcGetEntryStatisticsOut tempOut = new ArdbcGetEntryStatisticsOut((ArEsControlStruct4)arg1.getControl(), stats, null);
            out = ApiToRpcMapping.getInstance().toRPC(tempOut);
        }
        catch (ARException e) {
            LOGGER.error((Object)("getEntryStatistics() FAILs in plugin: " + pluginName), (Throwable)e);
            out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(e.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)("getEntryStatistics() FAILs in plugin:  " + pluginName), e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8753, CatalogReader.getInstance().getMessage(8753), pluginName + " " + e.getLocalizedMessage());
            out.setStatus(status);
        }
        return out;
    }

    @Override
    public List<StatusInfo> onEvent(ARPluginContext context, int eventId) {
        ArrayList<StatusInfo> status = new ArrayList<StatusInfo>();
        Collection<PluginEnvelope> plugins = this.mPlugins.values();
        for (PluginEnvelope env : plugins) {
            StringBuilder sb = new StringBuilder();
            try {
                context.setPluginInfo(env.mPluginInfo);
                sb.append(env.mPluginInfo.getName()).append("; version: ").append(env.mPluginInfo.getVersion()).append("; eventId = ").append(eventId);
                LOGGER.debug((Object)("calling " + sb.toString()));
                env.mPlugin.onEvent(context, eventId);
                LOGGER.debug((Object)("finished " + sb.toString()));
            }
            catch (ARException e) {
                status.addAll(e.getLastStatus());
            }
        }
        return status;
    }

    @Override
    void terminatePlugins(ARPluginContext context) {
        Collection<PluginEnvelope> plugins = this.mPlugins.values();
        for (PluginEnvelope env : plugins) {
            StringBuilder sb = new StringBuilder();
            try {
                context.setPluginInfo(env.mPluginInfo);
                sb.append(env.mPluginInfo.getName()).append("; version: ").append(env.mPluginInfo.getVersion()).append("; eventId = ").append("terminate");
                LOGGER.debug((Object)("calling " + sb.toString()));
                env.mPlugin.terminate(context);
                LOGGER.debug((Object)("finished " + sb.toString()));
            }
            catch (ARException e) {
                LOGGER.warn((Object)(CatalogReader.getInstance().getMessage(8794) + env.getPluginName() + " for thread Id: " + Thread.currentThread().getId()), (Throwable)e);
            }
            catch (Throwable e1) {
                LOGGER.error((Object)("got Exception from: " + sb.toString()));
                LOGGER.error((Object)e1.getStackTrace());
            }
        }
    }
}

