/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.binding;

import com.bmc.arsys.arthreadlocal.ARThreadLocalStorable;
import com.bmc.arsys.arthreadlocal.ARThreadLocalStorageBlock;
import com.bmc.arsys.pluginsvr.ARPluginSvrThreadLocalStorageBlock;
import com.bmc.arsys.pluginsvr.legacy.PluginProxy;
import com.bmc.arsys.pluginsvr.plugins.ARPluginLoaderRouter;
import com.bmc.arsys.utils.CatalogReader;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARPluginSvrThreadPoolExecutor
extends ThreadPoolExecutor {
    private static Logger log = Logger.getLogger(ARPluginSvrThreadPoolExecutor.class);
    private static boolean readyForRpcCall;
    private static int prestartedThreadCount;
    private static int prestartInitializedCount;
    private static int skipCount;
    private final ReentrantLock lock = new ReentrantLock();

    public ARPluginSvrThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public ARPluginSvrThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    @Override
    public int prestartAllCoreThreads() {
        prestartedThreadCount = super.prestartAllCoreThreads();
        String msg = "Java plug-in server is initializing all plug-ins for " + prestartedThreadCount + " core threads. Please wait ...";
        if (log.isInfoEnabled()) {
            log.info((Object)msg);
        } else {
            log.warn((Object)("INFO: " + msg));
        }
        System.out.println(msg);
        int i = 0;
        while (i < prestartedThreadCount + skipCount && !readyForRpcCall) {
            this.execute(new Runnable(){

                public void run() {
                }
            });
            if (++i < prestartedThreadCount) continue;
            this.checkSkipCountThread(i);
        }
        return prestartedThreadCount;
    }

    private void checkSkipCountThread(int i) {
        if (i >= prestartedThreadCount + skipCount || i % prestartedThreadCount == 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (skipCount > 0 && i > prestartedThreadCount * 3 && !readyForRpcCall && i % prestartedThreadCount == 0) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            log.warn((Object)("ThreadPoolExecutor initialized " + prestartInitializedCount + " threads to receive RPC calls." + " SkipCount : " + skipCount));
        }
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        boolean flag = ARPluginSvrThreadLocalStorageBlock.isTLBExist();
        if (!flag) {
            log.info((Object)("Will iniPlugins for thread: " + t.getId() + " " + t));
            this.iniPlugins(t);
        } else if (!readyForRpcCall) {
            ++skipCount;
            StringBuilder msg = new StringBuilder();
            msg.append("Same thread: " + t.getId() + " " + t);
            ARPluginLoaderRouter router = ARPluginLoaderRouter.getPluginRouter(t);
            if (router != null) {
                msg.append(" already instantiated.");
            } else {
                msg.append(" skipped");
            }
            log.info((Object)msg.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean iniPlugins(Thread t) {
        boolean flag = true;
        try {
            try {
                ARPluginSvrThreadLocalStorageBlock localVar = new ARPluginSvrThreadLocalStorageBlock();
                localVar.init(t);
                ARThreadLocalStorageBlock.registerTLB((ARThreadLocalStorable)localVar);
                log.info((Object)("Done iniPlugins for thread: " + t.getId()));
            }
            catch (Throwable e) {
                flag = false;
                log.error((Object)CatalogReader.getInstance().getMessage(8790), e);
            }
            try {
                PluginProxy nativeProxy = PluginProxy.getInstance();
                if (nativeProxy != null) {
                    nativeProxy.createInstancesForThread();
                }
            }
            catch (Throwable e) {
                log.error((Object)"Native plugin createInstancesForThread() failed.");
                log.error((Object)CatalogReader.getInstance().getMessage(8790), e);
            }
            Object var5_6 = null;
            if (readyForRpcCall) return flag;
            this.lock.lock();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (readyForRpcCall) throw throwable;
            this.lock.lock();
            try {
                if (readyForRpcCall || prestartedThreadCount != ++prestartInitializedCount) throw throwable;
                try {
                    if (skipCount > 0) {
                        log.info((Object)("Skipped empty runnable: " + skipCount));
                    }
                    String msg = "Java plug-in server has initialized plug-ins for all " + prestartedThreadCount + " core threads. The server is ready to receive RPC calls.";
                    if (log.isInfoEnabled()) {
                        log.info((Object)msg);
                    } else {
                        log.warn((Object)("INFO: " + msg));
                    }
                    System.out.println(msg);
                    throw throwable;
                }
                finally {
                    readyForRpcCall = true;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        try {
            if (readyForRpcCall || prestartedThreadCount != ++prestartInitializedCount) return flag;
            try {
                if (skipCount > 0) {
                    log.info((Object)("Skipped empty runnable: " + skipCount));
                }
                String msg = "Java plug-in server has initialized plug-ins for all " + prestartedThreadCount + " core threads. The server is ready to receive RPC calls.";
                if (log.isInfoEnabled()) {
                    log.info((Object)msg);
                } else {
                    log.warn((Object)("INFO: " + msg));
                }
                System.out.println(msg);
                return flag;
            }
            finally {
                readyForRpcCall = true;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isReadyForRpcCall() {
        return readyForRpcCall;
    }

    @Override
    public void shutdown() {
        this.cleanUp();
        super.shutdown();
    }

    protected void cleanUp() {
        Set<Thread> threads = ARPluginLoaderRouter.getAllThreads();
        for (Thread t : threads) {
            if (!t.isAlive()) continue;
            try {
                ARPluginLoaderRouter lr = ARPluginLoaderRouter.getPluginRouter(t);
                if (lr == null) continue;
                lr.cleanUpPlugins();
            }
            catch (Throwable e) {
                log.debug((Object)("Clean up plugins for thread " + t.getId()));
                log.error((Object)CatalogReader.getInstance().getMessage(8794), e);
            }
        }
        threads.clear();
        log.info((Object)"Worker thread executor cleaned up routers and plugins.");
        try {
            if (PluginProxy.IsNativeMethodAccessible()) {
                log.info((Object)"clean up native plugins");
                PluginProxy nativeProxy = PluginProxy.getInstance();
                if (nativeProxy != null) {
                    nativeProxy.deleteInstancesForThread();
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)CatalogReader.getInstance().getMessage(8790), e);
        }
    }

    static {
        prestartInitializedCount = 0;
        skipCount = 0;
    }
}

