/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.binding;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.pluginsvr.ARPluginServerConfiguration;
import com.bmc.arsys.pluginsvr.ARPluginServerMain;
import com.bmc.arsys.pluginsvr.legacy.PluginProxy;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginLoaderRouter;
import org.apache.log4j.Logger;

public class ARPluginOnEventHandler
implements Runnable {
    private static Logger log = Logger.getLogger(ARPluginOnEventHandler.class);
    private ARPluginContext context;
    int eventId;

    public ARPluginOnEventHandler(ARPluginContext ctx, int eventId) {
        this.context = ctx;
        this.eventId = eventId;
    }

    public void run() {
        if (this.eventId == 10019) {
            String msg = "Recieved shutdown signal from AR Server." + this.eventId;
            log.info((Object)msg);
            ARPluginServerMain.stopServer(0);
        }
        ARPluginServerConfiguration.getInstance().loadARConfigFile();
        for (Thread t : ARPluginLoaderRouter.getAllThreads()) {
            ARPluginLoaderRouter router = ARPluginLoaderRouter.getPluginRouter(t);
            if (router != null) {
                router.ARDBC.onEvent(this.context, this.eventId);
                router.AREA.onEvent(this.context, this.eventId);
                router.FILTERAPI.onEvent(this.context, this.eventId);
                continue;
            }
            log.error((Object)"PluginRouter is null");
        }
        try {
            PluginProxy nativeProxy = PluginProxy.getInstance();
            if (nativeProxy != null) {
                nativeProxy.onEvent(this.eventId);
            }
        }
        catch (ARException e) {
            log.error((Object)e.getLastStatus());
        }
    }
}

