/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.fts.impl.lucene;

import com.bmc.arsys.fts.FTSService;
import com.bmc.arsys.fts.FTSServiceException;
import com.bmc.arsys.fts.impl.FTSConfiguration;
import com.bmc.arsys.fts.impl.lucene.LuceneFTSService;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.BasicConfigurator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneFTSServiceTest {
    static FTSService service = LuceneFTSService.getLuceneFTSService();
    public static String schemaid;
    public static String fieldID;
    public static String[] field;
    public static String[][] values;
    public static BitSet[] ftsOption;
    public static BitSet[] literalFtsOption;
    private static FTSConfiguration config;

    @BeforeClass
    public static void beforeClass() {
        System.out.println("Lucene FTS Service tests started ");
    }

    @AfterClass
    public static void afterClass() {
        System.out.println("Done with Lucene FTS Service tests ");
    }

    @Before
    public void beforeTest() {
    }

    @Test
    public void testFTSServiceConstructor() {
        System.out.println("--Test creating a new FTS Service.");
        LuceneFTSService service = LuceneFTSService.getLuceneFTSService();
        Assert.assertNotNull((Object)service);
        try {
            service.close();
        }
        catch (FTSServiceException fTSServiceException) {
            // empty catch block
        }
    }

    private FTSConfiguration getConfig() {
        if (config == null) {
            config = new FTSConfiguration();
            config.setFullTextCaseInSensitive(false);
            config.setFullTextCollectionDir("C://Temp//Lucene");
            config.setFullTextConfigurationDir("C://Temp//config");
            config.setFullTextLocale("en");
            config.setFullTextOptimizeThreshold(500);
        }
        return config;
    }

    @Test
    public void testInit() {
        System.out.println("--Test FTS Service init().");
        LuceneFTSService service = LuceneFTSService.getLuceneFTSService();
        try {
            service.init(this.getConfig());
            service.close();
        }
        catch (FTSServiceException fTSServiceException) {
            // empty catch block
        }
    }

    @Test
    public void testIndexEntryFields() {
        System.out.println("--Test FTS Service indexEntryFields. ");
        LuceneFTSService service = LuceneFTSService.getLuceneFTSService();
        service.doLiteral = true;
        service.doLiteralCase = true;
        service.doNormal = true;
        service.doNormalCase = true;
        try {
            service.init(this.getConfig());
            ftsOption[0].set(1);
            literalFtsOption[0].set(1);
            for (int entryId = 0; entryId < values.length; ++entryId) {
                service.indexEntryFields(schemaid, entryId + "", 1.0f, field, values[entryId], ftsOption, null, 1);
            }
            int numDocs = service.getIndexCount();
            Assert.assertEquals((Object)16, (Object)numDocs);
            service.close();
        }
        catch (FTSServiceException fTSServiceException) {
            // empty catch block
        }
    }

    @Test
    public void testLiteralFTS() {
        LuceneFTSService service = LuceneFTSService.getLuceneFTSService();
        try {
            service.init(this.getConfig());
            literalFtsOption[0].clear();
            literalFtsOption[0].set(1);
            System.out.println("\n************************     testLiteralFTS     ********************************");
            List<FTSService.EntryData> entryIdsByQuery = null;
            String searchString = "";
            String[] FieldNames = new String[]{new String(fieldID)};
            searchString = "firewall";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, literalFtsOption);
            this.compareResults(entryIdsByQuery, new String[0], searchString);
            searchString = service.isCaseSensitive() ? "firewall will block AcceSS" : "Firewall will BlocK access";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, literalFtsOption);
            this.compareResults(entryIdsByQuery, new String[]{"2"}, searchString);
            searchString = "%firewall%";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, literalFtsOption);
            this.compareResults(entryIdsByQuery, new String[]{"1", "2", "3", "4", "5", "6", "7"}, searchString);
            searchString = "firewall%";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, literalFtsOption);
            this.compareResults(entryIdsByQuery, new String[]{"1", "2", "3", "4", "5", "7"}, searchString);
            searchString = "blocks";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, literalFtsOption);
            this.compareResults(entryIdsByQuery, new String[0], searchString);
            searchString = "%blocks%";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, literalFtsOption);
            this.compareResults(entryIdsByQuery, new String[]{"1"}, searchString);
            searchString = "%firewall block%";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, literalFtsOption);
            this.compareResults(entryIdsByQuery, new String[]{"1", "3", "4", "6"}, searchString);
            searchString = "user retested";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, literalFtsOption);
            this.compareResults(entryIdsByQuery, new String[]{"14"}, searchString);
            service.close();
        }
        catch (FTSServiceException fTSServiceException) {
            // empty catch block
        }
    }

    @Test
    public void testSimpleFTS() {
        System.out.println("\n************************     testSimpleFTS     ********************************");
        LuceneFTSService service = LuceneFTSService.getLuceneFTSService();
        try {
            service.init(this.getConfig());
            ftsOption[0].clear();
            ftsOption[0].set(0);
            List<FTSService.EntryData> entryIdsByQuery = null;
            String searchString = "";
            String[] FieldNames = new String[]{new String(fieldID)};
            searchString = "%test";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, ftsOption);
            this.compareResults(entryIdsByQuery, new String[]{"9", "10", "13"}, searchString);
            searchString = "%test%";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, ftsOption);
            this.compareResults(entryIdsByQuery, new String[]{"9", "10", "11", "12", "13", "14", "15"}, searchString);
            searchString = "test%";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, ftsOption);
            this.compareResults(entryIdsByQuery, new String[]{"9", "10", "11", "12", "15"}, searchString);
            searchString = "firewall blocked";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, ftsOption);
            this.compareResults(entryIdsByQuery, new String[]{"1", "3", "4", "6"}, searchString);
            searchString = "blocks\\_xxx";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, ftsOption);
            this.compareResults(entryIdsByQuery, new String[]{"1", "2", "3", "4", "5", "6", "8"}, searchString);
            searchString = "%blocks%";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, ftsOption);
            this.compareResults(entryIdsByQuery, new String[]{"1"}, searchString);
            searchString = "blocks%";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, ftsOption);
            this.compareResults(entryIdsByQuery, new String[]{"1"}, searchString);
            searchString = "blocked%";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, ftsOption);
            this.compareResults(entryIdsByQuery, new String[]{"4"}, searchString);
            searchString = "%firewall blocks%";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, ftsOption);
            this.compareResults(entryIdsByQuery, new String[]{"1"}, searchString);
            searchString = "%firewall block";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, ftsOption);
            this.compareResults(entryIdsByQuery, new String[]{"6"}, searchString);
            searchString = "%firewall block%";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, ftsOption);
            this.compareResults(entryIdsByQuery, new String[]{"1", "3", "4", "6"}, searchString);
            searchString = "firewall block%";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, ftsOption);
            this.compareResults(entryIdsByQuery, new String[]{"1", "3", "4", "6"}, searchString);
            searchString = "firewall blocks%";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, ftsOption);
            this.compareResults(entryIdsByQuery, new String[]{"1"}, searchString);
            searchString = "";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, ftsOption);
            System.out.println("search for empty string");
            for (FTSService.EntryData entryData : entryIdsByQuery) {
                System.out.println(entryData.entryId);
            }
            service.close();
        }
        catch (FTSServiceException fTSServiceException) {
            // empty catch block
        }
    }

    @Test
    public void testAccrueFTS() {
        System.out.println("\n************************     testAccrueFTS     ********************************");
        LuceneFTSService service = LuceneFTSService.getLuceneFTSService();
        try {
            service.init(this.getConfig());
            ftsOption[0].clear();
            ftsOption[0].set(0);
            List<FTSService.EntryData> entryIdsByQuery = null;
            String searchString = "";
            String[] FieldNames = new String[]{new String(fieldID)};
            searchString = "firewall,blocking";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, ftsOption);
            this.compareResults(entryIdsByQuery, new String[]{"1", "2", "3", "4", "5", "6", "7", "8"}, searchString);
            searchString = "firewall,blocked%";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, ftsOption);
            this.compareResults(entryIdsByQuery, new String[]{"1", "2", "3", "4", "5", "6", "7"}, searchString);
            service.close();
        }
        catch (FTSServiceException fTSServiceException) {
            // empty catch block
        }
    }

    @Test
    public void testdeleteDocumentsContainingField() {
        System.out.println("--Test FTS Service deleteDocumentsContainingField.");
        LuceneFTSService service = LuceneFTSService.getLuceneFTSService();
        try {
            service.init(this.getConfig());
            List<FTSService.EntryData> entryIdsByQuery = null;
            String searchString = "";
            String[] FieldNames = new String[]{new String("00001")};
            searchString = "try blocking his access";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, ftsOption);
            Assert.assertEquals((Object)1, (Object)entryIdsByQuery.size());
            service.deleteDocumentsContainingField("00001", "try blocking his access");
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, ftsOption);
            Assert.assertEquals((Object)0, (Object)entryIdsByQuery.size());
            service.close();
        }
        catch (FTSServiceException fTSServiceException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteEntryDocument() {
        System.out.println("--Test FTS Service deleteEntryDocument.");
        LuceneFTSService service = LuceneFTSService.getLuceneFTSService();
        try {
            service.init(this.getConfig());
            List<FTSService.EntryData> entryIdsByQuery = null;
            String searchString = "";
            String[] FieldNames = new String[]{new String("entryid")};
            searchString = "1";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, ftsOption);
            Assert.assertEquals((Object)1, (Object)entryIdsByQuery.size());
            service.deleteEntryDocument(schemaid, "1");
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, FieldNames, new String[]{searchString}, ftsOption);
            Assert.assertEquals((Object)0, (Object)entryIdsByQuery.size());
            service.close();
        }
        catch (FTSServiceException fTSServiceException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveFieldFromDocumentsByQuery() {
        System.out.println("--Test FTS Service removeFieldFromDocumentsByQuery.");
        LuceneFTSService service = LuceneFTSService.getLuceneFTSService();
        try {
            service.init(this.getConfig());
            ftsOption[0].clear();
            ftsOption[0].set(0);
            String[] queryFieldNames = new String[]{new String("schemaid")};
            String[] queryFieldValues = new String[]{new String("487")};
            List<FTSService.EntryData> entryIdsByQuery = null;
            String searchString = "%";
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, new String[]{"00001"}, new String[]{"%"}, ftsOption);
            this.compareResults(entryIdsByQuery, new String[]{"0", "2", "3", "4", "5", "6", "7", "9", "10", "11", "12", "13", "14", "15"}, searchString);
            service.removeFieldFromDocumentsByQuery("00001", queryFieldNames, queryFieldValues);
            entryIdsByQuery = service.getEntryIdsByQuery(schemaid, new String[]{"00001"}, new String[]{"%"}, ftsOption);
            this.compareResults(entryIdsByQuery, new String[0], searchString);
            service.close();
        }
        catch (FTSServiceException fTSServiceException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteIndexDir() {
        System.out.println("--Test FTS Service deleteIndexDir.");
        LuceneFTSService service = LuceneFTSService.getLuceneFTSService();
        try {
            service.init(this.getConfig());
            service.deleteIndexDir();
            File directory = new File("C://Temp//Lucene");
            Assert.assertFalse((boolean)directory.exists());
            service.close();
        }
        catch (FTSServiceException fTSServiceException) {
            // empty catch block
        }
    }

    private void compareResults(List<FTSService.EntryData> entryIdsByQuery, String[] expected, String searchString) {
        ArrayList<String> expectedList = new ArrayList<String>();
        ArrayList<String> resultList = new ArrayList<String>();
        System.out.println("search for \"" + searchString + "\"");
        for (FTSService.EntryData entryData : entryIdsByQuery) {
            System.out.println(entryData.entryId);
            resultList.add(entryData.entryId);
        }
        System.out.println();
        for (int i = 0; i < expected.length; ++i) {
            expectedList.add(expected[i]);
        }
        Collections.sort(resultList);
        Collections.sort(expectedList);
        Assert.assertEquals(expectedList, resultList);
    }

    static {
        BasicConfigurator.configure();
        schemaid = "487";
        fieldID = "00001";
        field = new String[]{"00001"};
        values = new String[][]{{"empty string"}, {"firewall blocks access"}, {"firewall will block AcceSS"}, {"firewall blocking my access"}, {"firewall blocked her access"}, {"firewall did not block access"}, {"have the firewall block access"}, {"firewall is not working"}, {"try blocking his access"}, {"super test"}, {"test left"}, {"tested"}, {"tested left"}, {"retest"}, {"user retested"}, {"testcase is"}};
        ftsOption = new BitSet[]{new BitSet(0)};
        literalFtsOption = new BitSet[]{new BitSet(1)};
        config = null;
    }
}

