/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arreporting;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.CurrencyFieldLimit;
import com.bmc.arsys.api.CurrencyValue;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DecimalFieldLimit;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListInfo;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.Form;
import com.bmc.arsys.api.FormCriteria;
import com.bmc.arsys.api.GroupInfo;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RealFieldLimit;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.arreporting.ARDataStructure;
import com.bmc.arsys.arreporting.Aggregation;
import com.bmc.arsys.arreporting.FieldInfo;
import com.bmc.arsys.arreporting.ILogListener;
import com.bmc.arsys.arreporting.ReportConstants;
import com.bmc.arsys.arreporting.ReportParameters;
import com.bmc.arsys.arreporting.ReportType;
import com.bmc.arsys.arreporting.Utilities;
import com.bmc.arsys.arreporting.birt.BIRTReportEngine;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.activity.SemanticException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportDelegator {
    private static final int MAX_AR_COND_OP_CODE = 5;
    private static final int MIN_AR_COND_OP_CODE = 0;
    private static final QualifierInfo reportTypeQualInfo = new QualifierInfo(new RelationalOperationInfo(1, new ArithmeticOrRelationalOperand(2000011), new ArithmeticOrRelationalOperand(new Value("Web"))));
    public static final String ENV_BIRT_TEMP = "BIRT_TEMP";
    private static final int REPORT_SET = 2000017;
    private static final int DESCRIPTION = 8;
    private static final int SERVER = 2000018;
    private static final int REPORT_DEFINITION = 2000012;
    private static final int REPORT_PERMISSION = 112;
    private static final int FORM_NAME = 2000010;
    private static final int REPORT_TYPE = 2000011;
    private static final int REPORT_NAME = 2010005;
    private static final int REPORT_ADHOC = 2010008;
    private static final int REPORT_LOCALE = 160;
    private static final int REPORT_QUERY_OVERRIDE = 2000040;
    private static final int REPORT_VISIBLE_IN_CONSOLE = 2010010;
    private String reportForm = null;
    private BIRTReportEngine birtEngine = null;
    private Properties properties = null;
    private final ILogListener logListener;
    private String tempDir = null;

    public ReportDelegator(Properties properties, ILogListener logListener) {
        this.properties = properties;
        this.logListener = logListener;
        this.tempDir = properties.getProperty("birt.reports.dir");
        if (this.tempDir == null || this.tempDir.length() <= 0) {
            this.tempDir = System.getenv(ENV_BIRT_TEMP);
        }
        if (this.tempDir == null || this.tempDir.length() <= 0) {
            this.tempDir = System.getProperty("java.io.tmpdir");
        }
        if (!this.tempDir.endsWith(System.getProperty("file.separator"))) {
            this.tempDir = this.tempDir + System.getProperty("file.separator");
        }
    }

    public void initializeEngines() throws ARException {
        this.initializeBIRTEngine();
    }

    private void initializeBIRTEngine() throws ARException {
        if (this.birtEngine == null || !this.birtEngine.isInitialized()) {
            this.birtEngine = new BIRTReportEngine(this.properties, this.logListener);
            this.birtEngine.startup();
        }
    }

    public void shutDown() {
        if (this.birtEngine != null) {
            this.birtEngine.shutdown();
        }
    }

    public Properties getEngineProperties(ReportType type) {
        if (ReportType.BIRT.equals((Object)type) && this.birtEngine != null) {
            return this.birtEngine.getEngineProperties();
        }
        return null;
    }

    public String createReport(ARServerUser context, ReportType type, ReportParameters parameters, String fileName, boolean persist) throws ARException {
        String returnValue = null;
        this.validateContext(context);
        if (ReportType.BIRT.equals((Object)type)) {
            this.validateBIRTEngine();
            try {
                List<Field> listFieldObjects = this.getFieldObjects(context, parameters);
                this.validateParameters(parameters, listFieldObjects);
                String locale = parameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_LOCALE_ID.toInt()));
                String primaryEncodedQual = parameters.getEncodedPrimaryQual();
                String secondaryEncodedQual = parameters.getEncodedSecondaryQual();
                String readableQual = "";
                if (primaryEncodedQual != null && !primaryEncodedQual.equals("1=1")) {
                    readableQual = primaryEncodedQual;
                    parameters.getProperties().setProperty("parseEncodedQualToStringPrimary", readableQual);
                }
                if (secondaryEncodedQual != null && secondaryEncodedQual.length() > 0) {
                    String testQual = this.parseEncodedQualToStringUsingDS(context, parameters.getForm(), secondaryEncodedQual, locale);
                    parameters.getProperties().setProperty("parseEncodedQualToStringSecondary", testQual);
                    if (testQual != null && testQual.length() > 0) {
                        if (readableQual != null && readableQual.length() > 0) {
                            readableQual = readableQual + " AND ";
                        }
                        readableQual = readableQual + testQual;
                    }
                }
                if (readableQual.length() > 0) {
                    QualifierInfo qualInfo = Utilities.parseQualification(context, readableQual, parameters.getForm(), locale);
                    String encodedQual = null;
                    if (qualInfo != null) {
                        encodedQual = context.encodeQualification(qualInfo);
                        parameters.getProperties().setProperty("Application-Parse-Qual-L", encodedQual);
                        readableQual = encodedQual;
                        OutputInteger matches = new OutputInteger(0);
                        context.getListEntry(parameters.getForm(), qualInfo, 0, 1, new ArrayList(), new ArrayList(), false, matches);
                    }
                }
                if (readableQual == null || readableQual.length() == 0) {
                    readableQual = "1=1";
                }
                parameters.setQualification(readableQual);
                block11: for (Field field : listFieldObjects) {
                    switch (field.getDataType()) {
                        case 12: {
                            if (field.getFieldLimit() == null || !(field.getFieldLimit() instanceof CurrencyFieldLimit)) break;
                            FieldInfo fieldInfo = parameters.getField(field.getFieldID());
                            if (fieldInfo == null) continue block11;
                            fieldInfo.setPrecision(((CurrencyFieldLimit)field.getFieldLimit()).getPrecision());
                            break;
                        }
                        case 3: {
                            if (field.getFieldLimit() == null || !(field.getFieldLimit() instanceof RealFieldLimit)) break;
                            FieldInfo fieldInfo = parameters.getField(field.getFieldID());
                            if (fieldInfo == null) continue block11;
                            fieldInfo.setPrecision(((RealFieldLimit)field.getFieldLimit()).getPrecision());
                            break;
                        }
                        case 10: {
                            if (field.getFieldLimit() == null || !(field.getFieldLimit() instanceof DecimalFieldLimit)) break;
                            FieldInfo fieldInfo = parameters.getField(field.getFieldID());
                            if (fieldInfo == null) continue block11;
                            fieldInfo.setPrecision(((DecimalFieldLimit)field.getFieldLimit()).getPrecision());
                            break;
                        }
                    }
                }
                this.birtEngine.createReport(context, parameters, fileName);
            }
            catch (SemanticException e) {
                throw new ARException(2, -1, e.getMessage());
            }
            catch (URISyntaxException e) {
                throw new ARException(2, -1, e.getMessage());
            }
            catch (IOException e) {
                throw new ARException(2, -1, e.getMessage());
            }
            catch (DesignFileException e) {
                throw new ARException(2, -1, e.getMessage());
            }
            catch (ParseException e) {
                throw new ARException(2, -1, e.getMessage());
            }
        }
        if (persist) {
            returnValue = this.persistReport(context, type, parameters, fileName);
            File file = new File(fileName);
            if (file.exists()) {
                file.delete();
            }
        }
        return returnValue;
    }

    private void validateParameters(ReportParameters parameters, List<Field> listFieldObjects) throws ARException {
        int seriesFieldId = parameters.getSeriesField();
        block3: for (Field field : listFieldObjects) {
            if (field.getFieldID() != seriesFieldId) continue;
            switch (field.getDataType()) {
                case 2: 
                case 3: 
                case 10: 
                case 12: 
                case 40: {
                    continue block3;
                }
            }
            if (Aggregation.COUNT.equals((Object)parameters.getAggregation())) continue;
            throw new ARException(2, -1, "The supplied series field is of an invalid datatype for the selected aggregation");
        }
    }

    private void addPermissionsToReportEntry(ARServerUser context, ReportParameters parameters, Entry entry) {
        int privacy;
        String privacyvalue = parameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_PRIVACY_ID.toInt()));
        String groups = "";
        if (privacyvalue != null && (privacy = Integer.parseInt(privacyvalue)) == 1) {
            groups = "0;";
            try {
                List groupList = context.getListGroup(context.getUser(), null);
                boolean firsttime = true;
                for (GroupInfo groupInfo : groupList) {
                    if (groupInfo == null) continue;
                    if (firsttime) {
                        groups = groupInfo.getId() + ";";
                        firsttime = false;
                        continue;
                    }
                    groups = groups + groupInfo.getId() + ";";
                }
            }
            catch (ARException arex) {
                // empty catch block
            }
        }
        if (groups != null && groups.length() > 0) {
            entry.put(Integer.valueOf(112), new Value(groups));
        }
    }

    private String persistReport(ARServerUser context, ReportType type, ReportParameters parameters, String fileName) throws ARException {
        String visibleInConsole;
        File file = new File(fileName);
        if (!file.exists()) {
            throw new ARException(2, 3351, "Unable to locate report file");
        }
        Entry entry = new Entry();
        entry.put(Integer.valueOf(2010005), new Value(parameters.getName()));
        entry.put(Integer.valueOf(2000011), new Value(parameters.getType().getName()));
        entry.put(Integer.valueOf(2000010), new Value(parameters.getForm()));
        entry.put(Integer.valueOf(2000018), new Value(Keyword.AR_KEYWORD_SERVER));
        String locale = parameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_LOCALE_ID.toInt()));
        if (locale == null) {
            locale = "";
        }
        if (locale.length() > 0 && !locale.startsWith("en")) {
            if (!locale.startsWith("zh") && !locale.equals("pt_BR")) {
                locale = locale.substring(0, 2);
            }
            entry.put(Integer.valueOf(160), locale != null && locale.length() > 0 ? new Value(locale) : new Value(Keyword.AR_KEYWORD_LOCALE));
        }
        if ((visibleInConsole = parameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_VISIBLE_IN_CONSOLE.toInt()))) != null) {
            entry.put(Integer.valueOf(2010010), new Value(visibleInConsole));
        }
        if (parameters.getDescription() == null || parameters.getDescription().length() == 0) {
            entry.put(Integer.valueOf(8), new Value("Web Report"));
        } else {
            entry.put(Integer.valueOf(8), new Value(parameters.getDescription()));
        }
        if (parameters.getReportSet() == null || parameters.getReportSet().length() == 0) {
            entry.put(Integer.valueOf(2000017), new Value("BIRT Ad-Hoc"));
        } else {
            entry.put(Integer.valueOf(2000017), new Value(parameters.getReportSet()));
        }
        entry.put(Integer.valueOf(7), new Value((Object)2, DataType.ENUM));
        entry.put(Integer.valueOf(2), new Value(context.getUser()));
        entry.put(Integer.valueOf(2000040), new Value((Object)0, DataType.ENUM));
        AttachmentValue attach = new AttachmentValue();
        if (parameters.getName() == null || parameters.getName().length() == 0) {
            attach.setName("Report.rptdesign");
        } else {
            attach.setName(this.makeValidFileName(parameters.getName()) + ".rptdesign");
        }
        attach.setLocationType(1);
        attach.setFilePath(file.getAbsolutePath());
        try {
            attach.setValue(file.getAbsolutePath());
        }
        catch (IOException e) {
            throw new ARException(2, 3351, e.getMessage());
        }
        entry.put(Integer.valueOf(2000012), new Value(attach));
        entry.put(Integer.valueOf(2010008), new Value("1"));
        this.addPermissionsToReportEntry(context, parameters, entry);
        return context.createEntry(this.getReportFormName(context), entry);
    }

    private void validateBIRTEngine() throws ARException {
        if (this.birtEngine == null || !this.birtEngine.isInitialized()) {
            this.initializeBIRTEngine();
        }
    }

    private void validateContext(ARServerUser context) throws ARException {
        if (context == null) {
            throw new ARException(2, 149);
        }
        if (context.getUser() == null || context.getUser().length() == 0) {
            throw new ARException(2, 149);
        }
        if (context.getServer() == null || context.getServer().length() == 0) {
            throw new ARException(2, 150);
        }
    }

    public void deleteReport(ARServerUser context, String reportName) throws ARException {
        this.validateContext(context);
        List listEntry = context.getListEntry(this.getReportFormName(context), this.getReportNameQualification(reportName), 0, 0, null, null, false, null);
        if (listEntry != null && !listEntry.isEmpty()) {
            context.deleteEntry(this.getReportFormName(context), ((EntryListInfo)listEntry.get(0)).getEntryID(), 0);
        }
    }

    private String getReportFormName(ARServerUser context) throws ARException {
        this.validateContext(context);
        if (this.reportForm == null) {
            FormCriteria criteria = new FormCriteria();
            criteria.setPropertiesToRetrieve(FormCriteria.NAME);
            int formType = 1025;
            List formList = context.getListFormObjects(0L, formType, null, new int[]{2010005, 2000011, 2000010}, criteria);
            if (formList.size() > 0) {
                this.reportForm = ((Form)formList.get(0)).getName();
            }
        } else {
            this.reportForm = "Report";
        }
        return this.reportForm;
    }

    private QualifierInfo getReportNameQualification(String reportName) {
        ArithmeticOrRelationalOperand left = new ArithmeticOrRelationalOperand(2010005);
        ArithmeticOrRelationalOperand right = new ArithmeticOrRelationalOperand(new Value(reportName));
        return new QualifierInfo(1, new QualifierInfo(new RelationalOperationInfo(1, left, right)), reportTypeQualInfo);
    }

    public Entry getReportEntry(ARServerUser context, String reportName) throws ARException {
        this.validateContext(context);
        List listEntryObjects = context.getListEntryObjects(this.getReportFormName(context), this.getReportNameQualification(reportName), 0, 0, new ArrayList(), new int[]{2010005, 2000011, 2000012, 2}, false, null);
        if (listEntryObjects != null && !listEntryObjects.isEmpty()) {
            return (Entry)listEntryObjects.get(0);
        }
        return null;
    }

    public Entry getReportEntryByEntryID(ARServerUser context, String entryID) throws ARException {
        this.validateContext(context);
        return context.getEntry(this.getReportFormName(context), entryID, new int[]{2010005, 2000011, 2000012, 2});
    }

    public String getReportType(Entry entry) {
        Value value = (Value)entry.get((Object)2000011);
        if (value != null) {
            return value.getValue().toString();
        }
        return null;
    }

    public String getReportName(Entry entry) {
        Value value = (Value)entry.get((Object)2010005);
        if (value != null) {
            return value.getValue().toString();
        }
        return null;
    }

    public String getSubmitter(Entry entry) {
        Value value = (Value)entry.get((Object)2);
        if (value != null) {
            return value.getValue().toString();
        }
        return "";
    }

    public byte[] getReportData(ARServerUser context, Entry entry) throws ARException {
        this.validateContext(context);
        Value reportDefinition = (Value)entry.get((Object)2000012);
        byte[] data = null;
        if (reportDefinition != null && reportDefinition.getValue() != null && DataType.ATTACHMENT.equals((Object)reportDefinition.getDataType())) {
            AttachmentValue attValue = (AttachmentValue)reportDefinition.getValue();
            if (attValue != null && ((data = attValue.getValue()) == null || data.length == 0)) {
                attValue.setValue(new byte[0]);
                data = context.getEntryBlob(this.getReportFormName(context), entry.getEntryId(), 2000012);
            }
            return data;
        }
        return data;
    }

    private ReportParameters getParameters(ARServerUser context, Entry entry) throws ARException {
        String reportType = this.getReportType(entry);
        if (ReportType.fromName(reportType).equals((Object)ReportType.BIRT)) {
            byte[] data = this.getReportData(context, entry);
            if (data == null) {
                throw new ARException(2, 3356);
            }
            ReportParameters parameters = this.birtEngine.getParameters(data);
            parameters.getProperties().setProperty(Integer.toString(2), this.getSubmitter(entry));
            return parameters;
        }
        return null;
    }

    public ReportParameters getParametersByEntryID(ARServerUser context, String entryID) throws ARException {
        Entry entry = this.getReportEntryByEntryID(context, entryID);
        if (entry != null) {
            return this.getParameters(context, entry);
        }
        return null;
    }

    public ReportParameters getParameters(String fileName) throws ARException {
        try {
            int offset;
            File file = new File(fileName);
            if (!file.exists()) {
                throw new ARException(2, -1, "File name is not valid");
            }
            FileInputStream is = new FileInputStream(file);
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                return null;
            }
            byte[] data = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < data.length && (numRead = ((InputStream)is).read(data, offset, data.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < data.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            ((InputStream)is).close();
            return this.birtEngine.getParameters(data);
        }
        catch (IOException iox) {
            throw new ARException(2, -1, iox.getMessage());
        }
    }

    public ReportParameters getParameters(ARServerUser context, String reportName) throws ARException {
        this.validateContext(context);
        Entry entry = this.getReportEntry(context, reportName);
        if (entry != null) {
            return this.getParameters(context, entry);
        }
        return null;
    }

    public byte[] getReport(ARServerUser context, String reportName) throws ARException {
        AttachmentValue attValue;
        Value value;
        this.validateContext(context);
        Entry reportEntry = this.getReportEntry(context, reportName);
        if (reportEntry != null && (value = (Value)reportEntry.get((Object)2000012)) != null && value.getValue() != null && DataType.ATTACHMENT.equals((Object)value.getDataType()) && (attValue = (AttachmentValue)value.getValue()) != null) {
            attValue.setValue(new byte[0]);
            return context.getEntryBlob(this.getReportFormName(context), reportEntry.getEntryId(), 2000012);
        }
        return null;
    }

    public byte[] getReportByEntryID(ARServerUser context, String entryID) throws ARException {
        AttachmentValue attValue;
        Value value;
        this.validateContext(context);
        Entry reportEntry = context.getEntry(this.getReportFormName(context), entryID, new int[]{2010005, 2000011, 2000012});
        if (reportEntry != null && (value = (Value)reportEntry.get((Object)2000012)) != null && value.getValue() != null && DataType.ATTACHMENT.equals((Object)value.getDataType()) && (attValue = (AttachmentValue)value.getValue()) != null) {
            attValue.setValue(new byte[0]);
            return context.getEntryBlob(this.getReportFormName(context), reportEntry.getEntryId(), 2000012);
        }
        return null;
    }

    public ByteArrayOutputStream runFileReport(ARServerUser context, ReportParameters parameters) throws ARException {
        this.validateContext(context);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        parameters.setQualification(this.convertEncodedQualStr(context, parameters.getForm(), parameters.getQualification()));
        this.birtEngine.runReport(context, parameters, parameters.getReportFile(), (OutputStream)out);
        return out;
    }

    public ByteArrayOutputStream runEntryReport(ARServerUser context, ReportParameters parameters) throws ARException {
        this.validateContext(context);
        byte[] reportDefinition = null;
        if (parameters.getEntryId() != null && parameters.getEntryId().length() > 0) {
            reportDefinition = this.getReportByEntryID(context, parameters.getEntryId());
        }
        if (reportDefinition == null && parameters.getName() != null && parameters.getName().length() > 0) {
            reportDefinition = this.getReport(context, parameters.getName());
        }
        if (reportDefinition != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            parameters.setQualification(this.convertEncodedQualStr(context, parameters.getForm(), parameters.getQualification()));
            this.birtEngine.runReport(context, parameters, reportDefinition, out);
            return out;
        }
        this.logMessage(2, "No report identifier was supplied for runEntryReport");
        throw new ARException(2, 3356, "A report name or entry id must be provided");
    }

    public ByteArrayOutputStream runNewReport(ARServerUser context, ReportParameters parameters) throws ARException {
        if (ReportType.BIRT.equals((Object)parameters.getType())) {
            this.validateContext(context);
            try {
                File tempFile = File.createTempFile(context.getUser(), ".rptdesign");
                tempFile.deleteOnExit();
                String fileName = tempFile.getAbsolutePath();
                this.birtEngine.createReport(context, parameters, fileName);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                parameters.setQualification(this.convertEncodedQualStr(context, parameters.getForm(), parameters.getQualification()));
                this.birtEngine.runReport(context, parameters, fileName, (OutputStream)out);
                return out;
            }
            catch (IOException e) {
                this.logMessage(2, e.getMessage());
                throw new ARException(2, -1, e.getMessage());
            }
            catch (SemanticException e) {
                this.logMessage(2, e.getMessage());
                throw new ARException(2, -1, e.getMessage());
            }
            catch (URISyntaxException e) {
                this.logMessage(2, e.getMessage());
                throw new ARException(2, -1, e.getMessage());
            }
            catch (DesignFileException e) {
                this.logMessage(2, e.getMessage());
                throw new ARException(2, -1, e.getMessage());
            }
        }
        return null;
    }

    public void updateReport(ARServerUser context, String reportName, ReportParameters parameters) throws ARException {
        this.validateContext(context);
        Entry entry = this.getReportEntry(context, reportName);
        if (entry != null) {
            Value value;
            if (parameters.getName() == null) {
                parameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_NAME_ID.toInt()), reportName);
            }
            if ((value = (Value)entry.get((Object)2000011)) != null && value.getDataType().equals((Object)DataType.CHAR) && ReportType.fromName((String)value.getValue()).equals((Object)ReportType.BIRT)) {
                String reportFileName = this.makeValidFileName(reportName);
                String fileName = this.tempDir + reportFileName + ".rptdesign";
                File file = new File(fileName);
                if (file.exists()) {
                    file.delete();
                }
                List<FieldInfo> fields = parameters.getFields();
                boolean fixDataTypes = false;
                for (FieldInfo fieldInfo : fields) {
                    if (fieldInfo.getDataType() != null) continue;
                    fixDataTypes = true;
                    break;
                }
                if (fixDataTypes) {
                    List<Field> listFieldObjects = this.getFieldObjects(context, parameters);
                    for (Field field : listFieldObjects) {
                        FieldInfo fieldInfo = parameters.getField(field.getFieldID());
                        if (fieldInfo == null) continue;
                        fieldInfo.setDataType(DataType.toDataType((int)field.getDataType()));
                    }
                }
                this.createReport(context, ReportType.BIRT, parameters, fileName, false);
                Entry modEntry = new Entry();
                file = new File(fileName);
                AttachmentValue attach = new AttachmentValue();
                if (parameters.getName() == null || parameters.getName().length() == 0) {
                    attach.setName("Report.rptdesign");
                } else {
                    attach.setName(parameters.getName() + ".rptdesign");
                }
                attach.setLocationType(1);
                attach.setFilePath(file.getAbsolutePath());
                try {
                    attach.setValue(file.getAbsolutePath());
                }
                catch (IOException e) {
                    throw new ARException(2, 3351, e.getMessage());
                }
                modEntry.put(Integer.valueOf(2000012), new Value(attach));
                String desc = parameters.getDescription();
                if (desc != null && desc.length() > 0) {
                    modEntry.put(Integer.valueOf(8), new Value(desc));
                }
                this.addPermissionsToReportEntry(context, parameters, modEntry);
                context.setEntry(this.getReportFormName(context), entry.getEntryId(), modEntry, new Timestamp(), 0);
            } else {
                throw new ARException(2, 3356);
            }
        }
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    private String parseEncodedQualToStringUsingDS(ARServerUser context, String form, String encoded, String localeString) throws ARException, ParseException {
        if (encoded == null) {
            return null;
        }
        ArrayList<String> snippetList = new ArrayList<String>();
        ArrayList<String> splitList = ARDataStructure.processAsList(encoded);
        for (int iLoop = 0; iLoop < splitList.size(); ++iLoop) {
            String qualSnippet = (String)splitList.get(iLoop);
            HashMap<String, String> qualMap = ARDataStructure.processAsMap(qualSnippet);
            if (qualMap == null || qualMap.size() <= 0) continue;
            String fieldIdString = (String)qualMap.get("id");
            String relopString = (String)qualMap.get("relop");
            int dtValue = Integer.parseInt((String)qualMap.get("dt"));
            String valueString = (String)qualMap.get("value");
            if (valueString != null && valueString.indexOf("$\\") != -1) {
                dtValue = 1;
            }
            switch (dtValue) {
                case 4: 
                case 6: 
                case 7: 
                case 11: 
                case 13: 
                case 14: {
                    if (valueString == null) break;
                    valueString = "\"" + valueString.trim().replaceAll("\"", "\"\"") + "\"";
                    break;
                }
                case 12: {
                    CurrencyValue currencyValue;
                    if (valueString == null || valueString.length() == 0) {
                        valueString = "$\\NULL$";
                        break;
                    }
                    if ((valueString = valueString.replace("\"\"", "\"")).startsWith("\"") && valueString.endsWith("\"")) {
                        valueString = valueString.substring(1, valueString.length() - 1);
                    }
                    if ((currencyValue = new CurrencyValue(valueString = valueString.trim())).getCurrencyCode() == null || currencyValue.getCurrencyCode().length() <= 0) break;
                    valueString = "\"" + valueString + "\"";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 10: {
                    if (valueString == null) break;
                    valueString = valueString.replace("\"\"", "\"");
                    if (!(valueString = valueString.trim()).startsWith("\"") || !valueString.endsWith("\"")) break;
                    valueString = valueString.substring(1, valueString.length() - 1);
                }
            }
            StringBuffer snippetBuffer = new StringBuffer();
            snippetBuffer.append(" '").append(fieldIdString).append("' ").append(relopString);
            if (valueString != null) {
                snippetBuffer.append(" ").append(valueString);
            }
            if (iLoop < splitList.size() - 1) {
                snippetBuffer.append(" AND ");
            }
            snippetList.add(snippetBuffer.toString());
        }
        StringBuffer fullQual = new StringBuffer();
        for (String snippet : snippetList) {
            if (snippet == null || snippet.length() <= 0) continue;
            fullQual.append(snippet);
        }
        return fullQual.toString();
    }

    private void logMessage(int level, String message) {
        if (this.logListener != null) {
            this.logListener.logMessage(level, message);
        }
    }

    private String convertEncodedQualStr(ARServerUser context, String form, String qual) throws ARException {
        if (this.isEncodedQual(qual)) {
            qual = context.formatQualification(form, (Object)qual);
            return qual;
        }
        return qual;
    }

    private boolean isEncodedQual(String qual) {
        int df;
        return qual != null && qual.length() > 2 && (df = qual.charAt(0) - 48) <= 5 && df >= 0 && qual.charAt(1) == '\\';
    }

    private List<Field> getFieldObjects(ARServerUser context, ReportParameters parameters) throws ARException {
        Object propObj = parameters.getProperties().get("arFieldObjects");
        if (propObj == null || !(propObj instanceof List) || ((List)propObj).isEmpty()) {
            List fieldObjects = context.getListFieldObjects(parameters.getForm(), 1);
            parameters.getProperties().put("arFieldObjects", fieldObjects);
            return fieldObjects;
        }
        return (List)propObj;
    }

    public String makeValidFileName(String fileName) {
        if (fileName == null) {
            return "";
        }
        return fileName.replaceAll("(\\[|#|/|\\\\|\\:|\\*|\\?|\"|<|>|\\||\\]|\\s)+", "_");
    }

    class SnippetInfo {
        QualifierInfo qualification = null;
        int operation = 0;

        SnippetInfo() {
        }

        public QualifierInfo getQualification() {
            return this.qualification;
        }

        public void setQualification(QualifierInfo qual) {
            this.qualification = qual;
        }

        public int getOperation() {
            return this.operation;
        }

        public void setOperation(int operation) {
            this.operation = operation;
        }
    }
}

