/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arreporting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OutputFormat {
    HTML("0", ".html", "text/html"),
    EMBEDDED_HTML("100", ".html", "text/html"),
    PDF("1", ".pdf", "application/pdf"),
    PPT("3", ".ppt", "application/vnd.ms-powerpoint"),
    DOC("2", ".doc", "application/vnd.ms-word"),
    XLS("4", ".xls", "application/vnd.ms-excel");

    private final String propValue;
    private final String extension;
    private final String mimeType;

    private OutputFormat(String propValue, String extension, String mimeType) {
        this.propValue = propValue;
        this.extension = extension;
        this.mimeType = mimeType;
    }

    public String getPropValue() {
        return this.propValue;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public static OutputFormat fromPropValue(String propValue) {
        for (OutputFormat type : OutputFormat.values()) {
            if (!type.propValue.equals(propValue)) continue;
            return type;
        }
        return null;
    }

    public static OutputFormat fromExtension(String extension) {
        for (OutputFormat type : OutputFormat.values()) {
            if (!type.extension.equals(extension)) continue;
            return type;
        }
        return null;
    }

    public static OutputFormat fromMimeType(String mimeType) {
        for (OutputFormat type : OutputFormat.values()) {
            if (!type.mimeType.equals(mimeType)) continue;
            return type;
        }
        return null;
    }
}

