/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.definition;

import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.apiext.definition.DefinitionException;
import com.bmc.arsys.apiext.definition.DefinitionItemData;
import com.bmc.arsys.apiext.definition.DefinitionItemType;
import com.bmc.arsys.apiext.definition.FileContent;
import com.bmc.arsys.apiext.definition.IFileParser;
import com.bmc.arsys.apiext.definition.RelatedType;
import com.bmc.arsys.apiext.definition.Util;
import com.bmc.arsys.apiext.definition.ViewItemData;
import java.io.BufferedReader;
import java.io.IOException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DefinitionFileParser
implements IFileParser {
    boolean abort = false;

    public boolean isAbort() {
        return this.abort;
    }

    public FileContent parseApplications(String string) throws DefinitionException, IOException {
        FileContent fileContent = new FileContent();
        BufferedReader bufferedReader = Util.openFile(string, null);
        String string2 = null;
        int n = 0;
        String string3 = null;
        try {
            while ((string2 = bufferedReader.readLine()) != null && !this.isAbort()) {
                ++n;
                if (!string2.startsWith("begin application")) continue;
                string2 = bufferedReader.readLine();
                string3 = this.new(string2);
                fileContent.addItem(new DefinitionItemData(DefinitionItemType.APPLICATION, string3, RelatedType.FULL));
            }
        }
        catch (Exception exception) {
            throw new DefinitionException("Error encountered while parsing definition file for content", exception.getCause());
        }
        finally {
            bufferedReader.close();
        }
        return fileContent;
    }

    public FileContent parseObjectsInApplication(String string, String string2) throws DefinitionException, IOException {
        FileContent fileContent = new FileContent();
        BufferedReader bufferedReader = Util.openFile(string, null);
        String string3 = null;
        int n = 0;
        String string4 = null;
        boolean bl = false;
        try {
            while ((string3 = bufferedReader.readLine()) != null && !this.isAbort()) {
                ++n;
                if (this.isAbort()) {
                    break;
                }
                if (string3.startsWith("begin application")) {
                    if (bl) {
                        break;
                    }
                    string3 = bufferedReader.readLine();
                    string4 = this.new(string3);
                    if (string4.equals(string2)) {
                        bl = true;
                    }
                }
                if (!bl) continue;
                this.a(string3, bufferedReader, fileContent);
            }
        }
        catch (Exception exception) {
            throw new DefinitionException("Error encountered while parsing definition file for content", exception.getCause());
        }
        finally {
            bufferedReader.close();
        }
        for (DefinitionItemType definitionItemType : fileContent.keySet()) {
            if (!definitionItemType.equals((Object)DefinitionItemType.APPLICATION)) continue;
            fileContent.remove((Object)definitionItemType);
            break;
        }
        return fileContent;
    }

    public FileContent parseObjects(String string) throws DefinitionException, IOException {
        FileContent fileContent = new FileContent();
        BufferedReader bufferedReader = Util.openFile(string, null);
        String string2 = null;
        int n = 0;
        try {
            while ((string2 = bufferedReader.readLine()) != null && !this.isAbort()) {
                ++n;
                this.a(string2, bufferedReader, fileContent);
            }
        }
        catch (Exception exception) {
            throw new DefinitionException("Error encountered while parsing definition file for content", exception.getCause());
        }
        finally {
            bufferedReader.close();
        }
        return fileContent;
    }

    private void a(String string, BufferedReader bufferedReader, FileContent fileContent) throws DefinitionException, IOException {
        if (string.startsWith("begin schema data")) {
            string = bufferedReader.readLine();
            String string2 = this.new(string);
            if (string2 != null) {
                fileContent.addItem(new DefinitionItemData(DefinitionItemType.FORM_DATA, string2, RelatedType.NONE));
            }
        } else if (string.startsWith("begin schema")) {
            DefinitionItemData definitionItemData = null;
            if ((definitionItemData = this.a(DefinitionItemType.FORM, bufferedReader, definitionItemData)) != null) {
                fileContent.addItem(definitionItemData);
            }
        } else if (string.startsWith("begin active link")) {
            DefinitionItemData definitionItemData = null;
            if ((definitionItemData = this.a(DefinitionItemType.ACTIVE_LINK, bufferedReader, definitionItemData)) != null) {
                fileContent.addItem(definitionItemData);
            }
        } else if (string.startsWith("begin char menu")) {
            DefinitionItemData definitionItemData = null;
            if ((definitionItemData = this.a(DefinitionItemType.MENU, bufferedReader, definitionItemData)) != null) {
                fileContent.addItem(definitionItemData);
            }
        } else if (string.startsWith("begin container")) {
            DefinitionItemData definitionItemData = null;
            if ((definitionItemData = this.if(bufferedReader, definitionItemData)) != null) {
                fileContent.addItem(definitionItemData);
            }
        } else if (string.startsWith("begin image")) {
            DefinitionItemData definitionItemData = null;
            if ((definitionItemData = this.a(DefinitionItemType.IMAGE, bufferedReader, definitionItemData)) != null) {
                fileContent.addItem(definitionItemData);
            }
        } else if (string.startsWith("begin distributed mapping")) {
            DefinitionItemData definitionItemData = null;
            if ((definitionItemData = this.a(DefinitionItemType.DISTRIBUTED_MAPPING, bufferedReader, definitionItemData)) != null) {
                fileContent.addItem(definitionItemData);
            }
        } else if (string.startsWith("begin filter")) {
            DefinitionItemData definitionItemData = null;
            if ((definitionItemData = this.a(DefinitionItemType.FILTER, bufferedReader, definitionItemData)) != null) {
                fileContent.addItem(definitionItemData);
            }
        } else if (string.startsWith("begin escalation")) {
            DefinitionItemData definitionItemData = null;
            if ((definitionItemData = this.a(DefinitionItemType.ESCALATION, bufferedReader, definitionItemData)) != null) {
                fileContent.addItem(definitionItemData);
            }
        } else if (string.startsWith("begin distributed pool")) {
            DefinitionItemData definitionItemData = null;
            if ((definitionItemData = this.a(DefinitionItemType.DISTRIBUTED_POOL, bufferedReader, definitionItemData)) != null) {
                fileContent.addItem(definitionItemData);
            }
        } else if (string.startsWith("begin lock block")) {
            StringBuffer stringBuffer = new StringBuffer();
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("  struct-item-list: ")) {
                    stringBuffer.append(string.replace("  struct-item-list: ", ""));
                    bufferedReader.mark(0);
                    continue;
                }
                try {
                    bufferedReader.reset();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.a(stringBuffer, fileContent);
                break;
            }
        } else if (string.startsWith("begin Data Visualization Definition") || string.startsWith("begin Data Visulaization Definition")) {
            DefinitionItemData definitionItemData = null;
            if ((definitionItemData = this.a(bufferedReader, definitionItemData)) != null) {
                fileContent.addItem(definitionItemData);
            }
        }
    }

    private DefinitionItemData a(BufferedReader bufferedReader, DefinitionItemData definitionItemData) throws IOException {
        String string;
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        while ((string = bufferedReader.readLine()) != null && !this.isAbort()) {
            if (string.startsWith("   name           : ")) {
                string2 = this.new(string);
                continue;
            }
            if (string.startsWith("   module         : ")) {
                string3 = this.a(string);
                continue;
            }
            if (string.startsWith("   subtype        : ")) {
                string4 = this.for(string);
                continue;
            }
            if (!string.startsWith("end")) continue;
            bl = true;
            break;
        }
        if (string2 != null && string3 != null && string4 != null && "Flashboard".equals(string3)) {
            if ("FLASHBOARD".equals(string4)) {
                definitionItemData = new DefinitionItemData(DefinitionItemType.FLASHBOARD, string2, RelatedType.NONE);
            } else if ("VARIABLE".equals(string4)) {
                definitionItemData = new DefinitionItemData(DefinitionItemType.FLASHBOARD_VARIABLE, string2, RelatedType.NONE);
            } else if ("ALARM".equals(string4)) {
                definitionItemData = new DefinitionItemData(DefinitionItemType.FLASHBOARD_ALARM, string2, RelatedType.NONE);
            }
        }
        if (definitionItemData.getType() != null) {
            return definitionItemData;
        }
        return null;
    }

    private DefinitionItemData if(BufferedReader bufferedReader, DefinitionItemData definitionItemData) throws IOException {
        String string;
        boolean bl = false;
        boolean bl2 = false;
        while ((string = bufferedReader.readLine()) != null && !this.isAbort()) {
            if (string.startsWith("   name           : ")) {
                bl = true;
                break;
            }
            if (!string.startsWith("end")) continue;
            bl2 = true;
            break;
        }
        String string2 = null;
        if (bl) {
            string2 = this.new(string);
        }
        if (string2 != null) {
            Object var7_7 = null;
            definitionItemData = new DefinitionItemData(null, string2, RelatedType.NONE);
            if (!bl2) {
                bl2 = false;
                block8: while ((string = bufferedReader.readLine()) != null && !this.isAbort()) {
                    if (definitionItemData.getType() == null && string.startsWith("   type           : ")) {
                        String string3 = string.substring("   type           : ".length());
                        int n = Integer.parseInt(string3);
                        switch (n) {
                            case 2: {
                                definitionItemData.setType(DefinitionItemType.APPLICATION);
                                continue block8;
                            }
                            case 4: {
                                definitionItemData.setType(DefinitionItemType.FILTER_GUIDE);
                                continue block8;
                            }
                            case 1: {
                                definitionItemData.setType(DefinitionItemType.ACTIVE_LINK_GUIDE);
                                continue block8;
                            }
                            case 3: {
                                definitionItemData.setType(DefinitionItemType.PACKING_LIST);
                                continue block8;
                            }
                            case 5: {
                                definitionItemData.setType(DefinitionItemType.WEB_SERVICE);
                                continue block8;
                            }
                        }
                        var7_7 = null;
                        continue;
                    }
                    if (string.startsWith("   timestamp      : ")) {
                        definitionItemData.setTimestamp(this.do(string));
                        continue;
                    }
                    if (string.startsWith("   owner          : ")) {
                        definitionItemData.setOwner(this.if(string));
                        continue;
                    }
                    if (string.startsWith("   last-changed   : ")) {
                        definitionItemData.setLastChanged(this.int(string));
                        continue;
                    }
                    if (!string.startsWith("end")) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        if (definitionItemData.getType() != null) {
            return definitionItemData;
        }
        return null;
    }

    private DefinitionItemData a(DefinitionItemType definitionItemType, BufferedReader bufferedReader, DefinitionItemData definitionItemData) throws IOException {
        String string;
        boolean bl = false;
        boolean bl2 = false;
        while ((string = bufferedReader.readLine()) != null && !this.isAbort()) {
            if (string.startsWith("   name           : ")) {
                bl = true;
                break;
            }
            if (!string.startsWith("end")) continue;
            bl2 = true;
            break;
        }
        String string2 = null;
        if (bl) {
            string2 = this.new(string);
        }
        if (string2 != null) {
            definitionItemData = new DefinitionItemData(definitionItemType, string2, RelatedType.NONE);
            if (!bl2) {
                bl2 = false;
                while ((string = bufferedReader.readLine()) != null && !this.isAbort()) {
                    if (string.startsWith("   timestamp      : ")) {
                        definitionItemData.setTimestamp(this.do(string));
                        continue;
                    }
                    if (string.startsWith("   owner          : ")) {
                        definitionItemData.setOwner(this.if(string));
                        continue;
                    }
                    if (string.startsWith("   last-changed   : ")) {
                        definitionItemData.setLastChanged(this.int(string));
                        continue;
                    }
                    if (!string.startsWith("end")) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        return definitionItemData;
    }

    public FileContent parseViews(String string) throws DefinitionException, IOException {
        FileContent fileContent = new FileContent();
        BufferedReader bufferedReader = Util.openFile(string, null);
        String string2 = null;
        int n = 0;
        String string3 = null;
        try {
            while ((string2 = bufferedReader.readLine()) != null && !this.isAbort()) {
                ++n;
                if (string2.startsWith("begin vui")) {
                    string2 = bufferedReader.readLine();
                    string3 = string2.substring("   name           : ".length());
                    continue;
                }
                if (string2.startsWith("vui  {") && string3 != null) {
                    String string4 = bufferedReader.readLine();
                    ++n;
                    String string5 = bufferedReader.readLine();
                    ++n;
                    String string6 = bufferedReader.readLine();
                    ++n;
                    String string7 = bufferedReader.readLine();
                    ++n;
                    String string8 = bufferedReader.readLine();
                    ++n;
                    String string9 = bufferedReader.readLine();
                    ++n;
                    if (string3 == null) continue;
                    ViewItemData viewItemData = new ViewItemData();
                    viewItemData.setName(this.new(string5));
                    viewItemData.setForm(string3);
                    if (string6.startsWith("   label          : ")) {
                        viewItemData.setLabel(string6.replace("   label          : ", ""));
                    }
                    if (string8.startsWith("   vui-locale     : ")) {
                        viewItemData.setLocale(string8.replace("   vui-locale     : ", ""));
                    }
                    if (string9.startsWith("   vui-type       : ")) {
                        viewItemData.setVuiType(Integer.parseInt(string9.replace("   vui-type       : ", "")));
                    }
                    if (string4.startsWith("   id             : ")) {
                        viewItemData.setViewId(Integer.parseInt(string4.replace("   id             : ", "")));
                    }
                    fileContent.addItem(viewItemData);
                    continue;
                }
                if (!string2.startsWith("end")) continue;
                string3 = null;
            }
        }
        catch (Exception exception) {
            throw new DefinitionException("Error encountered while parsing definition file for content", exception.getCause());
        }
        finally {
            bufferedReader.close();
        }
        return fileContent;
    }

    public void setAbort(boolean bl) {
        this.abort = bl;
    }

    private String int(String string) {
        String string2 = null;
        if (string.startsWith("   last-changed   : ")) {
            string2 = string.replace("   last-changed   : ", "");
        }
        return string2;
    }

    private String a(String string) {
        String string2 = null;
        if (string.startsWith("   module         : ")) {
            string2 = string.replace("   module         : ", "");
        }
        return string2;
    }

    private String new(String string) {
        String string2 = null;
        if (string.startsWith("   name           : ")) {
            string2 = string.replace("   name           : ", "");
        }
        return string2;
    }

    private String if(String string) {
        String string2 = null;
        if (string.startsWith("   owner          : ")) {
            string2 = string.replace("   owner          : ", "");
        }
        return string2;
    }

    private String for(String string) {
        String string2 = null;
        if (string.startsWith("   subtype        : ")) {
            string2 = string.replace("   subtype        : ", "");
        }
        return string2;
    }

    private Timestamp do(String string) {
        String string2;
        if (string.startsWith("   timestamp      : ") && (string2 = string.replace("   timestamp      : ", "")) != null) {
            try {
                return new Timestamp(Long.parseLong(string2));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    private void a(StringBuffer stringBuffer, FileContent fileContent) {
        int n;
        if (stringBuffer != null && stringBuffer.length() > 0 && (n = stringBuffer.indexOf("\\")) > -1) {
            stringBuffer.delete(0, n + 1);
            n = stringBuffer.indexOf("\\");
            while (n != -1) {
                int n2 = Integer.parseInt(stringBuffer.substring(0, n));
                int n3 = -1;
                stringBuffer.delete(0, n + 1);
                if (n2 == 12) {
                    n = stringBuffer.indexOf("\\");
                    if (n == -1) break;
                    n3 = Integer.parseInt(stringBuffer.substring(0, n));
                    stringBuffer.delete(0, n + 1);
                }
                if ((n = stringBuffer.indexOf("\\")) == -1) break;
                stringBuffer.delete(0, n + 1);
                int n4 = stringBuffer.indexOf("\\");
                String string = stringBuffer.substring(0, n4);
                stringBuffer.delete(0, n4 + 1);
                DefinitionItemType definitionItemType = DefinitionItemType.fromConstant(n2);
                if (definitionItemType == DefinitionItemType.CONTAINER) {
                    switch (n3) {
                        case 1: {
                            definitionItemType = DefinitionItemType.ACTIVE_LINK_GUIDE;
                            break;
                        }
                        case 2: {
                            definitionItemType = DefinitionItemType.APPLICATION;
                            break;
                        }
                        case 3: {
                            definitionItemType = DefinitionItemType.PACKING_LIST;
                            break;
                        }
                        case 4: {
                            definitionItemType = DefinitionItemType.FILTER_GUIDE;
                            break;
                        }
                        case 5: {
                            definitionItemType = DefinitionItemType.WEB_SERVICE;
                            break;
                        }
                        default: {
                            definitionItemType = null;
                        }
                    }
                }
                if (definitionItemType != null) {
                    DefinitionItemData definitionItemData = new DefinitionItemData(definitionItemType, string, RelatedType.NONE);
                    definitionItemData.setLocked(true);
                    fileContent.addItem(definitionItemData);
                }
                n = stringBuffer.indexOf("\\");
            }
        }
    }
}

