/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.definition;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.FormType;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.ServerInfoMap;
import com.bmc.arsys.api.StructItemInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.apiext.definition.BaseItemData;
import com.bmc.arsys.apiext.definition.DefinitionException;
import com.bmc.arsys.apiext.definition.DefinitionItemData;
import com.bmc.arsys.apiext.definition.DefinitionItemType;
import com.bmc.arsys.apiext.definition.DefinitionOptions;
import com.bmc.arsys.apiext.definition.RelatedType;
import com.bmc.arsys.apiext.definition.ViewItemData;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.SimpleLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CommandLineBase {
    protected static final String CHARSET_TAG = "char-set: ";
    protected static final String ACTLINK_ALL_FLAG = "-A";
    protected static final String ACTLINK_FLAG = "-a";
    protected static final String ALGUIDE_ALL_FLAG = "-G";
    protected static final String ALGUIDE_FLAG = "-g";
    protected static final String APP_INDIVIDUAL_FLAG = "-n";
    protected static final String APP_ALL_FLAG = "-N";
    protected static final String APP_EXPORT_RELATED_FLAG = "-expapp";
    protected static final String APP_IMPORT_RELATED_FLAG = "-impapp";
    protected static final String LOCALES_FLAG = "-loc";
    protected static final String LOCALE_ONLY = "-loconly";
    protected static final String INTEGRATION_FLAG = "-int";
    protected static final String SHARED_WORKFLOW_FLAG = "-shared";
    protected static final String AUTHENTICATION_FLAG = "-w";
    protected static final String DSOMAP_ALL_FLAG = "-D";
    protected static final String DSOMAP_FLAG = "-d";
    protected static final String DSOPOOL_ALL_FLAG = "-B";
    protected static final String DSOPOOL_FLAG = "-b";
    protected static final String ESCAL_ALL_FLAG = "-Q";
    protected static final String ESCAL_FLAG = "-q";
    protected static final String EXPORTFILE_FLAG = "-e";
    protected static final String FILGUIDE_ALL_FLAG = "-H";
    protected static final String FILGUIDE_FLAG = "-h";
    protected static final String FILTER_ALL_FLAG = "-T";
    protected static final String FILTER_FLAG = "-t";
    protected static final String FORM_ALL_FLAG = "-F";
    protected static final String FORM_FLAG = "-f";
    protected static final String IMPORTFILE_FLAG = "-i";
    protected static final String INPLACE = "-inplace";
    protected static final String LOCK = "-lock";
    protected static final String MENU_ALL_FLAG = "-M";
    protected static final String MENU_FLAG = "-m";
    protected static final String PACKLIST_ALL_FLAG = "-K";
    protected static final String PACKLIST_FLAG = "-k";
    protected static final String PASSWORD_FLAG = "-p";
    protected static final String SERVER_FLAG = "-x";
    protected static final String USER_FLAG = "-u";
    protected static final String VERSION = "--version";
    protected static final String WEBSERVICE_ALL_FLAG = "-Z";
    protected static final String WEBSERVICE_FLAG = "-z";
    protected static final String XML_PACKLIST = "-l";
    protected static final String PORT_NUM = "-portnum";
    protected static final String LOG_FILE = "-o";
    protected static final String CHAR_SET = "-charset";
    protected static final String FLASHBOARD_FLAG = "-fb";
    protected static final String FLASHBOARD_ALL_FLAG = "-FB";
    protected static final String FLASHBOARD_ALARM_FLAG = "-fa";
    protected static final String FLASHBOARD_ALARM_ALL_FLAG = "-FA";
    protected static final String FLASHBOARD_VARIABLE_FLAG = "-fv";
    protected static final String FLASHBOARD_VARIABLE_ALL_FLAG = "-FV";
    protected static final String OVERLAY_GROUP = "-og";
    private static final List<String> do = new ArrayList<String>(Arrays.asList("-l", "--version", "-inplace", "-lock", "-Z", "-z", "-T", "-t", "-Q", "-q", "-n", "-N", "-expapp", "-impapp", "-M", "-m", "-K", "-k", "-H", "-h", "-G", "-g", "-F", "-f", "-D", "-d", "-B", "-b", "-A", "-a", "-i", "-e", "-w", "-p", "-u", "-x", "-FA", "-fa", "-FB", "-fb", "-FV", "-fv", "-loc", "-loconly", "-shared", "-int", "-og"));
    protected static final int MODULE_NAME = 41000;
    protected static final int NAME = 41050;
    protected static final int SUB_DEFINITION = 41051;
    protected static final int SUB_TYPE = 41052;
    protected static final int DEFINTION_SMALL = 41053;
    protected static final int APPLICATION = 61001;
    protected String dataVisualizationForm = null;
    protected String dsoPoolForm = null;
    protected String dsoMapForm = null;
    protected static final String FLASHBOARD_TYPE = "FLASHBOARD";
    protected static final String VARIABLE_TYPE = "VARIABLE";
    protected static final String ALARM_TYPE = "ALARM";
    protected static final String FLASHBOARD_MODULE = "Flashboard";
    private static Logger if = Logger.getLogger((String)"com.bmc.arsys.api.definition");
    private DefinitionOptions a = null;

    public DefinitionOptions getOptions() {
        return this.a;
    }

    public String getTypeName(int n) {
        int n2 = n;
        if ((n & 0x40000000) == 0x40000000) {
            n2 = n -= 0x40000001;
        }
        switch (n2) {
            case 1: {
                return "Form";
            }
            case 2: {
                return "Form (User Cache)";
            }
            case 3: {
                return "Form View";
            }
            case 4: {
                return "Mail Template";
            }
            case 5: {
                return "Filter";
            }
            case 6: {
                return "Active Link";
            }
            case 7: {
                return "Admin Extension";
            }
            case 8: {
                return "Menu";
            }
            case 9: {
                return "Escalation";
            }
            case 10: {
                return "Distributed Mapping";
            }
            case 11: {
                return "View (User Cache)";
            }
            case 12: {
                return "Container";
            }
            case 13: {
                return "Distributed Pool";
            }
            case 14: {
                return "View";
            }
            case 15: {
                return "Field";
            }
            case 16: {
                return "Application";
            }
            case 30: {
                return "Form (Data)";
            }
            case 103: {
                return "View (All)";
            }
        }
        return "Object";
    }

    public String getTypeName(DefinitionItemType definitionItemType) {
        switch (definitionItemType) {
            case FORM: {
                return "Form";
            }
            case FORM_DEFN: {
                return "Form (User Cache)";
            }
            case FORM_VIEW: {
                return "Form View";
            }
            case FORM_MAIL: {
                return "Mail Template";
            }
            case FILTER: {
                return "Filter";
            }
            case ACTIVE_LINK: {
                return "Active Link";
            }
            case ADMIN_EXT: {
                return "Admin Extension";
            }
            case MENU: {
                return "Menu";
            }
            case ESCALATION: {
                return "Escalation";
            }
            case DISTRIBUTED_MAPPING: {
                return "Distributed Mapping";
            }
            case FORM_VIEW_MIN: {
                return "View (User Cache)";
            }
            case CONTAINER: {
                return "Container";
            }
            case DISTRIBUTED_POOL: {
                return "Distributed Pool";
            }
            case VIEW: {
                return "View";
            }
            case APPLICATION: {
                return "Application";
            }
            case FORM_DATA: {
                return "Form (Data)";
            }
            case ACTIVE_LINK_GUIDE: {
                return "Active Link Guide";
            }
            case FILTER_GUIDE: {
                return "Filter Guide";
            }
            case FLASHBOARD: {
                return FLASHBOARD_MODULE;
            }
            case FLASHBOARD_ALARM: {
                return "Flashboard Alarm";
            }
            case FLASHBOARD_VARIABLE: {
                return "Flashboard Variable";
            }
            case GROUPS: {
                return "Group";
            }
            case PACKING_LIST: {
                return "Packing List";
            }
            case WEB_SERVICE: {
                return "Web Service";
            }
        }
        return "Object";
    }

    public void setOptions(DefinitionOptions definitionOptions) {
        this.a = definitionOptions;
    }

    private int a(String[] stringArray, int n, List<String> list) {
        int n2 = n;
        for (int i = n; i < stringArray.length; ++i) {
            if (do.contains(stringArray[i])) {
                n2 = i - list.size();
                break;
            }
            list.add(stringArray[i]);
        }
        return n2;
    }

    protected DefinitionOptions parseCommandLine(String[] stringArray) throws DefinitionException {
        DefinitionOptions definitionOptions = new DefinitionOptions();
        int n = 2;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            Iterator iterator;
            String string2 = stringArray[i];
            if (string2.equals(SERVER_FLAG)) {
                definitionOptions.setServer(stringArray[++i]);
                continue;
            }
            if (string2.equals(USER_FLAG)) {
                definitionOptions.setUser(stringArray[++i]);
                continue;
            }
            if (string2.equals(PASSWORD_FLAG)) {
                definitionOptions.setPassword(stringArray[++i]);
                continue;
            }
            if (string2.equals(AUTHENTICATION_FLAG)) {
                definitionOptions.setAuthentication(stringArray[++i]);
                continue;
            }
            if (string2.equals(PORT_NUM)) {
                definitionOptions.setPortNumber(Integer.parseInt(stringArray[++i]));
                continue;
            }
            if (string2.equals(OVERLAY_GROUP)) {
                definitionOptions.setOverlayGroup(stringArray[++i]);
                continue;
            }
            if (string2.equals(EXPORTFILE_FLAG)) {
                if (definitionOptions.getOperation() != DefinitionOptions.Operation.NONE) {
                    throw new DefinitionException("Only one operation is supported.");
                }
                definitionOptions.setOperation(DefinitionOptions.Operation.EXPORT);
                definitionOptions.setFileName(stringArray[++i]);
                continue;
            }
            if (string2.equals(IMPORTFILE_FLAG)) {
                if (definitionOptions.getOperation() != DefinitionOptions.Operation.NONE) {
                    throw new DefinitionException("Only one operation is supported.");
                }
                definitionOptions.setOperation(DefinitionOptions.Operation.IMPORT);
                definitionOptions.setFileName(stringArray[++i]);
                continue;
            }
            if (string2.equals(ACTLINK_FLAG)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ++i;
                i = this.a(stringArray, i, arrayList);
                for (String string3 : arrayList) {
                    definitionOptions.add(DefinitionItemType.ACTIVE_LINK, string3, RelatedType.NONE);
                }
                continue;
            }
            if (string2.equals(ACTLINK_ALL_FLAG)) {
                definitionOptions.setAll(DefinitionItemType.ACTIVE_LINK, true);
                continue;
            }
            if (string2.equals(DSOPOOL_FLAG)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ++i;
                i = this.a(stringArray, i, arrayList);
                for (String string4 : arrayList) {
                    definitionOptions.add(DefinitionItemType.DISTRIBUTED_POOL, string4, RelatedType.NONE);
                }
                continue;
            }
            if (string2.equals(DSOPOOL_ALL_FLAG)) {
                definitionOptions.setAll(DefinitionItemType.DISTRIBUTED_POOL, true);
                continue;
            }
            if (string2.equals(DSOMAP_FLAG)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ++i;
                i = this.a(stringArray, i, arrayList);
                for (String string5 : arrayList) {
                    definitionOptions.add(DefinitionItemType.DISTRIBUTED_MAPPING, string5, RelatedType.NONE);
                }
                continue;
            }
            if (string2.equals(DSOMAP_ALL_FLAG)) {
                definitionOptions.setAll(DefinitionItemType.DISTRIBUTED_MAPPING, true);
                continue;
            }
            if (string2.equals(FORM_FLAG)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ++i;
                i = this.a(stringArray, i, arrayList);
                for (String string6 : arrayList) {
                    definitionOptions.add(DefinitionItemType.FORM, string6, RelatedType.NONE);
                }
                continue;
            }
            if (string2.equals(FORM_ALL_FLAG)) {
                definitionOptions.setAll(DefinitionItemType.FORM, true);
                continue;
            }
            if (string2.equals(ALGUIDE_FLAG)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ++i;
                i = this.a(stringArray, i, arrayList);
                for (String string7 : arrayList) {
                    definitionOptions.add(DefinitionItemType.ACTIVE_LINK_GUIDE, string7, RelatedType.NONE);
                }
                continue;
            }
            if (string2.equals(ALGUIDE_ALL_FLAG)) {
                definitionOptions.setAll(DefinitionItemType.ACTIVE_LINK_GUIDE, true);
                continue;
            }
            if (string2.equals(FILGUIDE_FLAG)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ++i;
                i = this.a(stringArray, i, arrayList);
                for (String string8 : arrayList) {
                    definitionOptions.add(DefinitionItemType.FILTER_GUIDE, string8, RelatedType.NONE);
                }
                continue;
            }
            if (string2.equals(FILGUIDE_ALL_FLAG)) {
                definitionOptions.setAll(DefinitionItemType.FILTER_GUIDE, true);
                continue;
            }
            if (string2.equals("-j")) {
                int n2 = Integer.parseInt(stringArray[++i]);
                iterator = stringArray[++i];
                definitionOptions.add(new DefinitionItemData(DefinitionItemType.ADMIN_EXT, (String)((Object)iterator), RelatedType.NONE, n2));
                continue;
            }
            if (string2.equals("-J")) {
                definitionOptions.setAll(DefinitionItemType.ADMIN_EXT, Boolean.parseBoolean(stringArray[++i]));
                continue;
            }
            if (string2.equals(PACKLIST_FLAG)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ++i;
                i = this.a(stringArray, i, arrayList);
                for (String string9 : arrayList) {
                    definitionOptions.add(DefinitionItemType.PACKING_LIST, string9, RelatedType.NONE);
                }
                continue;
            }
            if (string2.equals(PACKLIST_ALL_FLAG)) {
                definitionOptions.setAll(DefinitionItemType.PACKING_LIST, true);
                continue;
            }
            if (string2.equals(XML_PACKLIST)) {
                definitionOptions.setCommandSetFile(stringArray[++i]);
                continue;
            }
            if (string2.equals(MENU_FLAG)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ++i;
                i = this.a(stringArray, i, arrayList);
                for (String string10 : arrayList) {
                    definitionOptions.add(DefinitionItemType.MENU, string10, RelatedType.NONE);
                }
                continue;
            }
            if (string2.equals(MENU_ALL_FLAG)) {
                definitionOptions.setAll(DefinitionItemType.MENU, true);
                continue;
            }
            if (string2.equals(APP_EXPORT_RELATED_FLAG) || string2.equals(APP_IMPORT_RELATED_FLAG)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ++i;
                i = this.a(stringArray, i, arrayList);
                if (arrayList.size() == 0) {
                    throw new DefinitionException("No Application specified in Application option.");
                }
                for (String string11 : arrayList) {
                    definitionOptions.add(DefinitionItemType.APPLICATION, string11, RelatedType.FULL);
                }
                if (arrayList.size() == 0) continue;
                i += arrayList.size() - 1;
                continue;
            }
            if (string2.equals(APP_INDIVIDUAL_FLAG)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ++i;
                i = this.a(stringArray, i, arrayList);
                if (arrayList.size() == 0) {
                    throw new DefinitionException("No Application specified in Application option.");
                }
                for (String string12 : arrayList) {
                    definitionOptions.add(DefinitionItemType.CONTAINER, string12, RelatedType.NONE);
                }
                if (arrayList.size() == 0) continue;
                i += arrayList.size() - 1;
                continue;
            }
            if (string2.equals(LOCALES_FLAG)) {
                if (!definitionOptions.getItems().containsKey((Object)DefinitionItemType.APPLICATION)) {
                    throw new DefinitionException("Application locale option only valid for Application command.");
                }
                int n3 = definitionOptions.getExportOption();
                if ((n3 & 8) == 8) {
                    throw new DefinitionException("locales cannot be specified with Application integration option.");
                }
                iterator = new ArrayList();
                ++i;
                i = this.a(stringArray, i, (List<String>)((Object)iterator));
                Iterator iterator2 = iterator.iterator();
                while (iterator2.hasNext()) {
                    string = (String)iterator2.next();
                    if (string.equalsIgnoreCase("default")) {
                        if ((n3 & 4) == 4) continue;
                        n3 |= 2;
                        break;
                    }
                    if ((n3 & 2) == 2) continue;
                    n3 |= 4;
                    definitionOptions.addElement(string, definitionOptions.getLastName(DefinitionItemType.APPLICATION));
                }
                if (iterator.size() != 0) {
                    i += iterator.size() - 1;
                }
                definitionOptions.setExportOption(n3);
                continue;
            }
            if (string2.equals(INTEGRATION_FLAG)) {
                if (!definitionOptions.getItems().containsKey((Object)DefinitionItemType.APPLICATION)) {
                    throw new DefinitionException("Application integration option only valid for Application command.");
                }
                int n4 = definitionOptions.getExportOption();
                if ((n4 & 1) == 1) {
                    throw new DefinitionException("Application integration option cannot be selected with shared workflow.");
                }
                if ((n4 & 4) == 4 || (n4 & 2) == 2) {
                    throw new DefinitionException("Application integration option cannot be selected with locales.");
                }
                iterator = new ArrayList();
                ++i;
                i = this.a(stringArray, i, (List<String>)((Object)iterator));
                Iterator iterator3 = iterator.iterator();
                while (iterator3.hasNext()) {
                    string = (String)iterator3.next();
                    definitionOptions.addElement(string, definitionOptions.getLastName(DefinitionItemType.APPLICATION));
                }
                if (iterator.size() != 0) {
                    i += iterator.size() - 1;
                }
                definitionOptions.setExportOption(n4 |= 8);
                continue;
            }
            if (string2.equals(SHARED_WORKFLOW_FLAG)) {
                if (!definitionOptions.getItems().containsKey((Object)DefinitionItemType.APPLICATION)) {
                    throw new DefinitionException("Shared Workflow option only valid for Application command.");
                }
                int n5 = definitionOptions.getExportOption();
                if ((n5 & 8) == 8) {
                    throw new DefinitionException("Shared workflow cannot be selected with Application integration option.");
                }
                if ((n5 & 0x10) == 16) {
                    throw new DefinitionException("Shared workflow cannot be selected with locale only option.");
                }
                definitionOptions.setExportOption(n5 |= 1);
                continue;
            }
            if (string2.equals(LOCALE_ONLY)) {
                if (!definitionOptions.getItems().containsKey((Object)DefinitionItemType.APPLICATION)) {
                    throw new DefinitionException("Application Locale option only valid for Application command.");
                }
                int n6 = definitionOptions.getExportOption();
                if ((n6 & 8) == 8) {
                    throw new DefinitionException("Locale only option cannot be selected with Application integration option.");
                }
                if ((n6 & 1) == 1) {
                    throw new DefinitionException("Locale only option cannot be selected with shared workflow option.");
                }
                definitionOptions.setExportOption(n6 |= 0x10);
                continue;
            }
            if (string2.equals(APP_ALL_FLAG)) {
                definitionOptions.setAll(DefinitionItemType.APPLICATION, false);
                continue;
            }
            if (string2.equals(ESCAL_FLAG)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ++i;
                i = this.a(stringArray, i, arrayList);
                for (String string13 : arrayList) {
                    definitionOptions.add(DefinitionItemType.ESCALATION, string13, RelatedType.NONE);
                }
                continue;
            }
            if (string2.equals(ESCAL_ALL_FLAG)) {
                definitionOptions.setAll(DefinitionItemType.ESCALATION, true);
                continue;
            }
            if (string2.equals(FILTER_FLAG)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ++i;
                i = this.a(stringArray, i, arrayList);
                for (String string14 : arrayList) {
                    definitionOptions.add(DefinitionItemType.FILTER, string14, RelatedType.NONE);
                }
                continue;
            }
            if (string2.equals(FILTER_ALL_FLAG)) {
                definitionOptions.setAll(DefinitionItemType.FILTER, true);
                continue;
            }
            if (string2.equals(WEBSERVICE_FLAG)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ++i;
                i = this.a(stringArray, i, arrayList);
                for (String string15 : arrayList) {
                    definitionOptions.add(DefinitionItemType.WEB_SERVICE, string15, RelatedType.NONE);
                }
                continue;
            }
            if (string2.equals(WEBSERVICE_ALL_FLAG)) {
                definitionOptions.setAll(DefinitionItemType.WEB_SERVICE, true);
                continue;
            }
            if (string2.equals(INPLACE)) {
                definitionOptions.setOverwrite(true);
                continue;
            }
            if (string2.equals(LOCK)) {
                definitionOptions.setLockType(Integer.parseInt(stringArray[++i]));
                definitionOptions.setLockKey(stringArray[++i]);
                continue;
            }
            if (string2.equals(LOG_FILE)) {
                definitionOptions.setLogFile(stringArray[++i]);
                continue;
            }
            if (string2.equals(VERSION)) {
                this.printVersion();
                return null;
            }
            if (string2.equals("-debug")) {
                try {
                    n = Integer.parseInt(stringArray[++i]);
                }
                catch (Exception exception) {
                    n = 2;
                }
                continue;
            }
            if (string2.equals(CHAR_SET)) {
                definitionOptions.setCharset(stringArray[++i]);
                continue;
            }
            if (string2.equals(FLASHBOARD_FLAG)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ++i;
                i = this.a(stringArray, i, arrayList);
                for (String string16 : arrayList) {
                    definitionOptions.add(DefinitionItemType.FLASHBOARD, string16, RelatedType.NONE);
                }
                continue;
            }
            if (string2.equals(FLASHBOARD_ALL_FLAG)) {
                definitionOptions.setAll(DefinitionItemType.FLASHBOARD, true);
                continue;
            }
            if (string2.equals(FLASHBOARD_VARIABLE_FLAG)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ++i;
                i = this.a(stringArray, i, arrayList);
                for (String string17 : arrayList) {
                    definitionOptions.add(DefinitionItemType.FLASHBOARD_VARIABLE, string17, RelatedType.NONE);
                }
                continue;
            }
            if (string2.equals(FLASHBOARD_VARIABLE_ALL_FLAG)) {
                definitionOptions.setAll(DefinitionItemType.FLASHBOARD_VARIABLE, true);
                continue;
            }
            if (string2.equals(FLASHBOARD_ALARM_FLAG)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ++i;
                i = this.a(stringArray, i, arrayList);
                for (String string18 : arrayList) {
                    definitionOptions.add(DefinitionItemType.FLASHBOARD_ALARM, string18, RelatedType.NONE);
                }
                continue;
            }
            if (!string2.equals(FLASHBOARD_ALARM_ALL_FLAG)) continue;
            definitionOptions.setAll(DefinitionItemType.FLASHBOARD_ALARM, true);
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                CommandLineBase.a(definitionOptions.getLogFile(), Level.INFO);
                break;
            }
            case 3: {
                CommandLineBase.a(definitionOptions.getLogFile(), Level.DEBUG);
                break;
            }
            case 4: 
            case 5: {
                CommandLineBase.a(definitionOptions.getLogFile(), Level.WARN);
                break;
            }
            case 6: {
                CommandLineBase.a(definitionOptions.getLogFile(), Level.ALL);
                break;
            }
            default: {
                CommandLineBase.a(definitionOptions.getLogFile(), Level.OFF);
            }
        }
        return definitionOptions;
    }

    protected void printUsage(boolean bl) {
        System.out.println("Command Line Options:");
        System.out.println("    -u user : Required login parameter that identifies the user account.");
        System.out.println("    -p password : Optional login parameter that identifies the user account. Omit the option if the user account has no password.");
        System.out.println("    -x server name : Required login parameter that specifies the server to log in to.");
        System.out.println("    -w authenticator : Specifies the name of an external authentication string or Windows domain. This is related to the Login window Authentication field, which is discussed in the Configuring guide.");
        System.out.println("    -portnum : TCP port number used to log in when the portmapper is turned off.");
        if (bl) {
            System.out.println("    -e <filename> Specifies the file to which to export object definitions from the source server (identified with the -x login parameter).");
            System.out.println("     -og     set overlay group property");
        } else {
            System.out.println("    -i <filename> Specifies the file that contains the object definitions to be imported to the target server (identified with the -x login parameter). The -i option requires a <file> argument to identify the source file.");
        }
        System.out.println("    -o <logfile> Use to redirect errors normally displayed within the command line interface so that they appear in a file");
        System.out.println("");
        System.out.println("Nested Options:");
        System.out.println("    -a <active_link_name> for an active link");
        System.out.println("    -A for all active links");
        System.out.println("    -b <DSO_pool_name> for a DSO pool");
        System.out.println("    -B for all DSO pools");
        System.out.println("    -d <DSO_mapping_name> for a single DSO mapping");
        System.out.println("    -D for all DSO mappings");
        System.out.println("    -f <form_name> for a form");
        System.out.println("    -F for all forms");
        System.out.println("    -g <active_link_guide_name> for an active link guide");
        System.out.println("    -G for all active link guides");
        System.out.println("    -h <filter_guide_name> for a filter guide");
        System.out.println("    -H for all filter guides");
        System.out.println("    -k <packing_list_name> for a packing list object");
        System.out.println("    -K for packing list objects");
        System.out.println("    -l <packing_list.xml> for an XML command set. Provide either a command set file generated by Developer Studio or a packing list XML file generated by the Windows Admin Tool.");
        System.out.println("    -m <menu_name> for a menu");
        System.out.println("    -M for menus");
        System.out.println("    -n <application_name> for an application object");
        System.out.println("    -N for all application objects");
        if (bl) {
            System.out.println("    -expapp <application_name> for complete application");
            System.out.println("    Application specific options:");
            System.out.println("        -loc <locale...>        to specify the locales to include");
            System.out.println("        -loconly                for exporting locale objects only");
            System.out.println("        -shared                 to include shared workflow");
            System.out.println("        -int <applications...>  to specify the applications for integration workflow");
            System.out.println("             Note: locale and integration workflow are mutually exclusive");
        } else {
            System.out.println("    -impapp <application_name> for complete application");
        }
        System.out.println("    -q <escalation_name> for an escalation");
        System.out.println("    -Q for all escalations");
        System.out.println("    -t <filter_name> for a filter");
        System.out.println("    -T for all filters");
        System.out.println("    -z <web_service_name> for a web service");
        System.out.println("    -Z for all web services");
        System.out.println("    -fb <flashboard_name> for a flashboard");
        System.out.println("    -FB for all flashboards");
        System.out.println("    -fa <flashboard_alarm_name> for a flashboard alarm");
        System.out.println("    -FA for all flashboard alarms");
        System.out.println("    -fv <flashboard_variable_name> for a flashboard variable");
        System.out.println("    -FV for all flashboard variables");
        System.out.println("    -charset <name>    : Specifies the character set used in the definition file. The character set name must be supplied as listed in the IANA Charset Registry");
        if (!bl) {
            System.out.println("    -inplace to overwrite existing objects, without deleting objects first");
        }
        if (bl) {
            System.out.println("    -lock <type> <key> to export objects as locked. Valid values for type are 1 (read only) and 2 (hidden). The key is a string that is to be used as a key (or password) to enforce locking");
        }
    }

    protected void printVersion() {
        System.out.println("7.6.03 Build 001");
    }

    protected final List<StructItemInfo> convertToItemList(boolean bl) {
        ArrayList<StructItemInfo> arrayList = new ArrayList<StructItemInfo>();
        for (DefinitionItemType definitionItemType : this.getOptions().getItems().keySet()) {
            StructItemInfo structItemInfo;
            int n;
            int n2;
            List<BaseItemData> list = this.getOptions().getItems(definitionItemType);
            if (list == null) continue;
            if (definitionItemType == DefinitionItemType.APPLICATION) {
                n2 = 1;
                for (BaseItemData baseItemData : list) {
                    n = baseItemData.getType().getConstant();
                    StructItemInfo structItemInfo2 = null;
                    structItemInfo2 = new StructItemInfo(bl ? n | 0x40000000 : n, baseItemData.getName());
                    if (this.getOptions().hasElements(baseItemData.getName())) {
                        structItemInfo = this.getOptions().getElements(baseItemData.getName());
                        structItemInfo2.setSelectedElements(structItemInfo.toArray(new String[structItemInfo.size()]));
                    }
                    arrayList.add(structItemInfo2);
                    ++n2;
                }
                continue;
            }
            if (definitionItemType == DefinitionItemType.VIEW) {
                HashMap hashMap = new HashMap();
                for (BaseItemData baseItemData : list) {
                    ViewItemData viewItemData;
                    if (!(baseItemData instanceof ViewItemData) || (viewItemData = (ViewItemData)baseItemData).getForm() == null) continue;
                    ArrayList<String> arrayList2 = (ArrayList<String>)hashMap.get(viewItemData.getForm());
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<String>();
                    }
                    if (!arrayList2.contains(viewItemData.getName())) {
                        arrayList2.add(viewItemData.getName());
                    }
                    hashMap.put(viewItemData.getForm(), arrayList2);
                }
                int n3 = 1;
                for (String string : hashMap.keySet()) {
                    List list2 = (List)hashMap.get(string);
                    if (list2 == null || list2.size() <= 0) continue;
                    structItemInfo = new StructItemInfo(DefinitionItemType.VIEW.getConstant(), string);
                    structItemInfo.setSelectedElements(list2.toArray(new String[list2.size()]));
                    if (bl) {
                        structItemInfo.setType(structItemInfo.getType() | 0x40000000);
                    }
                    arrayList.add(structItemInfo);
                    ++n3;
                }
                continue;
            }
            n2 = 1;
            for (BaseItemData baseItemData : list) {
                n = 0;
                int n3 = baseItemData.getType().getConstant();
                structItemInfo = null;
                if (baseItemData instanceof DefinitionItemData) {
                    DefinitionItemData definitionItemData = (DefinitionItemData)baseItemData;
                    if (!(this.getOptions().isDsoLicensed() || definitionItemData.getType() != DefinitionItemType.DISTRIBUTED_MAPPING && definitionItemData.getType() != DefinitionItemType.DISTRIBUTED_POOL)) {
                        if (if.isEnabledFor((Priority)Level.INFO)) {
                            if.info((Object)MessageFormat.format("{0} \"{1}\" has been removed from the list of objects. Server {2} does not have a Distributed Server Option license", definitionItemData.getType().getTypeName(), definitionItemData.getName(), this.getOptions().getServer()));
                        }
                        n = 1;
                    }
                    if (definitionItemData.getType() != DefinitionItemType.FLASHBOARD && definitionItemData.getType() != DefinitionItemType.FLASHBOARD_VARIABLE && definitionItemData.getType() != DefinitionItemType.FLASHBOARD_ALARM) {
                        if (definitionItemData.getType() == DefinitionItemType.APPLICATION && definitionItemData.getRelated() == RelatedType.FULL) {
                            n3 = 16;
                        }
                        structItemInfo = new StructItemInfo(n3, baseItemData.getName());
                        if (definitionItemData.getSubItems() != null && definitionItemData.getSubItems().size() > 0) {
                            structItemInfo.setSelectedElements(definitionItemData.getSubItems().toArray(new String[definitionItemData.getSubItems().size()]));
                        }
                    }
                }
                if (structItemInfo != null) {
                    if (bl) {
                        structItemInfo.setType(structItemInfo.getType() | 0x40000000);
                    }
                    if (n == 0) {
                        arrayList.add(structItemInfo);
                    }
                }
                ++n2;
            }
        }
        return arrayList;
    }

    protected String getDataVisualizationForm() throws ARException {
        if (this.dataVisualizationForm != null) {
            return this.dataVisualizationForm;
        }
        int[] nArray = new int[]{41000, 41050, 41051, 41052, 61001, 41053};
        List list = this.getOptions().getContext().getListForm(0L, FormType.ALL.toInt(), null, nArray);
        this.dataVisualizationForm = list != null && list.size() >= 1 ? (String)list.get(0) : "Data Visualization Definition";
        return this.dataVisualizationForm;
    }

    protected QualifierInfo getDataVisualizationQualifier(String string, String string2, String string3) {
        ArithmeticOrRelationalOperand arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(41000);
        ArithmeticOrRelationalOperand arithmeticOrRelationalOperand2 = new ArithmeticOrRelationalOperand(new Value(string));
        QualifierInfo qualifierInfo = new QualifierInfo(new RelationalOperationInfo(1, arithmeticOrRelationalOperand, arithmeticOrRelationalOperand2));
        ArithmeticOrRelationalOperand arithmeticOrRelationalOperand3 = new ArithmeticOrRelationalOperand(41050);
        ArithmeticOrRelationalOperand arithmeticOrRelationalOperand4 = new ArithmeticOrRelationalOperand(new Value(string3));
        QualifierInfo qualifierInfo2 = new QualifierInfo(new RelationalOperationInfo(1, arithmeticOrRelationalOperand3, arithmeticOrRelationalOperand4));
        ArithmeticOrRelationalOperand arithmeticOrRelationalOperand5 = new ArithmeticOrRelationalOperand(41052);
        ArithmeticOrRelationalOperand arithmeticOrRelationalOperand6 = new ArithmeticOrRelationalOperand(new Value(string2));
        QualifierInfo qualifierInfo3 = new QualifierInfo(new RelationalOperationInfo(1, arithmeticOrRelationalOperand5, arithmeticOrRelationalOperand6));
        return new QualifierInfo(1, qualifierInfo, new QualifierInfo(1, qualifierInfo2, qualifierInfo3));
    }

    private static void a(String string, Level level) {
        Object object;
        if.setLevel(level);
        Object object2 = null;
        object2 = level.toInt() < Level.DEBUG.toInt() ? new PatternLayout("%d %-5p [%t] %C (%F:%L) - %m%n") : new SimpleLayout();
        if (string != null && string.length() > 0) {
            try {
                if.addAppender((Appender)new FileAppender((Layout)object2, string, false));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        boolean bl = true;
        Enumeration enumeration = if.getRootLogger().getAllAppenders();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!(object instanceof ConsoleAppender)) continue;
            bl = false;
            break;
        }
        if (bl) {
            enumeration = null;
            object = LogManager.getLoggerRepository().getCurrentLoggers();
            if (object != null) {
                block3: while (object.hasMoreElements()) {
                    Logger logger = (Logger)object.nextElement();
                    enumeration = logger.getAllAppenders();
                    while (enumeration.hasMoreElements()) {
                        Object e = enumeration.nextElement();
                        if (!(e instanceof ConsoleAppender)) continue;
                        bl = false;
                        continue block3;
                    }
                }
            }
        }
        if (bl) {
            if.addAppender((Appender)new ConsoleAppender((Layout)object2));
        }
    }

    protected void validateCommandLine(DefinitionOptions definitionOptions, boolean bl) {
        Set<Map.Entry<DefinitionItemType, Boolean>> set = definitionOptions.getAllFlags().entrySet();
        for (Map.Entry<DefinitionItemType, Boolean> entry : set) {
            List<BaseItemData> list;
            Boolean bl2;
            if (entry.getKey() == null || (bl2 = entry.getValue()) == null || !bl2.booleanValue() || (list = definitionOptions.getItems(entry.getKey())) == null || list.isEmpty() || !if.isEnabledFor((Priority)Level.WARN)) continue;
            if.warn((Object)MessageFormat.format("Command Line options specifies both all objects of type {0} and specific objects. All {0} objects will be {1}.", entry.getKey().getTypeName(), bl ? "exported" : "imported"));
        }
    }

    protected void checkDSOLicense() throws ARException {
        int[] nArray = new int[]{43, 127};
        ServerInfoMap serverInfoMap = this.getOptions().getContext().getServerInfo(nArray);
        if (((Value)serverInfoMap.get((Object)43)).getValue() != null) {
            String string = ((Value)serverInfoMap.get((Object)43)).getValue().toString();
            if (string.length() > 0) {
                this.a.setDsoLicensed(true);
            } else {
                this.a.setDsoLicensed(false);
            }
        }
    }

    private void a() throws ARException {
        int[] nArray = new int[]{43, 127};
        ServerInfoMap serverInfoMap = this.getOptions().getContext().getServerInfo(nArray);
        if (serverInfoMap != null) {
            Object object = ((Value)serverInfoMap.get((Object)43)).getValue();
            this.dsoMapForm = object != null ? object.toString() : "Distributed Mapping";
            object = ((Value)serverInfoMap.get((Object)127)).getValue();
            this.dsoPoolForm = object != null ? object.toString() : "Distributed Pool";
        }
    }

    protected String getDSOPoolForm() throws ARException {
        if (this.dsoPoolForm != null) {
            return this.dsoPoolForm;
        }
        this.a();
        return this.dsoPoolForm;
    }

    protected String getDSOMapForm() throws ARException {
        if (this.dsoMapForm != null) {
            return this.dsoMapForm;
        }
        this.a();
        return this.dsoMapForm;
    }
}

