/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.orm.jpa.persistenceunit;

import com.bmc.thirdparty.org.springframework.instrument.classloading.LoadTimeWeaver;
import com.bmc.thirdparty.org.springframework.instrument.classloading.SimpleThrowawayClassLoader;
import com.bmc.thirdparty.org.springframework.orm.jpa.persistenceunit.ClassFileTransformerAdapter;
import com.bmc.thirdparty.org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import javax.persistence.spi.ClassTransformer;

class SpringPersistenceUnitInfo
extends MutablePersistenceUnitInfo {
    private LoadTimeWeaver loadTimeWeaver;

    SpringPersistenceUnitInfo() {
    }

    public void setLoadTimeWeaver(LoadTimeWeaver loadTimeWeaver) {
        this.loadTimeWeaver = loadTimeWeaver;
    }

    public ClassLoader getClassLoader() {
        if (this.loadTimeWeaver != null) {
            return this.loadTimeWeaver.getInstrumentableClassLoader();
        }
        return ClassUtils.getDefaultClassLoader();
    }

    public void addTransformer(ClassTransformer classTransformer) {
        if (this.loadTimeWeaver == null) {
            throw new IllegalStateException("Cannot apply class transformer without LoadTimeWeaver specified");
        }
        this.loadTimeWeaver.addTransformer(new ClassFileTransformerAdapter(classTransformer));
    }

    public ClassLoader getNewTempClassLoader() {
        if (this.loadTimeWeaver != null) {
            return this.loadTimeWeaver.getThrowawayClassLoader();
        }
        return new SimpleThrowawayClassLoader(ClassUtils.getDefaultClassLoader());
    }
}

