/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.antlr.runtime;

import java.util.List;

public class BitSet
implements Cloneable {
    protected static final int BITS = 64;
    protected static final int LOG_BITS = 6;
    protected static final int MOD_MASK = 63;
    protected long[] bits;

    public BitSet() {
        this(64);
    }

    public BitSet(long[] lArray) {
        this.bits = lArray;
    }

    public BitSet(List list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Integer n2 = (Integer)list.get(i2);
            this.add(n2);
        }
    }

    public BitSet(int n2) {
        this.bits = new long[(n2 - 1 >> 6) + 1];
    }

    public static BitSet of(int n2) {
        BitSet bitSet = new BitSet(n2 + 1);
        bitSet.add(n2);
        return bitSet;
    }

    public static BitSet of(int n2, int n3) {
        BitSet bitSet = new BitSet(Math.max(n2, n3) + 1);
        bitSet.add(n2);
        bitSet.add(n3);
        return bitSet;
    }

    public static BitSet of(int n2, int n3, int n4) {
        BitSet bitSet = new BitSet();
        bitSet.add(n2);
        bitSet.add(n3);
        bitSet.add(n4);
        return bitSet;
    }

    public static BitSet of(int n2, int n3, int n4, int n5) {
        BitSet bitSet = new BitSet();
        bitSet.add(n2);
        bitSet.add(n3);
        bitSet.add(n4);
        bitSet.add(n5);
        return bitSet;
    }

    public BitSet or(BitSet bitSet) {
        if (bitSet == null) {
            return this;
        }
        BitSet bitSet2 = (BitSet)this.clone();
        bitSet2.orInPlace(bitSet);
        return bitSet2;
    }

    public void add(int n2) {
        int n3 = BitSet.wordNumber(n2);
        if (n3 >= this.bits.length) {
            this.growToInclude(n2);
        }
        int n4 = n3;
        this.bits[n4] = this.bits[n4] | BitSet.bitMask(n2);
    }

    public void growToInclude(int n2) {
        int n3 = Math.max(this.bits.length << 1, this.numWordsToHold(n2));
        long[] lArray = new long[n3];
        System.arraycopy(this.bits, 0, lArray, 0, this.bits.length);
        this.bits = lArray;
    }

    public void orInPlace(BitSet bitSet) {
        if (bitSet == null) {
            return;
        }
        if (bitSet.bits.length > this.bits.length) {
            this.setSize(bitSet.bits.length);
        }
        int n2 = Math.min(this.bits.length, bitSet.bits.length);
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            int n3 = i2;
            this.bits[n3] = this.bits[n3] | bitSet.bits[i2];
        }
    }

    private void setSize(int n2) {
        long[] lArray = new long[n2];
        int n3 = Math.min(n2, this.bits.length);
        System.arraycopy(this.bits, 0, lArray, 0, n3);
        this.bits = lArray;
    }

    private static final long bitMask(int n2) {
        int n3 = n2 & 0x3F;
        return 1L << n3;
    }

    public Object clone() {
        BitSet bitSet;
        try {
            bitSet = (BitSet)super.clone();
            bitSet.bits = new long[this.bits.length];
            System.arraycopy(this.bits, 0, bitSet.bits, 0, this.bits.length);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return bitSet;
    }

    public int size() {
        int n2 = 0;
        for (int i2 = this.bits.length - 1; i2 >= 0; --i2) {
            long l2 = this.bits[i2];
            if (l2 == 0L) continue;
            for (int i3 = 63; i3 >= 0; --i3) {
                if ((l2 & 1L << i3) == 0L) continue;
                ++n2;
            }
        }
        return n2;
    }

    public boolean equals(Object object) {
        block5: {
            int n2;
            int n3;
            BitSet bitSet;
            block4: {
                if (object == null || !(object instanceof BitSet)) {
                    return false;
                }
                bitSet = (BitSet)object;
                n3 = Math.min(this.bits.length, bitSet.bits.length);
                for (n2 = 0; n2 < n3; ++n2) {
                    if (this.bits[n2] == bitSet.bits[n2]) continue;
                    return false;
                }
                if (this.bits.length <= n3) break block4;
                for (n2 = n3 + 1; n2 < this.bits.length; ++n2) {
                    if (this.bits[n2] == 0L) continue;
                    return false;
                }
                break block5;
            }
            if (bitSet.bits.length <= n3) break block5;
            for (n2 = n3 + 1; n2 < bitSet.bits.length; ++n2) {
                if (bitSet.bits[n2] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean member(int n2) {
        if (n2 < 0) {
            return false;
        }
        int n3 = BitSet.wordNumber(n2);
        if (n3 >= this.bits.length) {
            return false;
        }
        return (this.bits[n3] & BitSet.bitMask(n2)) != 0L;
    }

    public void remove(int n2) {
        int n3 = BitSet.wordNumber(n2);
        if (n3 < this.bits.length) {
            int n4 = n3;
            this.bits[n4] = this.bits[n4] & (BitSet.bitMask(n2) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public boolean isNil() {
        for (int i2 = this.bits.length - 1; i2 >= 0; --i2) {
            if (this.bits[i2] == 0L) continue;
            return false;
        }
        return true;
    }

    private final int numWordsToHold(int n2) {
        return (n2 >> 6) + 1;
    }

    public int numBits() {
        return this.bits.length << 6;
    }

    public int lengthInLongWords() {
        return this.bits.length;
    }

    public int[] toArray() {
        int[] nArray = new int[this.size()];
        int n2 = 0;
        for (int i2 = 0; i2 < this.bits.length << 6; ++i2) {
            if (!this.member(i2)) continue;
            nArray[n2++] = i2;
        }
        return nArray;
    }

    public long[] toPackedArray() {
        return this.bits;
    }

    private static final int wordNumber(int n2) {
        return n2 >> 6;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = ",";
        boolean bl = false;
        stringBuffer.append('{');
        for (int i2 = 0; i2 < this.bits.length << 6; ++i2) {
            if (!this.member(i2)) continue;
            if (i2 > 0 && bl) {
                stringBuffer.append(string);
            }
            if (stringArray != null) {
                stringBuffer.append(stringArray[i2]);
            } else {
                stringBuffer.append(i2);
            }
            bl = true;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

