/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jndi;

import com.bmc.thirdparty.org.springframework.aop.TargetSource;
import com.bmc.thirdparty.org.springframework.jndi.JndiObjectLocator;
import javax.naming.NamingException;

public class JndiObjectTargetSource
extends JndiObjectLocator
implements TargetSource {
    private boolean lookupOnStartup = true;
    private boolean cache = true;
    private Object cachedObject;
    private Class targetClass;

    public void setLookupOnStartup(boolean lookupOnStartup) {
        this.lookupOnStartup = lookupOnStartup;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public void afterPropertiesSet() throws NamingException {
        super.afterPropertiesSet();
        if (this.lookupOnStartup) {
            Object object = this.lookup();
            if (this.cache) {
                this.cachedObject = object;
            } else {
                this.targetClass = object.getClass();
            }
        }
    }

    public Class getTargetClass() {
        return this.cachedObject != null ? this.cachedObject.getClass() : this.targetClass;
    }

    public boolean isStatic() {
        return this.cachedObject != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getTarget() throws NamingException {
        if (this.lookupOnStartup || !this.cache) {
            return this.cachedObject != null ? this.cachedObject : this.lookup();
        }
        JndiObjectTargetSource jndiObjectTargetSource = this;
        synchronized (jndiObjectTargetSource) {
            if (this.cachedObject == null) {
                this.cachedObject = this.lookup();
            }
            return this.cachedObject;
        }
    }

    public void releaseTarget(Object target) {
    }
}

