/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jdbc.support.incrementer;

import com.bmc.thirdparty.org.springframework.dao.DataAccessException;
import com.bmc.thirdparty.org.springframework.dao.DataAccessResourceFailureException;
import com.bmc.thirdparty.org.springframework.jdbc.datasource.DataSourceUtils;
import com.bmc.thirdparty.org.springframework.jdbc.support.JdbcUtils;
import com.bmc.thirdparty.org.springframework.jdbc.support.incrementer.AbstractDataFieldMaxValueIncrementer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;

public class MySQLMaxValueIncrementer
extends AbstractDataFieldMaxValueIncrementer {
    private static final String VALUE_SQL = "select last_insert_id()";
    private String columnName;
    private int cacheSize = 1;
    private long nextId = 0L;
    private long maxId = 0L;

    public MySQLMaxValueIncrementer() {
    }

    public MySQLMaxValueIncrementer(DataSource ds, String incrementerName, String columnName) {
        this.setDataSource(ds);
        this.setIncrementerName(incrementerName);
        this.columnName = columnName;
        this.afterPropertiesSet();
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.columnName == null) {
            throw new IllegalArgumentException("columnName is required");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized long getNextKey() throws DataAccessException {
        if (this.maxId == this.nextId) {
            Connection con = DataSourceUtils.getConnection(this.getDataSource());
            Statement stmt = null;
            try {
                stmt = con.createStatement();
                DataSourceUtils.applyTransactionTimeout(stmt, this.getDataSource());
                stmt.executeUpdate("update " + this.getIncrementerName() + " set " + this.columnName + " = last_insert_id(" + this.columnName + " + " + this.getCacheSize() + ")");
                ResultSet rs = stmt.executeQuery(VALUE_SQL);
                try {
                    if (!rs.next()) {
                        throw new DataAccessResourceFailureException("last_insert_id() failed after executing an update");
                    }
                    this.maxId = rs.getLong(1);
                }
                finally {
                    JdbcUtils.closeResultSet(rs);
                }
                this.nextId = this.maxId - (long)this.getCacheSize() + 1L;
            }
            catch (SQLException ex) {
                throw new DataAccessResourceFailureException("Could not obtain last_insert_id()", ex);
            }
            finally {
                JdbcUtils.closeStatement(stmt);
                DataSourceUtils.releaseConnection(con, this.getDataSource());
            }
        }
        ++this.nextId;
        return this.nextId;
    }
}

