/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.beans.factory.support;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanDefinitionStoreException;
import com.bmc.thirdparty.org.springframework.beans.factory.support.BeanDefinitionReader;
import com.bmc.thirdparty.org.springframework.beans.factory.support.BeanDefinitionRegistry;
import com.bmc.thirdparty.org.springframework.core.io.Resource;
import com.bmc.thirdparty.org.springframework.core.io.ResourceLoader;
import com.bmc.thirdparty.org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import com.bmc.thirdparty.org.springframework.core.io.support.ResourcePatternResolver;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.io.IOException;

public abstract class AbstractBeanDefinitionReader
implements BeanDefinitionReader {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final BeanDefinitionRegistry beanFactory;
    private ResourceLoader resourceLoader;
    private ClassLoader beanClassLoader;

    protected AbstractBeanDefinitionReader(BeanDefinitionRegistry beanFactory) {
        Assert.notNull(beanFactory, "Bean factory must not be null");
        this.beanFactory = beanFactory;
        this.resourceLoader = this.beanFactory instanceof ResourceLoader ? (ResourceLoader)((Object)this.beanFactory) : new PathMatchingResourcePatternResolver();
    }

    public BeanDefinitionRegistry getBeanFactory() {
        return this.beanFactory;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    public int loadBeanDefinitions(Resource[] resources) throws BeanDefinitionStoreException {
        Assert.notNull(resources, "Resource array must not be null");
        int counter = 0;
        for (int i2 = 0; i2 < resources.length; ++i2) {
            counter += this.loadBeanDefinitions(resources[i2]);
        }
        return counter;
    }

    public int loadBeanDefinitions(String location) throws BeanDefinitionStoreException {
        ResourceLoader resourceLoader = this.getResourceLoader();
        if (resourceLoader == null) {
            throw new BeanDefinitionStoreException("Cannot import bean definitions from location [" + location + "]: no ResourceLoader available");
        }
        if (resourceLoader instanceof ResourcePatternResolver) {
            try {
                Resource[] resources = ((ResourcePatternResolver)resourceLoader).getResources(location);
                int loadCount = this.loadBeanDefinitions(resources);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Loaded " + loadCount + " bean definitions from location pattern [" + location + "]");
                }
                return loadCount;
            }
            catch (IOException ex) {
                throw new BeanDefinitionStoreException("Could not resolve bean definition resource pattern [" + location + "]", ex);
            }
        }
        Resource resource = resourceLoader.getResource(location);
        int loadCount = this.loadBeanDefinitions(resource);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Loaded " + loadCount + " bean definitions from location [" + location + "]");
        }
        return loadCount;
    }

    public int loadBeanDefinitions(String[] locations) throws BeanDefinitionStoreException {
        Assert.notNull(locations, "Location array must not be null");
        int counter = 0;
        for (int i2 = 0; i2 < locations.length; ++i2) {
            counter += this.loadBeanDefinitions(locations[i2]);
        }
        return counter;
    }
}

