/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.beans;

import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.beans.ConfigurablePropertyAccessor;
import com.bmc.thirdparty.org.springframework.beans.MutablePropertyValues;
import com.bmc.thirdparty.org.springframework.beans.NotWritablePropertyException;
import com.bmc.thirdparty.org.springframework.beans.NullValueInNestedPathException;
import com.bmc.thirdparty.org.springframework.beans.PropertyAccessException;
import com.bmc.thirdparty.org.springframework.beans.PropertyBatchUpdateException;
import com.bmc.thirdparty.org.springframework.beans.PropertyEditorRegistrySupport;
import com.bmc.thirdparty.org.springframework.beans.PropertyValue;
import com.bmc.thirdparty.org.springframework.beans.PropertyValues;
import java.util.LinkedList;
import java.util.Map;

public abstract class AbstractPropertyAccessor
extends PropertyEditorRegistrySupport
implements ConfigurablePropertyAccessor {
    private boolean extractOldValueForEditor = false;

    public void setExtractOldValueForEditor(boolean extractOldValueForEditor) {
        this.extractOldValueForEditor = extractOldValueForEditor;
    }

    public boolean isExtractOldValueForEditor() {
        return this.extractOldValueForEditor;
    }

    public void setPropertyValue(PropertyValue pv) throws BeansException {
        this.setPropertyValue(pv.getName(), pv.getValue());
    }

    public void setPropertyValues(Map map) throws BeansException {
        this.setPropertyValues(new MutablePropertyValues(map));
    }

    public void setPropertyValues(PropertyValues pvs) throws BeansException {
        this.setPropertyValues(pvs, false, false);
    }

    public void setPropertyValues(PropertyValues pvs, boolean ignoreUnknown) throws BeansException {
        this.setPropertyValues(pvs, ignoreUnknown, false);
    }

    public void setPropertyValues(PropertyValues pvs, boolean ignoreUnknown, boolean ignoreInvalid) throws BeansException {
        LinkedList<PropertyAccessException> propertyAccessExceptions = new LinkedList<PropertyAccessException>();
        PropertyValue[] pvArray = pvs.getPropertyValues();
        for (int i2 = 0; i2 < pvArray.length; ++i2) {
            try {
                this.setPropertyValue(pvArray[i2]);
                continue;
            }
            catch (NotWritablePropertyException ex) {
                if (ignoreUnknown) continue;
                throw ex;
            }
            catch (NullValueInNestedPathException ex) {
                if (ignoreInvalid) continue;
                throw ex;
            }
            catch (PropertyAccessException ex) {
                propertyAccessExceptions.add(ex);
            }
        }
        if (!propertyAccessExceptions.isEmpty()) {
            PropertyAccessException[] paeArray = propertyAccessExceptions.toArray(new PropertyAccessException[propertyAccessExceptions.size()]);
            throw new PropertyBatchUpdateException(paeArray);
        }
    }

    public Class getPropertyType(String propertyPath) {
        return null;
    }

    public abstract Object getPropertyValue(String var1) throws BeansException;

    public abstract void setPropertyValue(String var1, Object var2) throws BeansException;
}

