/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.servlet.view;

import com.bmc.thirdparty.org.springframework.web.servlet.view.AbstractUrlBasedView;
import com.bmc.thirdparty.org.springframework.web.util.WebUtils;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class InternalResourceView
extends AbstractUrlBasedView {
    public InternalResourceView() {
    }

    public InternalResourceView(String url) {
        this.setUrl(url);
    }

    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.exposeModelAsRequestAttributes(model, request);
        this.exposeHelpers(request);
        String dispatcherPath = this.prepareForRendering(request, response);
        RequestDispatcher rd = request.getRequestDispatcher(dispatcherPath);
        if (rd == null) {
            throw new ServletException("Could not get RequestDispatcher for [" + this.getUrl() + "]: check that this file exists within your WAR");
        }
        if (this.useInclude(request, response)) {
            rd.include((ServletRequest)request, (ServletResponse)response);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Included resource [" + this.getUrl() + "] in InternalResourceView '" + this.getBeanName() + "'");
            }
        } else {
            this.exposeForwardRequestAttributes(request);
            rd.forward((ServletRequest)request, (ServletResponse)response);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Forwarded to resource [" + this.getUrl() + "] in InternalResourceView '" + this.getBeanName() + "'");
            }
        }
    }

    protected void exposeHelpers(HttpServletRequest request) throws Exception {
    }

    protected String prepareForRendering(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.getUrl();
    }

    protected boolean useInclude(HttpServletRequest request, HttpServletResponse response) {
        return WebUtils.isIncludeRequest((ServletRequest)request) || response.isCommitted();
    }

    protected void exposeForwardRequestAttributes(HttpServletRequest request) {
        WebUtils.exposeForwardRequestAttributes(request);
    }
}

