/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.mapping;

import com.bmc.arsys.ws.util.ARWSException;
import com.bmc.arsys.ws.wsdl.XMLSchemaParser;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class ARSMapping {
    public XMLSchemaParser schemaParser = null;
    public static final int MAPPING_INTERNAL = 1;
    public static final int MAPPING_EXTERNAL_ELEMENT = 2;
    public static final int MAPPING_EXTERNAL_COMPLEXTYPE = 3;
    protected int mappingMode = 1;
    public static final String WS_TARGET_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    public static final String WS_SECURITY = "Security";
    private static final String WS_UT_AUTH = "UTAuth";
    protected Element mappingElement = null;
    protected Element rootElement = null;
    protected String name;
    protected String targetNamespace;
    protected boolean generateXsiType = false;
    protected String externalSchema = null;
    protected boolean xmlSchemaLinked = false;
    protected String externalGlobalName;
    protected String externalNamespace;

    public int getMappingMode() {
        return this.mappingMode;
    }

    public String getName() {
        return this.name;
    }

    public Element getMappingElement() {
        return this.mappingElement;
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public boolean getGenerateXsiType() {
        return this.generateXsiType;
    }

    public boolean isXmlSchemaLinked() {
        return this.xmlSchemaLinked;
    }

    public String getExternalSchema() {
        return this.externalSchema;
    }

    public String getExternalGlobalName() {
        return this.externalGlobalName;
    }

    public String getExternalNamespace() {
        return this.externalNamespace;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addSoapSubHeader(XMLSchemaParser schemaParser, Document mappingDom, Element soapHeaderElem, Part soapHeaderPart) {
        if (soapHeaderPart.getElementName() != null) {
            String authVal;
            Element wsselem;
            String authType = null;
            Element soapHeaderSubElement = schemaParser.parseSchemaForElement(mappingDom, soapHeaderPart.getElementName());
            soapHeaderElem.appendChild(soapHeaderSubElement);
            String formName = soapHeaderSubElement.getAttribute("form");
            String targetNamespace = soapHeaderSubElement.getAttribute("targetNamespace");
            String tagName = soapHeaderSubElement.getTagName();
            if (!tagName.equals("complexType") && targetNamespace != null && formName.equals("unqualified")) {
                soapHeaderSubElement.setAttributeNS(null, "form", "qualified");
            }
            soapHeaderElem.appendChild(soapHeaderSubElement);
            tagName = soapHeaderSubElement.getTagName();
            String attrName = soapHeaderSubElement.getAttribute("name");
            targetNamespace = soapHeaderSubElement.getAttribute("targetNamespace");
            if ((!tagName.equals("element") || !attrName.equals("AuthenticationInfo")) && (!attrName.equals(WS_SECURITY) || targetNamespace == null || !targetNamespace.equals(WS_TARGET_NAMESPACE))) return;
            if (attrName.equals("AuthenticationInfo")) {
                Element attribChild2;
                Element attribChild1 = (Element)soapHeaderSubElement.getFirstChild();
                if (attribChild1 == null || !attribChild1.getTagName().equals("element") || attribChild1.getAttribute("name") == null || !attribChild1.getAttribute("name").equals("userName") || (attribChild2 = (Element)attribChild1.getNextSibling()) == null || !attribChild2.getTagName().equals("element") || attribChild2.getAttribute("name") == null || !attribChild2.getAttribute("name").equals("password")) return;
                attribChild1.setAttributeNS(null, "arUsername", "true");
                attribChild2.setAttributeNS(null, "arPassword", "true");
                authType = "ARAuth";
            }
            if (attrName.equals(WS_SECURITY)) {
                Element attribChild2;
                Element attribChild1;
                Element subElement1 = (Element)soapHeaderSubElement.getFirstChild();
                if (subElement1 == null || !subElement1.getTagName().equals("element") || subElement1.getAttribute("name") == null || !subElement1.getAttribute("name").equals("UsernameToken") || (attribChild1 = (Element)subElement1.getFirstChild()) == null || !attribChild1.getTagName().equals("element") || attribChild1.getAttribute("name") == null || !attribChild1.getAttribute("name").equals("Username") || (attribChild2 = (Element)attribChild1.getNextSibling()) == null || !attribChild2.getTagName().equals("element") || attribChild2.getAttribute("name") == null || !attribChild2.getAttribute("name").equals("Password")) return;
                attribChild1.setAttributeNS(null, "arUsername", "true");
                attribChild2.setAttributeNS(null, "arPassword", "true");
                authType = WS_UT_AUTH;
                Element attribChild3 = (Element)attribChild2.getFirstChild();
                if (attribChild3 != null && attribChild3.getTagName().equals("attribute") && attribChild3.getAttribute("name") != null && attribChild3.getAttribute("name").equals("Type")) {
                    attribChild2.removeChild(attribChild3);
                }
            }
            if (authType == null || (wsselem = mappingDom.getDocumentElement()) == null || !wsselem.getTagName().equals("webservices") || (authVal = wsselem.getAttribute("authType")) != null && !authVal.equals("")) return;
            wsselem.setAttributeNS(null, "authType", authType);
            return;
        } else {
            if (soapHeaderPart.getTypeName() == null) throw new ARWSException("INVALID_WSDL", "Part must have element or type");
            schemaParser.parseSchemaForType(soapHeaderElem, soapHeaderPart.getTypeName());
        }
    }

    public ARSMapping(Element mappingElement) {
        String temp;
        this.mappingElement = mappingElement;
        this.name = mappingElement.getAttribute("name");
        this.externalSchema = mappingElement.getAttribute("externalSchema");
        if (this.externalSchema != null && this.externalSchema.equals("")) {
            this.externalSchema = null;
        }
        if ((temp = mappingElement.getAttribute("xmlSchemaSource")) != null && temp.equals("linked")) {
            this.xmlSchemaLinked = true;
        }
        if ((temp = mappingElement.getAttribute("generateXsiType")) != null && temp.equals("true")) {
            this.generateXsiType = true;
        }
        this.rootElement = ARSMapping.skipToFirstMappingElement(mappingElement, false);
        if (this.rootElement == null) {
            return;
        }
        this.targetNamespace = this.rootElement.getAttribute("targetNamespace");
        String complexType = this.rootElement.getAttribute("complexType");
        if (complexType != null && !complexType.equals("")) {
            this.mappingMode = 3;
            int lastColonPosition = complexType.lastIndexOf(58);
            if (lastColonPosition > -1) {
                this.externalNamespace = complexType.substring(0, lastColonPosition);
                this.externalGlobalName = complexType.substring(lastColonPosition + 1, complexType.length());
            } else {
                Element firstChild = ARSMapping.skipToFirstMappingElement(this.rootElement, true);
                this.externalNamespace = firstChild != null ? firstChild.getAttribute("targetNamespace") : "";
                this.externalGlobalName = complexType;
            }
        } else {
            Element firstChild = ARSMapping.skipToFirstMappingElement(this.rootElement, true);
            if (firstChild != null && !firstChild.getAttribute("targetNamespace").equals("") && !this.targetNamespace.equals(firstChild.getAttribute("targetNamespace"))) {
                this.mappingMode = 2;
                this.externalNamespace = firstChild.getAttribute("targetNamespace");
                this.externalGlobalName = firstChild.getAttribute("name");
            }
        }
    }

    public static Element getFirstChildElement(Element elem) {
        NodeList childNodes = elem.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public static Element skipToFirstMappingElement(Element elem, boolean skipRoot) {
        NodeList children = elem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            Element childElem = (Element)child;
            if (childElem.getLocalName().equals("formMapping")) {
                return ARSMapping.skipToFirstMappingElement(childElem, skipRoot);
            }
            if (!childElem.getLocalName().equals("element")) continue;
            if (skipRoot && childElem.getAttribute("name").equals("ROOT")) {
                return ARSMapping.skipToFirstMappingElement(childElem, false);
            }
            return childElem;
        }
        return null;
    }

    public ARSMapping(XMLSchemaParser schemaParser, Message message, String targetNamespace, Document mappingDom, String useStyle) {
        this.schemaParser = schemaParser;
        this.name = message.getQName().getLocalPart();
        this.targetNamespace = targetNamespace;
        if (useStyle.equals("encoded")) {
            this.generateXsiType = true;
        }
        this.mappingMode = 2;
        this.createMappingRootElement(mappingDom);
        for (Part part : message.getOrderedParts(null)) {
            Element partElement = null;
            if (part.getElementName() != null) {
                if (schemaParser == null) {
                    throw new ARWSException("INVALID_WSDL", "part has an element name, but there is no <types> section in WSDL");
                }
                partElement = schemaParser.parseSchemaForElement(mappingDom, part.getElementName());
            } else if (part.getTypeName() != null) {
                partElement = mappingDom.createElementNS(null, "element");
                partElement.setAttributeNS(null, "name", part.getName());
                if (schemaParser != null) {
                    partElement.setAttributeNS(null, "targetNamespace", targetNamespace);
                    partElement.setAttributeNS(null, "form", schemaParser.getElementFormDefault(targetNamespace));
                } else {
                    partElement.setAttributeNS(null, "form", "unqualified");
                }
                if (useStyle.equals("literal")) {
                    if (schemaParser == null) {
                        throw new ARWSException("INVALID_WSDL", "part is literal, has a type name, but there is no <types> section in WSDL");
                    }
                    schemaParser.parseSchemaForType(partElement, part.getTypeName());
                } else if (useStyle.equals("encoded")) {
                    if (part.getTypeName().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                        partElement.setAttributeNS(null, "dataType", part.getTypeName().getLocalPart());
                    } else {
                        partElement.setAttributeNS(null, "dataType", "string");
                        partElement.setAttributeNS(null, "xmlType", "true");
                    }
                }
            }
            this.rootElement.appendChild(partElement);
        }
    }

    public ARSMapping(XMLSchemaParser schemaParser, Part part, Document mappingDom, String useStyle, boolean replaceRoot) {
        this.schemaParser = schemaParser;
        if (schemaParser == null) {
            throw new ARWSException("INVALID_WSDL", "document style wsdl must have a <types> section");
        }
        if (useStyle.equals("encoded")) {
            this.generateXsiType = true;
        }
        if (part.getElementName() != null) {
            this.name = part.getElementName().getLocalPart();
            this.targetNamespace = part.getElementName().getNamespaceURI();
            this.mappingMode = 2;
            this.createMappingRootElement(mappingDom);
            Element partElement = schemaParser.parseSchemaForElement(mappingDom, part.getElementName());
            NodeList partElementChildren = partElement.getChildNodes();
            int count = partElementChildren.getLength();
            if (count == 0) {
                Attr attr1 = partElement.getAttributeNode("dataType");
                if (attr1 != null) {
                    this.rootElement.appendChild(partElement);
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    this.rootElement.appendChild(partElementChildren.item(0));
                }
            }
        } else if (part.getTypeName() != null) {
            this.name = part.getTypeName().getLocalPart();
            this.targetNamespace = part.getTypeName().getNamespaceURI();
            this.mappingMode = 3;
            this.createMappingRootElement(mappingDom);
            schemaParser.parseSchemaForType(this.rootElement, part.getTypeName());
        } else {
            throw new ARWSException("INVALID_WSDL", "Part must have element or type");
        }
    }

    public ARSMapping(XMLSchemaParser schemaParser, QName qName, String type, Document mappingDom) {
        this.schemaParser = schemaParser;
        if (schemaParser == null) {
            throw new ARWSException("INVALID_XSD", "xml schema parsing should have valid schema");
        }
        this.name = qName.getLocalPart();
        this.targetNamespace = qName.getNamespaceURI();
        this.mappingMode = type.equals("complexType") ? 3 : 2;
        this.createMappingRootElement(mappingDom);
        if (type.equals("complexType")) {
            schemaParser.parseSchemaForType(this.rootElement, qName);
            String complexType = (qName.getNamespaceURI().length() > 0 ? qName.getNamespaceURI() + ":" : "") + qName.getLocalPart();
            this.rootElement.setAttributeNS(null, "complexType", complexType);
        } else {
            Element topLevelElement = schemaParser.parseSchemaForElement(mappingDom, qName);
            this.rootElement.appendChild(topLevelElement);
        }
    }

    public ARSMapping(String name, String targetNamespace, Document mappingDom) {
        this.name = name;
        this.targetNamespace = targetNamespace;
        this.createMappingRootElement(mappingDom);
    }

    protected void createMappingRootElement(Document mappingDom) {
        this.rootElement = mappingDom.createElementNS(null, "element");
        this.rootElement.setAttributeNS(null, "name", "ROOT");
        this.rootElement.setAttributeNS(null, "targetNamespace", this.targetNamespace);
        this.mappingElement = mappingDom.createElementNS(null, "arDocMapping");
        this.mappingElement.setAttributeNS(null, "name", this.name);
        this.mappingElement.appendChild(this.rootElement);
        if (this.generateXsiType) {
            this.mappingElement.setAttributeNS(null, "generateXsiType", "true");
        }
        if (this.mappingMode == 1) {
            this.mappingElement.setAttributeNS(null, "schemaSource", "generated");
        } else {
            this.mappingElement.setAttributeNS(null, "schemaSource", "imported");
        }
    }

    public void setMappingName(String name) {
        this.name = name;
        this.mappingElement.setAttributeNS(null, "name", name);
    }

    public void addSoapHeader(XMLSchemaParser schemaParser, Part soapHeaderPart) {
        Document mappingDom = this.rootElement.getOwnerDocument();
        Element soapHeaderElem = mappingDom.createElementNS(null, "element");
        soapHeaderElem.setAttributeNS(null, "name", "SOAPHeader");
        this.addSoapSubHeader(schemaParser, mappingDom, soapHeaderElem, soapHeaderPart);
        this.rootElement.insertBefore(soapHeaderElem, this.rootElement.getFirstChild());
    }

    public void addSoapHeaderList(XMLSchemaParser schemaParser, List soapHeaderList, Definition def) {
        Document mappingDom = this.rootElement.getOwnerDocument();
        Element soapHeaderElem = mappingDom.createElementNS(null, "element");
        soapHeaderElem.setAttributeNS(null, "name", "SOAPHeader");
        for (int i = 0; i < soapHeaderList.size(); ++i) {
            SOAPHeader tempHeader = (SOAPHeader)soapHeaderList.get(i);
            Message headerMessage = def.getMessage(tempHeader.getMessage());
            Part headerMessagePart = headerMessage.getPart(tempHeader.getPart());
            this.addSoapSubHeader(schemaParser, mappingDom, soapHeaderElem, headerMessagePart);
        }
        this.rootElement.insertBefore(soapHeaderElem, this.rootElement.getFirstChild());
    }

    public void resolveMapping(ARSMapping oldMapping, StringBuffer warnings) {
        Document newDoc = this.getMappingElement().getOwnerDocument();
        TreeWalker newTree = ((DocumentTraversal)((Object)newDoc)).createTreeWalker(this.rootElement, 1, new FieldAndFormFilter(), false);
        Element newRoot = (Element)newTree.getCurrentNode();
        Document oldDoc = oldMapping.getMappingElement().getOwnerDocument();
        TreeWalker oldTree = ((DocumentTraversal)((Object)oldDoc)).createTreeWalker(oldMapping.rootElement, 1, new FieldAndFormFilter(), false);
        Element oldRoot = (Element)oldTree.getCurrentNode();
        if (!(newRoot.getLocalName().equals("element") && oldRoot.getLocalName().equals("element") && newRoot.getAttribute("name").equals("ROOT") && oldRoot.getAttribute("name").equals("ROOT"))) {
            throw new ARWSException("OTHER_ERROR", "Internal error, root element is absent");
        }
        this.resolveTrees(newTree, oldTree, "", "", warnings);
    }

    public static Element importElement(Document doc, Element oldElem) {
        Element newElem = (Element)doc.importNode(oldElem, false);
        NamedNodeMap oldNodeMap = oldElem.getAttributes();
        for (int i = 0; i < oldNodeMap.getLength(); ++i) {
            Attr oldAttr = (Attr)oldNodeMap.item(i);
            Attr newAttr = (Attr)doc.importNode(oldAttr, false);
            newElem.setAttributeNode(newAttr);
        }
        return newElem;
    }

    protected void resolveTrees(TreeWalker newTree, TreeWalker oldTree, String currentFormName, String currentXPath, StringBuffer warnings) {
        Element oldElem = (Element)oldTree.getCurrentNode();
        Element newElem = (Element)newTree.getCurrentNode();
        Element oldFormMapping = this.getFormMapping(oldElem);
        Element oldFieldMapping = this.getFieldMapping(oldElem);
        Document doc = newElem.getOwnerDocument();
        if (oldFormMapping != null) {
            Element oldForm = ARSMapping.getFirstChildElement(oldFormMapping);
            Element newForm = ARSMapping.importElement(doc, oldForm);
            Element newFormMapping = ARSMapping.importElement(doc, oldFormMapping);
            newFormMapping.appendChild(newForm);
            currentFormName = oldForm.getAttribute("formName");
            Node parent = newElem.getParentNode();
            parent.insertBefore(newFormMapping, newElem);
            newFormMapping.appendChild(newElem);
        }
        if (oldFieldMapping != null) {
            Element newFieldMapping = ARSMapping.importElement(doc, oldFieldMapping);
            newElem.appendChild(newFieldMapping);
        }
        LinkedList<Element> newChildren = new LinkedList<Element>();
        Element newChild = (Element)newTree.firstChild();
        while (newChild != null) {
            newChildren.addLast(newChild);
            newChild = (Element)newTree.nextSibling();
        }
        Element oldChild = (Element)oldTree.firstChild();
        while (oldChild != null) {
            String newXPath = currentXPath + oldChild.getAttribute("name") + "/";
            boolean matched = false;
            Iterator i = newChildren.iterator();
            while (i.hasNext()) {
                newChild = (Element)i.next();
                if (!newChild.getLocalName().equals(oldChild.getLocalName()) || !newChild.getAttribute("name").equals(oldChild.getAttribute("name")) || !newChild.getAttribute("dataType").equals(oldChild.getAttribute("dataType"))) continue;
                i.remove();
                matched = true;
                break;
            }
            if (matched) {
                newTree.setCurrentNode(newChild);
                this.resolveTrees(newTree, oldTree, currentFormName, newXPath, warnings);
            } else {
                this.warnChildren(oldTree, currentFormName, currentXPath, warnings);
            }
            oldChild = (Element)oldTree.nextSibling();
        }
        oldTree.setCurrentNode(oldElem);
        newTree.setCurrentNode(newElem);
    }

    public Element getFormMapping(Element elem) {
        Node n1 = elem.getParentNode();
        if (n1 != null && n1.getNodeType() == 1 && n1.getNodeName().equals("formMapping")) {
            return (Element)n1;
        }
        return null;
    }

    public Element getFieldMapping(Element elem) {
        Element e1 = ARSMapping.getFirstChildElement(elem);
        if (e1 != null && e1.getNodeName().equals("fieldMapping")) {
            return e1;
        }
        return null;
    }

    public void warnChildren(StringBuffer warnings) {
        Document doc = this.getMappingElement().getOwnerDocument();
        TreeWalker tree = ((DocumentTraversal)((Object)doc)).createTreeWalker(this.rootElement, 1, new FieldAndFormFilter(), false);
        this.warnChildren(tree, "", "", warnings);
    }

    public void warnChildren(TreeWalker oldTree, String currentFormName, String currentXPath, StringBuffer warnings) {
        Element oldElem = (Element)oldTree.getCurrentNode();
        Element oldFormMapping = this.getFormMapping(oldElem);
        Element oldFieldMapping = this.getFieldMapping(oldElem);
        if (oldFormMapping != null) {
            Element oldForm = ARSMapping.getFirstChildElement(oldFormMapping);
            currentFormName = oldForm.getAttribute("formName");
            warnings.append("WARNING: losing form mapping of " + currentXPath + oldElem.getAttribute("name") + " to FORM " + currentFormName + " in " + this.getName() + System.getProperty("line.separator"));
        }
        if (oldFieldMapping != null) {
            warnings.append("WARNING: losing field mapping of " + currentXPath + oldElem.getAttribute("name") + " to FIELD " + oldFieldMapping.getAttribute("arFieldId") + " of " + currentFormName + " in " + this.getName() + System.getProperty("line.separator"));
        }
        Element child = (Element)oldTree.firstChild();
        while (child != null) {
            String newXPath = currentXPath + oldElem.getAttribute("name") + "/";
            this.warnChildren(oldTree, currentFormName, newXPath, warnings);
            child = (Element)oldTree.nextSibling();
        }
        oldTree.setCurrentNode(oldElem);
    }

    public void generateXML(Element serviceElem) {
        Document doc = serviceElem.getOwnerDocument();
        if (doc == this.mappingElement.getOwnerDocument()) {
            serviceElem.appendChild(this.mappingElement);
        }
    }

    public class FieldAndFormFilter
    implements NodeFilter {
        public short acceptNode(Node n) {
            if (n.getNodeType() == 1) {
                Element elem = (Element)n;
                if (elem.getLocalName().equals("element") || elem.getLocalName().equals("attribute") || elem.getLocalName().equals("choice")) {
                    return 1;
                }
                if (elem.getLocalName().equals("formMapping")) {
                    return 3;
                }
            }
            return 2;
        }
    }
}

