/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.legacy;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.FieldLimit;
import com.bmc.arsys.api.FieldMapping;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.StatisticsResultInfo;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.VendorFieldMapping;
import com.bmc.arsys.api.VendorForm;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.arsys.pluginsvr.ARPluginDefinition;
import com.bmc.arsys.pluginsvr.ARPluginServerConfiguration;
import com.bmc.arsys.pluginsvr.legacy.PluginTypeMgr;
import com.bmc.arsys.pluginsvr.plugins.AREAResponse;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARVendorField;
import com.bmc.arsys.utils.CatalogReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginProxy {
    private static Logger LOGGER = Logger.getLogger(PluginProxy.class);
    private static volatile boolean nativeLibraryExists = false;
    private static PluginProxy thePluginProxy = null;

    public static boolean IsNativeMethodAccessible() {
        return nativeLibraryExists;
    }

    public static void initializePluginProxy(List<ARPluginDefinition> plugins, String[] args) throws ARException {
        thePluginProxy = new PluginProxy(plugins, args);
    }

    public static PluginProxy getInstance() {
        return thePluginProxy;
    }

    private PluginProxy(List<ARPluginDefinition> plugins, String[] args) {
        try {
            String[] cargs = null;
            if (args != null) {
                cargs = new String[args.length + 1];
                cargs[0] = "JavaPluginServer";
                for (int i = 0; i < args.length; ++i) {
                    cargs[i + 1] = args[i];
                }
            }
            this.initializeNativePlugins(plugins, cargs);
        }
        catch (ARException e) {
            LOGGER.error((Object)CatalogReader.getInstance().getMessage(8766), (Throwable)e);
            System.out.println(CatalogReader.getInstance().getMessage(8766) + e.getLocalizedMessage());
        }
    }

    protected void initializeNativePlugins(List<ARPluginDefinition> plugins, String[] args) throws ARException {
        if (PluginProxy.IsNativeMethodAccessible()) {
            ArrayList<String> filenames = new ArrayList<String>();
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < plugins.size(); ++i) {
                filenames.add(plugins.get(i).getFileName());
                names.add(plugins.get(i).getPluginName());
            }
            Object[] in = new Object[]{"PluginInitialization", PluginTypeMgr.getInstance().ObjectListToVariant(filenames, null), PluginTypeMgr.getInstance().ObjectToVariant(names, null), args.length, args};
            Object[] out = this.invokeNativeCall(in);
            ArrayList ids = PluginTypeMgr.getInstance().ObjectListFromVariant(String.class, out[2], null);
            for (int i = 0; i < ids.size(); ++i) {
                if (plugins.get(i).getPluginName() != null && !plugins.get(i).getPluginName().equals("")) continue;
                plugins.get(i).setPluginName((String)ids.get(i));
            }
            ArrayList types = PluginTypeMgr.getInstance().ObjectListFromVariant(Integer.class, out[3], null);
            block7: for (int i = 0; i < types.size(); ++i) {
                if (plugins.get(i).getPluginType() != null && !plugins.get(i).getPluginType().equals("")) continue;
                switch ((Integer)types.get(i)) {
                    case 1: {
                        plugins.get(i).setPluginType("ARDBC");
                        continue block7;
                    }
                    case 2: {
                        plugins.get(i).setPluginType("FilterAPI");
                        continue block7;
                    }
                    case 3: {
                        plugins.get(i).setPluginType("AREA");
                    }
                }
            }
        }
    }

    public void createInstancesForThread() throws ARException {
        if (PluginProxy.IsNativeMethodAccessible()) {
            Object[] in = new Object[]{"PluginCreateInstances", PluginTypeMgr.getInstance().ObjectToVariant(new ARPluginContext(), null)};
            this.invokeNativeCall(in);
        }
    }

    public void deleteInstancesForThread() throws ARException {
        if (PluginProxy.IsNativeMethodAccessible()) {
            Object[] in = new Object[]{"PluginDeleteInstances", PluginTypeMgr.getInstance().ObjectToVariant(new ARPluginContext(), null)};
            this.invokeNativeCall(in);
        }
    }

    public void terminateNativePlugins() throws ARException {
        if (PluginProxy.IsNativeMethodAccessible()) {
            Object[] in = new Object[]{"PluginTermination"};
            this.invokeNativeCall(in);
        }
    }

    public void onEvent(int event) throws ARException {
        if (PluginProxy.IsNativeMethodAccessible()) {
            Object[] in = new Object[]{"PluginOnEvent", event};
            this.invokeNativeCall(in);
        }
    }

    public List<Value> filterAPICall(String serviceName, ARPluginContext context, List<Value> pInValues) throws ARException {
        Object[] in = new Object[]{"ARFilterApiCall", PluginTypeMgr.getInstance().ObjectToVariant(context, null), serviceName, PluginTypeMgr.getInstance().ObjectListToVariant(pInValues, null)};
        Object[] out = this.invokeNativeCall(in);
        return PluginTypeMgr.getInstance().ObjectListFromVariant(Value.class, out[2], null);
    }

    public AREAResponse areaVerifyLogin(ARPluginContext context, String user, String password, String networkAddress, String authString) throws ARException {
        Object[] in = new Object[]{"AREAVerifyLogin", PluginTypeMgr.getInstance().ObjectToVariant(context, null), user, password, networkAddress, authString};
        Object[] out = this.invokeNativeCall(in);
        return (AREAResponse)PluginTypeMgr.getInstance().ObjectFromVariant(AREAResponse.class, out[2], null);
    }

    public boolean areaNeedSync(ARPluginContext context) throws ARException {
        int ret;
        Object[] in = new Object[]{"AREANeedSync", PluginTypeMgr.getInstance().ObjectToVariant(context, null)};
        Object[] out = this.invokeNativeCall(in);
        if (out == null) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8766) + " AREANeedSync"));
        }
        return (ret = ((Integer)out[2]).intValue()) > 0;
    }

    protected String ardbcCreateEntry(String vendorName, ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, Entry entry) throws ARException {
        Object[] in = new Object[]{"ARDBCCreate", PluginTypeMgr.getInstance().ObjectToVariant(context, null), vendorName, tableName, PluginTypeMgr.getInstance().ObjectListToVariant(fieldsList, null), transId, PluginTypeMgr.getInstance().ObjectToVariant(entry, null)};
        Object[] out = this.invokeNativeCall(in);
        String entryId = ConversionUtil.getStringValue((Object)out[2]);
        entry.setEntryId(entryId);
        return entryId;
    }

    public Entry getEntry(String vendorName, ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, String entryId, int[] idList) throws ARException {
        Object[] in = new Object[]{"ARDBCGet", PluginTypeMgr.getInstance().ObjectToVariant(context, null), vendorName, tableName, PluginTypeMgr.getInstance().ObjectListToVariant(fieldsList, null), transId, Entry.splitEntryId((String)entryId), idList};
        Object[] out = this.invokeNativeCall(in);
        Entry object = (Entry)PluginTypeMgr.getInstance().ObjectFromVariant(Entry.class, out[4], null);
        object.setEntryId(entryId);
        return object;
    }

    public void setEntry(String vendorName, ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, String entryId, Entry entry, Timestamp getTimestamp) throws ARException {
        Object[] in = new Object[]{"ARDBCSet", PluginTypeMgr.getInstance().ObjectToVariant(context, null), vendorName, tableName, PluginTypeMgr.getInstance().ObjectListToVariant(fieldsList, null), transId, Entry.splitEntryId((String)entryId), PluginTypeMgr.getInstance().ObjectToVariant(entry, null), PluginTypeMgr.getInstance().ObjectToVariant(getTimestamp, null)};
        this.invokeNativeCall(in);
    }

    public void deleteEntry(String vendorName, ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, String entryId) throws ARException {
        Object[] in = new Object[]{"ARDBCDelete", PluginTypeMgr.getInstance().ObjectToVariant(context, null), vendorName, tableName, PluginTypeMgr.getInstance().ObjectListToVariant(fieldsList, null), transId, Entry.splitEntryId((String)entryId)};
        this.invokeNativeCall(in);
    }

    public AttachmentValue getBLOB(String vendorName, ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, String entryId, long fieldId) throws ARException {
        Object[] in = new Object[]{"ARDBCGetBlob", PluginTypeMgr.getInstance().ObjectToVariant(context, null), vendorName, tableName, PluginTypeMgr.getInstance().ObjectListToVariant(fieldsList, null), transId, Entry.splitEntryId((String)entryId), fieldId};
        Object[] out = this.invokeNativeCall(in);
        AttachmentValue info = new AttachmentValue((byte[])PluginTypeMgr.GetAt((Object)out, (int[])new int[]{2, 1, 1}));
        return info;
    }

    public void setBLOB(String vendorName, ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, String entryId, long fieldId, AttachmentValue info) throws ARException {
    }

    public List<Entry> getListEntryWithFields(String vendorName, ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, QualifierInfo qualifier, List<SortInfo> sortList, List<EntryListFieldInfo> getListFields, int startAt, int maxRetrieve, OutputInteger numMatches) throws ARException {
        Object[] in = new Object[]{"ARDBCGLEWF", PluginTypeMgr.getInstance().ObjectToVariant(context, null), vendorName, tableName, PluginTypeMgr.getInstance().ObjectListToVariant(fieldsList, null), transId, PluginTypeMgr.getInstance().ObjectToVariant(qualifier, null), PluginTypeMgr.getInstance().ObjectListToVariant(sortList, null), PluginTypeMgr.getInstance().ObjectListToVariant(getListFields, null), startAt, maxRetrieve};
        Object[] out = this.invokeNativeCall(in);
        if (numMatches != null) {
            numMatches.setValue(ConversionUtil.getIntValue((Object)out[3]));
        }
        List entryList = PluginTypeMgr.buildGLEWFResponse((Object[])((Object[])out[2]), null);
        return entryList;
    }

    public void commit(String vendorName, ARPluginContext context, long transId) throws ARException {
        Object[] in = new Object[]{"ARDBCCommit", PluginTypeMgr.getInstance().ObjectToVariant(context, null), vendorName, transId};
        this.invokeNativeCall(in);
    }

    public void rollback(String vendorName, ARPluginContext context, long transId) throws ARException {
        Object[] in = new Object[]{"ARDBCRollback", PluginTypeMgr.getInstance().ObjectToVariant(context, null), vendorName, transId};
        this.invokeNativeCall(in);
    }

    public void cancel(String vendorName, ARPluginContext context, long transId) throws ARException {
        Object[] in = new Object[]{"ARDBCCancel", PluginTypeMgr.getInstance().ObjectToVariant(context, null), vendorName, transId};
        this.invokeNativeCall(in);
    }

    public List<VendorForm> getListForms(ARPluginContext context) throws ARException {
        Object[] in = new Object[]{"ARDBCGetListForms", PluginTypeMgr.getInstance().ObjectToVariant(context, null)};
        Object[] out = this.invokeNativeCall(in);
        return PluginTypeMgr.getInstance().getVendorFormListFromVariant(out[2]);
    }

    public List<ARVendorField> getMultipleFields(String vendorName, ARPluginContext context, VendorForm schema) throws ARException {
        Object[] in = new Object[]{"ARDBCGetMultipleFields", PluginTypeMgr.getInstance().ObjectToVariant(context, null), vendorName, PluginTypeMgr.getInstance().getVariantFromVendorForm(schema)};
        Object[] out = this.invokeNativeCall(in);
        List<FieldMapping> mappings = PluginTypeMgr.getInstance().getVendorMappingListFromVariant(out[2]);
        ArrayList limits = PluginTypeMgr.getInstance().ObjectListFromVariant(FieldLimit.class, out[3], null);
        Object[] datatypes = (Object[])out[4];
        return this.getVendorFields(mappings, limits, datatypes);
    }

    private List<ARVendorField> getVendorFields(List<FieldMapping> mappings, List<FieldLimit> limits, Object[] datatypes) {
        ArrayList<ARVendorField> fields = new ArrayList<ARVendorField>();
        if (mappings != null && datatypes != null && limits != null) {
            for (int i = 0; i < mappings.size(); ++i) {
                String name = ((VendorFieldMapping)mappings.get(i)).getFieldName();
                int datatype = (Integer)datatypes[i];
                FieldLimit limit = limits.get(i);
                fields.add(new ARVendorField(name, 0, datatype, limit));
            }
        }
        return fields;
    }

    public List<StatisticsResultInfo> getEntryStatistics(String vendorName, ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, QualifierInfo qualifier, ArithmeticOrRelationalOperand target, int statistic, int[] groupByList) throws ARException {
        Object[] in = new Object[]{"ARDBCGetEntryStatistics", PluginTypeMgr.getInstance().ObjectToVariant(context, null), vendorName, tableName, PluginTypeMgr.getInstance().ObjectListToVariant(fieldsList, null), transId, PluginTypeMgr.getInstance().ObjectToVariant(qualifier, null), PluginTypeMgr.getInstance().ObjectToVariant(target, null), statistic, groupByList};
        Object[] out = this.invokeNativeCall(in);
        return PluginTypeMgr.getInstance().ObjectListFromVariant(StatisticsResultInfo.class, out[2], null);
    }

    private Object[] invokeNativeCall(Object[] args) throws ARException {
        if (PluginProxy.IsNativeMethodAccessible()) {
            Object[] out = (Object[])this.eval(args);
            if (out != null && out.length > 1) {
                ArrayList lastStatus = PluginTypeMgr.getInstance().ObjectListFromVariant(StatusInfo.class, (Object[])out[1], null);
                int returnVal = ConversionUtil.getIntValue((Object)out[0]);
                if (returnVal > 1) {
                    if (lastStatus.size() == 0) {
                        throw new ARException(2, returnVal, "");
                    }
                    throw new ARException((List)lastStatus);
                }
            }
            if (out == null) {
                throw new ARException(2, 8766, (String)args[0]);
            }
            return out;
        }
        throw new ARException(2, 8764, (String)args[0]);
    }

    native Object eval(Object var1) throws ARException;

    public static void logMessage(int level, String message) {
        switch (level) {
            case 1000: {
                LOGGER.error((Object)message);
                break;
            }
            case 900: {
                LOGGER.warn((Object)message);
                break;
            }
            default: {
                LOGGER.info((Object)message);
            }
        }
    }

    public static String getServerCharSet() {
        return "utf-8";
    }

    private static String shl_plat() {
        String osarch = System.getProperty("os.arch");
        if ("IA64N".equals(osarch)) {
            return "_hpia32";
        }
        if ("IA64W".equals(osarch)) {
            return "_hpia64";
        }
        return "";
    }

    static {
        if (ARPluginServerConfiguration.getLoadNativePluginhost()) {
            try {
                String l = "arpluginjni75" + PluginProxy.shl_plat();
                System.loadLibrary(l);
                nativeLibraryExists = true;
            }
            catch (Error err) {
                LOGGER.error((Object)CatalogReader.getInstance().getMessage(8764), (Throwable)err);
                nativeLibraryExists = false;
            }
            try {
                PluginTypeMgr.init();
                PluginTypeMgr.getInstance().loadAll();
            }
            catch (Throwable e) {
                LOGGER.error((Object)CatalogReader.getInstance().getMessage(8765), e);
            }
        }
    }
}

