/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.pluginsvr.ARPluginRPCCallQueueProcessor;
import com.bmc.arsys.pluginsvr.ARPluginServerConfiguration;
import com.bmc.arsys.pluginsvr.ARPluginServerManager;
import com.bmc.arsys.pluginsvr.ISignalMasking;
import com.bmc.arsys.pluginsvr.binding.ARPluginSvrExecutorFactory;
import com.bmc.arsys.pluginsvr.legacy.PluginProxy;
import com.bmc.arsys.pluginsvr.plugins.ARPluginLoaderRouter;
import com.bmc.arsys.utils.CatalogReader;
import java.io.IOException;
import org.acplt.oncrpc.OncRpcException;
import org.apache.log4j.Logger;

public class ARPluginServerMain {
    private static ARPluginRPCCallQueueProcessor rpcDispatcher = null;
    private static Logger log = Logger.getLogger(ARPluginServerMain.class);

    public static void main(String[] args) {
        try {
            Object signlaMaskObject;
            System.out.println("AR System Plugin Server Version 7.6.04 SP5 201308012025");
            ARPluginServerManager serverStateManager = ARPluginServerManager.getInstance();
            ARPluginServerConfiguration config = serverStateManager.loadConfiguration(args);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            String maskingClassName = config.getMaskingImplementation();
            if (maskingClassName != null && maskingClassName.length() > 0 && (signlaMaskObject = cl.loadClass(maskingClassName).newInstance()) instanceof ISignalMasking) {
                ((ISignalMasking)signlaMaskObject).useMasking();
            }
            serverStateManager.initRpcDispatcher();
            serverStateManager.initTransport();
            if (ARPluginServerConfiguration.isNativePluginHostSupported()) {
                try {
                    log.debug((Object)"initialize native plugin proxy");
                    PluginProxy.initializePluginProxy(config.getNativePlugins(), args);
                }
                catch (Exception e) {
                    log.error((Object)CatalogReader.getInstance().getMessage(8792), (Throwable)e);
                    System.out.println(CatalogReader.getInstance().getMessage(8792) + e.getLocalizedMessage());
                }
            }
            ARPluginLoaderRouter.initializeJavaPlugins();
            ARPluginSvrExecutorFactory.getRPCCallExecutor();
            log.info((Object)"AR System Plugin Server Version 7.6.04 SP5 201308012025");
            ARPluginServerMain.startReloadThread(args);
            ARPluginServerManager.getTransport().run();
        }
        catch (OncRpcException oe) {
            log.error((Object)(CatalogReader.getInstance().getMessage(8793) + " " + oe.getMessage()), (Throwable)oe);
            System.out.println(CatalogReader.getInstance().getMessage(8793) + oe.getLocalizedMessage());
            ARPluginServerMain.stopServer(1);
        }
        catch (IOException ie) {
            System.out.println(CatalogReader.getInstance().getMessage(8793) + " " + ie.getLocalizedMessage());
            log.error((Object)CatalogReader.getInstance().getMessage(8793), (Throwable)ie);
            ARPluginServerMain.stopServer(2);
        }
        catch (ARException ae) {
            log.error((Object)CatalogReader.getInstance().getMessage(8793), (Throwable)ae);
            System.out.println(CatalogReader.getInstance().getMessage(8793) + " " + ae.getLocalizedMessage());
            ARPluginServerMain.stopServer(3);
        }
        catch (Throwable ae) {
            log.error((Object)CatalogReader.getInstance().getMessage(8793), ae);
            System.out.println(CatalogReader.getInstance().getMessage(8793) + ae.getLocalizedMessage());
            ARPluginServerMain.stopServer(10);
        }
        log.info((Object)"AR Plugin Server going down.");
        System.out.println("AR Plugin Server going down.");
        ARPluginServerMain.stopServer(20);
    }

    public static void stopServer(int exitCode) {
        String msg = "Shutting down the AR Plugin server " + exitCode;
        log.info((Object)msg);
        System.out.println(msg);
        ARPluginSvrExecutorFactory.terminateAllPlugins();
        if (rpcDispatcher != null) {
            rpcDispatcher.close(ARPluginServerMain.rpcDispatcher.transports);
            rpcDispatcher.stopRpcProcessing();
        }
        System.exit(exitCode);
    }

    private static void startReloadThread(final String[] args) {
        new Thread(){

            public void run() {
                ARPluginServerConfiguration config = ARPluginServerConfiguration.getInstance();
                while (true) {
                    config.updateConfig(args);
                    try {
                        Thread.sleep(ARPluginServerConfiguration.getInstance().getReloadDelay());
                        continue;
                    }
                    catch (InterruptedException ie) {
                        log.error((Object)"Reloading Thread Interrupted!!", (Throwable)ie);
                        log.info((Object)"Restarting The Reload-Thread...");
                        ARPluginServerMain.startReloadThread(args);
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }
}

