/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.report;

import com.bmc.arsys.arreporting.ARDataStructure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class FormMetadata {
    private String mFormName;
    private String mFormAlias;
    private String mVersion;
    private final String mData;
    private final Map<String, FieldData> mFieldData = new HashMap<String, FieldData>();

    public FormMetadata(String metadatastring) {
        String fieldInfo;
        String formInfo;
        this.mData = metadatastring;
        ArrayList<String> arrList = ARDataStructure.processAsList(metadatastring);
        if (arrList.size() > 0 && (formInfo = (String)arrList.get(0)) != null && formInfo.length() > 0) {
            HashMap<String, String> formInfoMap = ARDataStructure.processAsMap(formInfo);
            this.mFormName = (String)formInfoMap.get("formname");
            this.mFormAlias = (String)formInfoMap.get("alias");
            this.mVersion = (String)formInfoMap.get("metadata_version");
        }
        if (arrList.size() > 1 && (fieldInfo = (String)arrList.get(1)) != null && fieldInfo.length() > 0) {
            HashMap<String, String> fieldInfoMap = ARDataStructure.processAsMap(fieldInfo);
            for (String key : fieldInfoMap.keySet()) {
                this.mFieldData.put(key, new FieldData());
            }
        }
        if (arrList.size() > 2) {
            for (int i = 2; i < arrList.size(); ++i) {
                HashMap<String, String> fmap;
                String id;
                FieldData fd = null;
                String mapInfo = (String)arrList.get(i);
                if (mapInfo == null || mapInfo.length() <= 0 || (id = (String)(fmap = ARDataStructure.processAsMap(mapInfo)).get("id")) == null) continue;
                fd = this.mFieldData.get(id);
                if (fd == null) {
                    fd = new FieldData();
                    this.mFieldData.put(id, fd);
                }
                fd.setID(Integer.parseInt(id));
                fd.setLabel((String)fmap.get("label"));
                fd.setMenu((String)fmap.get("menu"));
                fd.setDataType(fmap.get("dt") != null ? Integer.parseInt((String)fmap.get("dt")) : 4);
                fd.SetReportable(fmap.get("r") != null && ((String)fmap.get("r")).equals("1"));
                fd.SetSortable(fmap.get("s") != null && ((String)fmap.get("s")).equals("1"));
                fd.SetQuery(fmap.get("q") != null && ((String)fmap.get("q")).equals("1"));
            }
        }
    }

    public String getFormName() {
        return this.mFormName;
    }

    public String getFormAlias() {
        return this.mFormAlias;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public String getData() {
        return this.mData;
    }

    public FieldData getFieldData(String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        return this.mFieldData.get(id);
    }

    class FieldData {
        private int mID;
        private String mLabel;
        private int mDataType = 4;
        private boolean isReportable = false;
        private boolean isSortable = false;
        private boolean isQuery = false;
        private String mMenu;

        public int getID() {
            return this.mID;
        }

        public void setID(int fid) {
            this.mID = fid;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public void setLabel(String label) {
            this.mLabel = label;
        }

        public int getDataType() {
            return this.mDataType;
        }

        public void setDataType(int dataTpe) {
            this.mDataType = dataTpe;
        }

        public boolean IsReportable() {
            return this.isReportable;
        }

        public void SetReportable(boolean flag) {
            this.isReportable = flag;
        }

        public boolean IsSortable() {
            return this.isSortable;
        }

        public void SetSortable(boolean flag) {
            this.isSortable = flag;
        }

        public boolean IsQuery() {
            return this.isQuery;
        }

        public void SetQuery(boolean flag) {
            this.isQuery = flag;
        }

        public String getMenu() {
            return this.mMenu;
        }

        public void setMenu(String menu) {
            this.mMenu = menu;
        }
    }
}

