/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.registry;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARNativeAuthenticationInfo;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.arencrypt.PasswordReserveFieldEncryption;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.webservices.uddiapi.Criteria;
import com.bmc.webservices.uddiapi.CriteriaArrayList;
import com.bmc.webservices.uddiapi.CriteriaFactory;
import com.bmc.webservices.uddiapi.RegistryServerInfo;
import com.bmc.webservices.uddiapi.RegistryServerInfoFactory;
import com.bmc.webservices.uddiapi.Service;
import com.bmc.webservices.uddiapi.ServiceFactory;
import com.bmc.webservices.uddiapi.UDDIRegistry;
import com.bmc.webservices.uddiapi.UDDIRegistryFactory;
import com.bmc.webservices.uddiapi.User;
import com.bmc.webservices.uddiapi.UserFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARRegistryPlugin
extends ARFilterAPIPlugin {
    private String applicationName = null;
    private String businessName = null;
    private String webService = null;
    private String description = null;
    private String webServiceVersion = null;
    private URL wsdlUrl = null;
    private URL endPointUrl = null;
    private Value publish = null;
    private String outStr = null;
    private CriteriaArrayList criteriaArrayList = new CriteriaArrayList();
    private ArrayList<Value> outValues = new ArrayList();
    private RegistryServerInfo serverInfo;
    private UDDIRegistry uddiRegistry;
    private User user;
    private ARServerUser Server;
    private String categoryName = null;
    private String categoryValue = null;
    private String registryGUID = null;
    private String catGUID = null;
    private String interfaceVersion = null;
    private String operation = null;
    private String registryLocation = null;
    private String tempRegLocation = null;
    private String registryAdminUser;
    private String registryAdminPassword;
    private String registryAdminPasswordCopy = null;
    private URL securityServiceAccessPoint;
    private URL inquiryAccessPoint;
    private URL publishingAccessPoint;
    private URL subscriptionAccessPoint;
    private int onEventFlag = 0;
    private boolean checkLocation = true;
    private ARPluginInfo pluginInfo = new ARPluginInfo("ARSYS.ARF.REGISTRY", this);
    private final ReentrantLock lock = new ReentrantLock();
    public static final int CATEGORY_NAME_FIELD_ID = 8073;
    public static final int CATEGORY_VALUE_FIELD_ID = 8074;

    public static void init(ARPluginContext context) {
        System.out.println("Static initialize method invoked");
        System.out.println("UserDefined value for ARRegistry " + context.getConfigItem("ARRegistry"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Value> filterAPICall(ARPluginContext context, List<Value> pInValues) throws ARException {
        this.lock.lock();
        try {
            context.logMessage(this.pluginInfo, 0, "filterapiCall()");
            if (this.registryLocation == null || this.registryLocation.length() == 0) {
                context.logMessage(this.pluginInfo, 2, "Web Service Registry Location cannot be empty");
                throw new ARException(2, 9133, "");
            }
            if (pInValues.size() == 0) {
                context.logMessage(this.pluginInfo, 2, "Incorrect number of inputs. Got " + Integer.toString(pInValues.size()) + ". Expected 7 or 8");
                throw new ARException(2, 9134, "");
            }
            if (pInValues.size() > 14) {
                context.logMessage(this.pluginInfo, 2, "Incorrect number of inputs. Got " + Integer.toString(pInValues.size()) + ". Expected 7 or 8");
                throw new ARException(2, 9134, "");
            }
            context.logMessage(this.pluginInfo, 0, "applicationName : " + pInValues.get(0).toString());
            context.logMessage(this.pluginInfo, 0, "businessName : " + pInValues.get(1).toString());
            context.logMessage(this.pluginInfo, 0, "webService : " + pInValues.get(2).toString());
            context.logMessage(this.pluginInfo, 0, "webServiceVersion : " + pInValues.get(3).toString());
            context.logMessage(this.pluginInfo, 0, "description : " + pInValues.get(4).toString());
            context.logMessage(this.pluginInfo, 0, "wsdlUrl : " + pInValues.get(5).toString());
            context.logMessage(this.pluginInfo, 0, "endPointUrl : " + pInValues.get(6).toString());
            this.applicationName = pInValues.get(0).toString();
            this.businessName = pInValues.get(1).toString();
            this.webService = pInValues.get(2).toString();
            this.webServiceVersion = pInValues.get(3).toString();
            this.description = pInValues.get(4).toString();
            try {
                this.wsdlUrl = new URL(pInValues.get(5).toString());
                context.logMessage(this.pluginInfo, 0, "wsdlUrl : " + this.wsdlUrl.toString());
                this.endPointUrl = new URL(pInValues.get(6).toString());
                context.logMessage(this.pluginInfo, 0, "endPointUrl : " + this.endPointUrl.toString());
            }
            catch (MalformedURLException me) {
                throw new ARException(2, 9135, ": " + me.toString());
            }
            if (pInValues.size() >= 10) {
                this.registryGUID = pInValues.get(8).toString();
                this.interfaceVersion = pInValues.get(9).toString();
            } else {
                this.registryGUID = null;
            }
            if (pInValues.size() > 11) {
                context.logMessage(this.pluginInfo, 0, "categoryName : " + pInValues.get(10).toString());
                context.logMessage(this.pluginInfo, 0, "categoryValue : " + pInValues.get(11).toString());
                this.operation = pInValues.get(10).toString();
                this.categoryName = pInValues.get(11).toString();
                this.categoryValue = pInValues.get(12).toString();
                this.catGUID = pInValues.get(13).toString();
            } else {
                this.operation = null;
                this.categoryName = null;
                this.categoryValue = null;
                this.catGUID = null;
            }
            if (pInValues.size() > 7) {
                this.getMergedCriteriaList(context, this.registryGUID, this.categoryName, this.categoryValue, this.operation, this.catGUID);
                this.publish = pInValues.get(7);
                Integer publishInt = (Integer)this.publish.getValue();
                context.logMessage(this.pluginInfo, 0, "publish : " + publishInt.toString());
                if (publishInt == 0) {
                    if (this.catGUID != null || this.registryGUID != null) {
                        this.outStr = this.deregisterService(context);
                    }
                    this.outStr = this.registerService(context);
                }
                if (publishInt == 1) {
                    this.outStr = this.deregisterService(context);
                }
            } else {
                context.logMessage(this.pluginInfo, 0, "publish : null");
                this.outStr = this.deregisterService(context);
            }
            this.outValues.add(0, new Value(this.outStr));
        }
        finally {
            this.lock.unlock();
        }
        return this.outValues;
    }

    @Override
    public void initialize(ARPluginContext context) throws ARException {
        try {
            this.tempRegLocation = context.getARConfigEntry("Registry-Location");
            context.logMessage(this.pluginInfo, 0, "tempRegLocation " + this.tempRegLocation);
            if (this.registryLocation == null && this.tempRegLocation == null || this.tempRegLocation != null && this.tempRegLocation.equals(this.registryLocation)) {
                this.checkLocation = false;
            } else {
                this.registryLocation = this.tempRegLocation;
                this.checkLocation = true;
            }
            if (this.onEventFlag == 1) {
                this.checkLocation = true;
            } else {
                this.onEventFlag = 0;
            }
            context.logMessage(this.pluginInfo, 0, "registry location " + this.registryLocation);
            if (this.registryLocation == null || this.registryLocation.length() == 0) {
                if (this.checkLocation) {
                    context.logMessage(this.pluginInfo, 1, "Null registry location");
                    return;
                }
                return;
            }
            this.registryAdminUser = context.getARConfigEntry("Registry-Admin-User");
            context.logMessage(this.pluginInfo, 0, "registry admin user " + this.registryAdminUser);
            this.registryAdminPassword = context.getARConfigEntry("Registry-Admin-Password");
            if (this.registryAdminPassword != null && (this.registryAdminPasswordCopy == null || this.registryAdminPassword.compareTo(this.registryAdminPasswordCopy) != 0)) {
                this.registryAdminPasswordCopy = new String(this.registryAdminPassword);
                PasswordReserveFieldEncryption pwdEnc = new PasswordReserveFieldEncryption(false);
                byte[] decPasswd = pwdEnc.decryptPasswordEx(this.registryAdminPassword.getBytes());
                this.registryAdminPassword = new String(decPasswd);
            }
            if (this.registryLocation.contains("/uddi")) {
                this.securityServiceAccessPoint = new URL(this.registryLocation + "/services/security");
                this.inquiryAccessPoint = new URL(this.registryLocation + "/services/inquiry");
                this.publishingAccessPoint = new URL(this.registryLocation + "/services/publication");
                this.subscriptionAccessPoint = new URL(this.registryLocation + "/services/subscription");
            } else {
                this.securityServiceAccessPoint = new URL(this.registryLocation + "/uddi/services/security");
                this.inquiryAccessPoint = new URL(this.registryLocation + "/uddi/services/inquiry");
                this.publishingAccessPoint = new URL(this.registryLocation + "/uddi/services/publication");
                this.subscriptionAccessPoint = new URL(this.registryLocation + "/uddi/services/subscription");
            }
            this.serverInfo = RegistryServerInfoFactory.newInstance((URL)this.securityServiceAccessPoint, (URL)this.inquiryAccessPoint, (URL)this.publishingAccessPoint, (URL)this.subscriptionAccessPoint);
            this.uddiRegistry = UDDIRegistryFactory.newInstance((RegistryServerInfo)this.serverInfo);
            this.user = UserFactory.newInstance((String)this.registryAdminUser, (String)this.registryAdminPassword);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ARException(2, 9134, e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(ARPluginContext context, int pEventID) throws ARException {
        context.logMessage(this.pluginInfo, 0, "on event called with event id " + String.valueOf(pEventID));
        this.lock.lock();
        try {
            if (pEventID == 10005) {
                this.onEventFlag = 1;
                this.initialize(context);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private String registerService(ARPluginContext context) {
        Service retService = null;
        try {
            Service svcInput = ServiceFactory.newInstance((String)this.webService, (String)this.businessName, (String)this.applicationName, (String)this.webServiceVersion, (String)this.interfaceVersion, (String)this.description, (URL)this.endPointUrl, (URL)this.wsdlUrl, (CriteriaArrayList)(this.criteriaArrayList.size() == 0 ? null : this.criteriaArrayList));
            retService = this.uddiRegistry.publishService(this.user, svcInput);
            context.logMessage(this.pluginInfo, 0, "registerService returned " + retService);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        if (retService != null) {
            return "Registered";
        }
        return "Not Registered";
    }

    private String deregisterService(ARPluginContext context) {
        boolean retVal = false;
        try {
            Service svcInput = ServiceFactory.newInstance((String)this.webService, (String)this.businessName, (String)this.applicationName, (String)this.webServiceVersion);
            retVal = this.uddiRegistry.deleteService(this.user, svcInput);
            context.logMessage(this.pluginInfo, 0, "deregisterService returned " + retVal);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        if (retVal) {
            return "Not Registered";
        }
        return "Registered";
    }

    private List<Entry> getCategoryInfoFromServer(ARPluginContext context, String registryGUID) throws ARException {
        List entryObj = null;
        List list = null;
        int[] fieldIds = new int[3];
        int port = 0;
        OutputInteger ret = null;
        RelationalOperationInfo relop1 = new RelationalOperationInfo();
        QualifierInfo qualifier = new QualifierInfo(relop1);
        relop1.setOperation(1);
        relop1.setLeftOperand(new ArithmeticOrRelationalOperand(8082));
        relop1.setRightOperand(new ArithmeticOrRelationalOperand(new Value(registryGUID)));
        fieldIds[0] = 8073;
        fieldIds[1] = 8074;
        fieldIds[2] = 179;
        String serverName = context.getARConfigEntry("Server-Name");
        String serverPort = context.getARConfigEntry("TCD-Specific-Port");
        this.Server = new ARServerUser((ARNativeAuthenticationInfo)context, null, serverName);
        if (serverPort != null) {
            port = Integer.valueOf(serverPort);
            this.Server.setPort(port);
        }
        entryObj = this.Server.getListEntryObjects("AR System Web Services Category", qualifier, 0, 100, list, fieldIds, false, ret);
        return entryObj;
    }

    private void getMergedCriteriaList(ARPluginContext context, String registryGUID, String categoryName, String categoryValue, String Operation, String catGUID) throws ARException {
        Criteria criteria;
        List<Entry> entryObj = null;
        ArrayList<String> guidList = new ArrayList<String>();
        int i = 0;
        String catName = null;
        String catValue = null;
        entryObj = this.getCategoryInfoFromServer(context, registryGUID);
        this.criteriaArrayList.clear();
        for (i = 0; i < entryObj.size(); ++i) {
            catName = ((Value)entryObj.get(i).get((Object)8073)).getValue().toString();
            catValue = ((Value)entryObj.get(i).get((Object)8074)).getValue().toString();
            guidList.add(((Value)entryObj.get(i).get((Object)179)).getValue().toString());
            criteria = CriteriaFactory.newInstance((String)catName, (String)catValue);
            this.criteriaArrayList.add((Object)criteria);
        }
        if (Operation == null) {
            return;
        }
        if (Operation.equalsIgnoreCase("Add")) {
            criteria = CriteriaFactory.newInstance((String)categoryName, (String)categoryValue);
            this.criteriaArrayList.add((Object)criteria);
        }
        if (Operation.equalsIgnoreCase("Modify")) {
            for (i = 0; i < this.criteriaArrayList.size(); ++i) {
                if (!((String)guidList.get(i)).equals(catGUID)) continue;
                this.criteriaArrayList.remove(i);
                criteria = CriteriaFactory.newInstance((String)categoryName, (String)categoryValue);
                this.criteriaArrayList.add((Object)criteria);
            }
        }
        if (Operation.equalsIgnoreCase("Delete")) {
            for (i = 0; i < this.criteriaArrayList.size(); ++i) {
                if (!((String)guidList.get(i)).equals(catGUID)) continue;
                this.criteriaArrayList.remove(i);
            }
        }
    }
}

