/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.ftsconfig.helper.shared;

import com.bmc.arsys.plugins.ftsconfig.helper.FTSConfFileHelper;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.AbstractEntry;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.AbstractEntryContainer;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.ConfigurationFileListIterator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigurationFile
implements AbstractEntryContainer {
    protected List<AbstractEntry> entries_ = new ArrayList<AbstractEntry>();

    public abstract void parse(File var1) throws FileNotFoundException, IOException, ParseException;

    public void save(File file) throws FileNotFoundException, IOException {
        FTSConfFileHelper.writeStringToFile(this.toString(), file);
    }

    @Override
    public Iterator<AbstractEntry> iterator() {
        return this.getEntries().iterator();
    }

    @Override
    public List<AbstractEntry> getEntries() {
        return Collections.unmodifiableList(this.entries_);
    }

    @Override
    public void addEntry(AbstractEntry entry) {
        if (!this.allowsEntryType(entry)) {
            throw new IllegalArgumentException("Entry type not allowed");
        }
        this.entries_.add(entry);
    }

    @Override
    public void addEntry(int index, AbstractEntry entry) {
        if (!this.allowsEntryType(entry)) {
            throw new IllegalArgumentException("Entry type not allowed");
        }
        this.entries_.add(index, entry);
    }

    @Override
    public AbstractEntry getEntry(int index) {
        return this.entries_.get(index);
    }

    @Override
    public int indexOfEntry(AbstractEntry entry) {
        return this.entries_.indexOf(entry);
    }

    @Override
    public void removeEntry(AbstractEntry entry) {
        this.entries_.remove(entry);
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof AbstractConfigurationFile) {
            List<AbstractEntry> aa;
            AbstractConfigurationFile configurationFile = (AbstractConfigurationFile)obj;
            List<AbstractEntry> a = this.getEntries();
            if (FTSConfFileHelper.nullableEquals(a, aa = configurationFile.getEntries())) {
                result = true;
            }
        }
        return result;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (AbstractEntry current : this) {
            result.append(current);
        }
        return result.toString();
    }

    protected boolean continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    public ConfigurationFileListIterator getConfigurationFileListIterator() {
        return new ConfigurationFileListIterator(this, this.entries_.listIterator());
    }
}

