/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.ftsconfig.helper;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.plugins.ftsconfig.helper.FTSConfFileHelper;
import com.bmc.arsys.plugins.ftsconfig.helper.FTSConfigPluginConstants;
import com.bmc.arsys.plugins.ftsconfig.helper.RegexFileLineFilter;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.AbstractEntry;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.PropertiesConfigurationFile;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.PropertyEntry;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.XMLParser;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTSConfigConfFileCreate {
    public static final String UTF_8 = "UTF-8";
    private static Logger log = Logger.getLogger(FTSConfigConfFileCreate.class);
    private static int javaPluginLocation_;

    public void createEntryFTS(File arcfgFile, File armonitorFile, File ftsPrimaryConfigFile, File ftsSecondaryConfigFile, String ftscoreFolder, String arserverName, String pluginsvrFolder, String arhome, String ftsJavaPath, String ftsCollectionDirectory, String ftsConfigurationDirectory, Entry entry) throws ARException {
        try {
            Value fts_agent = (Value)entry.get((Object)FTSConfigPluginConstants.FIELD_FTS_AGENT_ENABLED.getFieldID());
            Value svr_config = (Value)entry.get((Object)FTSConfigPluginConstants.FIELD_SERVER_CONFIGURATION.getFieldID());
            Value fts_port1 = (Value)entry.get((Object)FTSConfigPluginConstants.FIELD_FTS_PORT1.getFieldID());
            Value max_jvm_mem1 = (Value)entry.get((Object)FTSConfigPluginConstants.FIELD_MAX_JVM_MEM1.getFieldID());
            Value prim_svr_name = (Value)entry.get((Object)FTSConfigPluginConstants.FIELD_PRIMARY_SVR_NAME.getFieldID());
            Value fts_port2 = (Value)entry.get((Object)FTSConfigPluginConstants.FIELD_FTS_PORT2.getFieldID());
            Value max_jvm_mem2 = (Value)entry.get((Object)FTSConfigPluginConstants.FIELD_MAX_JVM_MEM2.getFieldID());
            Value ftsCollectionVal = (Value)entry.get((Object)FTSConfigPluginConstants.FIELD_FTS_COLLECTION_DIR.getFieldID());
            String ftsCollectionDir = ftsCollectionVal.getValue() != null ? ftsCollectionVal.toString() : "";
            Value ftsConfigVal = (Value)entry.get((Object)FTSConfigPluginConstants.FIELD_FTS_CONFIG_DIR.getFieldID());
            String ftsConfigDir = ftsCollectionVal.getValue() != null ? ftsConfigVal.toString() : "";
            int fts_agent_value = fts_agent != null && fts_agent.getValue() != null ? Integer.parseInt(fts_agent.toString()) : 1;
            int svr_config_value = svr_config != null && svr_config.getValue() != null ? Integer.parseInt(svr_config.toString()) : 0;
            int fts_port1_value = fts_port1 != null && fts_port1.getValue() != null ? Integer.parseInt(fts_port1.toString()) : 0;
            int max_jvm_mem1_value = max_jvm_mem1 != null && max_jvm_mem1.getValue() != null ? Integer.parseInt(max_jvm_mem1.toString()) : 0;
            String prim_svr_name_str = prim_svr_name != null && prim_svr_name.getValue() != null ? prim_svr_name.toString() : "";
            int fts_port2_value = fts_port2 != null && fts_port2.getValue() != null ? Integer.parseInt(fts_port2.toString()) : 0;
            int max_jvm_mem2_value = max_jvm_mem2 != null && max_jvm_mem2.getValue() != null ? Integer.parseInt(max_jvm_mem2.toString()) : 0;
            log.debug((Object)("Entries Given by User: FTS Agent:" + fts_agent_value + ":Server Configuration:" + svr_config_value + ":FTS Port1:" + fts_port1_value + ":MAX JVM Memory1:" + max_jvm_mem1_value + ":prim_svr_name_str:" + prim_svr_name_str + ":fts_port2_value:" + fts_port2_value + ":max_jvm_mem2_value:" + max_jvm_mem2_value + ":FTS Collection Directory:" + ftsCollectionDir + ":FTS Configuration Directory:" + ftsConfigDir));
            this.createArcfgConfiguration(arcfgFile, svr_config_value, fts_port1_value, prim_svr_name_str, fts_port2_value, arhome, arserverName, ftsCollectionDir, ftsConfigDir, fts_agent_value);
            log.debug((Object)"After FTSConfigConfFileCreate.createArcfgConfiguration");
            this.createArmonConfiguration(armonitorFile, fts_agent_value, svr_config_value, max_jvm_mem1_value, max_jvm_mem2_value, arhome, ftsPrimaryConfigFile, ftsSecondaryConfigFile, ftscoreFolder, ftsJavaPath, arserverName, pluginsvrFolder);
            log.debug((Object)"After FTSConfigConfFileCreate.createArmonConfiguration");
            if (svr_config_value == 0) {
                this.createftsprimConfiguration(ftsPrimaryConfigFile, fts_port1_value);
            } else if (svr_config_value == 1) {
                this.createftsprimConfiguration(ftsPrimaryConfigFile, fts_port1_value);
                this.createftsprimConfiguration(ftsSecondaryConfigFile, fts_port2_value);
            }
            log.debug((Object)"After FTSConfigConfFileCreate.createftsprimConfiguration");
        }
        catch (Exception ex) {
            throw new ARException(2, 8750, "Failed to Create or Update File " + ex.getLocalizedMessage());
        }
    }

    public void createArcfgConfiguration(File arcfgFile, int svr_config_value, int fts_port1_value, String prim_svr_name_str, int fts_port2_value, String arhome, String arserverName, String fullTextCollectionDir, String fullTextConfigDir, int fts_agent_value) throws Exception {
        try {
            String key = "Server-Plugin-Alias";
            String plugVal = "ARSYS.ARF.FTS ARSYS.ARF.FTS ";
            String replaceval_ = "";
            int port = 0;
            if (svr_config_value == 2) {
                port = fts_port2_value;
                replaceval_ = plugVal + prim_svr_name_str + ":" + port;
            } else {
                port = fts_port1_value;
                replaceval_ = plugVal + arserverName + ":" + port;
            }
            String issvrgrpmember = this.readArcfgForProperty(arcfgFile, "Server-Group-Member");
            if (svr_config_value == 2 && fts_agent_value == 1) {
                this.removeCFGentry(arcfgFile, key, plugVal + prim_svr_name_str + ":" + fts_port2_value);
                this.removeCFGentry(arcfgFile, key, plugVal + arserverName + ":" + fts_port1_value);
                this.setCFGentry(arcfgFile, key, replaceval_, plugVal);
                if (issvrgrpmember != null && issvrgrpmember.length() > 0 && issvrgrpmember.equalsIgnoreCase("T")) {
                    this.setCFGentry(arcfgFile, "Full-Text-Mode", "Server-Group-secondary", "Server-Group-secondary");
                }
                return;
            }
            this.setCFGentry(arcfgFile, key, replaceval_, plugVal);
            key = "Full-Text-Mode";
            replaceval_ = svr_config_value == 0 ? (plugVal = "Single-Server") : (svr_config_value == 1 ? (issvrgrpmember != null && issvrgrpmember.length() > 0 && issvrgrpmember.equalsIgnoreCase("T") ? (plugVal = "Server-Group-primary") : (plugVal = "Single-Server")) : (svr_config_value == 2 ? (issvrgrpmember != null && issvrgrpmember.length() > 0 && issvrgrpmember.equalsIgnoreCase("T") ? (plugVal = "Server-Group-secondary") : (plugVal = "Single-Server")) : (plugVal = "Disabled")));
            this.setCFGentry(arcfgFile, key, replaceval_, plugVal);
            if ((svr_config_value == 1 || svr_config_value == 2) && issvrgrpmember != null && issvrgrpmember.length() > 0 && issvrgrpmember.equalsIgnoreCase("T")) {
                replaceval_ = plugVal = String.valueOf(fts_port2_value);
                key = "Full-Text-Secondary-Plugin-Port";
                this.setCFGentry(arcfgFile, key, replaceval_, plugVal);
            }
            this.setCFGentry(arcfgFile, key, replaceval_, plugVal);
            this.setCFGentry(arcfgFile, "Full-Text-Collection-Directory", fullTextCollectionDir, "");
            this.setCFGentry(arcfgFile, "Full-Text-Configuration-Directory", fullTextConfigDir, "");
        }
        catch (Exception ex) {
            throw new ARException(2, 8750, "Failed to set ar.conf entry.In method createArcfgConfiguration:" + ex.getLocalizedMessage());
        }
    }

    public void createArmonConfiguration(File armonitorFile, int fts_agent_value, int svr_config_value, int max_jvm_mem1_value, int max_jvm_mem2_value, String arhome, File ftsPrimaryConfigFile, File ftsSecondaryConfigFile, String ftscoreFolder, String ftsJavaPath, String arserverName, String pluginsvrFolder) throws Exception {
        try {
            String osName = FTSConfFileHelper.getOsName();
            String keyprocessPrimary = "";
            String keyprocessSecondary = "";
            keyprocessPrimary = FTSConfFileHelper.isMemberWindows(osName) ? "fts" + FTSConfFileHelper.getFileSeparator() + FTSConfFileHelper.getFileSeparator() + "primary" : "fts" + FTSConfFileHelper.getFileSeparator() + "primary";
            keyprocessSecondary = FTSConfFileHelper.isMemberWindows(osName) ? "fts" + FTSConfFileHelper.getFileSeparator() + FTSConfFileHelper.getFileSeparator() + "secondary" : "fts" + FTSConfFileHelper.getFileSeparator() + "secondary";
            String memory1 = " -Xmx" + max_jvm_mem1_value + "m";
            String memory2 = " -Xmx" + max_jvm_mem2_value + "m";
            String ipv6Parameter = " -Djava.net.preferIPv4Stack=true -Djava.net.preferIPv6Addresses=false";
            String osArch = FTSConfFileHelper.getOsArchitecture();
            if (osName != null && osName.startsWith("Windows") && !FTSConfFileHelper.is64bitWindows(osArch)) {
                ipv6Parameter = "";
            }
            String classPath = " -classpath ";
            String ftsprimFolder = ftsPrimaryConfigFile.getParent();
            String ftssecFolder = ftsSecondaryConfigFile.getParent();
            String plugjarPath = pluginsvrFolder + FTSConfFileHelper.getFileSeparator() + "arpluginsvr7604_build002.jar";
            String mainCla = " com.bmc.arsys.pluginsvr.ARPluginServerMain ";
            String searchvalueWindows1 = "\"" + ftsJavaPath + "\"" + memory1 + ipv6Parameter + classPath + "\"" + ftsprimFolder + ";" + ftscoreFolder + ";" + pluginsvrFolder + ";" + plugjarPath + "\"" + mainCla + "-x " + arserverName + " -i " + "\"" + arhome + "\"" + " -m";
            String searchvalueWindows2 = "\"" + ftsJavaPath + "\"" + memory2 + ipv6Parameter + classPath + "\"" + ftssecFolder + ";" + ftscoreFolder + ";" + pluginsvrFolder + ";" + plugjarPath + "\"" + mainCla + "-x " + arserverName + " -i " + "\"" + arhome + "\"" + " -m";
            String searchvalueUnix1 = ftsJavaPath + memory1 + ipv6Parameter + classPath + ftsprimFolder + ":" + ftscoreFolder + ":" + pluginsvrFolder + ":" + plugjarPath + ":" + mainCla + "-x " + arserverName + " -i " + arhome + " -m";
            String searchvalueUnix2 = ftsJavaPath + memory2 + ipv6Parameter + classPath + ftssecFolder + ":" + ftscoreFolder + ":" + pluginsvrFolder + ":" + plugjarPath + ":" + mainCla + "-x " + arserverName + " -i " + arhome + " -m";
            if (fts_agent_value == 0) {
                if (svr_config_value == 0) {
                    if (FTSConfFileHelper.isMemberWindows(osName)) {
                        this.createFTSMonitorRentry(armonitorFile, keyprocessPrimary, searchvalueWindows1);
                        this.unsetFTSMONITORentry(armonitorFile, keyprocessSecondary, searchvalueWindows2);
                    } else {
                        this.createFTSMonitorRentry(armonitorFile, keyprocessPrimary, searchvalueUnix1);
                        this.unsetFTSMONITORentry(armonitorFile, keyprocessSecondary, searchvalueUnix2);
                    }
                } else if (svr_config_value == 1) {
                    if (FTSConfFileHelper.isMemberWindows(osName)) {
                        this.createFTSMonitorRentry(armonitorFile, keyprocessPrimary, searchvalueWindows1);
                        this.createFTSMonitorRentry(armonitorFile, keyprocessSecondary, searchvalueWindows2);
                    } else {
                        this.createFTSMonitorRentry(armonitorFile, keyprocessPrimary, searchvalueUnix1);
                        this.createFTSMonitorRentry(armonitorFile, keyprocessSecondary, searchvalueUnix2);
                    }
                } else if (FTSConfFileHelper.isMemberWindows(osName)) {
                    this.unsetFTSMONITORentry(armonitorFile, keyprocessPrimary, searchvalueWindows1);
                    this.unsetFTSMONITORentry(armonitorFile, keyprocessSecondary, searchvalueWindows2);
                } else {
                    this.unsetFTSMONITORentry(armonitorFile, keyprocessPrimary, searchvalueUnix1);
                    this.unsetFTSMONITORentry(armonitorFile, keyprocessSecondary, searchvalueUnix2);
                }
            } else if (FTSConfFileHelper.isMemberWindows(osName)) {
                this.unsetFTSMONITORentry(armonitorFile, keyprocessPrimary, searchvalueWindows1);
                this.unsetFTSMONITORentry(armonitorFile, keyprocessSecondary, searchvalueWindows2);
            } else {
                this.unsetFTSMONITORentry(armonitorFile, keyprocessPrimary, searchvalueUnix1);
                this.unsetFTSMONITORentry(armonitorFile, keyprocessSecondary, searchvalueUnix2);
            }
        }
        catch (Exception ex) {
            throw new ARException(2, 8750, "Failed to set ar.conf entry.In method createArcfgConfiguration:" + ex.getLocalizedMessage());
        }
    }

    public void createftsprimConfiguration(File ftsConfigFile, int port) throws Exception {
        try {
            String key_ = String.valueOf(port);
            XMLParser parser = new XMLParser(ftsConfigFile.getAbsolutePath());
            if (key_ != null && !key_.trim().equals("")) {
                try {
                    parser.updateNodeValue("/pluginsvr_config/port", key_);
                    parser.commit();
                }
                catch (Exception e) {}
            }
        }
        catch (Exception ex) {
            throw new ARException(2, 8750, "Failed to set ar.conf entry.In method createftsprimConfiguration:" + ex.getLocalizedMessage());
        }
    }

    public String retrievePort(File ftsConfigFile) throws Exception {
        String port = "";
        try {
            XMLParser parser = new XMLParser(ftsConfigFile.getAbsolutePath());
            port = parser.getNodeValue("/pluginsvr_config/port");
        }
        catch (Exception ex) {
            throw new ARException(2, 8750, "Failed to set ar.conf entry.In method createftsprimConfiguration:" + ex.getLocalizedMessage());
        }
        return port;
    }

    private void createFTSMonitorRentry(File armonitorFile, String key, String replaceValue_) throws Exception {
        try {
            log.info((Object)"In Method createFTSMonitorRentry");
            String pattern = ".*" + key + ".*";
            RegexFileLineFilter filterLine = new RegexFileLineFilter(pattern);
            List<String> lines = FTSConfFileHelper.readLines(armonitorFile, null);
            ListIterator<String> listIterator = lines.listIterator();
            String line = "";
            boolean lineFound = false;
            while (listIterator.hasNext()) {
                line = listIterator.next();
                if (!filterLine.acceptLine(line)) continue;
                lineFound = true;
                if (!line.startsWith("#")) {
                    listIterator.set(replaceValue_);
                    continue;
                }
                listIterator.remove();
                listIterator.add(replaceValue_);
            }
            if (!lineFound) {
                lines.add(replaceValue_);
            }
            if (armonitorFile != null && armonitorFile.exists() && armonitorFile.canWrite()) {
                FTSConfFileHelper.writeLines(lines, armonitorFile);
                log.info((Object)("Updated SuccessFully" + lines.toString()));
            } else {
                log.warn((Object)("Could Not Write in File" + armonitorFile.getAbsolutePath()));
            }
        }
        catch (Exception ex) {
            throw new ARException(2, 8750, "Failed to set armonitor.conf entry.In method createFTSMonitorRentry:" + ex.getLocalizedMessage());
        }
    }

    private void unsetFTSMONITORentry(File armonitorFile, String searchValue_, String replaceValue_) throws Exception {
        try {
            log.info((Object)"In Method unsetFTSMONITORentry");
            String pattern = ".*" + searchValue_ + ".*";
            RegexFileLineFilter filterLine = new RegexFileLineFilter(pattern);
            List<String> lines = FTSConfFileHelper.readLines(armonitorFile, null);
            ListIterator<String> listIterator = lines.listIterator();
            String line = "";
            boolean lineFound = false;
            while (listIterator.hasNext()) {
                line = listIterator.next();
                if (!filterLine.acceptLine(line)) continue;
                lineFound = true;
                if (line.startsWith("#")) continue;
                listIterator.set("#" + line);
            }
            if (!lineFound) {
                lines.add("#" + replaceValue_);
            }
            if (armonitorFile != null && armonitorFile.exists() && armonitorFile.canWrite()) {
                FTSConfFileHelper.writeLines(lines, armonitorFile);
                log.info((Object)("Updated SuccessFully" + lines.toString()));
            } else {
                log.warn((Object)("Could Not Write in File" + armonitorFile.getAbsolutePath()));
            }
        }
        catch (Exception ex) {
            throw new ARException(2, 8750, "Failed to unset armonitor.conf entry.In method unsetFTSMONITORentry:" + ex.getLocalizedMessage());
        }
    }

    private void setCFGentry(File file_, String key_, String replaceval_, String searchval_) {
        try {
            log.debug((Object)"In setCFGentry");
            PropertiesConfigurationFile propertiesConfigurationFile = new PropertiesConfigurationFile();
            propertiesConfigurationFile.setAllowMultipleValuesPerKey(true);
            propertiesConfigurationFile.setUseSeparatorValueSpacing(true);
            propertiesConfigurationFile.parse(file_);
            List<String> propertyValues = propertiesConfigurationFile.getProperties(key_);
            if (!propertyValues.isEmpty()) {
                if (!this.isValueExists(propertyValues, searchval_)) {
                    if (propertyValues.size() >= 1) {
                        PropertyEntry propertyEntry = new PropertyEntry(key_, replaceval_);
                        propertyEntry.setSeparator(':');
                        propertyEntry.setSeparatorValueSpacing(" ");
                        propertyEntry.setUseSeparatorValueSpacing(true);
                        propertyEntry.setValue(replaceval_);
                        propertiesConfigurationFile.setProperty(propertyEntry);
                        propertiesConfigurationFile.save(file_);
                    }
                } else if (propertyValues.size() == 0) {
                    PropertyEntry propertyEntry = propertiesConfigurationFile.getPropertyEntry(key_, propertyValues.get(0));
                    propertyEntry.setSeparator(':');
                    propertyEntry.setSeparatorValueSpacing(" ");
                    propertyEntry.setUseSeparatorValueSpacing(true);
                    propertyEntry.setValue(replaceval_);
                    propertiesConfigurationFile.setProperty(propertyEntry);
                    propertiesConfigurationFile.save(file_);
                } else if (key_.equalsIgnoreCase("Server-Plugin-Alias")) {
                    PropertyEntry propertyEntry = propertiesConfigurationFile.getPropertyEntry(key_, propertyValues.get(javaPluginLocation_));
                    propertyEntry.setSeparator(':');
                    propertyEntry.setSeparatorValueSpacing(" ");
                    propertyEntry.setUseSeparatorValueSpacing(true);
                    propertyEntry.setValue(replaceval_);
                    propertiesConfigurationFile.save(file_);
                }
            } else {
                PropertyEntry propertyEntry = new PropertyEntry(key_, replaceval_);
                propertyEntry.setSeparator(':');
                propertyEntry.setSeparatorValueSpacing(" ");
                propertyEntry.setUseSeparatorValueSpacing(true);
                propertiesConfigurationFile.addProperty(propertyEntry);
                propertiesConfigurationFile.save(file_);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    public String readArMonitorforJVM(File armonitorFile, String typeSearch) throws Exception {
        String jvmSize;
        block4: {
            jvmSize = "";
            try {
                List<String> lines = FTSConfFileHelper.readLines(armonitorFile, null);
                ListIterator<String> listIterator = lines.listIterator();
                String pattern = ".*" + typeSearch + ".*";
                RegexFileLineFilter filterLine = new RegexFileLineFilter(pattern);
                String line = "";
                while (listIterator.hasNext()) {
                    String[] instanceTokens;
                    line = listIterator.next();
                    if (!filterLine.acceptLine(line)) continue;
                    for (String token : instanceTokens = line.split(" ")) {
                        if (token.length() == 0 || !token.startsWith("-Xmx")) continue;
                        jvmSize = token.substring(4, token.length() - 1);
                        break block4;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                throw new ARException(2, 8750, "Failed to read armonitor.conf .In method readArMonitorforPort:" + ex.getLocalizedMessage());
            }
        }
        return jvmSize;
    }

    public String readArcfgForProperty(File arCfgFile, String propKey) throws ARException {
        String propStr = null;
        try {
            PropertiesConfigurationFile propertiesConfigurationFile = new PropertiesConfigurationFile();
            propertiesConfigurationFile.setAllowMultipleValuesPerKey(true);
            propertiesConfigurationFile.setUseSeparatorValueSpacing(true);
            propertiesConfigurationFile.parse(arCfgFile);
            List<String> propertyValues = propertiesConfigurationFile.getProperties(propKey);
            StringBuilder propVal = new StringBuilder();
            Iterator<String> itr = propertyValues.iterator();
            while (itr.hasNext()) {
                propVal.append(itr.next());
            }
            propStr = propVal.toString();
        }
        catch (Exception ex) {
            throw new ARException(2, 8750, "Failed to read ar.conf " + ex.getLocalizedMessage());
        }
        return propStr;
    }

    public String readArcfgforPort(File arcfgFile, String key_, String searchval_) throws Exception {
        String primserverName;
        block7: {
            primserverName = "";
            try {
                PropertiesConfigurationFile propertiesConfigurationFile = new PropertiesConfigurationFile();
                propertiesConfigurationFile.setAllowMultipleValuesPerKey(true);
                propertiesConfigurationFile.setUseSeparatorValueSpacing(true);
                propertiesConfigurationFile.parse(arcfgFile);
                List<String> propertyValues = propertiesConfigurationFile.getProperties(key_);
                if (propertyValues.isEmpty()) break block7;
                if (this.isValueExists(propertyValues, searchval_)) {
                    primserverName = propertyValues.get(javaPluginLocation_);
                    if (primserverName != null && primserverName.length() > 0) {
                        String[] instanceTokens = primserverName.split(" ");
                        primserverName = instanceTokens[2];
                    } else {
                        primserverName = "";
                    }
                    break block7;
                }
                for (AbstractEntry current : propertiesConfigurationFile.getEntries()) {
                    String propertyEntry;
                    if (current.getType() != 1 || (propertyEntry = current.toString()) == null || propertyEntry.equals("") || !propertyEntry.startsWith("#" + key_)) continue;
                    String value = propertyEntry.substring(propertyEntry.indexOf(":") + 1);
                    if (value != null && value.length() > 0 && value.trim().startsWith(searchval_)) {
                        String[] instanceTokens = value.trim().split(" ");
                        primserverName = instanceTokens[2];
                        break;
                    }
                    primserverName = "";
                }
            }
            catch (Exception ex) {
                throw new ARException(2, 8750, "Failed to read armonitor.conf .In method readArMonitorforPort:" + ex.getLocalizedMessage());
            }
        }
        return primserverName;
    }

    public boolean isArcfgCommented(File arcfgFile, String key_, String searchval_) throws Exception {
        boolean isComm = false;
        try {
            PropertiesConfigurationFile propertiesConfigurationFile = new PropertiesConfigurationFile();
            propertiesConfigurationFile.setAllowMultipleValuesPerKey(true);
            propertiesConfigurationFile.setUseSeparatorValueSpacing(true);
            propertiesConfigurationFile.parse(arcfgFile);
            List<String> propertyValues = propertiesConfigurationFile.getProperties(key_);
            if (!propertyValues.isEmpty()) {
                isComm = !this.isValueExists(propertyValues, searchval_);
            }
        }
        catch (Exception ex) {
            throw new ARException(2, 8750, "Failed to read armonitor.conf .In method isArcfgCommented:" + ex.getLocalizedMessage());
        }
        return isComm;
    }

    public boolean readArMonitorforConfig(File armonitorFile, String keysearch) throws Exception {
        boolean isSet = false;
        try {
            List<String> lines = FTSConfFileHelper.readLines(armonitorFile, null);
            ListIterator<String> listIterator = lines.listIterator();
            String pattern = ".*" + keysearch + ".*";
            RegexFileLineFilter filterLine = new RegexFileLineFilter(pattern);
            String line = "";
            while (listIterator.hasNext()) {
                line = listIterator.next();
                if (!filterLine.acceptLine(line) || line.startsWith("#")) continue;
                isSet = true;
                break;
            }
        }
        catch (Exception ex) {
            throw new ARException(2, 8750, "Failed to read armonitor.conf .In method readArMonitorforConfig:" + ex.getLocalizedMessage());
        }
        return isSet;
    }

    private boolean isValueExists(List<String> values, String replaceValue_) {
        boolean retValue = false;
        try {
            for (String value : values) {
                if (replaceValue_.equals("") || !value.contains(replaceValue_)) continue;
                retValue = true;
                javaPluginLocation_ = values.indexOf(value);
                break;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return retValue;
    }

    private void removeCFGentry(File file_, String key_, String replaceValue_) {
        try {
            PropertiesConfigurationFile propertiesConfigurationFile = new PropertiesConfigurationFile();
            propertiesConfigurationFile.setAllowMultipleValuesPerKey(true);
            propertiesConfigurationFile.setUseSeparatorValueSpacing(true);
            propertiesConfigurationFile.parse(file_);
            List<String> propertyValues = propertiesConfigurationFile.getProperties(key_);
            if (!propertyValues.isEmpty() && propertyValues.contains(replaceValue_)) {
                String value = "";
                value = propertyValues.size() > 1 ? replaceValue_ : propertyValues.get(0);
                PropertyEntry propertyEntry = propertiesConfigurationFile.getPropertyEntry(key_, value);
                propertyEntry.setSeparator(':');
                propertyEntry.setValue(value);
                propertyEntry.setSeparatorValueSpacing(" ");
                propertyEntry.setUseSeparatorValueSpacing(true);
                propertiesConfigurationFile.removeEntry(propertyEntry);
                propertiesConfigurationFile.save(file_);
            }
        }
        catch (Throwable t) {
            log.debug((Object)("In unsetCFGentry" + t));
        }
    }

    private void unsetCFGentry(File file_, String key_, String replaceValue_) {
        try {
            PropertiesConfigurationFile propertiesConfigurationFile = new PropertiesConfigurationFile();
            propertiesConfigurationFile.setAllowMultipleValuesPerKey(true);
            propertiesConfigurationFile.setUseSeparatorValueSpacing(true);
            propertiesConfigurationFile.parse(file_);
            List<String> propertyValues = propertiesConfigurationFile.getProperties(key_);
            if (!propertyValues.isEmpty() && propertyValues.contains(replaceValue_)) {
                String value = "";
                value = propertyValues.size() > 1 ? replaceValue_ : propertyValues.get(0);
                PropertyEntry propertyEntry = propertiesConfigurationFile.getPropertyEntry(key_, value);
                propertyEntry.setSeparator(':');
                propertyEntry.setValue(value);
                propertyEntry.setSeparatorValueSpacing(" ");
                propertyEntry.setUseSeparatorValueSpacing(true);
                propertiesConfigurationFile.commentProperty("#", propertyEntry);
                propertiesConfigurationFile.save(file_);
            }
        }
        catch (Throwable t) {
            log.debug((Object)("In unsetCFGentry" + t));
        }
    }
}

