/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.ftsconfig.helper;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FTSConfFileHelper {
    public static final String UTF_8 = "UTF-8";

    public static boolean isMemberWindows(String osname) {
        boolean result = false;
        if (osname != null && osname.startsWith("Windows ")) {
            result = true;
        }
        return result;
    }

    public static boolean is64bitWindows(String architecture) {
        Boolean result = false;
        if (architecture != null && architecture.indexOf("64") >= 0) {
            result = true;
        }
        return result;
    }

    public static String getConfExtension() {
        String osName = FTSConfFileHelper.getOsName();
        if (FTSConfFileHelper.isMemberWindows(osName)) {
            return ".cfg";
        }
        return ".conf";
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static String getOsArchitecture() {
        return System.getProperty("os.arch");
    }

    public static String getOsVersion() {
        return System.getProperty("os.version");
    }

    public static boolean digitsOnly(String text) {
        boolean result = true;
        if (FTSConfFileHelper.isNullOrEmpty(text, true)) {
            result = false;
        } else {
            char[] c = text.toCharArray();
            for (int j = 0; result && j < c.length; ++j) {
                if (Character.isDigit(c[j])) continue;
                result = false;
            }
        }
        return result;
    }

    public static boolean isNullOrEmpty(String text, boolean trim) {
        boolean result = true;
        if (text != null) {
            String data = text;
            if (trim) {
                data = data.trim();
            }
            if (data.length() > 0) {
                result = false;
            }
        }
        return result;
    }

    public static String getUserDir() {
        return System.getProperty("user.dir");
    }

    public static String getJavaIOTmpdir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static void writeLines(List<String> lines, File outputFile) throws IOException {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter writer = null;
        try {
            FTSConfFileHelper.createFile(outputFile);
            fos = new FileOutputStream(outputFile);
            osw = new OutputStreamWriter((OutputStream)fos, UTF_8);
            writer = new BufferedWriter(osw);
            for (String current : lines) {
                writer.write(current);
                writer.newLine();
            }
            writer.flush();
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable t) {}
            }
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (Throwable t) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    public static boolean createFile(File file) throws IOException {
        boolean result = false;
        if (file != null) {
            result = true;
            if (!file.exists()) {
                File parentFile = file.getParentFile();
                if (parentFile != null && !parentFile.exists()) {
                    result = parentFile.mkdirs();
                }
                if (result) {
                    try {
                        result = file.createNewFile();
                    }
                    catch (IOException ioe) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        result = file.createNewFile();
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(File file, String charsetName) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        FileInputStream fis = null;
        InputStreamReader isw = null;
        BufferedReader reader = null;
        try {
            String line;
            fis = new FileInputStream(file);
            isw = charsetName == null ? new InputStreamReader(fis) : new InputStreamReader((InputStream)fis, charsetName);
            reader = new BufferedReader(isw);
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable t) {}
            }
            if (isw != null) {
                try {
                    isw.close();
                }
                catch (Throwable t) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable t) {}
            }
        }
        return result;
    }

    public static void writeStringToFile(String data, File outputFile) throws IOException {
        FTSConfFileHelper.writeStringToFile(data, outputFile, "UTF_8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(String data, File outputFile, String charSetName) throws IOException {
        FTSConfFileHelper.createFile(outputFile);
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        OutputStreamWriter osw = null;
        try {
            fos = new FileOutputStream(outputFile);
            bos = new BufferedOutputStream(fos);
            osw = new OutputStreamWriter((OutputStream)bos, charSetName);
            osw.write(data);
            osw.flush();
        }
        finally {
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (Throwable t) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Throwable t) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    public static boolean nullableEquals(Object a, Object b) {
        boolean result = true;
        if (a == null) {
            if (b != null) {
                result = false;
            }
        } else {
            result = b == null ? false : a.equals(b);
        }
        return result;
    }
}

