/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.ftsconfig;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.plugins.ftsconfig.helper.FTSConfFileHelper;
import com.bmc.arsys.plugins.ftsconfig.helper.FTSConfigConfFileCreate;
import com.bmc.arsys.plugins.ftsconfig.helper.FTSConfigPluginConstants;
import com.bmc.arsys.pluginsvr.plugins.ARDBCPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARVendorField;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTSConfigPlugin
extends ARDBCPlugin {
    private static Logger log = Logger.getLogger(FTSConfigPlugin.class);
    private static FTSConfigConfFileCreate ftsFileHelper;
    private static String armonitorstr;
    private static File armonitorFile;
    private static String arconfStr;
    private static File arconfFile;
    private static String ftsFolder;
    private static File ftsPrimaryConfigFile;
    private static String ftsJavaPath;
    private static File ftsSecondaryConfigFile;
    private static String ftscoreFolder;
    private static String arhome;
    private static String arserverName;
    private static String pluginsvrFolder;
    private static String ftsCollectionDirectory;
    private static String ftsConfigurationDirectory;

    public static void init(ARPluginContext arPluginContext) throws ARException {
        log.info((Object)"###############################################################");
        log.info((Object)"Plugin initialization.");
        log.info((Object)("Plugin name is " + arPluginContext.getPluginInfo().getName()));
        log.info((Object)("Plugin version is " + arPluginContext.getPluginInfo().getVersion()));
        ftsFileHelper = new FTSConfigConfFileCreate();
        arconfStr = arPluginContext.getConfigItem("arconfPath");
        arconfStr = arconfStr.replace("/", FTSConfFileHelper.getFileSeparator());
        log.debug((Object)("AR Conf Path: " + arconfStr));
        armonitorstr = arPluginContext.getConfigItem("armonitorPath");
        armonitorstr = armonitorstr.replace("/", FTSConfFileHelper.getFileSeparator());
        log.debug((Object)("AR Monitor Path: " + armonitorstr));
        ftsFolder = arPluginContext.getConfigItem("ftsFolder");
        ftsFolder = ftsFolder.replace("/", FTSConfFileHelper.getFileSeparator());
        log.debug((Object)("FTS Folder Path: " + ftsFolder));
        ftsJavaPath = arPluginContext.getConfigItem("ftsJavaPath");
        ftsJavaPath = ftsJavaPath.replace("/", FTSConfFileHelper.getFileSeparator());
        log.debug((Object)("FTS java Path:" + ftsJavaPath));
        arhome = arconfStr;
        arconfFile = new File(arconfStr + FTSConfFileHelper.getFileSeparator() + "conf" + FTSConfFileHelper.getFileSeparator() + "ar" + FTSConfFileHelper.getConfExtension());
        armonitorFile = new File(armonitorstr + FTSConfFileHelper.getFileSeparator() + "armonitor" + FTSConfFileHelper.getConfExtension());
        ftsPrimaryConfigFile = new File(ftsFolder + FTSConfFileHelper.getFileSeparator() + "primary" + FTSConfFileHelper.getFileSeparator() + "pluginsvr_config.xml");
        ftsSecondaryConfigFile = new File(ftsFolder + FTSConfFileHelper.getFileSeparator() + "secondary" + FTSConfFileHelper.getFileSeparator() + "pluginsvr_config.xml");
        ftscoreFolder = ftsFolder + FTSConfFileHelper.getFileSeparator() + "core";
        arserverName = arPluginContext.getARConfigEntry("Server-Name");
        ftsCollectionDirectory = arPluginContext.getARConfigEntry("Full-Text-Collection-Directory");
        ftsConfigurationDirectory = arPluginContext.getARConfigEntry("Full-Text-Configuration-Directory");
        pluginsvrFolder = arhome + FTSConfFileHelper.getFileSeparator() + "pluginsvr";
        log.info((Object)"###############################################################");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createEntry(ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, Entry entry) throws ARException {
        String ar = "";
        try {
            Class<FTSConfigPlugin> clazz = FTSConfigPlugin.class;
            synchronized (FTSConfigPlugin.class) {
                log.debug((Object)"In Method createEntry");
                ftsFileHelper.createEntryFTS(arconfFile, armonitorFile, ftsPrimaryConfigFile, ftsSecondaryConfigFile, ftscoreFolder, arserverName, pluginsvrFolder, arhome, ftsJavaPath, ftsCollectionDirectory, ftsConfigurationDirectory, entry);
                // ** MonitorExit[var8_7] (shouldn't be in output)
            }
        }
        catch (Exception ex) {
            throw new ARException(2, 8750, "Failed to Create or Update File " + ex.getLocalizedMessage());
        }
        {
            return ar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry getEntry(ARPluginContext arPluginContext, String tableName, List<ARVendorField> fieldsList, long transId, String entryId, int[] idList) throws ARException {
        Entry entry;
        try {
            Class<FTSConfigPlugin> clazz = FTSConfigPlugin.class;
            synchronized (FTSConfigPlugin.class) {
                entry = this.readconfFile();
                // ** MonitorExit[var9_7] (shouldn't be in output)
            }
        }
        catch (Throwable thr) {
            throw new RuntimeException("The FTS Config Plugin could not retrieve getEntry", thr);
        }
        {
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEntry(ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, String entryId, Entry entry, Timestamp getTimestamp) throws ARException {
        try {
            Class<FTSConfigPlugin> clazz = FTSConfigPlugin.class;
            synchronized (FTSConfigPlugin.class) {
                log.debug((Object)"In Method setEntry");
                Entry entry1 = this.readconfFile();
                entry1.putAll((Map)entry);
                ftsFileHelper.createEntryFTS(arconfFile, armonitorFile, ftsPrimaryConfigFile, ftsSecondaryConfigFile, ftscoreFolder, arserverName, pluginsvrFolder, arhome, ftsJavaPath, ftsCollectionDirectory, ftsConfigurationDirectory, entry1);
                // ** MonitorExit[var9_8] (shouldn't be in output)
            }
        }
        catch (Exception ex) {
            throw new ARException(2, 8750, "Failed to Create or Update File " + ex.getLocalizedMessage());
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Entry> getListEntryWithFields(ARPluginContext arPluginContext, String tableName, List<ARVendorField> fieldsList, long transId, QualifierInfo qualifier, List<SortInfo> sortList, List<EntryListFieldInfo> getListFields, int startAt, int maxRetrieve, OutputInteger numMatches) throws ARException {
        ArrayList<Entry> listEntries = new ArrayList<Entry>();
        try {
            Class<FTSConfigPlugin> clazz = FTSConfigPlugin.class;
            synchronized (FTSConfigPlugin.class) {
                Entry entry = this.readconfFile();
                log.debug((Object)"In Method getListEntryWithFields");
                entry.put(Integer.valueOf(1), new Value("000000000000001"));
                listEntries.add(entry);
                if (numMatches != null) {
                    numMatches.setValue(listEntries.size());
                }
                // ** MonitorExit[var13_12] (shouldn't be in output)
            }
        }
        catch (Throwable thr) {
            throw new RuntimeException("The FTS Config Plugin could not retrieve getListEntryWithFields", thr);
        }
        {
            return listEntries;
        }
    }

    @Override
    public void terminate(ARPluginContext arPluginContext) throws ARException {
        arconfFile = null;
        armonitorFile = null;
        ftsPrimaryConfigFile = null;
        ftsSecondaryConfigFile = null;
        if (log.isInfoEnabled()) {
            log.info((Object)"###############################################################");
            log.info((Object)("Plugin name is " + arPluginContext.getPluginInfo().getName()));
            log.info((Object)"Plugin terminated");
            log.info((Object)"###############################################################");
        }
    }

    public Entry readconfFile() {
        Entry entry = new Entry();
        try {
            log.debug((Object)"In Method getEntry");
            String osName = FTSConfFileHelper.getOsName();
            int fts_agent_val = 1;
            int svr_confg_val = 0;
            String keysearchprim = "";
            String keysearchsec = "";
            keysearchprim = FTSConfFileHelper.isMemberWindows(osName) ? "fts" + FTSConfFileHelper.getFileSeparator() + FTSConfFileHelper.getFileSeparator() + "primary" : "fts" + FTSConfFileHelper.getFileSeparator() + "primary";
            keysearchsec = FTSConfFileHelper.isMemberWindows(osName) ? "fts" + FTSConfFileHelper.getFileSeparator() + FTSConfFileHelper.getFileSeparator() + "secondary" : "fts" + FTSConfFileHelper.getFileSeparator() + "secondary";
            String strPrimaryJVM = ftsFileHelper.readArMonitorforJVM(armonitorFile, keysearchprim);
            if (strPrimaryJVM == null || strPrimaryJVM.equals("")) {
                strPrimaryJVM = "0";
            }
            log.debug((Object)("In Method readconfFile:strPrimaryJVM" + strPrimaryJVM));
            String strSecondaryJVM = ftsFileHelper.readArMonitorforJVM(armonitorFile, keysearchsec);
            if (strSecondaryJVM == null || strSecondaryJVM.equals("")) {
                strSecondaryJVM = "0";
            }
            log.debug((Object)("In Method readconfFile:strSecondaryJVM" + strSecondaryJVM));
            boolean isarcfgComm = ftsFileHelper.isArcfgCommented(arconfFile, "Server-Plugin-Alias", "ARSYS.ARF.FTS ARSYS.ARF.FTS");
            String svrname = ftsFileHelper.readArcfgforPort(arconfFile, "Server-Plugin-Alias", "ARSYS.ARF.FTS ARSYS.ARF.FTS");
            String primserverName = "";
            String actualPort = "";
            if (svrname != null && !svrname.equals("")) {
                String[] instanceTokens = svrname.split(":");
                primserverName = instanceTokens[0];
                actualPort = instanceTokens[1];
            }
            log.debug((Object)("In Method readconfFile:primserverName" + primserverName + actualPort));
            String ftsport1 = ftsFileHelper.retrievePort(ftsPrimaryConfigFile);
            log.debug((Object)("In Method readconfFile:ftsport1" + ftsport1));
            String ftsport2 = ftsFileHelper.retrievePort(ftsSecondaryConfigFile);
            log.debug((Object)("In Method readconfFile:ftsport2" + ftsport2));
            if (ftsport1 == null || ftsport1.equals("") || ftsport1.equalsIgnoreCase("PLUGINPORT")) {
                ftsport1 = "0";
            }
            if (ftsport2 == null || ftsport2.equals("") || ftsport2.equalsIgnoreCase("PLUGINPORT")) {
                ftsport2 = "0";
            }
            boolean isArmonitorsetforWriter = ftsFileHelper.readArMonitorforConfig(armonitorFile, keysearchprim);
            boolean isArmonitorsetforReader = ftsFileHelper.readArMonitorforConfig(armonitorFile, keysearchsec);
            fts_agent_val = isArmonitorsetforWriter || isArmonitorsetforReader ? 0 : 1;
            String svrtype = ftsFileHelper.readArcfgForProperty(arconfFile, "Full-Text-Mode");
            String issvrgrpmember = ftsFileHelper.readArcfgForProperty(arconfFile, "Server-Group-Member");
            svr_confg_val = isArmonitorsetforWriter && isArmonitorsetforReader ? (issvrgrpmember != null && !issvrgrpmember.equals("") && issvrgrpmember.equalsIgnoreCase("T") ? 1 : 0) : (!isArmonitorsetforWriter && !isArmonitorsetforReader ? (issvrgrpmember != null && !issvrgrpmember.equals("") && issvrgrpmember.equalsIgnoreCase("T") ? (svrtype != null && !svrtype.equals("") && svrtype.equalsIgnoreCase("Server-Group-primary") ? 1 : (svrtype != null && !svrtype.equals("") && svrtype.equalsIgnoreCase("Server-Group-secondary") ? 2 : 0)) : 0) : (isArmonitorsetforWriter && !isArmonitorsetforReader ? 0 : (!isArmonitorsetforWriter && isArmonitorsetforReader ? (issvrgrpmember != null && !issvrgrpmember.equals("") && issvrgrpmember.equalsIgnoreCase("T") ? 1 : 0) : 0)));
            if (actualPort != null && ftsport1.equals(actualPort)) {
                log.info((Object)"Port in ar.cfg matches writer port");
            } else if (actualPort != null && ftsport2.equals(actualPort)) {
                log.info((Object)"Port in ar.cfg matches reader port");
            } else {
                if (actualPort != null && !actualPort.equals("") && svr_confg_val == 2) {
                    ftsport2 = actualPort;
                    log.info((Object)"Setting Port for Secondary Server from ar.cfg");
                }
                log.info((Object)"Incosistent Port in ar.cfg and pluginsvr_config.xml");
            }
            if (svr_confg_val == 2 && isarcfgComm) {
                fts_agent_val = 1;
            } else if (svr_confg_val == 2 && !isarcfgComm) {
                fts_agent_val = 0;
            }
            String ftsCollectionDir = ftsFileHelper.readArcfgForProperty(arconfFile, "Full-Text-Collection-Directory");
            String ftsConfigDir = ftsFileHelper.readArcfgForProperty(arconfFile, "Full-Text-Configuration-Directory");
            entry.put(Integer.valueOf(FTSConfigPluginConstants.FIELD_FTS_AGENT_ENABLED.getFieldID()), new Value(fts_agent_val));
            entry.put(Integer.valueOf(FTSConfigPluginConstants.FIELD_SERVER_CONFIGURATION.getFieldID()), new Value(svr_confg_val));
            entry.put(Integer.valueOf(FTSConfigPluginConstants.FIELD_FTS_PORT1.getFieldID()), new Value(Integer.parseInt(ftsport1)));
            entry.put(Integer.valueOf(FTSConfigPluginConstants.FIELD_MAX_JVM_MEM1.getFieldID()), new Value(Integer.parseInt(strPrimaryJVM)));
            entry.put(Integer.valueOf(FTSConfigPluginConstants.FIELD_PRIMARY_SVR_NAME.getFieldID()), new Value(primserverName));
            entry.put(Integer.valueOf(FTSConfigPluginConstants.FIELD_FTS_PORT2.getFieldID()), new Value(Integer.parseInt(ftsport2)));
            entry.put(Integer.valueOf(FTSConfigPluginConstants.FIELD_MAX_JVM_MEM2.getFieldID()), new Value(Integer.parseInt(strSecondaryJVM)));
            entry.put(Integer.valueOf(FTSConfigPluginConstants.FIELD_FTS_COLLECTION_DIR.getFieldID()), new Value(ftsCollectionDir));
            entry.put(Integer.valueOf(FTSConfigPluginConstants.FIELD_FTS_CONFIG_DIR.getFieldID()), new Value(ftsConfigDir));
        }
        catch (Throwable thr) {
            throw new RuntimeException("Could Not Retrieve FTS Configuration data from Files.", thr);
        }
        return entry;
    }

    static {
        armonitorstr = "";
        armonitorFile = null;
        arconfStr = "";
        arconfFile = null;
        ftsFolder = "";
        ftsPrimaryConfigFile = null;
        ftsJavaPath = "";
        ftsSecondaryConfigFile = null;
        ftscoreFolder = "";
        arhome = "";
        arserverName = "";
        pluginsvrFolder = "";
        ftsCollectionDirectory = "";
        ftsConfigurationDirectory = "";
    }
}

